"""GTA.Native stub - Compatible avec Function.Call[Type]()"""

from typing import Any, List, ClassVar, TypeVar, Type, Generic, Callable, overload
from enum import Enum

T = TypeVar('T')

__all__ = ["Function", "Hash", "InputArgument", "OutputArgument", "GlobalVariable", "Native"]

class InputArgument:
    """Input argument for native functions"""
    def __init__(self, value: Any = None) -> None: ...
    def ToString(self) -> str: ...


class OutputArgument:
    """Output argument for native functions"""
    def __init__(self, value: Any = None) -> None: ...
    def Dispose(self) -> None: ...
    
    @staticmethod
    def Alloc(size: int) -> 'OutputArgument': ...
    
    def GetResult(self) -> Any: ...


class _GenericCall(Generic[T]):
    """Result of Call[Type] - callable with hash and arguments"""
    def __call__(self, hash: 'Hash', *args: Any) -> T: ...


class _CallDispatcher:
    """
    Allows the syntax Function.Call[bool](hash, args) 
    and Function.Call(hash, args)
    """
    @overload
    def __getitem__(self, return_type: Type[bool]) -> _GenericCall[bool]: ...
    @overload
    def __getitem__(self, return_type: Type[int]) -> _GenericCall[int]: ...
    @overload
    def __getitem__(self, return_type: Type[float]) -> _GenericCall[float]: ...
    @overload
    def __getitem__(self, return_type: Type[str]) -> _GenericCall[str]: ...
    @overload
    def __getitem__(self, return_type: Type[T]) -> _GenericCall[T]: ...
    
    def __getitem__(self, return_type: Type[T]) -> _GenericCall[T]: ...
    
    def __call__(self, hash: 'Hash', *args: Any) -> Any: ...


class Function:
    """
    Class for calling GTA V native functions.
    
    Usage:
        # With return type
        result = Function.Call[bool](Hash.IS_PED_DEAD, ped)
        pos = Function.Call[Vector3](Hash.GET_ENTITY_COORDS, entity)
        
        # Without return type (void)
        Function.Call(Hash.SET_ENTITY_COORDS, entity, x, y, z)
    """
    Call: ClassVar[_CallDispatcher]
    CallLongBlockingFunc: ClassVar[_CallDispatcher]


class GlobalVariable:
    """Variable globale du script"""
    MemoryAddress: int
    
    @staticmethod
    def Get(index: int) -> 'GlobalVariable': ...
    
    def Read(self) -> Any: ...
    def Write(self, value: Any) -> None: ...
    def WriteString(self, value: str, maxSize: int) -> None: ...
    def SetBit(self, index: int) -> None: ...
    def ClearBit(self, index: int) -> None: ...
    def IsBitSet(self, index: int) -> bool: ...
    def GetStructField(self, index: int) -> 'GlobalVariable': ...
    def GetArray(self, itemSize: int) -> List['GlobalVariable']: ...
    def GetArrayItem(self, index: int, itemSize: int) -> 'GlobalVariable': ...

class Hash(Enum):
    TIMESTEP = 1348042466
    SET_ROADS_BACK_TO_ORIGINAL_IN_ANGLED_AREA = 11065603657515134
    RESET_LAW_RESPONSE_DELAY_OVERRIDE = 14257211138295064
    NETWORK_SPENT_PAY_BUSINESS_SUPPLIES = 15124406335893987
    GET_BLIP_ROTATION = 17612777317178751
    WAYPOINT_RECORDING_GET_SPEED_AT_POINT = 24244981874273449
    NETWORK_EARN_WAGE_PAYMENT_BONUS = 25555334596464669
    REMOVE_VEHICLE_HIGH_DETAIL_MODEL = 29445876476569479
    PLAY_OBJECT_AUTO_START_ANIM = 31044728238866115
    PLAYSTATS_NPC_PHONE = 33760874230671763
    RESET_FACIAL_IDLE_ANIM = 35991802193896486
    IS_VEHICLE_MOD_GEN9_EXCLUSIVE = 36959723841839120
    SET_PLAYER_MODEL = 45540521788082230
    GET_SEQUENCE_PROGRESS = 47570426378728755
    GET_VEHICLE_CLASS_ESTIMATED_MAX_SPEED = 54218174286978434
    DISPLAY_ONSCREEN_KEYBOARD = 62068802110151670
    IS_PED_USING_ACTION_MODE = 65078344399845189
    DECOR_REMOVE = 67166044987557664
    DATAFILE_SELECT_CREATOR_STATS = 74692667292169764
    SET_CUTSCENE_ORIGIN_AND_ORIENTATION = 78958077777363754
    CREATE_CHECKPOINT = 86958739780190155
    START_AUDIO_SCENE = 88524962657658098
    GET_PED_MAKEUP_TINT_COLOR = 89611280948482951
    HAS_STREAMED_TEXTURE_DICT_LOADED = 91750494399812324
    UNREQUEST_TENNIS_BANKS = 94776799139586789
    GET_AMMO_IN_PED_WEAPON = 97480644549409105
    SEND_METRIC_PUNISH_BODYGUARD = 97676138129909484
    CELL_CAM_ACTIVATE_SELFIE_MODE = 98034283137861742
    IS_GAMEPLAY_CAM_SHAKING = 102466813717061513
    GET_TIME_OFFSET = 103592467367232771
    GET_NUM_NAVMESHES_EXISTING_IN_AREA = 103739531227794533
    GET_SHOP_PED_APPAREL_FORCED_PROP_COUNT = 105105237482510502
    SET_TYRE_WEAR_RATE = 110705629056875682
    GET_CURRENT_WEBPAGE_ID = 118035704584043142
    SET_PED_MIN_MOVE_BLEND_RATIO = 119513419683673053
    NETWORK_GET_PLATFORM_PARTY_MEMBER_COUNT = 120416720270500246
    IS_NEW_LOAD_SCENE_LOADED = 123889098213268177
    SET_DISABLE_FRAG_DAMAGE = 124476729854094587
    SET_VEHICLE_AUDIO_BODY_DAMAGE_FACTOR = 124778452841184670
    NETWORK_HAS_CONTROL_OF_ENTITY = 125925576390379655
    CLEAR_AREA_OF_VEHICLES = 128275295070891702
    IS_AMBIENT_ZONE_ENABLED = 135813300961836955
    SET_PED_RAGDOLL_FORCE_FALL = 141398619419546193
    REMOVE_CLIP_SET = 141645767035637140
    IS_PED_ON_FOOT = 143805665679202738
    SET_ARRIVE_DISTANCE_OVERRIDE_FOR_VEHICLE_PERSUIT_ATTACK = 145792176621802219
    SET_WANTED_LEVEL_MULTIPLIER = 148160294804391866
    GET_VEHICLE_DEFAULT_HORN = 150410257217231276
    PROCGRASS_DISABLE_AMBSCALESCAN = 151075124549033450
    NETWORK_CAN_SEND_LOCAL_INVITE = 151641059970794272
    HAS_ADDITIONAL_TEXT_LOADED = 154353723296127160
    SET_GAMEPLAY_CAM_MAX_MOTION_BLUR_STRENGTH_THIS_UPDATE = 154661188599136908
    DISABLE_SCUFF_DECALS = 159487857601412559
    NETWORK_CANCEL_TRANSITION_MATCHMAKING = 159740278142764526
    SET_VEHICLE_HAS_BEEN_DRIVEN_FLAG = 160312516739012764
    NETWORK_SHOULD_SHOW_PROMOTION_ALERT_SCREEN = 160663606279390372
    IS_PLAYER_ENTIRELY_INSIDE_GARAGE = 165050845919603184
    HAS_ENTITY_CLEAR_LOS_TO_ENTITY_IN_FRONT = 173335856089985402
    SET_CAM_ACTIVE = 175562857184911236
    IS_CAM_SPLINE_PAUSED = 184915161366755428
    SET_PLAYER_TEAM = 187455978900965696
    PREPARE_SYNCHRONIZED_AUDIO_EVENT_FOR_SCENE = 189124577488416373
    SET_PED_AS_ENEMY = 189372676006300666
    NETWORK_GET_GAMER_STATUS_RESULT = 191612746030839392
    CASCADE_SHADOWS_SET_DYNAMIC_DEPTH_VALUE = 192573910898679882
    UGC_HAS_GET_FINISHED = 192988611513586063
    IS_PLAYER_TELEPORT_ACTIVE = 194031241483815023
    START_PARTICLE_FX_NON_LOOPED_ON_ENTITY_BONE = 194203058799858469
    NETWORK_GET_LOCAL_SCENE_FROM_NETWORK_ID = 199297445535246262
    SET_SCENARIO_GROUP_ENABLED = 200662747229742670
    FLASH_ABILITY_BAR = 202585071617734094
    NETWORK_SPEND_VEHICLE_REQUESTED = 203306527527548163
    SET_CLOUD_SETTINGS_OVERRIDE = 206790413051920359
    SET_RADIO_POSITION_AUDIO_MUTE = 209765349828934295
    IS_CAM_RENDERING = 210555333278735226
    SET_PED_DUCKING = 218850962977810733
    UNLOCK_RADIO_STATION_TRACK_LIST = 223714790757418793
    DATADICT_GET_TYPE = 224148558715188081
    NETWORK_IS_PLAYER_TALKING = 224636770351277182
    CAN_VEHICLE_RECEIVE_CB_RADIO = 228013862591714732
    SET_ANIM_RATE = 228920270337460295
    RENDER_SHADOWED_LIGHTS_WITH_NO_SHADOWS = 229696053525114331
    REMOVE_MODEL_SWAP = 233078436508346798
    SET_VEHICLE_HORN_SOUND_INDEX = 238945735878862800
    START_ALARM = 240361013244630962
    GET_HASH_NAME_FOR_COMPONENT = 245643714767553352
    IS_CAM_INTERPOLATING = 247583394219865388
    IS_OBJECT_A_PORTABLE_PICKUP = 250161456850799885
    NETWORK_SET_OBJECT_CAN_BLEND_WHEN_FIXED = 250472015593511589
    NETWORK_SPEND_UPGRADE_ARENA = 250718365903846065
    SET_TEXT_PROPORTIONAL = 255613713711619320
    NET_GAMESERVER_RETRIEVE_INIT_SESSION_STATUS = 258336062401865260
    SC_INBOX_GET_TOTAL_NUM_MESSAGES = 263812360228702308
    NETWORK_CLEAR_INVALID_OBJECT_MODELS = 266539461273738817
    ADD_TEXT_COMPONENT_INTEGER = 267125040633950652
    DOOR_SYSTEM_SET_AUTOMATIC_RATE = 270917550687784578
    PLAYSTATS_MC_FORMATION_ENDS = 271041414600850290
    SET_BLIP_COLOUR = 276965922061511550
    GET_MODEL_DIMENSIONS = 281707892607355002
    GET_CAN_PED_BE_GRABBED_BY_SCRIPT = 282041979060640951
    FORCE_ALLOW_TIME_BASED_FADING_THIS_FRAME = 284185301824822590
    CASCADE_SHADOWS_INIT_SESSION = 287220246558562848
    SC_EMAIL_RETRIEVE_EMAILS = 291288992813482378
    VEHICLE_SET_OVERRIDE_EXTENABLE_SIDE_RATIO = 295462310503419699
    NETWORK_SESSION_RESERVE_SLOTS_TRANSITION = 296251495686903014
    NETWORK_GET_PRIMARY_CLAN_DATA_CANCEL = 301261172596695124
    STOP_SAVE_ARRAY = 307774835641838564
    SET_PORTAL_SETTINGS_OVERRIDE = 310109384757357541
    SET_DIRECTOR_MODE_AVAILABLE = 316764476837530341
    NETWORK_IS_TUNABLE_CLOUD_REQUEST_PENDING = 317434636979109160
    TASK_GO_TO_ENTITY_WHILE_AIMING_AT_COORD = 319782179644759269
    STAT_SET_CHEAT_IS_ACTIVE = 323343103739606588
    CHANGE_PLAYER_PED = 324692358308552430
    NETWORK_IS_IN_SPECTATOR_MODE = 326307441068617233
    NETWORK_TRANSITION_FINISH = 329196262716571991
    GET_CONTROL_INSTRUCTIONAL_BUTTONS_STRING = 331533201183454215
    IS_PED_IN_CURRENT_CONVERSATION = 332865596560769548
    PLAYSTATS_CASINO_INSIDE_TRACK = 332991039873059462
    GET_PED_INDEX_FROM_ENTITY_INDEX = 334009695758536769
    GET_PED_TEXTURE_VARIATION = 334205219021784294
    PLAYSTATS_RECOVER_CONTRABAND_MISSION = 349323262825257517
    RELEASE_BINK_MOVIE = 349399433429839244
    GET_LAST_SHUNT_VEHICLE = 356622671460524791
    CLEAR_AREA_OF_COPS = 358313864965191821
    GET_IS_VEHICLE_DISABLED_BY_EMP = 362238040870672645
    NETWORK_IS_ACTIVITY_SESSION = 362913841291696122
    IS_PED_LIPSTICK_TINT_FOR_BARBER = 370881499881225428
    START_SHAPE_TEST_BOUNDING_BOX = 371607932468809415
    GET_MENU_PED_BOOL_STAT = 371988859392025828
    NETWORK_IS_SIGNED_IN = 379239880906107798
    SET_CUTSCENE_PED_PROP_VARIATION = 380081700068038435
    GET_RANDOM_VEHICLE_MODEL_IN_MEMORY = 386166814800147709
    IS_DLC_VEHICLE_MOD = 388639975248345132
    DECOR_EXIST_ON = 389028657215641183
    GET_VEHICLE_NODE_PROPERTIES = 389656384451763932
    STOP_FIRE_IN_RANGE = 390276194669331103
    SET_ALL_RANDOM_PEDS_FLEE = 391267708132141385
    WAYPOINT_PLAYBACK_START_SHOOTING_AT_COORD = 394669491769685617
    SET_VEHICLE_TURRET_TARGET = 396724732079637522
    CREATE_MONEY_PICKUPS = 399050048187308843
    NETWORK_CLEAR_FOLLOWERS = 400613574254813978
    SET_PICKUP_GLOW_OFFSET = 402654606518738149
    CREATE_INCIDENT_WITH_ENTITY = 403129834911911520
    IS_SPECIAL_ABILITY_METER_FULL = 405885062257517959
    GET_NAME_OF_SCRIPT_WITH_THIS_ID = 406497875456797035
    NETWORK_DELETE_CHARACTER = 406743382443420557
    GET_INTERIOR_AT_COORDS_WITH_TYPE = 411983278217074684
    NETWORK_SPENT_ORDER_WAREHOUSE_VEHICLE = 427913800648686527
    IS_TARGET_PED_IN_PERCEPTION_AREA = 434726530479457705
    DOES_ENTITY_HAVE_DRAWABLE = 436126333621822605
    DOES_VEHICLE_HAVE_CREW_EMBLEM = 436166767530844789
    SET_ALLOW_LOCKON_TO_PED_IF_FRIENDLY = 440428521789940772
    IS_RADIO_FADED_OUT = 443220042696381232
    FORCE_PED_PANIC_WALLA = 445116036604426858
    SET_SHOULD_LERP_FROM_AI_TO_FULL_RECORDING = 448920370433963400
    CLEAR_CODE_REQUESTED_AUTOSAVE = 452095636843837052
    SET_PED_FOOTSTEPS_EVENTS_ENABLED = 455909428772601479
    SET_VEHICLE_INACTIVE_DURING_PLAYBACK = 457162638838287477
    SET_VEHICLE_CAN_EJECT_PASSENGERS_IF_LOCKED = 458526765048055477
    GET_WEAPON_TIME_BETWEEN_SHOTS = 458569658196096932
    DATAARRAY_GET_COUNT = 458719005676202541
    DATADICT_GET_FLOAT = 459652227145635623
    SET_ENTITY_COORDS = 469568048723526251
    ANIMPOSTFX_STOP = 472459433978216675
    SET_VEHICLE_DROPS_MONEY_WHEN_BLOWN_UP = 472707477634258518
    SET_MAX_ARMOUR_HUD_DISPLAY = 478261527885840968
    REQUEST_CUT_FILE = 478316426198057658
    SET_SCRIPT_UPDATE_DOOR_AUDIO = 486391216160038251
    GET_CAM_DOF_STRENGTH = 491265921572888872
    PLAYSTATS_BC_SMASH_AND_GRAB = 498482334864393246
    SET_CUTSCENE_MULTIHEAD_FADE_MANUAL = 499495251841909634
    HAS_PRELOAD_MODS_FINISHED = 501093978136604054
    GOLF_TRAIL_SET_FACING = 501977542329226221
    NETWORK_REGISTER_ENTITY_AS_NETWORKED = 502904344163126442
    SET_PED_TARGET_LOSS_RESPONSE = 505451025464023626
    SET_VEHICLE_IS_RACING = 509309337690280605
    STOP_REPLAY_RECORDING = 511811220243728563
    HAS_CHEAT_WITH_HASH_BEEN_ACTIVATED = 512894152345136528
    SET_PED_CURRENT_WEAPON_VISIBLE = 514998932744280688
    SET_PARACHUTE_TASK_THRUST = 516148973502087959
    GET_SHOP_PED_OUTFIT_LOCATE = 521470237441234286
    REQUEST_COLLISION_AT_COORD = 526990946549928359
    TASK_FOLLOW_WAYPOINT_RECORDING = 529552391231721339
    HAVE_CREDITS_REACHED_END = 531175541629031354
    SET_PLAYER_RESERVE_PARACHUTE_MODEL_OVERRIDE = 532630280031652059
    CHANGE_FAKE_MP_CASH = 536737010038877744
    SHUTDOWN_LOADING_SCREEN = 544582165167134263
    STREAMVOL_IS_VALID = 559312740087656492
    SC_LICENSEPLATE_GET_ADD_IS_PENDING = 560159903570416333
    SET_TEXT_SCALE = 560759698880214217
    SC_EMAIL_SET_CURRENT_EMAIL_TAG = 566281623328471127
    NETWORK_CAN_PLAY_MULTIPLAYER_WITH_GAMER = 566655126717555697
    RENDER_SCRIPT_CAMS = 569060033405794044
    NETWORK_CHECK_TEXT_COMMUNICATION_PRIVILEGES = 570465608387534233
    FIND_ANIM_EVENT_PHASE = 572447722979338151
    REQUEST_PATH_NODES_IN_AREA_THIS_FRAME = 575074935357023879
    SET_RESTORE_FOCUS_ENTITY = 581307532518502380
    NETWORK_EARN_CASINO_TIME_TRIAL_WIN = 583739081145433048
    IS_ANY_PED_NEAR_POINT = 592611794392571039
    DRAW_DEBUG_BOX = 592835387914023869
    SET_PED_MOVE_RATE_OVERRIDE = 602347721261201873
    GET_WANTED_LEVEL_RADIUS = 602896624907716626
    ON_ENTER_MP = 614956098268163829
    NETWORK_SPEND_GOON = 621980720819078786
    GET_TRAIN_CARRIAGE = 624589709488827331
    NETWORK_EARN_BOSS = 626222975329479730
    GET_PLAYER_SWITCH_INTERP_OUT_DURATION = 631303040090047675
    TASK_SHOOT_AT_ENTITY = 637987121588266866
    NETWORK_GET_CAN_TRANSFER_CASH = 642025377942586528
    GET_WEAPON_TYPE_FROM_PICKUP_TYPE = 646667485035212113
    SET_MINIMAP_FOW_REVEAL_COORDINATE = 658611830838489950
    GET_SUBMARINE_NUMBER_OF_AIR_LEAKS = 665809114361297838
    CLEAR_PED_PROP = 667629751983728494
    SET_VEHICLE_RUDDER_BROKEN = 675646909037616623
    TASK_RAPPEL_FROM_HELI = 678138103285225033
    SET_RADAR_ZOOM = 679750498325732282
    PLAYSTATS_STARTED_SESSION_IN_OFFLINEMODE = 686623877187970253
    FACEBOOK_POST_COMPLETED_HEIST = 687562397750766060
    NETWORK_GET_ENTITY_IS_LOCAL = 689425255090243426
    PLAYSTATS_CASINO_CHIP = 691852232327188498
    IS_SCRIPTED_HUD_COMPONENT_HIDDEN_THIS_FRAME = 702632180553568706
    IS_PED_BLUSH_FACEPAINT_TINT_FOR_BARBER = 713799278733668880
    NETWORK_EARN_CASINO_MISSION_PARTICIPATION = 714086099869115765
    END_PETROL_TRAIL_DECALS = 725699894922983117
    CLEAR_AREA_OF_PROJECTILES = 728660689210954150
    BEGIN_TEXT_COMMAND_IS_THIS_HELP_MESSAGE_BEING_DISPLAYED = 730948983286339829
    IS_STEAM_VERSION = 731749959898984809
    GET_ENTITY_INDEX_OF_CUTSCENE_ENTITY = 733699554847515382
    SET_HELI_COMBAT_OFFSET = 738451845967157957
    END_SRL = 738964234645925399
    CLEAR_VEHICLE_GENERATOR_AREA_OF_INTEREST = 739552988220189972
    FREE_MEMORY_FOR_MISSION_CREATOR_PHOTO = 740472198017080842
    CAN_REGISTER_MISSION_PICKUPS = 741354285336670066
    SET_ENTITY_RECORDS_COLLISIONS = 743271985761492581
    PLAYSTATS_SWITCH_MC_EMBLEM = 743325249583827860
    SCRIPT_RACE_INIT = 747599185332294898
    SET_BOAT_DISABLE_AVOIDANCE = 750455852747783536
    NET_GAMESERVER_DELETE_CHARACTER_GET_STATUS = 751417507822812553
    GET_SELECTED_PED_WEAPON = 751455270629331523
    ARE_PLAYER_STARS_GREYED_OUT = 751735369465373403
    GET_ENTITY_FORWARD_VECTOR = 754716164444708753
    IS_ENTITY_A_MISSION_ENTITY = 755240282434935612
    SET_PED_MOTION_BLUR = 763475691609175112
    PLAYSTATS_FM_EVENT_DEADDROP = 764625910507222659
    DOES_SCENARIO_OF_TYPE_EXIST_IN_AREA = 764780887253223105
    ADD_CAM_SPLINE_NODE_USING_CAMERA_FRAME = 765376944147697268
    FORCE_VEHICLE_CAM_STUNT_SETTINGS_THIS_UPDATE = 766305181431055354
    SET_FLASH = 772440552382255046
    GET_CUT_FILE_CONCAT_COUNT = 773586550140027132
    REMOVE_AIR_DEFENCE_SPHERE = 774429300358739296
    STREAMVOL_CREATE_LINE = 781780310675118351
    IS_TVSHOW_CURRENTLY_PLAYING = 781783322249886560
    SET_VEHICLE_INFLUENCES_WANTED_LEVEL = 781912164321968495
    FACEBOOK_POST_COMPLETED_MILESTONE = 784173227228613305
    TASK_JUMP = 784761447855974321
    CASCADE_SHADOWS_ENABLE_FREEZER = 785664339886957234
    SET_FIRST_PERSON_AIM_CAM_NEAR_CLIP_THIS_UPDATE = 790298410384163763
    HUD_SUPPRESS_WEAPON_WHEEL_RESULTS_THIS_FRAME = 791590050914061127
    GET_MAX_NUM_NETWORK_VEHICLES = 791759602904146431
    CLOUD_GET_AVAILABILITY_CHECK_RESULT = 796223470490173243
    TITLE_TEXTURE_DOWNLOAD_REQUEST = 801705926945225295
    NETWORK_EARN_FROM_BUSINESS_HUB_SELL = 808905264239593603
    SET_PED_MOVE_RATE_IN_WATER_OVERRIDE = 810143995894630361
    REACTIVATE_ALL_WORLD_BRAINS_THAT_ARE_WAITING_TILL_OUT_OF_RANGE = 810908834336276356
    SHOW_HUD_COMPONENT_THIS_FRAME = 814573165291300452
    PLAYSTATS_CHANGE_MC_ROLE = 816940483847037160
    SET_CONVERSATION_AUDIO_CONTROLLED_BY_ANIM = 816983326938755307
    NETWORK_IS_TRANSITION_HOST = 829303998639972697
    STAT_GET_VEHICLE_BAIL_DISTANCE = 831898695577771117
    SET_AMBIENT_PED_RANGE_MULTIPLIER_THIS_FRAME = 833621265049502944
    SET_PED_VOICE_GROUP_FROM_RACE_TO_PVG = 840978186039458582
    SIN = 841539415165780831
    GET_HYDRAULIC_SUSPENSION_RAISE_FACTOR = 843804658755590883
    SET_PLANE_SECTION_DAMAGE_SCALE = 845439206254613275
    PLAYSTATS_DAR_CHECKPOINT = 847333135075054849
    ADD_MODEL_TO_CREATOR_BUDGET = 847543479770252902
    GET_PACKED_STAT_INT_CODE = 849210721969600268
    LEADERBOARDS_WRITE_ADD_COLUMN = 849523555731296873
    IS_PED_IN_ANY_POLICE_VEHICLE = 851266269252197394
    SET_PED_GROUP_MEMBER_PASSENGER_INDEX = 855042750384164668
    IS_VEHICLE_RADIO_ON = 857019373655947543
    NETWORK_IS_PENDING_FRIEND = 857722039766249011
    REGISTER_OBJECT_SCRIPT_BRAIN = 858019504694160418
    SET_MAX_NUM_PORTABLE_PICKUPS_CARRIED_BY_PLAYER = 861229579293400072
    VEHICLE_START_PARACHUTING = 864603342341212823
    GET_STATUS_OF_SAVE_HIGH_QUALITY_PHOTO = 868155147919581344
    GET_IS_ENTITY_A_FRAG = 869519518610521630
    GET_LODSCALE = 870796597400843421
    HAS_SCALEFORM_MOVIE_FILENAME_LOADED = 872675186769785655
    GET_MAX_NUM_NETWORK_PEDS = 873554608501105289
    PLAYSTATS_CASINO_LUCKY_SEVEN = 883598417211024634
    SET_PED_AI_BLIP_FORCED_ON = 886012180890750030
    ARE_STRINGS_EQUAL = 887595790686087826
    SET_WARNING_MESSAGE_OPTION_ITEMS = 890165343464903977
    USE_VEHICLE_TARGETING_RETICULE = 894401646490121415
    NETWORK_SPENT_UPRADE_BUNKER = 901513886547717449
    SEETHROUGH_SET_MAX_THICKNESS = 905131731184149215
    GET_PLAYER_WANTED_CENTRE_POSITION = 905991576682964728
    NETWORK_SET_TRANSITION_VISIBILITY_LOCK = 907352016830409772
    NETWORK_EARN_AGENCY = 914721133180232872
    SET_BINK_MOVIE_TIME = 916116680606070138
    NETWORK_SPENT_BUY_TILTROTOR = 922802226996570245
    GET_NUM_CREATED_MISSION_VEHICLES = 925959778748084458
    SET_VEHICLE_CAN_DEFORM_WHEELS = 927077622732950694
    DECOR_SET_INT = 928773269352455696
    UPDATE_ONSCREEN_KEYBOARD = 933008831334139310
    SET_SAVEGAME_LIST_UNIQUE_ID = 933739500335761308
    NETWORK_CHECK_PRIVILEGES = 934158623844135160
    CLEAR_WEATHER_TYPE_NOW_PERSIST_NETWORK = 934918351311327304
    SET_FREEMODE_PROLOGUE_DONE = 937261121067054075
    STAT_SLOT_IS_LOADED = 939738356816354876
    GET_PLAYER_GROUP = 941944490316279983
    NETWORK_SPENT_PA_SERVICE_SNACK = 950518470969025477
    RESET_SCENARIO_TYPES_ENABLED = 955024987292118381
    START_PARTICLE_FX_NON_LOOPED_ON_ENTITY = 960291159887317458
    SET_CARGOBOB_PICKUP_ROPE_TYPE = 963600621618584245
    GET_STATUS_OF_TAKE_HIGH_QUALITY_PHOTO = 967332321029885091
    NETWORK_SET_INVITE_FAILED_MESSAGE_FOR_INVITE_MENU = 970429159217093209
    IS_PED_WEAPON_COMPONENT_ACTIVE = 970769834681013918
    GET_WEAPON_COMPONENT_TYPE_MODEL = 987831216342151299
    NETWORK_IS_TRANSITION_CLOSED_CREW = 990050289851296827
    SET_ENTITY_LOAD_COLLISION_FLAG = 992985146056095358
    NETWORK_EARN_CHALLENGE = 996248731132662826
    DRAW_SCALEFORM_MOVIE_FULLSCREEN = 1005998793517194209
    NETWORK_EARN_SELL_BASE = 1017303290664980906
    DETACH_VEHICLE_FROM_CARGOBOB = 1018327945767369117
    NETWORK_GET_AVERAGE_PING = 1025136395677346629
    DISABLE_COMPOSITE_SHOTGUN_DECALS = 1027552737622020593
    SET_ENTITY_MAX_SPEED = 1028689870813569457
    GET_TOTAL_DURATION_OF_VEHICLE_RECORDING = 1029303147655924048
    ADD_TEXT_COMPONENT_FORMATTED_INTEGER = 1030326645201738948
    NETWORK_SET_ACTIVITY_PLAYER_MAX = 1031174745549655428
    CLEAR_PED_DECORATIONS = 1031733064081305144
    START_PARTICLE_FX_NON_LOOPED_ON_PED_BONE = 1044398152630765081
    CLEAR_PED_LAST_WEAPON_DAMAGE = 1051863785197139128
    PLAYSTATS_GUNRUNNING_MISSION_ENDED = 1057465772832789850
    DOES_NAVMESH_BLOCKING_OBJECT_EXIST = 1057977418382517145
    SET_PED_CAN_PLAY_AMBIENT_BASE_ANIMS = 1058443069242033984
    RELEASE_MISSION_AUDIO_BANK = 1065429086337593735
    NETWORK_SET_ATTRIBUTE_DAMAGE_TO_PLAYER = 1071349206298201918
    PED_TO_NET = 1071509001333212809
    GET_VEHICLE_WINDOW_TINT = 1072440087508450453
    STOP_GAMEPLAY_CAM_SHAKING = 1078962439376650616
    CLEAR_TIMECYCLE_MODIFIER = 1083088722320385809
    NETWORK_IS_GAMER_IN_MY_SESSION = 1085561427425302249
    NETWORK_ALLOW_CLONING_WHILE_IN_TUTORIAL = 1088265022765349781
    WAYPOINT_PLAYBACK_PAUSE = 1095541594788396757
    ALLOW_BOAT_BOOM_TO_ANIMATE = 1097555932723245622
    TASK_VEHICLE_PARK = 1098373536217184078
    IS_ENTITY_TOUCHING_MODEL = 1099496473397398668
    CLEAR_PLAYER_PARACHUTE_VARIATION_OVERRIDE = 1102477168737024801
    SET_PED_TREATED_AS_FRIENDLY = 1108555744747593070
    BG_DOES_LAUNCH_PARAM_EXIST = 1112141424794654182
    GET_IS_USING_ALTERNATE_DRIVEBY = 1112515670661118870
    PLAYSTATS_FRIEND_ACTIVITY = 1112914853483403505
    SC_LICENSEPLATE_ISVALID = 1113296461350463280
    TASK_CLEAR_LOOK_AT = 1116979696540292745
    STOP_ALL_GARAGE_ACTIVITY = 1119119462339091814
    NETWORK_EARN_ARENA_CAREER_PROGRESSION = 1124201214560519705
    TASK_VEHICLE_ESCORT = 1127840232930026496
    ADD_CAM_SPLINE_NODE_USING_CAMERA = 1132696415976092923
    SET_VEHICLE_MODEL_IS_SUPPRESSED = 1135708215248050196
    SET_PLAYER_SWITCH_ESTABLISHING_SHOT = 1143524802295151717
    NETWORK_SPENT_PA_HELI_PICKUP = 1146414581149100851
    SET_PLAYER_FORCED_AIM = 1147942369090643750
    NETWORK_OVERRIDE_RECEIVE_RESTRICTIONS_ALL = 1149128375812852473
    SET_TASK_MOVE_NETWORK_ENABLE_COLLISION_ON_NETWORK_CLONE_WHEN_FIXED = 1151580605323675577
    GET_TATTOO_SHOP_DLC_ITEM_INDEX = 1158624018000152172
    GET_CURRENT_PED_VEHICLE_WEAPON = 1159492374221042396
    GET_TOTAL_DURATION_OF_VEHICLE_RECORDING_ID = 1165608030841583334
    SET_CREATE_RANDOM_COPS = 1165984467287626605
    REMOVE_ROAD_NODE_SPEED_ZONE = 1167337338073268903
    SET_FIRST_PERSON_SHOOTER_CAMERA_HEADING = 1169125920733647986
    SET_WEAPON_ANIMATION_OVERRIDE = 1177036244454935001
    SET_VEHICLE_HANDLING_OVERRIDE = 1181455667866985021
    RESTART_FRONTEND_MENU = 1184567402074819008
    DRAW_LOW_QUALITY_PHOTO_TO_PHONE = 1185274728117465470
    NETWORK_IS_SIGNED_ONLINE = 1186549578762377154
    SET_SHORT_SLOWDOWN_FOR_LANDING = 1187339781137647529
    BG_END_CONTEXT_HASH = 1188489364839345089
    SEETHROUGH_SET_COLOR_NEAR = 1190659471955939422
    SET_DONT_PROCESS_VEHICLE_GLASS = 1191127947843525355
    UI3DSCENE_MAKE_PUSHED_PRESET_PERSISTENT = 1192295468473375163
    TERMINATE_THIS_THREAD = 1193458620648027898
    SET_VEHICLE_TURRET_SPEED_THIS_FRAME = 1194369293196529990
    DOES_PLAYER_VEH_HAVE_RADIO = 1195309752322279585
    SET_MOBILE_RADIO_ENABLED_DURING_GAMEPLAY = 1195764362099706803
    UPDATE_NAVMESH_BLOCKING_OBJECT = 1197563013489034887
    PLAYSTATS_VEH_DEL = 1199806834163324624
    TASK_VEHICLE_SHOOT_AT_PED = 1201071848380568792
    NETWORK_GET_TUNABLE_CLOUD_CRC = 1206158184553319812
    END_TEXT_COMMAND_IS_THIS_HELP_MESSAGE_BEING_DISPLAYED = 1206362151968843997
    REGISTER_ENUM_TO_SAVE = 1207803046896150689
    CLEAR_PLAYER_PARACHUTE_PACK_MODEL_OVERRIDE = 1208458126999759682
    GET_IS_LOADING_SCREEN_ACTIVE = 1211654058606673609
    BUSYSPINNER_OFF = 1212439384324545549
    NETWORK_IS_GAME_IN_PROGRESS = 1223487422827645399
    SET_PED_ENVEFF_CPV_ADD = 1229291841594331423
    ADD_TEXT_COMPONENT_SUBSTRING_TIME = 1231155517346932927
    FORCE_SONAR_BLIPS_THIS_FRAME = 1234478473798820520
    NETWORK_SPENT_PA_SERVICE_HELI = 1234560028263891002
    SET_PED_TO_INFORM_RESPECTED_FRIENDS = 1236592994736994059
    NET_GAMESERVER_DELETE_SET_TELEMETRY_NONCE_SEED = 1237626875751240607
    TASK_GO_TO_COORD_WHILE_AIMING_AT_COORD = 1238871098294766272
    IS_NAMED_RENDERTARGET_LINKED = 1240548542186197656
    SET_TV_AUDIO_FRONTEND = 1242197853481080692
    NETWORK_CLAN_RELEASE_EMBLEM = 1242551761124886192
    NETWORK_SESSION_SET_SCRIPT_VALIDATE_JOIN = 1248616410999489820
    SET_VEHICLE_FIXED = 1249505568339610652
    UNHINT_NAMED_SCRIPT_AUDIO_BANK = 1249640680755152030
    OVERRIDE_SAVE_HOUSE = 1252821528711679722
    SC_EMAIL_SEND_EMAIL = 1256426564723646231
    NETWORK_SEND_IMPORTANT_TRANSITION_INVITE_VIA_PRESENCE = 1256972113491362230
    SET_OVERRIDE_WEATHEREX = 1259003504230393228
    LEADERBOARDS_GET_NUMBER_OF_COLUMNS = 1259676479113854766
    IS_PED_VAULTING = 1260006042825329502
    SET_TEXT_INPUT_BOX_ENABLED = 1262600024832291372
    DATADICT_GET_BOOL = 1262859536984702700
    SET_FIRE_AMMO_THIS_FRAME = 1263150695653912820
    PLAYSTATS_CARCLUB_CHALLENGE = 1263201802941349591
    NETWORK_EARN_FIRST_TIME_BONUS = 1274696868198055478
    WAS_PED_SKELETON_UPDATED = 1275813652435273049
    PRELOAD_CLOUD_HAT = 1276048922525190248
    STAT_GET_BOOL = 1276179861973759118
    IS_PICKUP_WEAPON_OBJECT_VALID = 1284059407967621630
    SET_PLAYER_PHONE_PALETTE_IDX = 1285205011011698912
    ARE_ALL_VEHICLE_WINDOWS_INTACT = 1285886149750401519
    CLEAR_ANGLED_AREA_OF_VEHICLES = 1286680396691581098
    CEIL = 1288057844309609610
    GET_DISABLED_CONTROL_NORMAL = 1289816700883198844
    STOP_SYNCHRONIZED_MAP_ENTITY_ANIM = 1290172078422734581
    SET_FIRST_PERSON_FLASH_EFFECT_VEHICLE_MODEL_HASH = 1295450322785262919
    REQUEST_SCALEFORM_MOVIE = 1296532278728670831
    PRESENCE_EVENT_UPDATESTAT_INT = 1296786554448025581
    SET_CAN_USE_HYDRAULICS = 1297573955125263256
    NETWORK_GET_PLATFORM_PARTY_MEMBERS = 1297992022934018808
    CLEAR_AMBIENT_ZONE_LIST_STATE = 1300494407988977572
    NETWORK_IS_ACTIVITY_SPECTATOR = 1301605842312729339
    REQUEST_RAGDOLL_BOUNDS_UPDATE = 1303476255918442243
    IS_ENTITY_STATIC = 1304045565746447143
    VEHICLE_WAYPOINT_PLAYBACK_OVERRIDE_SPEED = 1305768549647921623
    PLAYSTATS_ROS_BET = 1305961281935463057
    IS_PED_A_PLAYER = 1320482904327632523
    CREATE_NON_NETWORKED_PORTABLE_PICKUP = 1320844115333720823
    NETWORK_SPEND_APARTMENT_UTILITIES = 1320880373585870141
    SET_AUDIO_SPECIAL_EFFECT_MODE = 1321278500475067292
    IS_POINT_ON_ROAD = 1322919935073282825
    NETWORK_GET_LAST_PLAYER_POS_RECEIVED_OVER_NETWORK = 1323615614803510740
    DOES_EXTRA_EXIST = 1324855812493050196
    SET_ARTIFICIAL_LIGHTS_STATE = 1326417132894082308
    ADD_OIL_DECAL = 1327857695801580126
    TASK_SCRIPTED_ANIMATION = 1328270928019696613
    RESET_RETICULE_VALUES = 1330863033260894704
    LOCK_MINIMAP_POSITION = 1331350670911596351
    SET_BLIP_NAME_TO_PLAYER_NAME = 1332475816669390499
    CLEAR_PED_PARACHUTE_PACK_VARIATION = 1333206568589405548
    NETWORK_EARN_DOOMSDAY_FINALE_BONUS = 1336008329522252114
    CAN_PED_RAGDOLL = 1337421676636164053
    SET_FORCE_FOOTSTEP_UPDATE = 1338808158756540301
    IS_VEHICLE_IN_BURNOUT = 1339724742140375275
    GOLF_TRAIL_SET_COLOUR = 1340207016701830657
    SET_PLAYER_INVISIBLE_LOCALLY = 1347558514964148408
    GET_NUM_CREATED_MISSION_OBJECTS = 1348309236691961536
    NETWORK_SPENT_BUY_BUNKER = 1355945031293784313
    SET_CUTSCENE_CAM_FAR_CLIP_THIS_UPDATE = 1359762501013896869
    SET_BLIP_SHOW_CONE = 1374300214002618081
    SET_WHEELIE_ENABLED = 1374404757029580366
    IS_POP_MULTIPLIER_AREA_NETWORKED = 1374429882756406499
    NETWORK_EARN_FROM_BOUNTY = 1376894059356175055
    HAS_ENTITY_BEEN_DAMAGED_BY_WEAPON = 1377327512274689684
    DOES_POP_MULTIPLIER_AREA_EXIST = 1380321393899911918
    GET_CLOSEST_ROAD = 1382414576514039442
    IS_USING_CURSOR = 1383584994661180681
    NETWORK_CLAN_REQUEST_EMBLEM = 1392052028417673528
    NETWORK_HAS_AGE_RESTRICTIONS = 1392729932145385991
    NETWORK_CAN_GAMER_PLAY_MULTIPLAYER_WITH_ME = 1396005364152738181
    IS_SHOCKING_EVENT_IN_SPHERE = 1401934189730442130
    SET_PED_BLEND_FROM_PARENTS = 1403923538616627757
    END_TEXT_COMMAND_THEFEED_POST_CREWTAG_WITH_GAME_NAME = 1403930481009053214
    SET_CAM_SPLINE_DURATION = 1405496505074404570
    IS_XBOX_PLATFORM = 1406945842121809747
    ASSISTED_MOVEMENT_OVERRIDE_LOAD_DISTANCE_THIS_FRAME = 1410850791483177234
    NETWORK_TRANSITION_SET_IN_PROGRESS = 1411975427025712109
    NETWORK_GET_PVC_TRANSFER_BALANCE = 1416626379868144883
    OVERRIDE_TREVOR_RAGE = 1417901953124670078
    REPLAY_CANCEL_EVENT = 1419567061659479568
    PAUSE_MENU_GET_MOUSE_HOVER_UNIQUE_ID = 1424467214412173952
    GET_CLOCK_MINUTES = 1428407088615670002
    REMOVE_ACTION_MODE_ASSET = 1434749392412277329
    GET_PLAYER_TARGET_ENTITY = 1436051958677346249
    SET_NON_PARTICIPANTS_OF_THIS_SCRIPT_AS_GHOSTS = 1437207593544589488
    NETWORK_CLEAR_OFFLINE_INVITE_PENDING = 1445209372988412366
    TASK_START_SCENARIO_IN_PLACE = 1452976313881078745
    SET_DISABLE_VEHICLE_EXPLOSIONS_DAMAGE = 1457233219157249378
    NETWORK_ALLOW_REMOTE_SYNCED_SCENE_LOCAL_PLAYER_REQUESTS = 1463001728641853400
    SET_FAKE_WANTED_LEVEL = 1465062155054416227
    IS_PED_TAKING_OFF_HELMET = 1466218391922666629
    GET_PED_EMISSIVE_SCALE = 1468651259382824296
    START_ROPE_WINDING = 1468673947584050238
    RELEASE_CONTROL_OF_FRONTEND = 1468766879242052274
    NETWORK_SPEND_CAR_CLUB_MEMBERSHIP = 1469547258303035106
    NETWORK_EARN_AWARD_CONTRACT = 1471919200337018943
    IS_VEHICLE_ATTACHED_TO_TOW_TRUCK = 1472107446507642836
    HAS_ASYNC_INSTALL_FINISHED = 1478073423969468357
    SET_BLIP_SECONDARY_COLOUR = 1479754035503172075
    CLONE_PED_TO_TARGET_ALT = 1480286535372552324
    NETWORK_IS_QUEUING_FOR_SESSION_JOIN = 1482298714948592112
    HARD_ATTACH_CAM_TO_PED_BONE = 1484242793922864141
    SET_PED_WALLA_DENSITY = 1484761153065925273
    GET_OWNER_OF_EXPLOSION_IN_ANGLED_AREA = 1493589382222802156
    HUD_SHOWING_CHARACTER_SWITCH_SELECTION = 1498007404799336291
    SET_CONTROL_TRIGGER_SHAKE = 1500432811139004044
    GET_GAMEPLAY_CAM_COORD = 1501657350880041783
    DISABLE_SCRIPT_BRAIN_SET = 1502040148594978959
    SET_PLAYER_CLOTH_LOCK_COUNTER = 1502253629415880154
    PLAYSTATS_JOB_LTS_ROUND_END = 1504398889163179232
    SET_PED_AMMO = 1505728147329083929
    SET_VEHICLE_SEARCHLIGHT = 1506555638038451522
    NETWORK_SPENT_ARENA_JOIN_SPECTATOR = 1507274693168289199
    PLAYSTATS_BC_PROTECTION_RACKET = 1508048290572998182
    SET_SCENARIO_PEDS_TO_BE_RETURNED_BY_NEXT_COMMAND = 1509157256951236382
    GET_NEXT_BLIP_INFO_ID = 1511356407087087271
    PROCGRASS_ENABLE_AMBSCALESCAN = 1512180552135033000
    SET_PED_STEERS_AROUND_OBJECTS = 1515954447145109695
    CREATE_FORCED_OBJECT = 1517291459887904858
    APP_GET_FLOAT = 1519115109592212258
    UGC_COPY_CONTENT = 1526035160925238154
    NETWORK_AM_I_BLOCKED_BY_GAMER = 1527701571273107378
    ADD_ENTITY_TO_AUDIO_MIX_GROUP = 1529380729329191296
    GET_USER_STARTER_ACCESS = 1536967363972650757
    SET_MP_GAMER_TAGS_POINT_HEALTH = 1541355004996259431
    IS_RADAR_HIDDEN = 1549119181875577954
    SET_WARNING_MESSAGE_WITH_HEADER_AND_SUBSTRING_FLAGS_EXTENDED = 1549308555660265259
    SET_PACKED_STAT_INT_CODE = 1549607960675208494
    TASK_VEHICLE_DRIVE_TO_COORD_LONGRANGE = 1552531582173918732
    NETWORK_CASINO_CAN_BET = 1552641216897565176
    UGC_QUERY_BY_CONTENT_ID = 1553394584470340713
    SET_GLOBAL_RADIO_SIGNAL_LEVEL = 1556964644180597976
    DOES_PED_HAVE_AI_BLIP = 1565261421563766765
    NETWORK_EARN_GANGOPS_WAGES_BONUS = 1565891872037976351
    GET_FRAME_TIME = 1568387602608814839
    TASK_BOAT_MISSION = 1569610105169438271
    THEFEED_SHOW = 1571656529949308399
    TASK_FOLLOW_NAV_MESH_TO_COORD = 1572784988947265811
    GET_ENTITY_MAX_HEALTH = 1573822666447981628
    CLEAR_ALL_TCMODIFIER_OVERRIDES = 1577159921918073952
    CELL_CAM_SET_SELFIE_MODE_ROLL_OFFSET = 1578122614122105741
    SET_USE_KINEMATIC_PHYSICS = 1583372004919288402
    DATAFILE_HAS_LOADED_FILE_DATA = 1585076544250520403
    OVERRIDE_INTERIOR_SMOKE_LEVEL = 1585545850718698514
    DOOR_SYSTEM_GET_DOOR_STATE = 1588259609567639992
    DISABLE_PROCOBJ_CREATION = 1590549533371010372
    TEXTURE_DOWNLOAD_REQUEST = 1591474530483598498
    UGC_DID_DESCRIPTION_REQUEST_SUCCEED = 1597691320513399394
    GET_FINAL_RENDERED_CAM_MOTION_BLUR_STRENGTH = 1598669674660486169
    NETWORK_CONCEAL_ENTITY = 1599549771081984118
    REMOVE_ANIM_SET = 1600190916137591987
    SEETHROUGH_SET_HIGHLIGHT_NOISE = 1600704195218575570
    GET_OFFSET_FROM_COORD_AND_HEADING_IN_WORLD_COORDS = 1602759396355842355
    GET_COORDS_AND_ROTATION_OF_CLOSEST_OBJECT_OF_TYPE = 1603153204248928042
    SET_TRAIN_CRUISE_SPEED = 1605131416520909493
    PLAYSTATS_FM_EVENT_KINGOFTHECASTLE = 1606764678899894341
    SET_TRACKED_POINT_INFO = 1607446090157984944
    CLEAR_CUSTOM_RADIO_TRACK_LIST = 1609177368812381182
    NETWORK_SPENT_UPGRADE_TILTROTOR = 1611747008643213575
    SET_ENTITY_MAX_HEALTH = 1616366714517706933
    GET_STATUS_OF_LOAD_MISSION_CREATOR_PHOTO = 1617065839810769495
    IS_SCRIPTED_CONVERSATION_ONGOING = 1618283570897280573
    ATTACH_ENTITY_TO_ENTITY_PHYSICALLY_OVERRIDE_INVERSE_MASS = 1624121411865611172
    GET_CHARACTER_FROM_AUDIO_CONVERSATION_FILENAME = 1629134525311535296
    SET_SECOND_SCRIPT_VARIABLE_HUD_COLOUR = 1631152879335897785
    SET_CAM_USE_SHALLOW_DOF_MODE = 1632951117018387131
    ATTACH_VEHICLE_ON_TO_TRAILER = 1636463030648963832
    NETWORK_IS_CONNECTED_VIA_RELAY = 1644892042565162939
    SC_EMAIL_GET_RETRIEVAL_STATUS = 1646770941550933162
    FORCE_PED_TO_OPEN_PARACHUTE = 1649494491004346913
    IS_COP_PED_IN_AREA_3D = 1651774575515508574
    GET_POSITION_BY_SIDE_OF_ROAD = 1654069771508910564
    GET_PED_CAUSE_OF_DEATH = 1657294059935554649
    NET_GAMESERVER_RETRIEVE_START_SESSION_STATUS = 1659875569343973561
    REGISTER_POSTFX_BULLET_IMPACT = 1659877675174752041
    USE_FAKE_MP_CASH = 1661639275829907934
    SET_ENTITY_DYNAMIC = 1664324764839715786
    DOES_POP_MULTIPLIER_SPHERE_EXIST = 1665117673899657716
    UGC_REQUEST_CONTENT_DATA_FROM_INDEX = 1665758607481746396
    ADD_TEXT_COMPONENT_SUBSTRING_TEXT_LABEL_HASH_KEY = 1669035989767043627
    ADD_OWNED_EXPLOSION = 1669324415570677779
    NETWORK_PLAYER_GET_CHEATER_REASON = 1670683415317459898
    RESET_GHOST_ALPHA = 1671696100976829608
    THEFEED_SET_RGBA_PARAMETER_FOR_NEXT_MESSAGE = 1676196205975159618
    UGC_CLEAR_CREATE_RESULT = 1676476649456875321
    SC_PROFANITY_GET_CHECK_IS_VALID = 1680744588958193838
    SET_DEBUG_LINES_AND_SPHERES_DRAWING_ACTIVE = 1683057616194752709
    SET_ENTITY_CAN_BE_DAMAGED = 1684627360525536614
    IS_PLAYER_PARTIALLY_INSIDE_GARAGE = 1684870029825395626
    PLAYSTATS_SHOP_ITEM = 1686688962002908113
    STAT_SET_GXT_LABEL = 1686967509200874208
    CLEAR_PED_SECONDARY_TASK = 1687984505842882311
    NETWORK_SET_PROPERTY_ID = 1690422282951576412
    THEFEED_SET_FLASH_DURATION_PARAMETER_FOR_NEXT_MESSAGE = 1706174414124341386
    GET_PED_BONE_COORDS = 1711508347870014286
    NETWORK_SPENT_TAXI = 1712396808525593081
    NETWORK_KEEP_ENTITY_COLLISION_DISABLED_AFTER_ANIM_SCENE = 1714149902278879053
    GET_TENNIS_SWING_ANIM_COMPLETE = 1720208855854118904
    NETWORK_START_SOLO_TUTORIAL_SESSION = 1720403143394771659
    TASK_FOLLOW_NAV_MESH_TO_COORD_ADVANCED = 1726439451896699820
    SPECIAL_ABILITY_DEACTIVATE_MP = 1726927179191124624
    DISABLE_CINEMATIC_SLOW_MO_THIS_UPDATE = 1728440085408580099
    IS_ENTITY_TOUCHING_ENTITY = 1729313755305976980
    ENABLE_SPECIAL_ABILITY = 1738039364168966433
    DOES_CARGOBOB_HAVE_PICK_UP_ROPE = 1738909640402755848
    SET_VEHICLE_CUSTOM_PATH_NODE_STREAMING_RADIUS = 1742653826879335403
    SET_VEHICLE_FRICTION_OVERRIDE = 1745056329391671738
    SET_PED_INFINITE_AMMO_CLIP = 1746743299266654598
    START_CUTSCENE = 1760164965717704571
    GET_WAYPOINT_BLIP_ENUM_ID = 1760446918642962045
    GET_ANGLE_BETWEEN_2D_VECTORS = 1760842301871889554
    NETWORK_GET_CONTENT_MODIFIER_LIST_ID = 1761895883644905155
    GET_PLAYER_SPRINT_TIME_REMAINING = 1767025802996305049
    NETWORK_CLEAR_GROUP_ACTIVITY = 1767778616599332241
    IS_REPLAY_RECORDING = 1772107567646544052
    GET_OFFSET_FROM_ENTITY_IN_WORLD_COORDS = 1772715284438788168
    SET_GAMEPLAY_ENTITY_HINT = 1774019519209267864
    GET_MELEE_TARGET_FOR_PED = 1775519886837546297
    NETWORK_DOES_ENTITY_EXIST_WITH_NETWORK_ID = 1775681623300832616
    NETWORK_DEDUCT_CASH = 1781083639959289382
    GET_NO_LOADING_SCREEN = 1783749871316081084
    NETWORK_GET_NUM_PARTICIPANTS = 1788005393069262420
    REMOVE_ENTITY_FROM_AUDIO_MIX_GROUP = 1795608933623082656
    SET_NIGHTVISION = 1798662448701634653
    APPLY_FORCE_TO_ENTITY_CENTER_OF_MASS = 1801159460433909150
    CLEAR_OBJECTS_INSIDE_GARAGE = 1802610079936284306
    SET_PED_CONFIG_FLAG = 1807067481085428835
    SET_VEHICLE_CAN_LEAK_PETROL = 1811932647050764253
    IS_HUD_PREFERENCE_SWITCHED_ON = 1815196559013396164
    SET_FOLLOW_VEHICLE_CAM_ZOOM_LEVEL = 1821227447711403146
    NETWORK_ACCESS_TUNABLE_FLOAT_MODIFICATION_DETECTION_REGISTRATION_HASH = 1824198545570940729
    RESET_PLAYER_INPUT_GAIT = 1824833368012609169
    TASK_VEHICLE_GOTO_NAVMESH = 1827035043851133678
    SC_COMMUNITY_EVENT_GET_DISPLAY_NAME_BY_ID = 1838941285278776266
    SC_LICENSEPLATE_ADD = 1840220618037819048
    SC_ACCOUNT_INFO_GET_NICKNAME = 1841152146231184511
    SET_FOCUS_ENTITY = 1841822097142223645
    IS_MISSION_COMPLETE_PLAYING = 1847333620734394250
    IS_MODEL_A_VEHICLE = 1849511532187010366
    UNHINT_AMBIENT_AUDIO_BANK = 1850837445463126104
    SHOW_FOR_SALE_ICON_ON_BLIP = 1854759825759971578
    GET_TENNIS_SWING_ANIM_CAN_BE_INTERRUPTED = 1855462174485675081
    GET_CAM_ACTIVE_VIEW_MODE_CONTEXT = 1858572934129894143
    TASK_AGITATED_ACTION_CONFRONT_RESPONSE = 1860469957888209150
    NETWORK_PLAYER_IS_BADSPORT = 1862478201098863706
    SET_MINIGAME_IN_PROGRESS = 1864505033887250523
    SEETHROUGH_SET_HILIGHT_INTENSITY = 1865913799274274088
    SET_USER_RADIO_CONTROL_ENABLED = 1869590208789261902
    GET_SHOP_PED_OUTFIT_COMPONENT_VARIANT = 1869732884373307711
    SET_ENTITY_USE_MAX_DISTANCE_FOR_WATER_REFLECTION = 1876078757970742166
    PLAYSTATS_FREEMODE_CASINO_MISSION_ENDED = 1877238448262970309
    NETWORK_IS_FRIEND = 1883808089400088148
    DISABLE_AIM_CAM_THIS_UPDATE = 1887568996038165238
    SET_LADDER_CLIMB_INPUT_STATE = 1887867140601310145
    SET_ROADS_IN_ANGLED_AREA = 1899007354032479065
    SET_MINIMAP_IN_SPECTATOR_MODE = 1899630041123425491
    GET_NAMED_RENDERTARGET_RENDER_ID = 1901777666213403707
    PLAYSTATS_ROBBERY_PREP = 1902735379545208885
    SET_WEAPON_IMPACTS_APPLY_GREATER_FORCE = 1904102380720412573
    SET_CONVERTIBLE_ROOF_LATCH_STATE = 1907464921881269103
    PLAYSTATS_FM_EVENT_PENNEDIN = 1908655210799379589
    IS_BULLET_IN_ANGLED_AREA = 1912727178083218551
    ADD_TCMODIFIER_OVERRIDE = 1913515869824373916
    STAT_GET_FLYING_ALTITUDE = 1913645162782162363
    SET_ENTITY_COLLISION = 1914599121192125055
    ADD_STUNT_JUMP = 1916613292774941452
    SET_VEHICLE_HAS_UNBREAKABLE_LIGHTS = 1920970198774881684
    CLOSE_MP_TEXT_CHAT = 1930061465283338535
    UGC_GET_CONTENT_RATING = 1931195021371552494
    NETWORK_IS_PLAYER_A_PARTICIPANT_ON_SCRIPT = 1933652918107981856
    START_PARTICLE_FX_LOOPED_ON_ENTITY = 1937722214304277783
    CELL_CAM_SET_SELFIE_MODE_SIDE_OFFSET_SCALING = 1948733653416260636
    CLEAR_REPLAY_STATS = 1953068219433474645
    SET_AI_WEAPON_DAMAGE_MODIFIER = 1954045745482663201
    NETWORK_SPEND_AGENCY = 1954879173856072284
    SET_OPEN_REAR_DOORS_ON_EXPLOSION = 1954891159175955679
    GET_BENCHMARK_PASS = 1955519654984534239
    ADD_SCENARIO_BLOCKING_AREA = 1971597822648460654
    SET_PED_RACE_AND_VOICE_GROUP = 1980104060019931335
    NETWORK_GET_PARTICIPANT_INDEX = 1982955386380249400
    NETWORK_SET_PLAYER_IS_PASSIVE = 1983121393000847988
    NETWORK_SERVICE_EARN_GANGOPS_RIVAL_DELIVERY = 1983871953063809058
    BLIP_SIREN = 1986128932158055094
    SET_CAM_DEBUG_NAME = 1987178221944560960
    SET_VEH_RADIO_STATION = 1989465795936398022
    SCRIPT_RACE_PLAYER_HIT_CHECKPOINT = 1995826017863633939
    VEHICLE_SET_ENABLE_RAMP_CAR_SIDE_IMPULSE = 1998131056741791318
    SET_TAKEN_PHOTO_IS_MUGSHOT = 1998493613207973342
    HAS_VEHICLE_ASSET_LOADED = 1999040935582472737
    NETWORK_SPEND_BOUNTY_HUNTER_MISSION = 2011434310601587487
    GET_FIRST_BLIP_INFO_ID = 2012513321047894559
    IS_PED_USING_SCENARIO = 2013272256919514158
    ENABLE_VEHICLE_FANBELT_DAMAGE = 2019638435461318354
    NETWORK_EARN_GANGOPS_FINALE = 2022714132207111506
    GET_ACHIEVEMENT_PROGRESS = 2024482621431583541
    SET_PICKUP_UNCOLLECTABLE = 2025328983738530455
    NETWORK_CAN_SHARE_JOB_CASH = 2027872382674036410
    NETWORK_SPENT_BETTING = 2036594400476948783
    IS_PAUSE_MENU_RESTARTING = 2038185694189597127
    TERRAINGRID_SET_PARAMS = 2040066263258861128
    SET_IS_OBJECT_ARTICULATED = 2042322277382900010
    TASK_PUT_PED_DIRECTLY_INTO_MELEE = 2048242048576781881
    DOES_TEXT_BLOCK_EXIST = 2049985447167629193
    IS_PED_HANGING_ON_TO_VEHICLE = 2055568525940312952
    IS_PLAYBACK_GOING_ON_FOR_VEHICLE = 2056539932144865004
    SET_ENTITY_VELOCITY = 2060884443309461871
    START_CUTSCENE_AT_COORDS = 2061203472233668543
    STOP_SCRIPT_GLOBAL_SHAKING = 2061937563044885648
    SET_TEXT_DROP_SHADOW = 2063750248883895902
    NETWORK_SET_THIS_SCRIPT_IS_NETWORK_SCRIPT = 2064229935073689765
    PLAYSTATS_CRATE_DROP_MISSION_DONE = 2066691732226574320
    SET_TRANSITION_OUT_OF_TIMECYCLE_MODIFIER = 2069973225690361349
    REPLACE_HUD_COLOUR = 2075157288053966355
    END_TEXT_COMMAND_THEFEED_POST_MESSAGETEXT = 2075484565200204495
    SET_PED_CAN_SMASH_GLASS = 2075618556141060770
    GET_VEHICLE_TRAILER_VEHICLE = 2079936996953260813
    DRAW_SCALEFORM_MOVIE_3D_SOLID = 2082232021396608757
    IS_CONTROL_ENABLED = 2083596516048037337
    GET_MOBILE_PHONE_ROTATION = 2085085397178675374
    SET_VEHICLE_STAYS_FROZEN_WHEN_CLEANED_UP = 2086166438371148249
    ACOS = 2092125917621793974
    SC_COMMUNITY_EVENT_GET_EXTRA_DATA_STRING_FOR_TYPE = 2094918676218898734
    SET_SCALEFORM_MOVIE_AS_NO_LONGER_NEEDED = 2095068147598518289
    SET_TIME_SCALE = 2107831375318018078
    SC_LICENSEPLATE_GET_PLATE = 2108888205053243600
    IS_COMMERCE_DATA_FETCH_IN_PROGRESS = 2111556539582951408
    SPECIAL_ABILITY_DEPLETE_METER = 2112308878322558539
    SET_ENTITY_ICON_COLOR = 2116508604963152440
    UGC_GET_CONTENT_HAS_LO_RES_PHOTO = 2116989453190239961
    SET_AMBIENT_ZONE_STATE_PERSISTENT = 2118468919339294011
    NETWORK_GET_HOST_OF_SCRIPT = 2119529604139398908
    SET_VEHICLE_USE_ALTERNATE_HANDLING = 2132403724273476767
    SET_GROUP_FORMATION_SPACING = 2133937666023541014
    GET_IS_WHEELS_RETRACTED = 2134946589942270143
    MP_TEXT_CHAT_DISABLE = 2139801655277685667
    IS_ENTITY_UPSIDEDOWN = 2142966313329761649
    NETWORK_SPENT_UPGRADE_NIGHTCLUB_AND_WAREHOUSE = 2146448225466198059
    NETWORK_SET_RICH_PRESENCE = 2147281187475198818
    IS_WAYPOINT_ACTIVE = 2148768492990438821
    BEGIN_TAKE_MISSION_CREATOR_PHOTO = 2148801526940884200
    TASK_GO_TO_COORD_ANY_MEANS_EXTRA_PARAMS = 2149448057859283913
    GET_ENTITY_HEIGHT_ABOVE_GROUND = 2149720059000459493
    PLAYER_DETACH_VIRTUAL_BOUND = 2149775572197631945
    SET_VEHICLE_ALLOW_HOMING_MISSLE_LOCKON_SYNCED = 2151040074505494254
    TASK_TURN_PED_TO_FACE_COORD = 2151193443362375025
    UGC_PUBLISH = 2152991054724480170
    SET_PLAYER_MAY_NOT_ENTER_ANY_VEHICLE = 2153701109743272266
    SET_ABILITY_BAR_VISIBILITY = 2161407953474885033
    TASK_VEHICLE_HELI_PROTECT = 2164475639359274268
    SET_FADE_OUT_AFTER_ARREST = 2164909536560850151
    PLAYSTATS_INSTANCED_HEIST_ENDED = 2167524243805339925
    SET_PARTICLE_FX_NON_LOOPED_EMITTER_SIZE = 2174677594349752942
    GET_BLIP_INFO_ID_DISPLAY = 2175592009778191419
    COMPARE_STRINGS = 2176488828314497259
    BLOCK_PLAYERS_FOR_AMBIENT_PICKUP = 2179490549748869802
    REMOVE_ALL_AIR_DEFENCE_SPHERES = 2181346728676877454
    PREPARE_MUSIC_EVENT = 2184674316064724362
    END_TEXT_COMMAND_THEFEED_POST_MESSAGETEXT_TU = 2190457049005153131
    GET_FM_MALE_SHOP_PED_APPAREL_ITEM_INDEX = 2195498746919152716
    TASK_EXTEND_ROUTE = 2195655964724855866
    REMOVE_WEAPON_COMPONENT_FROM_PED = 2201109082612124681
    INIT_SHOP_PED_COMPONENT = 2201187712157007926
    IS_PED_RINGTONE_PLAYING = 2201800761837236535
    SET_SCENE_STREAMING_TRACKS_CAM_POS_THIS_FRAME = 2202356593894833699
    SET_PED_DESIRED_MOVE_BLEND_RATIO = 2204559057982395077
    GET_PED_TIME_OF_DEATH = 2204654383702665610
    SET_RACE_TRACK_RENDER = 2210246596673425523
    SUPRESS_RANDOM_EVENT_THIS_FRAME = 2210715937190483106
    CUSTOM_MINIMAP_SET_BLIP_OBJECT = 2210825213572701946
    IS_VEHICLE_NODE_ID_VALID = 2211039805179277172
    GET_PHONE_GESTURE_ANIM_TOTAL_TIME = 2225049290569801414
    SET_ROADS_BACK_TO_ORIGINAL = 2226755393395083132
    STREAMVOL_DELETE = 2226986994190643283
    IS_ENTITY_PLAYING_ANIM = 2237014829242392265
    GET_NUM_RESERVED_MISSION_PEDS = 2239368384589430295
    SC_PRESENCE_ATTR_SET_INT = 2242395150778537927
    LOAD_STREAM = 2242675453442413023
    IS_IN_VEHICLE_MOBILE_PHONE_CAMERA_RENDERING = 2243637913380698102
    IS_VEHICLE_HIGH_DETAIL = 2244350069363982968
    SET_VEHICLE_MOD_KIT = 2245783831530643834
    FORCE_PLAYBACK_RECORDED_VEHICLE_UPDATE = 2246819055516817707
    SET_CARGOBOB_EXCLUDE_FROM_PICKUP_ENTITY = 2248616050735793024
    REMOVE_SPECIFIC_COVER_BLOCKING_AREAS = 2248735413680690996
    STREAMVOL_CREATE_FRUSTUM = 2251520038503688060
    GET_WIND_DIRECTION = 2251817334770594010
    ADD_HOSPITAL_RESTART = 2253575497185647233
    NETWORK_CLAN_GET_LOCAL_MEMBERSHIPS_COUNT = 2253800347926072303
    NETWORK_FADE_IN_ENTITY = 2255972746681902637
    IS_PLAYLIST_ON_CHANNEL = 2265605279497216609
    NETWORK_SET_PRIVILEGE_CHECK_RESULT_NOT_NEEDED = 2268621601238811172
    NETWORK_TRANSITION_SET_CONTENT_CREATOR = 2273755940310455808
    GET_ENTITY_OF_TYPE_ATTACHED_TO_ENTITY = 2274923869864836390
    SET_VEHICLE_ACT_AS_IF_HIGH_SPEED_FOR_FRAG_SMASHING = 2278740525307151058
    GET_NUMBER_OF_PLAYERS_IN_TEAM = 2288391838204225265
    SET_IGNORE_NO_GPS_FLAG_UNTIL_FIRST_NORMAL_NODE = 2288542884233692943
    GET_BLIP_SPRITE = 2290211554291153999
    SET_VEHICLE_HEADLIGHT_SHADOWS = 2292506429516893524
    NETWORK_EARN_FROM_FMBB_BOSS_WORK = 2295158670222791067
    SET_SIREN_WITH_NO_DRIVER = 2301065097431137522
    SCRIPT_RACE_SHUTDOWN = 2303238929268438399
    SET_PED_STEERS_AROUND_DEAD_BODIES = 2312253178490951804
    PROCESS_CASH_GIFT = 2312964859205818945
    BEGIN_TEXT_COMMAND_THEFEED_POST = 2316831480196236324
    HARD_ATTACH_CAM_TO_ENTITY = 2317769247792682727
    SET_VEHICLE_EXTRA_COLOURS = 2321312457832869427
    PLAYSTATS_PIMENU_HIDE_OPTIONS = 2322511679369343097
    SET_VEHICLE_DOORS_LOCKED_FOR_ALL_TEAMS = 2322540730124832844
    NETWORK_GET_FRIEND_COUNT = 2323607807883683748
    TASK_SWEEP_AIM_ENTITY = 2326038982017040474
    RESET_PED_STRAFE_CLIPSET = 2328651364711703671
    GET_PED_RAGDOLL_BONE_INDEX = 2330594670382917490
    GET_ROTATION_OF_VEHICLE_RECORDING_AT_TIME = 2330648471473334445
    SET_VEHICLE_CAN_ENGINE_MISSFIRE = 2336178383040988938
    SET_CUTSCENE_MULTIHEAD_FADE = 2338616680855544775
    SET_ANIM_WEIGHT = 2341619226725592904
    REPLAY_CHECK_FOR_EVENT_THIS_FRAME = 2343987307675302960
    SET_PED_DROPS_INVENTORY_WEAPON = 2344713528402755814
    GET_CLOUDS_ALPHA = 2354298381451283076
    MAKE_PED_RELOAD = 2354876776827322419
    IS_ENTITY_AT_COORD = 2357081991963017295
    HAS_ENTITY_ANIM_FINISHED = 2357372060430414962
    SET_SRL_LONG_JUMP_MODE = 2361794840612055679
    HAS_PLAYER_DAMAGED_AT_LEAST_ONE_PED = 2363968351086004940
    WAYPOINT_PLAYBACK_START_AIMING_AT_PED = 2369791238929489193
    GET_PLAYER_SHORT_SWITCH_STATE = 2375816641523492864
    HIDE_MINIMAP_INTERIOR_MAP_THIS_FRAME = 2377478253056964800
    HAS_CODE_REQUESTED_AUTOSAVE = 2380050660515190893
    GET_INTERIOR_FROM_ENTITY = 2380075781929936571
    SET_VEHICLE_ACTIVE_FOR_PED_NAVIGATION = 2382786615732102506
    DECOR_SET_FLOAT = 2385414517758572090
    DRAW_FRONTEND_BACKGROUND_THIS_FRAME = 2385868713821235287
    SET_DISABLE_WEAPON_BLADE_FORCES = 2386509567115891724
    NEW_LOAD_SCENE_START = 2389877639980251842
    SET_CAN_DISPLAY_MINIMAP_DURING_CUTSCENE_THIS_UPDATE = 2391697727604071172
    COPY_SCRIPT_STRUCT = 2394484724246226860
    GET_ENTITY_ROTATION_VELOCITY = 2394667074804365699
    PLAY_STREAM_FROM_POSITION = 2397092858668377451
    HAS_SCRIPT_HIDDEN_HELP_THIS_FRAME = 2399527321204237418
    GET_VEHICLE_RECORDING_ID = 2401610889199999804
    DOES_ENTITY_HAVE_ANIM_DIRECTOR = 2402925601363484329
    FORCE_SCRIPTED_GFX_WHEN_FRONTEND_ACTIVE = 2405700959651969277
    GET_TV_VOLUME = 2409567900673795611
    GET_PED_USING_VEHICLE_DOOR = 2414659197036496187
    CLEAR_AMBIENT_ZONE_STATE = 2417821992125818111
    SET_TRAIN_TRACK_SPAWN_FREQUENCY = 2420469018626878970
    CLEAR_GPS_FLAGS = 2420798229104011312
    STREAMVOL_CREATE_SPHERE = 2421946546546551293
    NETWORK_GET_PLAYER_LOUDNESS = 2423332742172411519
    GET_ROPE_LAST_VERTEX_COORD = 2430553729362132013
    GET_CLOSEST_POINT_ON_LINE = 2432565831989927514
    IS_ENTITY_A_GHOST = 2436532592392585542
    RESET_VEHICLE_WHEELS = 2437262575350542317
    SET_FIRST_PERSON_FLASH_EFFECT_VEHICLE_MODEL_NAME = 2441605928887934459
    IGNORE_NEXT_RESTART = 2449877097777288033
    SET_TV_CHANNEL_PLAYLIST_AT_HOUR = 2450456787070675944
    GET_USINGNIGHTVISION = 2450701416357846905
    ANIMPOSTFX_PLAY = 2451857716230485796
    FORCE_PED_AI_AND_ANIMATION_UPDATE = 2452284214444829210
    DELETE_SCRIPT_VEHICLE_GENERATOR = 2454510840071524957
    SET_VEHICLE_REDUCE_GRIP = 2463458723210797794
    STOP_CINEMATIC_CAM_SHAKING = 2465973172114597591
    GET_HUD_COMPONENT_POSITION = 2467029878600636413
    SC_ACHIEVEMENT_INFO_STATUS = 2474614145210663211
    GET_PICKUP_COORDS = 2475725483283589555
    IS_ALARM_PLAYING = 2478164843485265036
    NETWORK_SPENT_UPGRADE_HACKER_TRUCK = 2480401803855596712
    IS_STUNT_JUMP_MESSAGE_SHOWING = 2482240551046425076
    GET_OFFSET_FROM_ENTITY_GIVEN_WORLD_COORDS = 2482816124249826099
    HAS_THIS_CUTSCENE_LOADED = 2489713879041514556
    SET_ALLOW_STREAM_PROLOGUE_NODES = 2490029257889631229
    DONT_RENDER_IN_GAME_UI = 2495638117343839498
    IS_VEHICLE_SEAT_FREE = 2498470473267324521
    TASK_SMART_FLEE_PED = 2499727468660491277
    HAS_COLLISION_FOR_MODEL_LOADED = 2507559639599083578
    GET_NTH_CLOSEST_VEHICLE_NODE_ID = 2510518586829603349
    DATAFILE_SELECT_ACTIVE_FILE = 2511432525605240631
    BG_GET_LAUNCH_PARAM_VALUE = 2513606438577291593
    RESET_PED_IN_VEHICLE_CONTEXT = 2517389014042947819
    NETWORK_PREVENT_SCRIPT_HOST_MIGRATION = 2522790012041661745
    ADD_PATROL_ROUTE_LINK = 2524322982776776017
    GET_CURRENT_FRONTEND_MENU_VERSION = 2524647312791458405
    ALLOW_TRAIN_TO_BE_REMOVED_BY_POPULATION = 2526705179464482627
    SET_VEHICLE_RESPECTS_LOCKS_WHEN_HAS_DRIVER = 2527044344841504130
    SET_BIGMAP_ACTIVE = 2530054912743808399
    DISABLE_SCREEN_DIMMING_THIS_FRAME = 2531724413268743273
    DISABLE_POLICE_RESTART = 2533378064742448803
    SC_EMAIL_MESSAGE_PUSH_GAMER_TO_RECIP_LIST = 2535738978395512086
    DISABLE_PLANE_AILERON = 2540751217074672028
    SET_BLIP_CATEGORY = 2543651177335553434
    NETWORK_EARN_FIXER_RIVAL_DELIVERY = 2548264574339652190
    NETWORK_ADD_FOLLOWERS = 2550170942847456982
    START_PRELOADED_CONVERSATION = 2550192969488200581
    STAT_GET_USER_ID = 2550659756676332514
    NETWORK_DISABLE_REALTIME_MULTIPLAYER = 2551577016155354445
    TASK_PLANE_MISSION = 2553607858489408392
    SET_PLAYER_VEHICLE_WEAPON_TO_NON_HOMING = 2554738238460888649
    NET_GAMESERVER_TRANSFER_BANK_TO_WALLET_GET_STATUS = 2555967024569568836
    NETWORK_HAS_CACHED_PLAYER_HEAD_BLEND_DATA = 2557291657655828744
    SET_APPLY_WAYPOINT_OF_PLAYER = 2558795628960999354
    IS_PLAYER_WANTED_LEVEL_GREATER = 2561900175157029359
    END_TEXT_COMMAND_DISPLAY_HELP = 2562546386151446694
    SET_PLAYER_INVINCIBLE = 2564000551796991966
    SET_ENTITY_COORDS_NO_OFFSET = 2565419363613909893
    PLAYSTATS_CASINO_INSIDE_TRACK_LIGHT = 2568120295216205383
    CLEAR_ROOM_FOR_GAME_VIEWPORT = 2573135974166512198
    SET_BACKFACECULLING = 2574487836998217939
    SHOW_FRIEND_INDICATOR_ON_BLIP = 2577162348705017882
    BEGIN_TEXT_COMMAND_ADD_DIRECTLY_TO_PREVIOUS_BRIEFS = 2582425178060816424
    NETWORK_SESSION_WAS_INVITED = 2584983741619047652
    IS_USING_REMOTE_PLAY = 2589744254827121110
    GET_PED_NEARBY_PEDS = 2592092050355407467
    GET_CLOSEST_VEHICLE_NODE = 2596914974566212883
    SET_ENTITY_LOCALLY_VISIBLE = 2602562282395639516
    ARE_ANY_CCS_PENDING = 2603021602281049973
    SET_CAM_SPLINE_PHASE = 2606274068640751698
    IS_FLOATING_HELP_TEXT_ON_SCREEN = 2608279396813442468
    HIDE_HUDMARKERS_THIS_FRAME = 2608312769895031478
    NETWORK_GET_PRESENCE_INVITE_CONTENT_ID = 2612263451348480557
    WAYPOINT_PLAYBACK_RESUME = 2616433914101923117
    SET_VEHICLE_DENSITY_MULTIPLIER_THIS_FRAME = 2619521048766764343
    ADD_PED_AMMO_BY_TYPE = 2626269477619291231
    STOP_CODE_GAMEPLAY_HINT = 2628637378079399196
    NET_GAMESERVER_CATALOG_ITEM_KEY_IS_VALID = 2629837696713026059
    GOLF_TRAIL_SET_RADIUS = 2631741890581638788
    SET_VEHICLE_ENGINE_ON = 2636792098548582430
    GET_SHOP_PED_QUERY_COMPONENT = 2638600355764635289
    IS_MOVE_BLEND_RATIO_SPRINTING = 2639863049524614370
    GET_CHARACTER_MENU_PED_MASKED_INT_STAT = 2640406714971118736
    SET_BLIP_AS_MISSION_CREATOR_BLIP = 2642488418240536533
    IS_PED_RELOADING = 2643895309002103121
    SET_PED_STUN_GUN_FINITE_AMMO = 2648156964382156554
    GET_VEHICLE_NUMBER_OF_PASSENGERS = 2651249327676063369
    GET_CONTENT_TO_LOAD = 2655572877792606985
    UGC_DID_CREATE_SUCCEED = 2658501604606674425
    CAN_ANCHOR_BOAT_HERE_IGNORE_PLAYERS = 2662773195569338496
    NETWORK_GET_PLAYER_INDEX = 2664865239777350247
    START_PARTICLE_FX_NON_LOOPED_AT_COORD = 2671361570822135507
    SET_TEXT_OUTLINE = 2671724955187806462
    GET_CLOCK_HOURS = 2675767815307398015
    GET_INTERIOR_LOCATION_AND_NAMEHASH = 2678476324804208362
    START_SCRIPT_PHONE_CONVERSATION = 2679183906295232117
    TRIGGER_PED_SCENARIO_PANICEXITTOFLEE = 2681359863467467801
    SET_DISABLE_PRETEND_OCCUPANTS = 2681469048992354070
    GET_HAS_OBJECT_BEEN_COMPLETELY_DESTROYED = 2684750738819034244
    NETWORK_GET_SIGNALLING_INFO = 2690284490974508948
    GET_CAM_FAR_DOF = 2693026888527434647
    SET_RADIUS_BLIP_EDGE = 2693527789144160276
    SC_COMMUNITY_EVENT_GET_EXTRA_DATA_FLOAT_FOR_TYPE = 2697905129846826211
    NETWORK_GET_POSITION_HASH_OF_THIS_SCRIPT = 2701826602378267599
    SET_RIOT_MODE_ENABLED = 2704311021531429599
    SET_PED_AS_NO_LONGER_NEEDED = 2708314027382316259
    NETWORK_EARN_GANGOPS_ELITE = 2708810536048143479
    CASCADE_SHADOWS_SET_BOUND_POSITION = 2709943034131777777
    GET_IS_USING_ALTERNATE_HANDBRAKE = 2714161134224077475
    NETWORK_ADD_CLIENT_ENTITY_AREA = 2718371469070999809
    GET_VEHICLE_DOOR_LOCK_STATUS = 2719216112082266466
    NETWORK_HAVE_ONLINE_PRIVILEGES = 2723370039557214307
    IS_SYNCHRONIZED_SCENE_RUNNING = 2725693256661961254
    APP_SET_FLOAT = 2726762982940924580
    NETWORK_REMOVE_ALL_QUEUED_JOIN_REQUESTS = 2727370447948869948
    REMOVE_FROM_ITEMSET = 2731013455570499206
    DOES_VEHICLE_HAVE_WEAPONS = 2732763548735084768
    THEFEED_HIDE_THIS_FRAME = 2736072222996364455
    BEGIN_TEXT_COMMAND_DISPLAY_TEXT = 2736978246810207435
    CASCADE_SHADOWS_SET_SCREEN_SIZE_CHECK_ENABLED = 2737131065035116745
    PLAYSTATS_DEFEND_CONTRABAND_MISSION = 2739708355486563165
    BRING_VEHICLE_TO_HALT = 2741540918328977952
    GET_RAYFIRE_MAP_OBJECT_ANIM_PHASE = 2742381001580010241
    SET_PARTICLE_FX_NON_LOOPED_COLOUR = 2743882230916493922
    NETWORK_ARE_TRANSITION_DETAILS_VALID = 2744286647084986561
    UNPIN_INTERIOR = 2746296917326628417
    NETWORK_MARK_AS_PREFERRED_ACTIVITY = 2746799594104896832
    SET_PED_WEAPON_MOVEMENT_CLIPSET = 2748008704641313954
    APP_SET_BLOCK = 2750208806671753107
    SET_PED_COMPONENT_VARIATION = 2750315038012726912
    SET_DIRECTOR_MODE_LAUNCHED_BY_SCRIPT = 2752341692579949447
    SET_FAR_DRAW_VEHICLES = 2752349403850161347
    REMOVE_DISPATCH_SPAWN_BLOCKING_AREA = 2759231624002622373
    NETWORK_SET_SCRIPT_CONTROLLING_TEAMS = 2762212740384944935
    DELAY_MP_STORE_OPEN = 2762453786012211246
    SET_RAGDOLL_BLOCKING_FLAGS = 2767847656522943876
    NETWORK_ALLOW_REMOTE_ATTACHMENT_MODIFICATION = 2773224262595537818
    GET_FINAL_RENDERED_REMOTE_PLAYER_CAM_ROT = 2778788713819758380
    IS_ENTITY_ATTACHED_TO_ANY_VEHICLE = 2786199138849258315
    IS_PED_OPENING_DOOR = 2787462698231474732
    IS_VALID_INTERIOR = 2787982420646491347
    CAN_ANCHOR_BOAT_HERE = 2792529512651097147
    STAT_RESET_ALL_ONLINE_CHARACTER_STATS = 2798769033825484425
    SET_PED_HELMET_PROP_INDEX = 2799047177385093404
    SET_DISABLE_BMX_EXTRA_TRICK_FORCES = 2799441655457716456
    SET_DISABLE_EXPLODE_FROM_BODY_DAMAGE_ON_COLLISION = 2801587805711458404
    NETWORK_GET_PRESENCE_INVITE_SESSION_ID = 2801746490292190560
    NETWORK_HAS_AUTOMUTE_OVERRIDE = 2805880935497564056
    IS_MISSION_CREATOR_BLIP = 2807039936679482173
    GET_ZONE_AT_COORDS = 2811385424171021044
    SET_CHECKPOINT_CYLINDER_HEIGHT = 2812404413663640969
    CUSTOM_MINIMAP_CLEAR_BLIPS = 2812775079407254015
    ALLOW_MOTION_BLUR_DECAY = 2814775853572051814
    USE_SCRIPT_CAM_FOR_AMBIENT_POPULATION_ORIGIN_THIS_FRAME = 2815877335269666450
    DOES_SCRIPT_OWN_ROPE = 2818300342655869961
    NETWORK_SESSION_MARK_VISIBLE = 2818345906077432229
    GET_PED_WAYPOINT_PROGRESS = 2819441002312491156
    GET_PAUSE_MENU_STATE = 2822294085854325189
    ATTACH_SYNCHRONIZED_SCENE_TO_ENTITY = 2823272235100945302
    SET_CORPSE_RAGDOLL_FRICTION = 2825203075280215023
    GET_PED_HEAD_BLEND_DATA = 2830157900151113168
    UGC_SET_BOOKMARKED = 2831098516628113743
    GET_NUMBER_OF_PED_DRAWABLE_VARIATIONS = 2834476523764480066
    NETWORK_IS_ACTIVITY_SPECTATOR_FROM_HANDLE = 2838318530915974329
    DISPLAY_AREA_NAME = 2840483713975006840
    TASK_USE_NEAREST_SCENARIO_TO_COORD = 2846071673660833803
    GET_NUM_TATTOO_SHOP_DLC_ITEMS = 2850627672003375369
    SET_FORCE_SHOW_GPS = 2851047607269690918
    SET_VEHICLE_GENERATES_ENGINE_SHOCKING_EVENTS = 2854526654683994421
    NET_GAMESERVER_BASKET_START = 2855010247841586046
    PLAYSTATS_RIVAL_BEHAVIOR = 2858128349403610723
    SET_PED_SWEAT = 2859856541646028063
    IS_VEHICLE_BUMPER_BOUNCING = 2862361333363068973
    CASCADE_SHADOWS_CLEAR_SHADOW_SAMPLE_TYPE = 2867516576068883237
    SET_DISABLE_PETROL_DECALS_RECYCLING_THIS_FRAME = 2868706865191635757
    SET_PARTICLE_FX_BULLET_IMPACT_SCALE = 2874185409664238614
    SET_PICKUP_OBJECT_GLOW_WHEN_UNCOLLECTABLE = 2878443118472964819
    NET_GAMESERVER_BASKET_IS_FULL = 2879890087697109774
    REMOVE_ALL_PICKUPS_OF_TYPE = 2880568813926046159
    PHONEPHOTOEDITOR_SET_FRAME_TXD = 2881939983279181283
    STOP_ENTITY_ANIM = 2882391207405552608
    CLEAR_GPS_DISABLED_ZONE_AT_INDEX = 2882813939784539911
    SPAWNPOINTS_GET_SEARCH_RESULT = 2885820252165598864
    SET_SCENARIO_PEDS_SPAWN_IN_SPHERE_AREA = 2888352466223499649
    PLAYSTATS_HUB_ENTRY = 2889339975462750686
    PLAYSTATS_BW_FRAGILE_GOODS = 2894520681709388615
    NETWORK_ON_RETURN_TO_SINGLE_PLAYER = 2899016761896607387
    DRAW_MARKER = 2902427857584726153
    START_SHAPE_TEST_CAPSULE = 2906964826188852352
    SC_PRESENCE_ATTR_SET_STRING = 2918085674462623125
    SET_PED_STEER_BIAS = 2922261323115769199
    NETWORK_SPENT_CASH_DROP = 2922861363037298912
    ENABLE_TENNIS_MODE = 2927422500758616230
    FORCE_BONNET_CAMERA_RELATIVE_HEADING_AND_PITCH = 2931881434367298106
    SET_HYDRAULICS_CONTROL = 2932269383469114870
    ADD_SCRIPTED_COVER_AREA = 2934017915918382250
    VEHICLE_SET_RAMP_AND_RAMMING_CARS_TAKE_DAMAGE = 2940908458198899701
    SET_ENTITY_ANIM_SPEED = 2941309488218838902
    GET_VEHICLE_LAYOUT_HASH = 2941832761766075480
    IS_ENTITY_ON_FIRE = 2941975181394786827
    PLAYSTATS_CHANGE_MC_OUTFIT = 2948934905689570738
    NETWORK_SPENT_JOB_SKIP = 2950267489290619951
    GET_EVENT_DATA = 2955069715068431737
    CLEAR_PLAYER_RESERVE_PARACHUTE_MODEL_OVERRIDE = 2958060723185474280
    REQUEST_ACTION_MODE_ASSET = 2958345439083668888
    NETWORK_GET_THIS_SCRIPT_IS_NETWORK_SCRIPT = 2958977764275344222
    RELOAD_MAP_MENU = 2960739795670439975
    IS_ANY_PED_RAPPELLING_FROM_HELI = 2962866341200953063
    NETWORK_IS_TRANSITION_MATCHMAKING = 2964886736447430367
    DRAW_TEXTURED_POLY = 2965620363887581480
    REPLAY_RECORD_BACK_FOR_TIME = 2968471225523162812
    GET_VEHICLE_CLASS = 2973386714919209570
    IS_VEHICLE_STOPPED_AT_TRAFFIC_LIGHTS = 2979683755510794905
    SET_ENTITY_MOTION_BLUR = 2980682187891773776
    PED_HAS_USE_SCENARIO_TASK = 2980886862190202071
    TASK_MOVE_NETWORK_ADVANCED_BY_NAME_WITH_INIT_PARAMS = 2983685523121498549
    SET_INCREASE_WHEEL_CRUSH_DAMAGE = 2986144532570432559
    GET_ENTITY_PLAYER_IS_FREE_AIMING_AT = 2987514272108589712
    SET_TV_VOLUME = 2991163607304019420
    IS_PED_IN_ANY_HELI = 2993646556015384325
    SET_PLAYER_LOCKON_RANGE_OVERRIDE = 2996614801672115453
    SET_NETWORK_ID_CAN_MIGRATE = 2999092937823393276
    UGC_HAS_MODIFY_FINISHED = 2999102431296959750
    LOCK_MINIMAP_ANGLE = 2999307995311693915
    ATTACH_VEHICLE_TO_TOW_TRUCK = 2999801479832552712
    SET_PED_STRAFE_CLIPSET = 3000117804892870740
    SET_VEHICLE_WHEELS_CAN_BREAK = 3004335601414621839
    NETWORK_SPENT_BOUNTY = 3004570246029238220
    SET_WEATHER_TYPE_NOW = 3005176124459292809
    GET_APPROX_HEIGHT_FOR_POINT = 3009051046431078651
    SET_PED_CLOTH_EVENTS_ENABLED = 3015789596365711661
    START_PLAYBACK_RECORDED_VEHICLE_USING_AI = 3016953963414045324
    REQUEST_STEALTH_MODE_ASSET = 3029342537570676047
    CLEAR_ADDITIONAL_TEXT = 3033066534563939533
    TOGGLE_VEHICLE_MOD = 3035231775696334088
    SET_CAM_VIEW_MODE_FOR_CONTEXT = 3035835048754334994
    CLEAR_PARTICLE_FX_SHOOTOUT_BOAT = 3036862817743095515
    PAUSE_MENU_IS_CONTEXT_MENU_ACTIVE = 3037024583464485919
    OVERRIDE_INTERIOR_SMOKE_NAME = 3038331618218043136
    SET_PED_DIES_IN_VEHICLE = 3040090468580439084
    VDIST = 3046839180162419877
    SET_CUTSCENE_PED_COMPONENT_VARIATION_FROM_PED = 3050837379472601305
    NETWORK_EXPLODE_HELI = 3052884339923704474
    TRANSFORM_TO_CAR = 3056255098283622302
    IS_POINT_IN_ANGLED_AREA = 3058149654865529985
    IS_PED_GETTING_UP = 3059318355911511788
    GET_COMMERCE_ITEM_NUM_CATS = 3060045069052562096
    SET_PED_AS_GROUP_LEADER = 3060223848321776590
    NETWORK_SPEND_GANGOPS_REPAIR_COST = 3061581824351550412
    SET_PLANE_ENGINE_HEALTH = 3064312824809002036
    QUEUE_OPERATION_TO_CREATE_SORTED_LIST_OF_PHOTOS = 3065044247237059994
    SET_TRAILER_INVERSE_MASS_SCALE = 3066724414011636543
    NETWORK_SPENT_PURCHASE_HACKER_TRUCK = 3068011733585931465
    SET_VEHICLE_NEON_ENABLED = 3073461435007496809
    UNBLOCK_SPEECH_CONTEXT_GROUP = 3083486709265083890
    SET_CUSTOM_MP_HUD_COLOR = 3084035102440479198
    GET_VEHICLE_MODEL_NUMBER_OF_SEATS = 3087559591220014500
    SET_GAMEPLAY_CAM_IGNORE_ENTITY_COLLISION_THIS_UPDATE = 3093237379154053077
    SET_BLIP_FADE = 3093567789283289484
    NETWORK_SPENT_UPGRADE_OFFICE_GARAGE = 3097400232158664690
    SET_GARBAGE_TRUCKS = 3097765567273685773
    IS_PED_RUNNING_MOBILE_PHONE_TASK = 3098004816684799861
    SET_PED_PRELOAD_PROP_DATA = 3104849037912428105
    NETWORK_EARN_FROM_CHALLENGE_WIN = 3104983913800718559
    IS_RADIO_STATION_FAVOURITED = 3105096544373697145
    NETWORK_USE_HIGH_PRECISION_BLENDING = 3105253570959644357
    NETWORK_ADD_CLIENT_ENTITY_ANGLED_AREA = 3106465836238048669
    GET_DEEP_OCEAN_SCALER = 3110347731893794329
    PIN_ROPE_VERTEX = 3112564522788239002
    RELEASE_SCRIPT_GUID_FROM_ENTITY = 3112889752278063001
    TEST_VERTICAL_PROBE_AGAINST_ALL_WATER = 3113203377110074082
    NETWORK_OPEN_TRANSITION_MATCHMAKING = 3114959857764241374
    SET_PARTICLE_FX_SLIPSTREAM_LODRANGE_SCALE = 3116677267589698824
    SET_GAMEPLAY_PED_HINT = 3118850947964815571
    IS_MINIGAME_IN_PROGRESS = 3119329762210804856
    GET_PACKED_NG_INT_STAT_KEY = 3120111251418510298
    NETWORK_CLAN_CREWINFO_GET_CREWRANKTITLE = 3121537421275042617
    SET_PED_AO_BLOB_RENDERING = 3123993011470596940
    GET_STATUS_OF_MISSION_REPEAT_SAVE = 3124952982442144447
    SET_VEHICLE_HAS_BEEN_OWNED_BY_PLAYER = 3125389474191733293
    GET_REPLAY_STAT_MISSION_TYPE = 3126177645233230921
    SET_VEHICLE_DISABLE_TOWING = 3127547608149237099
    MARK_PED_DECORATIONS_AS_CLONED_FROM_LOCAL_PLAYER = 3128113866510068116
    PLAYSTATS_IMPORT_EXPORT_MISSION_DONE = 3128300827883161617
    SET_BLIP_AS_MINIMAL_ON_EDGE = 3129234821653548685
    END_TEXT_COMMAND_THEFEED_POST_STATS = 3134112053357788297
    NET_GAMESERVER_IS_CATALOG_CURRENT = 3140304295617662826
    GET_PED_WEAPON_TINT_INDEX = 3143211000917945247
    GET_VEHICLE_LIVERY = 3150587921134411402
    TASK_COMBAT_HATED_TARGETS_AROUND_PED_TIMED = 3150884457545943564
    REQUEST_PED_VEHICLE_VISIBILITY_TRACKING = 3153426456988567048
    DRAW_SPRITE_NAMED_RENDERTARGET = 3154009034243605640
    GET_CURRENT_LANGUAGE = 3160758157564346030
    ENABLE_VEHICLE_EXHAUST_POPS = 3162860040914967898
    NETWORK_CAN_QUEUE_FOR_PREVIOUS_SESSION_JOIN = 3167839434185176710
    DISABLE_MOON_CYCLE_OVERRIDE = 3168047960216479545
    SC_INBOX_SET_MESSAGE_AS_READ_AT_INDEX = 3170907184822864413
    GET_BLIP_FADE_DIRECTION = 3177072807653226590
    CAN_CARGOBOB_PICK_UP_ENTITY = 3178849997947213772
    STAT_SET_DATE = 3182285401449548772
    PAUSE_DEATH_ARREST_RESTART = 3182695371859369073
    SET_ENTITY_NOWEAPONDECALS = 3183549886422598409
    ENABLE_MOON_CYCLE_OVERRIDE = 3184760656109826057
    PROCGRASS_IS_CULLSPHERE_ENABLED = 3189168727600683312
    SET_VEHICLE_WILL_TELL_OTHERS_TO_HURRY = 3191386997049802379
    NETWORK_EARN_BIKER_SHOP = 3195314843191439959
    SET_CAM_DOF_MAX_NEAR_IN_FOCUS_DISTANCE_BLEND_LEVEL = 3199045888357818236
    GET_NUMBER_OF_THREADS_RUNNING_THE_SCRIPT_WITH_THIS_HASH = 3207594115197814009
    NETWORK_SET_CURRENT_PUBLIC_CONTENT_ID = 3208316440131318747
    GET_VEHICLE_NUM_OF_BROKEN_LOOSEN_PARTS = 3210151611429013041
    RESERVE_LOCAL_NETWORK_MISSION_PEDS = 3210492388075721345
    SET_TIMECYCLE_MODIFIER = 3211975551654944577
    SET_RADIO_FRONTEND_FADE_TIME = 3212981541312017806
    SET_BLIP_USE_HEIGHT_INDICATOR_ON_EDGE = 3215341588412707137
    PIN_INTERIOR_IN_MEMORY = 3216741939161133639
    SET_RADIO_TRACK_WITH_START_OFFSET = 3220081778324545110
    NETWORK_GET_GAMER_STATUS_FROM_QUEUE = 3226909021043692691
    PLAYSTATS_FM_EVENT_HUNTBEAST = 3231617888242436776
    REMOVE_SHOCKING_EVENT = 3231987544506158309
    STAT_GET_NUMBER_OF_SECONDS = 3233680186593767435
    ADD_ROAD_NODE_SPEED_ZONE = 3235067526940988064
    NETWORK_SET_IN_PROGRESS_FINISH_TIME = 3236356806071660237
    CLEAR_SMALL_PRINTS = 3236443508323387820
    NETWORK_SPEND_GUNRUNNING = 3236696200869018629
    NETWORK_SESSION_DO_FRIEND_MATCHMAKING = 3241596539743226260
    RESET_PLAYER_ARREST_STATE = 3243683805626065110
    EXPLODE_PED_HEAD = 3244226514967662394
    IS_IN_ITEMSET = 3247031099325006087
    TASK_PLANE_CHASE = 3252591731777960485
    HAS_PED_BEEN_DAMAGED_BY_WEAPON = 3257295647166759546
    ARE_ANY_VEHICLE_SEATS_FREE = 3257505764128700288
    DRAW_SPRITE_ARX = 3259221273759489504
    ADD_DISPATCH_SPAWN_SPHERE_BLOCKING_AREA = 3261267976065129897
    TASK_MOVE_NETWORK_BY_NAME = 3266090088685725238
    SET_DISABLE_HOVER_MODE_FLIGHT = 3266796618201947025
    UGC_IS_DESCRIPTION_REQUEST_IN_PROGRESS = 3268989017712820500
    PLAYSTATS_WAREHOUSE_MISSION_ENDED = 3277102478951331934
    SET_PLAYER_WEAPON_DEFENSE_MODIFIER = 3279671666617174588
    SC_GAMERDATA_GET_ACTIVE_XP_BONUS = 3280675837645596255
    NETWORK_SET_LOCAL_PLAYER_INVINCIBLE_TIME = 3284751280334992135
    NETWORK_GET_KILLER_OF_PLAYER = 3288787536150583205
    DOES_ANIM_DICT_EXIST = 3288925407143094625
    GET_POSITION_IN_RECORDING = 3291240748898849909
    SET_PED_VISUAL_FIELD_MIN_ANGLE = 3293417903041420838
    NETWORK_EARN_GANGOPS_WAGES = 3299759377078255784
    NETWORK_LAUNCH_TRANSITION = 3300934890019555460
    AUDIO_IS_SCRIPTED_MUSIC_PLAYING = 3302154423580083327
    IS_ENTITY_FOCUS = 3305628913299216199
    GET_NETWORK_ID_FROM_SOUND_ID = 3306751126589651981
    PAUSE_TOGGLE_FULLSCREEN_MAP = 3307548554722472312
    GET_SCALEFORM_MOVIE_METHOD_RETURN_VALUE_INT = 3307875949375152182
    SPAWNPOINTS_START_SEARCH = 3312682903165293156
    CAN_PED_SHUFFLE_TO_OR_FROM_EXTRA_SEAT = 3313666129236362569
    PLAYSTATS_HEIST3_FINALE = 3315310934253609767
    CLEAR_PED_NON_CREATION_AREA = 3316092437016479313
    SET_VEHICLE_TIMED_EXPLOSION = 3317592585230581937
    NETWORK_HAS_BONE_BEEN_HIT_BY_KILLER = 3318016592125070665
    IS_PROJECTILE_TYPE_IN_AREA = 3318523262566943341
    IS_PED_IN_ANY_BOAT = 3318620947760329529
    GET_AMMO_IN_CLIP = 3319718231269668700
    HAS_MENU_LAYOUT_CHANGED_EVENT_OCCURRED = 3324499824664913758
    IS_EXPLOSION_IN_AREA = 3327801747854774496
    SET_PED_CAN_TELEPORT_TO_GROUP_LEADER = 3327951495314425415
    IS_PLAYER_FREE_AIMING = 3330833943310335111
    NETWORK_IS_ANY_PLAYER_NEAR = 3336061477655834894
    BREAK_ENTITY_GLASS = 3342951953186621683
    LEADERBOARDS_WRITE_ADD_COLUMN_LONG = 3343118456493061529
    SPECIAL_ABILITY_CHARGE_SMALL = 3349441619739895933
    SC_LICENSEPLATE_GET_PLATE_DATA = 3353379682425139395
    SET_DISABLE_AMBIENT_MELEE_MOVE = 3353681963845701516
    SET_BLIP_FLASHES_ALTERNATE = 3354500681329135825
    NETWORK_IS_FRIEND_IN_SAME_TITLE = 3362398636993353656
    GET_CLOSEST_MAJOR_VEHICLE_NODE = 3363031893684044222
    IS_COMMERCE_STORE_OPEN = 3363153954813650818
    CREATE_PORTABLE_PICKUP = 3363942472927762072
    GET_STREET_NAME_AT_COORD = 3365332906397525184
    DATAFILE_STORE_MISSION_HEADER = 3374907331190686072
    END_TEXT_COMMAND_THEFEED_POST_TICKER = 3375311854262816803
    IS_STORE_PENDING_NETWORK_SHUTDOWN_TO_OPEN = 3388243585844183137
    DATAARRAY_ADD_STRING = 3388503252636987050
    SET_COP_PERCEPTION_OVERRIDES = 3388761427279155870
    GET_IS_PETROL_DECAL_IN_RANGE = 3389512424302388228
    NETWORK_SET_MOCAP_CUTSCENE_CAN_BE_SKIPPED = 3392190530248128754
    REGISTER_TARGET = 3397360839466220450
    GET_PLAYER_CURRENT_STEALTH_NOISE = 3402853668735809655
    SET_TREAT_AS_AMBIENT_PED_FOR_DRIVER_LOCKON = 3403663172843347428
    ALLOW_EVASION_HUD_IF_DISABLING_HIDDEN_EVASION_THIS_FRAME = 3405182816286533114
    NET_GAMESERVER_SESSION_APPLY_RECEIVED_DATA = 3405237107956699633
    GET_DRIFT_TYRES_SET = 3412165300017744083
    STOP_ALL_ALARMS = 3420847337706966162
    SET_PLAYER_SPECTATED_VEHICLE_RADIO_OVERRIDE = 3421868636458483809
    SET_FIRST_PERSON_AIM_CAM_RELATIVE_HEADING_LIMITS_THIS_UPDATE = 3422501687745517806
    GET_VEHICLE_CLASS_MAX_ACCELERATION = 3423835109740947374
    REQUEST_SCRIPT_AUDIO_BANK = 3423943577717663365
    TASK_DRIVE_BY = 3425815346453651825
    GET_MILLISECONDS_PER_GAME_MINUTE = 3425916725698957787
    SUPPRESS_SHOCKING_EVENTS_NEXT_FRAME = 3430099330061811081
    SET_VARIABLE_ON_STREAM = 3430960290047061881
    SET_DOOR_ALLOWED_TO_BE_BROKEN_OFF = 3432081173349891800
    SET_TRAILER_ATTACHMENT_ENABLED = 3432386453688930313
    PLAYSTATS_HEIST4_HACK = 3432612855239705747
    ADD_VEHICLE_STUCK_CHECK_WITH_WARP = 3434436927361464684
    IS_NEXT_WEATHER_TYPE = 3434621646856581725
    NETWORK_SPENT_TRADE_IMPEXP_WAREHOUSE_PROPERTY = 3434951380343906710
    LEADERBOARDS_READ_SUCCESSFUL = 3436688693710979884
    WAYPOINT_RECORDING_GET_COORD = 3438664618184061793
    NETWORK_SESSION_CANCEL_INVITE = 3440547468879410937
    NETWORK_IS_IN_PLATFORM_PARTY = 3442268588154669911
    IS_ACTIVE_SCALEFORM_MOVIE_DELETING = 3443867491242756587
    SLIDE_OBJECT = 3449744191218520391
    GET_HEADING_FROM_VECTOR_2D = 3457474934040373542
    SC_TRANSITION_NEWS_HAS_EXTRA_DATA_TU = 3459255939663279744
    SET_VEHICLE_CAN_BE_USED_BY_FLEEING_PEDS = 3460177052258514705
    HAS_VEHICLE_RECORDING_BEEN_LOADED = 3462530660256210884
    NETWORK_EXPLODE_VEHICLE = 3466155522193544967
    GRASSBATCH_DISABLE_FLATTENING = 3471309577180905342
    NETWORK_OVERRIDE_CHAT_RESTRICTIONS = 3475000292599775428
    GET_CURRENT_TV_CLIP_NAMEHASH = 3477669521453706752
    IS_INTERPOLATING_FROM_SCRIPT_CAMS = 3477944451262818370
    TASK_FOLLOW_TO_OFFSET_OF_ENTITY = 3479844549214047358
    UGC_GET_CONTENT_IS_PUBLISHED = 3482673480369709546
    IS_DISABLED_CONTROL_JUST_RELEASED = 3484816125330098959
    CAN_SHUFFLE_SEAT = 3492644387460398901
    UGC_TEXTURE_DOWNLOAD_REQUEST = 3499180660926482380
    PRESENCE_EVENT_UPDATESTAT_FLOAT = 3505596339527850424
    SCRIPT_THREAD_ITERATOR_GET_NEXT_THREAD_ID = 3509705009990028191
    IS_ANY_POSITIONAL_SPEECH_PLAYING = 3515674106585787896
    GET_IS_WIDESCREEN = 3517113235013310725
    SET_VEHICLE_FLIGHT_NOZZLE_POSITION = 3519415630288612819
    NETWORK_SET_TRANSITION_ACTIVITY_ID = 3521414185226275538
    IS_TASK_MOVE_NETWORK_READY_FOR_TRANSITION = 3525624535481412151
    NETWORK_BUY_CONTRABAND_MISSION = 3530126386747468278
    GET_DLC_WEAPON_DATA_SP = 3533134305400830515
    ACTIVITY_FEED_ADD_SUBSTRING_TO_CAPTION = 3535994026037150783
    ADD_POINT_TO_GPS_CUSTOM_ROUTE = 3536513869148953370
    CELL_CAM_SET_SELFIE_MODE_VERT_PAN_OFFSET = 3537533866042521467
    GOLF_TRAIL_SET_PATH = 3540747268938747711
    TASK_VEHICLE_FOLLOW_WAYPOINT_RECORDING = 3540949326590965741
    GET_WEAPON_DAMAGE = 3545380775022239827
    GET_RANDOM_FLOAT_IN_RANGE = 3547962977077129165
    SET_PROP_TINT_INDEX = 3555393011261539955
    SET_MP_GAMER_TAG_HEALTH_BAR_COLOUR = 3555811234731821748
    REMOVE_MP_GAMER_TAG = 3560529434807247864
    PLAYSTATS_BUSINESS_BATTLE_ENDED = 3561702565450880884
    WATER_OVERRIDE_SET_OCEANNOISEMINAMPLITUDE = 3563043329174420565
    SET_RENDER_TRAIN_AS_DERAILED = 3565462922087847220
    THEFEED_UPDATE_ITEM_TEXTURE = 3566492953030704978
    HAS_CLIP_SET_LOADED = 3567472081491954419
    SET_PICKUP_GENERATION_RANGE_MULTIPLIER = 3568283431859383522
    UGC_GET_MY_CONTENT = 3573035507683364946
    CLEAR_FOCUS = 3582399230505917858
    SET_VEHICLE_IS_CONSIDERED_BY_PLAYER = 3582938665954924237
    NETWORK_EARN_FROM_HANGAR_TRADE = 3583197960089172895
    REMOVE_SCENARIO_BLOCKING_AREA = 3589768527288114534
    NETWORK_SEND_TRANSITION_GAMER_INSTRUCTION = 3589882067196993131
    GET_DLC_WEAPON_COMPONENT_DATA_SP = 3591023065493486812
    SET_PLAYER_WEAPON_TAKEDOWN_DEFENSE_MODIFIER = 3596418458115689787
    SET_ONLY_ALLOW_AMMO_COLLECTION_WHEN_LOW = 3600949737918685029
    PLAYSTATS_SMUGGLER_MISSION_ENDED = 3606315763735682525
    SET_GPS_FLASHES = 3606554328064200347
    GET_DECAL_WASH_LEVEL = 3620723085438652675
    STOP_CUTSCENE_CAM_SHAKING = 3624371460847073079
    STAT_SAVE_MIGRATION_CONSUME_CONTENT = 3634675924293778369
    IS_HELP_MESSAGE_FADING_OUT = 3638590665636823913
    THEFEED_HIDE = 3641304572445219184
    REMOVE_PICKUP = 3641398534907701938
    GET_PED_TARGET_FROM_COMBAT_PED = 3657620061624664524
    SET_POLICE_IGNORE_PLAYER = 3658658653323582058
    ADD_POP_MULTIPLIER_SPHERE = 3659077840428212096
    STAT_GET_CURRENT_DRIVING_REVERSE_DISTANCE = 3659958909376347442
    DISABLE_VEHICLE_TURRET_MOVEMENT_THIS_FRAME = 3659999272077112133
    UGC_GET_CONTENT_LANGUAGE = 3665245578741978738
    SET_NETWORK_ID_VISIBLE_IN_CUTSCENE_HACK = 3669256483543681945
    SET_SCALEFORM_MOVIE_TO_USE_LARGE_RT = 3671366047641330747
    NETWORK_SESSION_DO_FREEROAM_QUICKMATCH = 3679111936845386575
    APPLY_PED_BLOOD_BY_ZONE = 3679973589918796732
    IS_PED_DEAD_OR_DYING = 3681656254872768568
    SET_PED_TO_LOAD_COVER = 3687135479488455577
    SET_PED_PARACHUTE_TINT_INDEX = 3692891062518116742
    GET_DLC_VEHICLE_DATA = 3694797619997143542
    FORCE_SUBMARINE_SURFACE_MODE = 3697570207336415455
    REPLAY_CONTROL_SHUTDOWN = 3698529787668625041
    NETWORK_REGISTER_PLAYER_BROADCAST_VARIABLES = 3703272359995417109
    GET_APPROX_FLOOR_FOR_POINT = 3703385661687878021
    COUNT_PEDS_IN_COMBAT_WITH_TARGET_WITHIN_RADIUS = 3705122326269921227
    CLEAR_OVERRIDE_WEATHER = 3714676070527602768
    SET_BINK_MOVIE = 3714800504997819099
    TASK_GOTO_ENTITY_OFFSET_XY = 3715046334087075241
    NETWORK_SPENT_PURCHASE_IMPEXP_WAREHOUSE_PROPERTY = 3717753824990342985
    SET_PED_IS_IGNORED_BY_AUTO_OPEN_DOORS = 3721677036434903180
    SET_PED_HEARING_RANGE = 3722497735840494396
    IS_REPLAY_RECORD_SPACE_AVAILABLE = 3734749103720410061
    STAT_START_RECORD_STAT = 3735499057318867813
    NETWORK_GET_LAST_VEL_RECEIVED_OVER_NETWORK = 3737506027128350586
    SC_COMMUNITY_EVENT_GET_DISPLAY_NAME_FOR_TYPE = 3737785157344691739
    GIVE_WEAPON_COMPONENT_TO_WEAPON_OBJECT = 3738402496176665051
    SET_POSITION_FOR_NULL_CONV_PED = 3739050673429329158
    GET_FOLLOW_PED_CAM_ZOOM_LEVEL = 3739897472903648233
    SET_VEHICLE_COLOUR_COMBINATION = 3740465110043524657
    END_TEXT_COMMAND_THEFEED_POST_UNLOCK = 3741948630837060419
    GET_NUM_MOD_KITS = 3743304922253930013
    UNREGISTER_SCRIPT_VARIABLE = 3749869730642106009
    SET_PLAYER_WANTED_LEVEL_NO_DROP = 3751043147892200805
    REMOVE_SHOCKING_EVENT_SPAWN_BLOCKING_AREAS = 3751239098112338654
    DOES_SHOP_PED_APPAREL_HAVE_RESTRICTION_TAG = 3755412669879426045
    RENDER_FAKE_PICKUP_GLOW = 3760619398412235293
    IS_PROJECTILE_TYPE_WITHIN_DISTANCE = 3760934030850953138
    SET_ALLOW_VEHICLE_EXPLODES_ON_CONTACT = 3765513770812774691
    NETWORK_SESSION_LEAVE_SINGLE_PLAYER = 3765703441783795114
    TEXTURE_DOWNLOAD_GET_NAME = 3767349441916642861
    FREEZE_RADIO_STATION = 3769294338740074691
    IS_PED_SHOOTING = 3774412487161016737
    GET_ENTITY_ANIM_CURRENT_TIME = 3777817843249745730
    FREE_MEMORY_FOR_MISSION_CREATOR_PHOTO_PREVIEW = 3778225335211594910
    LEADERBOARDS2_READ_GET_ROW_DATA_INFO = 3780503180616416145
    IS_MOVE_BLEND_RATIO_STILL = 3791159752754452828
    NETWORK_SPEND_BUY_CASINO = 3793997143862467087
    SET_ALL_VEHICLE_GENERATORS_ACTIVE = 3795840726385927356
    PLAYSTATS_CLOTH_CHANGE = 3799194223729862841
    REGISTER_INT_TO_SAVE = 3803833428561200149
    GET_MAXIMUM_NUMBER_OF_PHOTOS = 3806162157312716991
    GET_CURRENT_TRACK_SOUND_NAME = 3807349008842726624
    SET_VEHICLE_LIGHTS = 3812034297014287450
    GET_SCREEN_COORD_FROM_WORLD_COORD = 3812348786834502901
    SET_PED_PATHS_IN_AREA = 3814655488685170712
    NETWORK_BLOCK_INVITES = 3817338365050922912
    NET_GAMESERVER_TRANSFER_WALLET_TO_BANK_GET_STATUS = 3822049665738423250
    NETWORK_GET_AVERAGE_PACKET_LOSS = 3822469304948058220
    STAT_GET_POS = 3823418424324172315
    ENABLE_CONTROL_ACTION = 3824154378443735381
    DATADICT_SET_BOOL = 3824192712233886501
    PLAY_PED_AMBIENT_SPEECH_WITH_VOICE_NATIVE = 3829013244756636440
    GET_CLOSEST_FIRE_POS = 3831049718424668191
    SET_ENTITY_CAN_ONLY_BE_DAMAGED_BY_SCRIPT_PARTICIPANTS = 3832048011171643195
    RELEASE_SOUND_ID = 3837005861822892282
    ASSISTED_MOVEMENT_REMOVE_ROUTE = 3839410373541067051
    CLOSE_BOMB_BAY_DOORS = 3843263829955894388
    GET_TEXTURE_RESOLUTION = 3851544041993800721
    NET_GAMESERVER_REFRESH_SERVER_CATALOG = 3853697197642887350
    GET_APPROX_FLOOR_FOR_AREA = 3862354833003275024
    PAUSE_MENU_GET_MOUSE_HOVER_INDEX = 3862666924682049005
    NET_GAMESERVER_START_SESSION_RESTART = 3864567737719282938
    REMOVE_FAKE_CONE_DATA = 3865158956636743378
    CREATE_ITEMSET = 3867793419214068516
    IS_MODEL_IN_CDIMAGE = 3871372195910563393
    SET_VEHICLE_OCCUPANTS_TAKE_EXPLOSIVE_DAMAGE = 3871725542130074483
    SET_AMBIENT_VEHICLE_NEON_ENABLED = 3882214270039849329
    PLAYSTATS_STONE_HATCHET_ENDED = 3883121393515464240
    SET_MINIMAP_GOLF_COURSE_OFF = 3885997017796641216
    PLAYSTATS_SWITCH_PASSIVE_MODE = 3886262068155914865
    NETWORK_IS_TUTORIAL_SESSION_CHANGE_PENDING = 3886810482984036173
    IS_INTERIOR_ENTITY_SET_ACTIVE = 3888820095585132909
    NETWORK_EARN_WAGE_PAYMENT = 3889098034217348891
    GET_REQUESTINGNIGHTVISION = 3889835590572031265
    END_TEXT_COMMAND_SCALEFORM_STRING = 3904107679495919961
    NETWORK_START_COMMUNICATION_PERMISSIONS_CHECK = 3907188483393935709
    GET_VEHICLE_CURRENT_TIME_IN_SLIP_STREAM = 3911706331942440022
    SET_PED_CAPSULE = 3913053473658322402
    GET_ROPE_VERTEX_COUNT = 3915305126917632181
    NETWORK_GET_NUM_SCRIPT_PARTICIPANTS = 3916135845664133658
    NETWORK_SPENT_UPGRADE_TRUCK = 3917717694146058379
    DISABLE_OCCLUSION_THIS_FRAME = 3920930695678831183
    IS_SCENARIO_GROUP_ENABLED = 3925460877865671577
    NET_TO_VEH = 3925893566760105484
    NETWORK_SET_PLAYER_MENTAL_STATE = 3926846280222487750
    NETWORK_EARN_AUTOSHOP_BUSINESS = 3938394964053241918
    ANIMPOSTFX_IS_RUNNING = 3939873869940501739
    GET_TIME_PED_DAMAGED_BY_WEAPON = 3942756030173659928
    GET_MENU_TRIGGER_EVENT_DETAILS = 3945510728816956976
    SET_PED_SCUBA_GEAR_VARIATION = 3947009576675625233
    ROPE_SET_SMOOTH_REELIN = 3948735200732213501
    SET_VEHICLE_CUSTOM_SECONDARY_COLOUR = 3949330575929153364
    GET_HAS_ROCKET_BOOST = 3951771193449683930
    ADD_EXPLOSION_WITH_USER_VFX = 3953386303019438610
    SET_VEHICLE_COMBAT_MODE = 3953615755679023300
    HAS_WEAPON_ASSET_LOADED = 3955096325251305710
    SUPPRESS_WITNESSES_CALLING_POLICE_THIS_FRAME = 3959142945574267103
    SET_ALLOW_MIGRATE_TO_SPECTATOR = 3959558973732041790
    CASCADE_SHADOWS_SET_SPLIT_Z_EXP_WEIGHT = 3960461105462580311
    UGC_GET_CONTENT_FILE_VERSION = 3963830848753916081
    GET_PLAYER_TEAM = 3964173737923747848
    START_SHAPE_TEST_BOUND = 3969945164008163584
    NETWORK_GET_RESPAWN_RESULT = 3971792475680808177
    IS_OBJECT_ENTIRELY_INSIDE_GARAGE = 3976386454284050916
    SET_TASK_MOVE_NETWORK_SIGNAL_LOCAL_FLOAT = 3980887443223517091
    STABILISE_ENTITY_ATTACHED_TO_HELI = 3983159160330308376
    SET_VEHICLE_CAN_BE_TARGETTED = 3985708116393687682
    SET_MOBILE_PHONE_DOF_STATE = 3988624022105477252
    FIND_HANDLER_VEHICLE_CONTAINER_IS_ATTACHED_TO = 3989766801014769835
    SPECIAL_ABILITY_RESET = 3989923684365507220
    NETWORK_GET_UNRELIABLE_RESEND_COUNT = 3991811753474862608
    NETWORK_ADD_ENTITY_ANGLED_AREA = 3993676326859974970
    START_EXPENSIVE_SYNCHRONOUS_SHAPE_TEST_LOS_PROBE = 3997233671787402630
    END_TEXT_COMMAND_THEFEED_POST_TICKER_WITH_TOKENS = 4003278526116448320
    IS_PED_SWITCHING_WEAPON = 4005222386344271542
    NETWORK_IS_TRANSITION_OPEN_TO_MATCHMAKING = 4009410126883190217
    SET_DISABLE_VEHICLE_PETROL_TANK_DAMAGE = 4019503531837018135
    NETWORK_GET_ENTITY_FROM_OBJECT_ID = 4023393670560040565
    SAVE_END_USER_BENCHMARK = 4025849361513559768
    SET_FORKLIFT_FORK_HEIGHT = 4029524509185632805
    GET_PED_ACCURACY = 4032038155253976278
    GET_PLAYER_RESERVE_PARACHUTE_MODEL_OVERRIDE = 4033723783619137677
    FORCE_TIGHTSPACE_CUSTOM_FRAMING_THIS_UPDATE = 4038402205414366805
    CLEAR_SEQUENCE_TASK = 4053593907568086412
    NETWORK_EARN_AGENCY_CONTRACT = 4055538557097936327
    LEADERBOARDS2_READ_GET_ROW_DATA_FLOAT = 4055795177535209341
    NETWORK_GET_INVITE_REPLY_STATUS = 4059427023289182386
    GET_RANDOM_VEHICLE_IN_SPHERE = 4066588722478844188
    ADD_NAVMESH_REQUIRED_REGION = 4070881873695303301
    SET_ENTITY_INVINCIBLE = 4071836030646819540
    IS_PLAYER_BEING_ARRESTED = 4074147724792802446
    NETWORK_HANDLE_FROM_PLAYER = 4075391217980126899
    SET_WARNING_MESSAGE_WITH_HEADER_EXTENDED = 4086262782383651053
    NETWORK_TRIGGER_DAMAGE_EVENT_FOR_ZERO_WEAPON_HASH = 4086951905306986456
    SET_PROFILE_SETTING_CREATOR_DM_DONE = 4087766931770823071
    STOP_CONTROL_SHAKE = 4089666692606385293
    FORCE_ACTIVATING_TRACKING_ON_ENTITY = 4089773260719890454
    NETWORK_DOES_NETWORK_ID_EXIST = 4093234165679461188
    IS_PLAYER_BATTLE_AWARE = 4094490764435692537
    NETWORK_GET_PRESENCE_INVITE_HANDLE = 4095374044269408117
    SET_PED_PATH_PREFER_TO_AVOID_WATER = 4106753751182965052
    DRAW_DEBUG_TEXT = 4108375870853646568
    SET_ENTITY_SHOULD_FREEZE_WAITING_ON_COLLISION = 4111792081076072460
    SET_TYRE_WEAR_RATE_SCALE = 4116716376237110935
    TASK_SEEK_COVER_TO_COORDS = 4117532960019646252
    GET_LIGHT_OVERRIDE_MAX_INTENSITY_SCALE = 4124120950292314003
    IS_AREA_OCCUPIED_SLOW = 4126805741194793350
    SET_SYNCHRONIZED_SCENE_HOLD_LAST_FRAME = 4128565905484794241
    HAS_ENTITY_CLEAR_LOS_TO_ENTITY_ADJUST_FOR_COVER = 4128637757460972318
    FORCE_PICKUP_ROTATE_FACE_UP = 4128904267521145896
    NETWORK_CASINO_CAN_BET_PVC = 4129182631717156777
    SET_AGGRESSIVE_HORNS = 4133168733379211737
    GET_STATUS_OF_MANUAL_SAVE = 4142091203678808726
    APPLY_PED_DAMAGE_DECAL = 4142248062138081155
    IS_ANY_OBJECT_NEAR_POINT = 4142684454248421585
    NETWORK_MARK_AS_WAITING_ASYNC = 4148235387500820753
    GET_KEY_FOR_ENTITY_IN_ROOM = 4149651284798158524
    IS_PED_AIMING_FROM_COVER = 4150261839465480421
    SET_STATIC_EMITTER_ENABLED = 4151524163803265259
    SET_PICKUP_OBJECT_ARROW_MARKER = 4154002752840992832
    IS_GAMEPLAY_CAM_RENDERING = 4158460389144916168
    SET_COLOUR_OF_NEXT_TEXT_COMPONENT = 4160189315227336364
    NET_GAMESERVER_CHECKOUT_START = 4160900452576970982
    GET_PED_AMMO_BY_TYPE = 4166428001530627777
    SET_PED_PRELOAD_VARIATION_DATA = 4167336407419546170
    IS_THIS_MODEL_A_QUADBIKE = 4168859234758687272
    CLOSE_SEQUENCE_TASK = 4172351724727787723
    SET_PLAYER_WANTED_LEVEL = 4179087318742194779
    DATAARRAY_GET_TYPE = 4179363190438798277
    UGC_GET_CONTENT_HASH = 4185993038394771591
    NETWORK_SEND_TEXT_MESSAGE = 4188716190782828800
    SET_REDUCED_SUSPENSION_FORCE = 4194911084860680805
    CLOUD_DID_REQUEST_SUCCEED = 4196604335882861781
    GET_MUSIC_VOL_SLIDER = 4199794962240674238
    CREATE_MODEL_HIDE_EXCLUDING_SCRIPT_OBJECTS = 4202613097555345279
    PLAY_VEHICLE_DOOR_OPEN_SOUND = 4202875855019354157
    NETWORK_CAN_BET = 4203234174936471167
    DRAW_RECT = 4206795403398567152
    GET_GAMEPLAY_CAM_RELATIVE_PITCH = 4208727876790119842
    IS_SCENARIO_TYPE_ENABLED = 4215753753502451490
    GET_CURRENT_PED_WEAPON = 4217590589943717204
    NETWORK_ACCESS_TUNABLE_INT_MODIFICATION_DETECTION_REGISTRATION_HASH = 4218560023842315759
    GET_CLIP_SET_FOR_SCRIPTED_GUN_TASK = 4218938024697441477
    GET_OUTRIGGERS_DEPLOYED = 4220198534704307845
    NETWORK_DO_TRANSITION_TO_FREEMODE = 4228188662541461663
    RESET_PED_VISIBLE_DAMAGE = 4233937496917085189
    SET_OBJECT_AS_NO_LONGER_NEEDED = 4243004287814575078
    SET_VEHICLE_ENVEFF_SCALE = 4250770462311716468
    SET_OBJECT_IS_VISIBLE_IN_MIRRORS = 4264863276274823964
    GET_CURRENT_PED_WEAPON_ENTITY_INDEX = 4267453750986192380
    NETWORK_GET_PLAYER_TUTORIAL_SESSION_INSTANCE = 4267481048380686644
    PRELOAD_SCRIPT_CONVERSATION = 4268477180684627335
    NETWORK_SET_MISSION_FINISHED = 4268587596667215817
    SET_VEHICLE_DOOR_AUTO_LOCK = 4270975794827988744
    SET_CUTSCENE_AUDIO_OVERRIDE = 4272779084872942809
    SET_PED_VISUAL_FIELD_CENTER_ANGLE = 4279552042771720455
    GET_NUMBER_OF_VEHICLE_COLOURS = 4293673586576970782
    SET_VEHICLE_RADIO_ENABLED = 4294324703405435915
    IS_FRONTEND_READY_FOR_CONTROL = 4299699930381940167
    LANDING_SCREEN_STARTED_END_USER_BENCHMARK = 4304263934447298462
    GET_VEHICLE_EXTRA_COLOURS = 4306607109209941751
    DESTROY_MOBILE_PHONE = 4307800655868612759
    SET_TRANSITION_TIMECYCLE_MODIFIER = 4309758426879203100
    NETWORK_CASINO_BUY_CHIPS = 4310227723302706924
    SET_GPS_ACTIVE = 4311058836203103464
    GET_IS_ARTICULATED_JOINT_AT_MAX_ANGLE = 4312039217650216373
    GET_WEAPON_DAMAGE_TYPE = 4314654132534227717
    SET_PED_ALLOW_VEHICLES_OVERRIDE = 4324172950841413337
    IS_PLAYER_FREE_AIMING_AT_ENTITY = 4325344363702095739
    GET_PED_DEFENSIVE_AREA_POSITION = 4325347319514483921
    TASK_VEHICLE_CHASE = 4325893135057269587
    REVERT_CONTENT_CHANGESET_GROUP_FOR_ALL = 4330624631414418213
    NET_GAMESERVER_CATALOG_IS_VALID = 4342744675922939339
    GIVE_PLAYER_RAGDOLL_CONTROL = 4344223702803483176
    NETWORK_SET_OVERRIDE_TUTORIAL_SESSION_CHAT = 4349384515265238193
    NET_GAMESERVER_BEGIN_SERVICE = 4350428291716962350
    SET_PED_COMBAT_RANGE = 4350590797670664571
    SPAWNPOINTS_IS_SEARCH_ACTIVE = 4352535979295252318
    SET_CHECKPOINT_DIRECTION = 4357389317274367309
    ATTACH_VEHICLE_TO_TRAILER = 4358713499366918996
    NETWORK_QUERY_RESPAWN_RESULTS = 4362046460660277198
    POP_TIMECYCLE_MODIFIER = 4362080213785518366
    NETWORK_IS_PLAYER_A_PARTICIPANT = 4370056710535763844
    SET_PAUSE_MENU_PED_LIGHTING = 4370186014199407024
    OVERRIDE_VEH_HORN = 4385413544159347542
    REGISTER_WORLD_POINT_SCRIPT_BRAIN = 4385504615524893885
    SET_CAM_DOF_PLANES = 4392293246028958172
    GET_CLOCK_DAY_OF_MONTH = 4400224173958044981
    PREFETCH_SRL = 4405742584854648876
    DATADICT_GET_STRING = 4408982148052305010
    IS_ROCKET_BOOST_ACTIVE = 4410405085910852542
    START_GPS_MULTI_ROUTE = 4412707053333294979
    GET_USED_CREATOR_BUDGET = 4412836299265293621
    INIT_PC_SCRIPTED_CONTROLS = 4414294155012051829
    TASK_MOVE_NETWORK_BY_NAME_WITH_INIT_PARAMS = 4415129293991305417
    GET_SHAPE_TEST_RESULT = 4433588284967978644
    ATTACH_ENTITIES_TO_ROPE = 4437713091426519747
    IS_MOUSE_ROLLED_OVER_INSTRUCTIONAL_BUTTONS = 4439083715409864450
    NETWORK_INITIALIZE_CASH = 4442216992638548589
    GET_COORDS_OF_PROJECTILE_TYPE_IN_ANGLED_AREA = 4443014901483842797
    SPECIAL_ABILITY_FILL_METER = 4444112602787563904
    NETWORK_SET_CURRENT_CHAT_OPTION = 4444208572099671403
    NETWORK_GET_PRESENCE_INVITE_FROM_ADMIN = 4449325468612022921
    SET_PED_NEVER_LEAVES_GROUP = 4449491961641677895
    IS_PED_RUNNING_ARREST_TASK = 4451006101258455776
    NETWORK_SPENT_UPGRADE_BASE = 4455171888399116911
    SET_GPS_MULTI_ROUTE_RENDER = 4456935334064794792
    PLAYSTATS_FM_EVENT_CHECKPOINTCOLLECTION = 4459595322769876644
    IS_VEHICLE_PARACHUTE_DEPLOYED = 4460004663503165135
    SAVE_HIGH_QUALITY_PHOTO = 4462067139630668716
    GET_VEHICLE_XENON_LIGHT_COLOR_INDEX = 4467343895069330651
    NETWORK_SET_RICH_PRESENCE_STRING = 4476591411906569451
    IS_CONTROLLED_VEHICLE_UNABLE_TO_GET_TO_ROAD = 4483582511875677686
    SET_VEH_HAS_NORMAL_RADIO = 4487122755207780399
    NETWORK_EARN_FROM_WAREHOUSE = 4488640767785496902
    DATAARRAY_GET_INT = 4493151604661122238
    IS_SPECIAL_ABILITY_ACTIVE = 4494451451678248469
    GET_CURRENT_TRACK_PLAY_TIME = 4496226186989941441
    GET_SUBMARINE_IS_UNDER_DESIGN_DEPTH = 4499606969949596281
    IS_PED_LIPSTICK_TINT_FOR_CREATOR = 4503651381657368180
    CAN_CREATE_RANDOM_PED = 4504525143670489828
    SET_VEHICLE_STRONG = 4507125931233151499
    IS_VEHICLE_DOOR_FULLY_OPEN = 4509014719907044386
    UNLOCK_MINIMAP_POSITION = 4509194413786734384
    SET_PED_WILL_ONLY_ATTACK_WANTED_PLAYER = 4509925950448681516
    NETWORK_REGISTER_HOST_BROADCAST_VARIABLES = 4511251136389182869
    NETWORK_DO_TRANSITION_TO_GAME = 4511396818418239920
    PLAYSTATS_CASINO_BLACKJACK = 4516713711249385389
    TASK_COWER = 4517671858179444245
    START_BEING_BOSS = 4521240656848484029
    NETWORK_EARN_CASINO_HEIST_AWARDS = 4523662546653772170
    SET_HELI_TAIL_BOOM_CAN_BREAK_OFF = 4524075938350448617
    NEXT_ONSCREEN_KEYBOARD_RESULT_WILL_DISPLAY_USING_THESE_FONTS = 4526473369584690706
    SET_PICKUP_HIDDEN_WHEN_UNCOLLECTABLE = 4526883137709942681
    SET_PED_INFINITE_AMMO = 4529689184233022011
    SET_PED_AI_BLIP_HAS_CONE = 4534422099245292714
    GET_NORTH_BLID_INDEX = 4543280776503401352
    IS_BULLET_IN_AREA = 4548674766278827039
    GET_PED_BONE_INDEX = 4558360841545231921
    NETWORK_EARN_FROM_PERSONAL_VEHICLE = 4561302094203707565
    NETWORK_SESSION_SET_MATCHMAKING_PROPERTY_ID = 4562965011801491658
    SET_HEALTH_HUD_DISPLAY_VALUES = 4565739922285832434
    GET_REAL_WORLD_TIME = 4566721762568853320
    ADD_PICKUP_TO_INTERIOR_ROOM_BY_NAME = 4567045791865538352
    GET_PED_MONEY = 4569205681148115687
    SET_PED_HELMET_VISOR_PROP_INDICES = 4572039103616496717
    START_PLAYBACK_RECORDED_VEHICLE = 4577785406487502961
    CREATE_INCIDENT = 4578239628062247655
    NETWORK_HAS_TRANSITION_INVITE_BEEN_ACKED = 4582853247435437468
    GET_PLAYER_SPRINT_STAMINA_REMAINING = 4584408203958845143
    TASK_STOP_PHONE_GESTURE_ANIMATION = 4584679054795456430
    SET_NETWORK_ID_PASS_CONTROL_IN_TUTORIAL = 4585624849189151999
    SET_CAM_NEAR_DOF = 4586000372299456044
    NETWORK_PLAYER_HAS_HEADSET = 4591871217020014550
    NETWORK_SET_NO_LONGER_NEEDED = 4595806223365064733
    SUPPRESS_SHOCKING_EVENT_TYPE_NEXT_FRAME = 4598998255302463280
    GET_ENTITY_COORDS = 4607031842625162586
    APP_SET_STRING = 4608023460562018740
    SET_ALLOW_CUSTOM_VEHICLE_DRIVE_BY_CAM_THIS_UPDATE = 4614199466959077749
    DISPLAY_HUD_WHEN_PAUSED_THIS_FRAME = 4625089984838756504
    SET_DRIVE_TASK_MAX_CRUISE_SPEED = 4632614851719509830
    GET_NUM_DLC_WEAPON_COMPONENTS = 4635370828358050302
    WATER_OVERRIDE_SET_OCEANWAVEAMPLITUDE = 4635771836659468653
    PAUSE_CLOCK = 4635862130881195037
    SET_HELI_MAIN_ROTOR_HEALTH = 4636150225259834327
    SET_ROOM_FOR_GAME_VIEWPORT_BY_KEY = 4638077247980279225
    GET_NUMBER_OF_STREAMING_REQUESTS = 4638713605285395593
    SET_ACTIVATE_OBJECT_PHYSICS_AS_SOON_AS_IT_IS_UNFROZEN = 4639050633478990581
    NETWORK_DISABLE_PROXIMITY_MIGRATION = 4643371535677460878
    HINT_MISSION_AUDIO_BANK = 4644968955775517671
    GET_NUMBER_OF_PLAYERS = 4646729180006083606
    SET_VEHICLE_HOMING_LOCKEDONTO_STATE = 4647087997143065811
    DATAARRAY_ADD_VECTOR = 4647588385826861250
    SET_RENDER_HD_ONLY = 4660940953094668786
    GET_LOAD_HIGH_QUALITY_PHOTO_STATUS = 4661138211621164270
    OVERRIDE_CAM_SPLINE_VELOCITY = 4662966829301039942
    WAS_CUTSCENE_SKIPPED = 4668092540563346793
    SET_PED_VOICE_FULL = 4669965713077873128
    NETWORK_SPEND_BUY_ARENA = 4671880523305962310
    REGISTER_SCRIPT_VARIABLE = 4677866712381006524
    UGC_GET_CACHED_DESCRIPTION = 4681463656773271132
    NETWORK_ACCESS_TUNABLE_INT_HASH = 4682864270808505320
    FORCE_ENTITY_AI_AND_ANIMATION_UPDATE = 4683160558567068594
    SET_GROUP_SEPARATION_RANGE = 4684525938828829924
    SET_VEHICLE_AI_CAN_USE_EXCLUSIVE_SEATS = 4685471052375971924
    ATTACH_VEHICLE_TO_CARGOBOB = 4694987047884322665
    NETWORK_SPENT_UPGRADE_IMPEXP_WAREHOUSE_PROPERTY = 4695079861652539915
    SET_VEHICLE_USE_BOOST_BUTTON_FOR_WHEEL_RETRACT = 4695296460217116378
    IS_PED_LANDING = 4696994260783099131
    SET_PM_WARNINGSCREEN_ACTIVE = 4698674223425403201
    SET_PED_DEFENSIVE_AREA_DIRECTION = 4700751366107889581
    SET_CAM_ANIM_CURRENT_PHASE = 4703346548920268198
    IS_PED_EVASIVE_DIVING = 4703519164161087640
    GET_ENTITY_LOD_DIST = 4709008698181652950
    GET_NUM_DLC_WEAPONS_SP = 4710965711659709865
    NETWORK_GET_FRIEND_DISPLAY_NAME = 4712157362949120659
    IS_HOVERING_OVER_MISSION_CREATOR_BLIP = 4712999281802178670
    GET_VEHICLE_WAYPOINT_TARGET_POINT = 4713969928189664189
    FADE_OUT_LOCAL_PLAYER = 4714632522647834066
    TASK_PUT_PED_DIRECTLY_INTO_COVER = 4715894700071059150
    SC_HAS_ACHIEVEMENT_BEEN_PASSED = 4723644269590817820
    CREATE_NM_MESSAGE = 4723979835631036037
    NETWORK_SET_IN_SPECTATOR_MODE_EXTENDED = 4725847079013019936
    PLAYSTATS_FM_EVENT_PASSTHEPARCEL = 4725988259761428822
    IS_PLANE_LANDING_GEAR_INTACT = 4726715825995734919
    REQUEST_IPL = 4734559983020792692
    SET_TRANSFORM_TO_SUBMARINE_USES_ALTERNATE_INPUT = 4736093091632329382
    CLEAN_ITEMSET = 4736675692165480993
    INT_TO_PLAYERINDEX = 4736989022120507222
    IS_NETWORK_LOADING_SCENE = 4740700733220758699
    REFRESH_INTERIOR = 4752278595253525216
    SET_CUTSCENE_CAN_BE_SKIPPED = 4754298153418524448
    RESET_EXCLUSIVE_SCENARIO_GROUP = 4756570639266240061
    DEACTIVATE_INTERIOR_ENTITY_SET = 4759129920140927330
    GET_WEAPONTYPE_SLOT = 4761789196682362784
    SET_THIRD_PERSON_AIM_CAM_NEAR_CLIP_THIS_UPDATE = 4761823267666126430
    NETWORK_CAN_RECEIVE_LOCAL_INVITE = 4764303478112803172
    NETWORK_HAVE_ROS_LEADERBOARD_WRITE_PRIV = 4768530731517961543
    NETWORK_IS_ENTITY_FADING = 4769086384282971053
    NETWORK_WAS_GAME_SUSPENDED = 4771537563777076137
    NETWORK_SET_IN_SPECTATOR_MODE = 4773221341722904724
    IS_VEHICLE_MODEL = 4773408663263202697
    IS_PLAYER_DEAD = 4777552329540785746
    NETWORK_IS_FRIEND_ONLINE = 4781209078556243533
    USE_DEDICATED_STUNT_CAMERA_THIS_UPDATE = 4781294551213673946
    SET_PED_SHOULD_IGNORE_SCENARIO_EXIT_COLLISION_CHECKS = 4781394475973230408
    RESERVE_LOCAL_NETWORK_MISSION_VEHICLES = 4783157283796173320
    NETWORK_GET_GAMERTAG_FROM_HANDLE = 4783175842773490907
    IS_REPLAY_AVAILABLE = 4792639800086006755
    SET_FORMATION_LEADER = 4794877722726604464
    SET_VEHICLE_CAN_SAVE_IN_GARAGE = 4795116228859555501
    ADD_VEHICLE_CREW_EMBLEM = 4795168919056341587
    FREEZE_ENTITY_POSITION = 4795391166277829702
    STAT_NETWORK_INCREMENT_ON_SUICIDE = 4795963659938393142
    GET_VEHICLE_NUM_OF_BROKEN_OFF_PARTS = 4802172780256109575
    SET_VEHICLE_STEER_BIAS = 4803349002010823870
    NETWORK_GET_ENTITY_KILLER_OF_PLAYER = 4806144161903736312
    SET_THIS_THREAD_PRIORITY = 4807132933123863201
    GET_CURRENT_PLAYBACK_FOR_VEHICLE = 4808724834963185748
    NETWORK_OVERRIDE_CLOCK_RATE = 4809595012377177470
    SET_DITCH_POLICE_MODELS = 4813192708654442036
    NETWORK_REQUEST_CLOUD_TUNABLES = 4826516654086319724
    NETWORK_EARN_FROM_BUSINESS_BATTLE = 4826980631411061393
    GET_PED_RELATIONSHIP_GROUP_DEFAULT_HASH = 4827244105219302286
    GET_SOUND_ID = 4828851653567843141
    SET_GROUND_EFFECT_REDUCES_DRAG = 4830803505957346279
    IS_VEHICLE_ALARM_ACTIVATED = 4835145494804037428
    SET_PED_CAN_BE_TARGETED_WITHOUT_LOS = 4839229034522385521
    SET_POLICE_RADAR_BLIPS = 4839238016204716223
    SET_PED_MAX_MOVE_BLEND_RATIO = 4841514138165184074
    GET_ZONE_POPSCHEDULE = 4842702485247014075
    NETWORK_EARN_FROM_NOT_BADSPORT = 4843429120666901814
    IS_PED_JUMPING_OUT_OF_VEHICLE = 4845275056676582966
    NETWORK_SET_SAME_TEAM_AS_LOCAL_PLAYER = 4848335943331101231
    RESET_END_USER_BENCHMARK = 4859727830066402922
    FACEBOOK_CAN_POST_TO_FACEBOOK = 4865671592456286423
    SET_BEAST_JUMP_THIS_FRAME = 4866177616034872211
    SET_SPECIAL_FLIGHT_MODE_TARGET_RATIO = 4867051427776102033
    NETWORK_CLEAR_FOLLOW_INVITE = 4871766576770453750
    CELL_CAM_IS_CHAR_VISIBLE_NO_FACE_CHECK = 4872503135987204030
    GET_PLAYER_PED = 4874702607714914752
    NETWORK_SPEND_ARCADE = 4875849924608878215
    GET_IS_ARTICULATED_JOINT_AT_MIN_ANGLE = 4883722726676987909
    SET_PED_MAX_TIME_IN_WATER = 4884243307403809085
    ALLOW_PLAYER_SWITCH_PAN = 4886801473252993257
    STOP_SYNCHRONIZED_ENTITY_ANIM = 4887391290816356835
    SEETHROUGH_GET_MAX_THICKNESS = 4889693381928478783
    GET_LENGTH_OF_LITERAL_STRING_IN_BYTES = 4892053862256824078
    NETWORK_CLOSE_TRANSITION_MATCHMAKING = 4896780203404091422
    SET_SIREN_CAN_BE_CONTROLLED_BY_AUDIO = 4898242922278320149
    OVERRIDE_NIGHTVISION_LIGHT_RANGE = 4898364700755669529
    SET_VEHICLE_MOD_COLOR_1 = 4899557154630895032
    REMOVE_CUTSCENE = 4903000637243045999
    APP_DELETE_APP_DATA = 4905856963927646211
    SET_TEXT_EDGE = 4906112297440653222
    CLEAR_VEHICLE_PETROLTANK_FIRE_CULPRIT = 4907118662167955226
    GET_THIS_SCRIPT_NAME = 4912875783519368074
    LOAD_SCENE = 4920441483675323355
    RESET_STORE_NETWORK_GAME_TRACKING = 4921384521999361209
    SET_CREATE_RANDOM_COPS_ON_SCENARIOS = 4921510630544283453
    PAUSE_MENU_DEACTIVATE_CONTEXT = 4921744939901789637
    SET_RANDOM_SEED = 4921758165350085612
    SET_PED_PATH_AVOID_FIRE = 4923931356997885536
    RELEASE_PRELOAD_MODS = 4926227680272089863
    SET_CHECKPOINT_INSIDE_CYLINDER_SCALE = 4927523499458061606
    REGISTER_PEDHEADSHOT = 4927612575077781622
    TASK_VEHICLE_AIM_AT_COORD = 4934852959810141199
    SET_ENTITY_ANIM_CURRENT_TIME = 4938129207985637751
    CHANGE_GOON_LOOKING_FOR_WORK = 4940902616692121791
    SET_ENTITY_ALPHA = 4945100874290747328
    QUEUE_MISSION_REPEAT_SAVE = 4945161046163939182
    SET_FOLLOW_PED_CAM_THIS_UPDATE = 4945255707617020113
    GET_WORLD_POSITION_OF_ENTITY_BONE = 4947482061849130808
    GET_TASK_MOVE_NETWORK_SIGNAL_FLOAT = 4948060963607470658
    SC_EMAIL_DELETE_EMAILS = 4948508597307199963
    NETWORK_CHECK_DATA_MANAGER_SUCCEEDED_FOR_HANDLE = 4950437702671948462
    GET_USINGSEETHROUGH = 4951719587391998931
    SET_PED_WETNESS_HEIGHT = 4957166074485742240
    SET_VEHICLE_WEAPON_RESTRICTED_AMMO = 4957653164232974502
    IS_PED_TRYING_TO_ENTER_A_LOCKED_VEHICLE = 4959181574016202380
    CELL_HORIZONTAL_MODE_TOGGLE = 4964164612513600398
    FIRE_AIR_DEFENCE_SPHERE_WEAPON_AT_POSITION = 4967753149926421364
    IS_PREV_WEATHER_TYPE = 4968191145759412393
    SET_DISPATCH_TIME_BETWEEN_SPAWN_ATTEMPTS = 4969664746815173245
    END_TEXT_COMMAND_THEFEED_POST_TICKER_FORCED = 4970289087243395310
    SC_COMMUNITY_EVENT_IS_ACTIVE_FOR_TYPE = 4974254207416714262
    NETWORK_EARN_SIGHTSEEING_REWARD = 4974360910261007276
    RESET_HUD_COMPONENT_VALUES = 4974561028181810445
    GET_PED_HELMET_STORED_HAT_PROP_INDEX = 4977204263859830808
    IS_PED_DOING_A_BEAST_JUMP = 4980142265546490420
    TASK_SHOCKING_EVENT_REACT = 4982135451075216987
    ADD_POLICE_RESTART = 4983011394672786507
    GET_NTH_CLOSEST_VEHICLE_NODE_FAVOUR_DIRECTION = 5012607438953308263
    GET_VEHICLE_MOD_IDENTIFIER_HASH = 5013578970299864838
    GET_TIMECYCLE_TRANSITION_MODIFIER_INDEX = 5016960269850212540
    SET_VEHICLE_WEAPON_DAMAGE_SCALE = 5018524739360700077
    NETWORK_QUIT_MP_TO_DESKTOP = 5019317137924348348
    IS_THIS_MODEL_A_BOAT = 5019570168338364899
    NETWORK_EARN_FROM_HOLDUPS = 5023788809209093709
    KNOCK_PED_OFF_VEHICLE = 5024833729465002049
    ADD_COVER_BLOCKING_AREA = 5027590626050820993
    UGC_IS_MODIFYING = 5037300884352248283
    SET_PED_DEFAULT_COMPONENT_VARIATION = 5039218013098765667
    SET_CAM_INHERIT_ROLL_VEHICLE = 5040054220485114598
    NETWORK_ADD_MAP_ENTITY_TO_SYNCHRONISED_SCENE = 5040473626851389499
    SET_VEHICLE_ENGINE_HEALTH = 5041455353683427057
    SET_BLIP_ALPHA = 5043916472936335156
    IS_PED_ON_MOUNT = 5047347065715189086
    GET_MAX_WANTED_LEVEL = 5056994522776984671
    PLAYSTATS_APPEND_DIRECTOR_METRIC = 5058226363036468550
    REMOVE_NAVMESH_BLOCKING_OBJECT = 5060245499023817742
    UGC_UPDATE_MISSION = 5063698106916904595
    HAS_CLOSEST_OBJECT_OF_TYPE_BEEN_COMPLETELY_DESTROYED = 5064660776404390723
    REMOVE_DOOR_FROM_SYSTEM = 5065861373067882468
    SET_DISABLE_VEHICLE_PETROL_TANK_FIRES = 5069912345726698322
    SET_TEXT_DROPSHADOW = 5070073224473199441
    NETWORK_DO_TRANSITION_TO_NEW_GAME = 5072730068775600180
    FINALIZE_HEAD_BLEND = 5073542492743713433
    SUPPRESS_LOSING_WANTED_LEVEL_IF_HIDDEN_THIS_FRAME = 5073784287861558094
    CELL_CAM_SET_SELFIE_MODE_HEAD_PITCH_OFFSET = 5074892866309215571
    HAS_NETWORK_TIME_STARTED = 5075990876382755972
    IS_VEHICLE_BUMPER_BROKEN_OFF = 5080155653783107654
    ADD_BLIP_FOR_RADIUS = 5080497408466962842
    SWITCH_PC_SCRIPTED_CONTROLS = 5080927476962420641
    SET_SCRIPTED_CAMERA_IS_FIRST_PERSON_THIS_FRAME = 5088837565914833719
    REMOVE_VEHICLES_FROM_GENERATORS_IN_AREA = 5089597142388722618
    TASK_SHOOT_AT_COORD = 5090980737222598918
    PLAYSTATS_FM_MISSION_END = 5091046114642946745
    PED_HAS_SEXINESS_FLAG_SET = 5093672105526449840
    DATADICT_GET_VECTOR = 5101800707108382156
    SET_DECAL_BULLET_IMPACT_RANGE_SCALE = 5103042483956573948
    APPLY_PED_DAMAGE_PACK = 5106960513763051839
    HAS_CLOUD_REQUESTS_FINISHED = 5107847532010784240
    RESET_AI_MELEE_WEAPON_DAMAGE_MODIFIER = 5108606436650662975
    IS_VEHICLE_WINDOW_INTACT = 5108614288122905073
    IS_THREAD_ACTIVE = 5109806802820293655
    SET_PED_STEERS_AROUND_PEDS = 5112176269199530129
    SET_PORTABLE_PICKUP_PERSIST = 5112621118961072882
    GET_ENTITY_BONE_POSTION = 5113953277438213275
    PLAYSTATS_AWARD_XP = 5114145200206417892
    GET_PED_MAX_HEALTH = 5116269594984730355
    GET_PLAYER_SWITCH_STATE = 5117590216442426021
    SET_ALL_RANDOM_PEDS_FLEE_THIS_FRAME = 5124304676750406898
    SUPPRESS_HD_MAP_STREAMING_THIS_FRAME = 5126107042663278678
    REMOTE_CHEATER_PLAYER_DETECTED = 5127420331863207307
    GET_CURRENT_NUMBER_OF_CLOUD_PHOTOS = 5129971523656009434
    SC_EMAIL_GET_EMAIL_AT_INDEX = 5131737488626825222
    NETWORK_SPEND_UPGRADE_CASINO = 5134339058624162794
    GET_BENCHMARK_ITERATIONS = 5138884420723479020
    IS_PED_ARMED = 5140692576702410007
    SET_WEAPON_DAMAGE_MODIFIER = 5140841433027198206
    INSTANTLY_FILL_PED_POPULATION = 5141365244174826625
    GET_PHONE_GESTURE_ANIM_CURRENT_TIME = 5143562392602840160
    SET_PED_DROPS_WEAPONS_WHEN_DEAD = 5146179700877021608
    SIMULATE_PLAYER_INPUT_GAIT = 5151376232427735645
    LOCK_RADIO_STATION = 5151446947609482641
    NETWORK_ATTACH_SYNCHRONISED_SCENE_TO_ENTITY = 5156001254057144410
    UPDATE_UNLOCKABLE_DJ_RADIO_TRACKS = 5165303600949523728
    PLAYSTATS_AWARD_BAD_SPORT = 5166525244238128259
    SET_CAM_DOF_FOCAL_LENGTH_MULTIPLIER = 5167200893940322298
    GET_ROOM_KEY_FROM_ENTITY = 5170871713518273099
    SET_CLOCK_TIME = 5171176378044663256
    IS_ENTITY_VISIBLE = 5176593366545292405
    IS_PED_RAGDOLL = 5180522170171546453
    WAYPOINT_PLAYBACK_STOP_AIMING_OR_SHOOTING = 5183537896819843818
    TASK_VEHICLE_DRIVE_WANDER = 5188501456062479616
    GET_CURRENT_SCRIPTED_CONVERSATION_LINE = 5189087877674051930
    GET_ENTITY_VELOCITY = 5189785806902891689
    NETWORK_SESSION_SET_UNIQUE_CREW_LIMIT_TRANSITION = 5193138193310285013
    REQUEST_WEAPON_HIGH_DETAIL_MODEL = 5194424688306734064
    ACTIVATE_INTERIOR_GROUPS_USING_CAMERA = 5204694495736271857
    STAT_SET_FLOAT = 5211115015523703612
    GET_PED_HAIR_TINT_COLOR = 5211505038117968821
    IS_PED_IN_COMBAT = 5213464110014277518
    FORCE_CAMERA_RELATIVE_HEADING_AND_PITCH = 5215322525155035828
    REPLAY_START_EVENT = 5215762791066942760
    LOAD_MISSION_CREATOR_PHOTO = 5215805510928798128
    NETWORK_SPEND_CASINO_HEIST_SKIP_MISSION = 5219682815361758249
    SC_PRESENCE_SET_ACTIVITY_RATING = 5222226121362177503
    ARE_WIDESCREEN_BORDERS_ACTIVE = 5222457023442406623
    SET_GAMEPLAY_CAM_MOTION_BLUR_SCALING_THIS_UPDATE = 5222630506162255769
    SET_VEHICLE_WHEEL_TYPE = 5223808454466558881
    TEXTURE_DOWNLOAD_RELEASE = 5223816077257603865
    HUD_FORCE_SPECIAL_VEHICLE_WEAPON_WHEEL = 5224249802429961583
    SET_DISPATCH_TIME_BETWEEN_SPAWN_ATTEMPTS_MULTIPLIER = 5225177057813206481
    PAUSE_MENU_REDRAW_INSTRUCTIONAL_BUTTONS = 5230295355364982912
    REMOVE_WEAPON_FROM_PED = 5231435679784720824
    NETWORK_CLAN_GET_MEMBERSHIP_VALID = 5234762733223927566
    INSTANTLY_FILL_VEHICLE_POPULATION = 5237062563221882480
    IS_PC_VERSION = 5237464558608994872
    SET_CONTROL_SHAKE = 5238680789324452053
    GET_ENTITY_ATTACHED_TO = 5242962755833553187
    IS_VEHICLE_PRODUCING_SLIP_STREAM = 5243935893189903015
    NETWORK_CLAN_GET_MEMBERSHIP_DESC = 5250766909322331576
    REGISTER_TEXT_LABEL_23_TO_SAVE = 5255816378581928940
    SET_PED_HEAD_OVERLAY = 5256907375973354526
    GET_CUTSCENE_SECTION_PLAYING = 5260497291091203032
    RESET_PICKUP_ENTITY_GLOW = 5262563609888675910
    NETWORK_PLAYER_GET_USERID = 5271459214043670944
    DISABLE_CAM_COLLISION_FOR_OBJECT = 5280522926486084266
    NETWORK_ADD_ENTITY_AREA = 5281754460235301481
    GET_CLOCK_SECONDS = 5282326276443980912
    NETWORK_GET_PRESENCE_INVITE_INVITER = 5288013533419881911
    GET_VEHICLE_MOD_COLOR_2_NAME = 5289377805256336801
    SET_VEHICLE_ON_GROUND_PROPERLY = 5292642784517372369
    LOCALIZATION_GET_SYSTEM_LANGUAGE = 5292891609090321215
    SET_PED_HEAD_OVERLAY_TINT = 5295097686177659218
    SET_TRANSFORM_RATE_FOR_ANIMATION = 5296822661613602605
    NET_GAMESERVER_TRANSFER_CASH_SET_TELEMETRY_NONCE_SEED = 5299643871794264183
    DOES_CUTSCENE_ENTITY_EXIST = 5304943546014522457
    STAT_DELETE_SLOT = 5306537703468780912
    SET_WANTED_LEVEL_HIDDEN_ESCAPE_TIME = 5312091079599474631
    DOES_CONTEXT_EXIST_FOR_THIS_PED = 5312448707695254138
    IS_PLAYER_CONTROL_ON = 5315141875575487047
    ACTIVATE_ROCKSTAR_EDITOR = 5321708044775270181
    SET_PED_ALLOW_MINOR_REACTIONS_AS_MISSION_PED = 5324675172004059826
    NETWORK_SESSION_SET_MATCHMAKING_GROUP = 5326773407029747595
    SET_VEHICLE_BOOST_ACTIVE = 5333632485742295457
    THEFEED_SET_VIBRATE_PARAMETER_FOR_NEXT_MESSAGE = 5335776666659240758
    SET_FADE_OUT_AFTER_DEATH = 5339263777479621510
    NETWORK_ENTITY_AREA_IS_OCCUPIED = 5345014695762221839
    REMOVE_OBJECT_HIGH_DETAIL_MODEL = 5348547117121860522
    SET_PLAYER_MELEE_WEAPON_DAMAGE_MODIFIER = 5349651752238059570
    SET_ENTITY_HAS_GRAVITY = 5352284360007020277
    TASK_GUARD_CURRENT_POSITION = 5357212602577714356
    NETWORK_INVITE_GAMERS_TO_TRANSITION = 5357414605704265590
    SC_COMMUNITY_EVENT_GET_EVENT_ID_FOR_TYPE = 5367567768941238087
    GET_STANDARD_BLIP_ENUM_ID = 5375366355209657773
    NETWORK_SET_PRESENCE_SESSION_INVITES_BLOCKED = 5377260822310224951
    CLEAR_PLAYER_HAS_DAMAGED_AT_LEAST_ONE_NON_ANIMAL_PED = 5380879485422869041
    SET_DISABLE_WANTED_CONES_RESPONSE = 5391513451941255398
    NETWORK_CHECK_DATA_MANAGER_FOR_HANDLE = 5392093731223933755
    REQUEST_TENNIS_BANKS = 5393692883528867911
    IS_PED_JACKING = 5396719252235051482
    SET_WEAPON_AOE_MODIFIER = 5396909443708183596
    CLEAR_STATUS_OF_SORTED_LIST_OPERATION = 5402396288790681964
    IS_VEHICLE_STOLEN = 5402557589466559571
    CLEAR_PED_DRIVE_BY_CLIPSET_OVERRIDE = 5403816598616192428
    PLAYSTATS_KILL_YOURSELF = 5404176628756900139
    HIDE_LOADING_ON_FADE_THIS_FRAME = 5405183579162698895
    STAT_SET_BOOL = 5418890436592845874
    ATTACH_ROPE_TO_ENTITY = 5424878668781820517
    GET_VEHICLE_INDEX_FROM_ENTITY_INDEX = 5427955931250817728
    UNPIN_ROPE_VERTEX = 5429901816414925184
    SET_CHECKPOINT_INSIDE_CYLINDER_HEIGHT_SCALE = 5430019150407735619
    SET_BLIP_SHORT_HEIGHT_THRESHOLD = 5430041582010756404
    SET_DISABLE_DECAL_RENDERING_THIS_FRAME = 5430492890577892866
    IS_FLASH_LIGHT_ON = 5437569628196246124
    GET_ANIM_INITIAL_OFFSET_ROTATION = 5440452117463473735
    SET_CONTENT_ID_INDEX = 5441186655226709556
    SET_ENTITY_GHOSTED_FOR_GHOST_PLAYERS = 5449749206986493652
    GET_BLIP_INFO_ID_ENTITY_INDEX = 5450730304715021356
    NETWORK_START_RESPAWN_SEARCH_IN_ANGLED_AREA_FOR_PLAYER = 5451935107821324897
    DOOR_SYSTEM_GET_DOOR_PENDING_STATE = 5459072227459966793
    GET_VEHICLE_CLASS_MAX_BRAKING = 5473364583480552451
    FORCE_ACTIVATE_PHYSICS_ON_UNFIXED_PICKUP = 5481807969674864080
    SET_INTERIOR_IN_USE = 5486282535958604630
    IS_VEHICLE_DRIVEABLE = 5486543479196481881
    NETWORK_IGNORE_REMOTE_WAYPOINTS = 5488374863720050805
    NETWORK_EARN_UPGRADE_ARCADE = 5493113265674128796
    GET_NUMBER_OF_VEHICLE_NUMBER_PLATES = 5498168532199037131
    IS_PED_TRACKED = 5502869916007599031
    SET_PLAYER_VEHICLE_DEFENSE_MODIFIER = 5503652662492472418
    CLOUD_HAS_REQUEST_COMPLETED = 5503877690153780698
    SET_CUTSCENE_ENTITY_STREAMING_FLAGS = 5503899417280873666
    FORCE_CLEANUP_FOR_ALL_THREADS_WITH_THIS_NAME = 5505894489745093399
    CAN_SET_EXIT_STATE_FOR_REGISTERED_ENTITY = 5506323796818019938
    SET_VEHICLE_CAN_BE_VISIBLY_DAMAGED = 5507947388011886209
    SET_PLANE_PROPELLER_HEALTH = 5512791535143907204
    DISABLE_NAVMESH_IN_AREA = 5514784019205462923
    STAT_MIGRATE_CHECK_ALREADY_DONE = 5515218683065266537
    NETWORK_GET_GAME_MODE = 5516966813216858630
    GET_FAKE_WANTED_LEVEL = 5517638295545943838
    IS_VEHICLE_SIREN_ON = 5520275388034856114
    NETWORK_GET_ASSISTED_DAMAGE_OF_ENTITY = 5524975853978134262
    SET_RADIO_STATION_AS_FAVOURITE = 5525894727350360205
    USE_SNOW_WHEEL_VFX_WHEN_UNSHELTERED = 5532655643731181536
    DATADICT_SET_VECTOR = 5536220773918473710
    IS_CUTSCENE_AUTHORIZED = 5542736990898262622
    TASK_COMBAT_HATED_TARGETS_IN_AREA = 5545608298846388384
    SET_PED_HAIR_TINT = 5548371331445766729
    UGC_DID_QUERY_CREATORS_SUCCEED = 5549041244052548094
    GET_WEAPON_COMPONENT_VARIANT_EXTRA_MODEL = 5556519296376539671
    NETWORK_HAS_CONTROL_OF_NETWORK_ID = 5563642154429010310
    SET_CAM_COORD = 5566862829459727406
    VEHICLE_SET_PARACHUTE_MODEL_OVERRIDE = 5575751468805460817
    IS_HELP_MESSAGE_BEING_DISPLAYED = 5582567543607241831
    NETWORK_HAS_INVITED_GAMER = 5586378002039008974
    SET_OBJECT_ALLOW_LOW_LOD_BUOYANCY = 5587232141692752338
    REACTIVATE_ALL_OBJECT_BRAINS_THAT_ARE_WAITING_TILL_OUT_OF_RANGE = 5590442645911470424
    IS_DURANGO_VERSION = 5591266057893987373
    SET_PED_COMBAT_MOVEMENT = 5592521861259579479
    SET_FORCE_VEHICLE_ENGINE_DAMAGE_BY_BULLET = 5592644589027516884
    PLAYSTATS_FAST_TRVL = 5603629066178797512
    GET_NEAREST_PLAYER_TO_ENTITY_ON_TEAM = 5605193934252643127
    ACTIVITY_FEED_CREATE = 5606411078356580045
    NETWORK_ENTITY_AREA_HAVE_ALL_REPLIED = 5618187755484512177
    DATAFILE_UPDATE_SAVE_TO_CLOUD = 5619887515254096192
    SET_TEXT_JUSTIFICATION = 5623137247512493770
    FORCE_MUSIC_TRACK_LIST = 5623580937310184828
    IS_PED_IN_MELEE_COMBAT = 5629670148008661337
    SET_VEHICLE_DAMAGE_SCALE = 5629731145273908878
    IS_NAVIGATING_MENU_CONTENT = 5637610560796792129
    SET_CUSTOM_RADIO_TRACK_LIST = 5638588730332109746
    DOES_VEHICLE_ALLOW_RAPPEL = 5638924910568065101
    SET_ALL_MAPDATA_CULLED = 5643827625767894650
    UGC_GET_CONTENT_RATING_NEGATIVE_COUNT = 5644290222526275577
    RESERVE_NETWORK_MISSION_OBJECTS = 5646550472978529272
    GET_STREAM_PLAY_TIME = 5652787034970432475
    SET_POLICE_FOCUS_WILL_TRACK_VEHICLE = 5653396517677426945
    SET_PLAYER_STEALTH_PERCEPTION_MODIFIER = 5661061848659480698
    SET_PED_EMISSIVE_SCALE = 5661261427343501117
    IS_MP_GAMER_TAG_ACTIVE = 5661761929850846502
    NETWORK_SPENT_BUY_BASE = 5666641199259471137
    SET_PLAYER_IS_IN_ANIMAL_FORM = 5673267276741983956
    IS_PLAYER_RIDING_TRAIN = 5674859435992752534
    GET_VEHICLE_DEFORMATION_AT_POS = 5676452788774540598
    SC_COMMUNITY_EVENT_GET_EVENT_ID = 5681793230013298233
    WAIT = 5683038035346286502
    ADD_SCRIPT_TO_RANDOM_PED = 5685009978224958668
    NETWORK_CAN_SESSION_END = 5686853811537823090
    SET_PED_DEFENSIVE_AREA_ATTACHED_TO_PED = 5689312838294218934
    TASK_FORCE_MOTION_STATE = 5694078366121924523
    FORCE_USE_AUDIO_GAME_OBJECT = 5695999342423706424
    DECOR_IS_REGISTERED_AS_TYPE = 5698454273970863048
    CLOUD_CHECK_AVAILABILITY = 5699333282453812877
    SET_VEHICLE_COLOURS = 5700796144468248065
    IS_CINEMATIC_FIRST_PERSON_VEHICLE_INTERIOR_CAM_RENDERING = 5706835701728451392
    SHOW_SCRIPTED_HUD_COMPONENT_THIS_FRAME = 5708555112408592034
    GET_VEHICLE_NODE_IS_SWITCHED_OFF = 5715191804072465017
    ADD_PETROL_DECAL = 5715651525905747448
    SET_SAVE_HOUSE = 5716348497048196028
    NETWORK_GET_PVC_BALANCE = 5716461793304574798
    SET_PED_BOUNDS_ORIENTATION = 5719401217563149519
    SET_BLIP_ROUTE = 5727886703621522409
    PLAYER_ID = 5730343094349521110
    GET_DISABLED_CONTROL_UNBOUND_NORMAL = 5731435981211263739
    GET_VEHICLE_CLASS_MAX_AGILITY = 5733938639626755643
    IS_PED_BEING_STUNNED = 5745129553015312104
    CLEAR_DECISION_MAKER_EVENT_RESPONSE = 5749188085697907048
    DOES_CUTSCENE_HANDLE_EXIST = 5750418796423043084
    PLAYSTATS_ARCADE_LOVE_MATCH = 5750460377678822437
    STAT_SAVE_MIGRATION_CANCEL_PENDING_OPERATION = 5759913811985064980
    EXTEND_WORLD_BOUNDARY_FOR_PLAYER = 5766535433347029031
    CLEAR_FLOATING_HELP = 5766949786331905786
    DISABLE_INDIVIDUAL_PLANE_PROPELLER = 5766986472521779299
    PLAYSTATS_BACKGROUND_SCRIPT_ACTION = 5767386913429428009
    PLAYSTATS_EARNED_MC_POINTS = 5770369536710702286
    SET_PED_CYCLE_VEHICLE_WEAPONS_ONLY = 5775707058945875730
    SET_FLY_CAM_HORIZONTAL_RESPONSE = 5782438440912250290
    TASK_LEAVE_ANY_VEHICLE = 5786374414059643463
    SET_INSIDE_VERY_SMALL_INTERIOR = 5786560795809227414
    GET_VEHICLE_HAS_KERS = 5792559533331924207
    GET_TIME_SINCE_LAST_ARREST = 5792747526117565206
    IPL_GROUP_SWAP_IS_ACTIVE = 5794149789284519384
    SET_SCRIPTED_CONVERSION_COORD_THIS_FRAME = 5802544540557692805
    SET_PED_WEAPON_TINT_INDEX = 5806999861877102392
    SET_EXTRA_TCMODIFIER = 5807107619408119149
    GET_PICKUP_OBJECT = 5807880269390882222
    CREATE_OBJECT = 5808896370743568450
    SC_COMMUNITY_EVENT_GET_EXTRA_DATA_FLOAT = 5812074960454940734
    GET_AUDIBLE_MUSIC_TRACK_TEXT_ID = 5814594605652792411
    SET_HEAD_BLEND_EYE_COLOR = 5815670529632284639
    GET_ENTITY_ANIM_TOTAL_TIME = 5817849383723590496
    DATAARRAY_GET_BOOL = 5819128487743635732
    ENABLE_SHADOW_CULL_MODEL_THIS_FRAME = 5819624144786551657
    GET_LOCAL_TIME = 5820807480810575688
    GET_NUMBER_OF_FIRES_IN_RANGE = 5821699207502803717
    DO_AUTO_SAVE = 5831786413828533845
    SETUP_SHOP_PED_APPAREL_QUERY = 5833383634230766431
    IS_CONTROL_JUST_RELEASED = 5834765322530865638
    GET_PLAYER_PED_SCRIPT_INDEX = 5835191375820269281
    GET_TRACKED_PED_PIXELCOUNT = 5845419876193650658
    IS_ENTITY_IN_ANGLED_AREA = 5845968004384409482
    NETWORK_EARN_DAILY_OBJECTIVE_EVENT = 5848169395913459452
    SET_GAMEPLAY_HINT_FOV = 5851306195055681823
    GET_PED_AS_GROUP_MEMBER = 5856179815557885335
    NETWORK_EARN_FROM_AI_TARGET_KILL = 5862360853681260247
    SET_CINEMATIC_BUTTON_ACTIVE = 5865550924448349599
    PLAYSTATS_BAN_ALERT = 5868130316867006437
    SET_VEHICLE_DOORS_LOCKED_FOR_PLAYER = 5871197926712478929
    TASK_VEHICLE_SHOOT_AT_COORD = 5877331030622116717
    CAN_KNOCK_PED_OFF_VEHICLE = 5885087215319473034
    SET_VEHICLE_CAN_LEAK_OIL = 5889351003397591371
    CALL_SCALEFORM_MOVIE_METHOD_WITH_STRING = 5889616307707767031
    NETWORK_ENABLE_EMPTY_CROWDING_VEHICLES_REMOVAL = 5898325932266726880
    GET_MOD_SLOT_NAME = 5904499186143762624
    NET_GAMESERVER_DELETE_CHARACTER = 5904686286018260845
    GET_CAN_VEHICLE_BE_PLACED_HERE = 5905078611851256334
    SET_PLAYER_WANTED_CENTRE_POSITION = 5912755833973846868
    NETWORK_IS_TRANSITION_BUSY = 5913000372460136119
    NETWORK_APPLY_TRANSITION_PARAMETER = 5914977478991547672
    BEGIN_TEXT_COMMAND_GET_NUMBER_OF_LINES_FOR_STRING = 5917642232252190948
    GET_RENDERING_CAM = 5923634223534172858
    OPEN_REPORTUGC_MENU = 5925146168273977555
    CLEAR_PED_DAMAGE_DECAL_BY_ZONE = 5925745001967143466
    IS_ENTITY_A_PED = 5929769480716891198
    NETWORK_SPENT_BOAT_PICKUP = 5930928697977809920
    NETWORK_SET_LOCAL_PLAYER_SYNC_LOOK_AT = 5931223868673636723
    SET_NO_LOADING_SCREEN = 5936531669087452681
    IS_PROJECTILE_IN_AREA = 5940433707723179000
    DATAFILE_SELECT_UGC_PLAYER_DATA = 5945182624153545536
    FORCE_ROOM_FOR_ENTITY = 5949884333633149191
    DOES_RAYFIRE_MAP_OBJECT_EXIST = 5958072615692896941
    DELETE_ROPE = 5959531772662662729
    SET_CAN_RESPRAY_VEHICLE = 5961537328538620758
    NETWORK_GET_HIGHEST_RELIABLE_RESEND_COUNT = 5963305607794590466
    SET_PED_HIGHLY_PERCEPTIVE = 5968846988125144541
    GET_COMBAT_FLOAT = 5971765001374402826
    GET_DEFAULT_SCRIPT_RENDERTARGET_RENDER_ID = 5976444026706024118
    IS_VEHICLE_A_CONVERTIBLE = 5977217488152739022
    GET_PATROL_TASK_INFO = 5978305092915355578
    SET_PED_IN_VEHICLE_CONTEXT = 5980904727542081734
    IS_PED_STOPPED = 5983389407396798996
    GET_BITS_IN_RANGE = 5986841242682558778
    END_TEXT_COMMAND_THEFEED_POST_MESSAGETEXT_WITH_CREW_TAG_AND_ADDITIONAL_ICON = 5988526260858920886
    UGC_GET_TOP_RATED_CONTENT = 5991090304966342000
    HIDE_NUMBER_ON_BLIP = 5993446006920315208
    NETWORK_EARN_DAILY_VEHICLE = 5994418547077808268
    IS_ENTITY_UPRIGHT = 5995405076656232874
    SET_WHEELS_RETRACTED_INSTANTLY = 5995907767309952846
    PLAYSTATS_ARCADE_GAME = 5997243424377272664
    GET_VEHICLE_MODEL_ACCELERATION_MAX_MODS = 5998965477527107654
    WAYPOINT_RECORDING_GET_NUM_POINTS = 5999730577058591284
    GET_ACTIVE_VEHICLE_MISSION_TYPE = 6001868555479239851
    IS_EXTRA_BROKEN_OFF = 6002795641177033821
    CUSTOM_MINIMAP_SET_ACTIVE = 6004641606629091492
    SET_EXCLUSIVE_SCENARIO_GROUP = 6007405949742746730
    ROPE_CONVERT_TO_SIMPLE = 6019576087505209242
    START_ROPE_UNWINDING_FRONT = 6020487492214106537
    GET_FAKE_SUSPENSION_LOWERING_AMOUNT = 6022772658798698263
    GET_VEHICLE_MODEL_MAX_TRACTION = 6025228394570841357
    DELETE_OBJECT = 6025265325407423391
    GET_VEHICLE_ESTIMATED_MAX_SPEED = 6030207453007825479
    NETWORK_SESSION_GET_PRIVATE_SLOTS = 6030274049712124665
    NETWORK_NEED_TO_START_NEW_GAME_BUT_BLOCKED = 6035118770407928521
    PLAYSTATS_HEIST3_PREP = 6035694674337149439
    PLAYSTATS_BC_CASHING = 6037885909452614035
    CLEAR_VEHICLE_CRASH_TASK = 6043205471939857040
    SET_TEAM_PICKUP_OBJECT = 6044076003401986250
    IS_PED_CLIMBING = 6046306041128281635
    CELL_CAM_SET_SELFIE_MODE_HORZ_PAN_OFFSET = 6049611026250109092
    NETWORK_IS_TRANSITION_STARTED = 6051293360723593214
    COUNT_PEDS_IN_COMBAT_WITH_TARGET = 6055009608815376567
    SET_BLIP_HIDDEN_ON_LEGEND = 6066784729005810894
    REQUEST_WEAPON_ASSET = 6071771004139350467
    HAS_LOADED_MP_DATA_SET = 6073122710248405990
    SET_GLIDER_ACTIVE = 6073551323999682027
    NETWORK_PLAYER_IS_ROCKSTAR_DEV = 6073875792457145197
    SET_CALMED_WAVE_HEIGHT_SCALER = 6084987251721979102
    IS_ENTITY_IN_AREA = 6085324774352294245
    STAT_GET_LICENSE_PLATE = 6085440726694933220
    STOP_PLAYBACK_RECORDED_VEHICLE = 6089770571023433194
    GET_JACK_TARGET = 6090739841496855597
    DRAW_SCALEFORM_MOVIE = 6095387740489730707
    NETWORK_SPEND_BEACH_PARTY = 6101148445739258441
    ADD_VEHICLE_COMBAT_ANGLED_AVOIDANCE_AREA = 6102648063364385375
    GIVE_PED_HELMET = 6109067650810737022
    BEGIN_TEXT_COMMAND_GET_SCREEN_WIDTH_OF_DISPLAY_TEXT = 6110974342664948907
    SET_PARTICLE_FX_BANG_SCRAPE_LODRANGE_SCALE = 6116502520489929357
    SET_TENNIS_MOVE_NETWORK_SIGNAL_FLOAT = 6120769989020104738
    DISABLE_CAMERA_VIEW_MODE_CYCLE = 6125378890949434679
    NETWORK_EARN_COLLECTABLES_ACTION_FIGURES = 6131643197212221513
    CUSTOM_MINIMAP_CREATE_BLIP = 6133332691679669992
    DISTANT_COP_CAR_SIRENS = 6134863619627039445
    IS_PED_DIVING = 6136075483951897361
    SET_PROFILE_SETTING_CREATOR_CTF_DONE = 6140733103462002062
    NETWORK_SESSION_SET_UNIQUE_CREW_ONLY_CREWS_TRANSITION = 6141154985024726330
    GET_DLC_VEHICLE_FLAGS = 6145704927502204146
    THEFEED_SET_SCRIPTED_MENU_HEIGHT = 6150101939890469272
    DELETE_INCIDENT = 6155324075688698375
    NETWORK_SPEND_UPGRADE_ARCADE = 6157655951153373146
    HAS_PC_CHEAT_WITH_HASH_BEEN_ACTIVATED = 6160435850588389544
    NETWORK_PERMISSIONS_HAS_GAMER_RECORD = 6169579165185763552
    NETWORK_EARN_PURCHASE_CLUB_HOUSE = 6170459898703589285
    STAT_GET_CURRENT_SPEED = 6172393068173086391
    UGC_GET_CONTENT_ID = 6172911116647568594
    SC_EMAIL_MESSAGE_CLEAR_RECIP_LIST = 6187785034258785134
    CLEAR_VEHICLE_CUSTOM_PRIMARY_COLOUR = 6188458765339386935
    ACTIVATE_INTERIOR_ENTITY_SET = 6190315277334034081
    GET_TYRE_HEALTH = 6190954224750072704
    SET_NEXT_RADIO_TRACK = 6191592767246369712
    DONT_ZOOM_MINIMAP_WHEN_SNIPING_THIS_FRAME = 6194039314628009568
    SET_PLAYER_CAN_DAMAGE_PLAYER = 6196039133528458004
    SET_PED_HELMET = 6199841587769737477
    NETWORK_IS_THREAD_A_NETWORK_SCRIPT = 6200122143695527543
    GET_PLAYER_FAKE_WANTED_LEVEL = 6201560425862729466
    SET_RELATIONSHIP_GROUP_AFFECTS_WANTED_LEVEL = 6203111202431420130
    GET_AI_PED_VEHICLE_BLIP_INDEX = 6203541990188666856
    ADD_PED_DECORATION_FROM_HASHES_IN_CORONA = 6204200657692227635
    NETWORK_REPORT_CODE_TAMPER = 6207888651687768277
    IS_VEHICLE_WEAPON_DISABLED = 6213671875666315054
    POINT_CAM_AT_ENTITY = 6215178559440742620
    GET_PREV_WEATHER_TYPE_HASH_NAME = 6218213562023429539
    NETWORK_PLAYER_INDEX_IS_CHEATER = 6223485461200919532
    NETWORK_EARN_CASINO_MISSION_REWARD = 6228429917723789278
    STAT_GET_CANCEL_SAVE_MIGRATION_STATUS = 6229468805688469990
    SET_FACIAL_CLIPSET = 6235172044254340097
    STAT_SET_OPEN_SAVETYPE_IN_JOB = 6235330846678990040
    NETWORK_RECEIVE_PLAYER_JOBSHARE_CASH = 6243032628598211992
    SET_VEHICLE_TANK_TURRET_POSITION = 6249109990886858682
    THEFEED_AUTO_POST_GAMETIPS_ON = 6253448231566743636
    NETWORK_SESSION_GET_MATCHMAKING_GROUP_FREE = 6255079904156517387
    SET_PED_DIES_IN_WATER = 6255201556019755998
    CLEAR_PED_BLOOD_DAMAGE_BY_ZONE = 6261049720308292084
    SET_CARGOBOB_PICKUP_MAGNET_ENSURE_PICKUP_ENTITY_UPRIGHT = 6263203697368317878
    NETWORK_IS_FRIEND_IN_MULTIPLAYER = 6269111941638076968
    SET_PLAYER_TARGET_LEVEL = 6269777142802657741
    SET_PED_INCREASED_AVOIDANCE_RADIUS = 6270006640257154155
    SET_CARGOBOB_FORCE_DONT_DETACH_VEHICLE = 6277995032391883046
    IS_VEHICLE_STOPPED = 6278497493873644922
    NETWORK_MARK_TRANSITION_GAMER_AS_FULLY_JOINED = 6280475758869872413
    GET_TIME_POSITION_IN_RECORDING = 6288981831131850052
    SET_PED_BLOCKS_PATHING_WHEN_DEAD = 6297603381695575522
    IS_ENTITY_ATTACHED_TO_HANDLER_FRAME = 6300915648399759277
    SET_ALLOW_COMMA_ON_TEXT_INPUT = 6302112359009983650
    TEXTURE_DOWNLOAD_HAS_FAILED = 6302485682914018951
    SET_GAME_PAUSED = 6304215415132731153
    SET_CURR_WEATHER_STATE = 6308545993921853964
    NETWORK_CLAN_SERVICE_IS_VALID = 6313148171058759830
    PARTICIPANT_ID_TO_INT = 6315099850143017482
    DATAARRAY_ADD_FLOAT = 6316744868199890774
    IS_PED_USING_ANY_SCENARIO = 6317224474499895619
    NETWORK_IS_PLAYER_BLOCKED_BY_ME = 6318303497628956449
    NETWORK_OVERRIDE_SEND_RESTRICTIONS_ALL = 6318993057537401813
    SET_VEHICLE_WINDOW_TINT = 6324494699532199574
    SET_ENTITY_TRAFFICLIGHT_OVERRIDE = 6324702480186075844
    NETWORK_GET_SCRIPT_STATUS = 6327936140006128319
    FORCE_NEXT_MESSAGE_TO_PREVIOUS_BRIEFS_LIST = 6329634270836220017
    REGISTER_NAMED_RENDERTARGET = 6330303121102888163
    NETWORK_ARE_HANDLES_THE_SAME = 6330829940368405015
    IS_PED_SPRINTING = 6333283514708902248
    DOES_VEHICLE_HAVE_STUCK_VEHICLE_CHECK = 6333402058924655728
    SET_SUPER_JUMP_THIS_FRAME = 6341050950550703115
    IS_CONTROL_JUST_PRESSED = 6342219533232326959
    NETWORK_CAN_BAIL = 6344696953694702689
    SET_VEHICLE_TAIL_LIGHTS = 6347187226712444404
    THEFEED_FORCE_RENDER_OFF = 6354659923928739388
    NETWORK_CLAN_GET_EMBLEM_TXD_NAME = 6356225926059536772
    GET_WEAPON_CLIP_SIZE = 6357925372124491444
    GET_CUTSCENE_CONCAT_SECTION_PLAYING = 6358511906326560152
    SET_ADDITIONAL_ROTATION_FOR_RECORDED_VEHICLE_PLAYBACK = 6360497116269160439
    UGC_GET_CONTENT_CREATOR_GAMER_HANDLE = 6361176664977017880
    GET_MOBILE_PHONE_POSITION = 6363550927110036358
    NETWORK_HASH_FROM_GAMER_HANDLE = 6365656395352418540
    GET_MAX_AMMO_BY_TYPE = 6365916988562282249
    GET_BLIP_COORDS = 6371184173552343406
    GET_VEHICLE_MODEL_VALUE = 6373650422620963382
    IS_PED_IN_GROUP = 6382105097986178932
    RESET_DISPATCH_SPAWN_LOCATION = 6383556416858465505
    DOOR_SYSTEM_FIND_EXISTING_DOOR = 6385964303556313797
    CANCEL_ONSCREEN_KEYBOARD = 6387120106938210765
    LEADERBOARDS_GET_CACHE_NUMBER_OF_ROWS = 6387883062920579501
    PLACE_OBJECT_ON_GROUND_PROPERLY = 6388445041372756643
    SET_VEHICLE_CONVERSATIONS_PERSIST = 6393765101370660340
    OPEN_COMMERCE_STORE = 6395693550441617554
    SET_SEQUENCE_TO_REPEAT = 6397096036273113831
    NETWORK_GET_DISPLAYNAMES_FROM_HANDLES = 6398515658071826839
    TASK_USE_NEAREST_SCENARIO_TO_COORD_WARP = 6404928951124981443
    PUSH_TIMECYCLE_MODIFIER = 6410651044935755444
    SET_MINIMAP_BLOCK_WAYPOINT = 6411681030037084124
    PLAY_STREAM_FRONTEND = 6412250883756258804
    SET_SCRIPTED_ANIM_SEAT_OFFSET = 6419806103349412400
    SET_MISSION_TRAIN_COORDS = 6421190184434054966
    SET_ENTITY_LOD_DIST = 6424377629148148579
    IS_USER_OLD_ENOUGH_TO_ACCESS_STORE = 6427356507131407147
    NETWORK_HAS_ROS_PRIVILEGE_PLAYED_LAST_GEN = 6428168023976670856
    SHUTDOWN_AND_LAUNCH_SINGLE_PLAYER_GAME = 6428977259712263826
    GET_SCREEN_CODE_WANTS_SCRIPT_TO_CONTROL = 6431117049144251092
    DISABLE_FIRST_PERSON_FLASH_EFFECT_THIS_UPDATE = 6431786605995149745
    NETWORK_YOHAN_SOURCE_GOODS = 6433827236767904092
    GET_SCRIPTED_COVER_POINT_COORDS = 6433972785867538053
    TASK_FOLLOW_POINT_ROUTE = 6437195450626368110
    IS_MP_GAMER_TAG_FREE = 6438829671920624025
    NETWORK_CHECK_USER_CONTENT_PRIVILEGES = 6439868769262579161
    SET_IGNORE_LOW_PRIORITY_SHOCKING_EVENTS = 6442811240944981760
    UGC_GET_CREATOR_NUM = 6449029024023867335
    IS_PED_HURT = 6450204994699254546
    SET_TAXI_LIGHTS = 6451410762761259225
    ARE_WINGS_OF_PLANE_INTACT = 6454115749644375671
    NETWORK_GET_RANDOM_INT = 6457686472773252607
    GET_LOCAL_PLAYER_GAMEPAD_AIM_STATE = 6465383111413011260
    SET_VEHICLE_CAN_BREAK = 6467041784937131878
    LOAD_STREAM_WITH_START_OFFSET = 6467568711430256402
    SET_PEDS_CAN_FALL_OFF_THIS_VEHICLE_FROM_LARGE_FALL_DAMAGE = 6468142661973051624
    NETWORK_SESSION_SET_NUM_BOSSES = 6472835296025215834
    NETWORK_JOIN_PREVIOUSLY_FAILED_SESSION = 6476028042681886688
    SET_RADAR_AS_INTERIOR_THIS_FRAME = 6478190164825072410
    SET_VEHICLE_AUDIO_ENGINE_DAMAGE_FACTOR = 6478345086363979066
    ADD_BLIP_FOR_COORD = 6486199071725192374
    UGC_GET_MODIFY_RESULT = 6488065395468686600
    UGC_RELEASE_CACHED_DESCRIPTION = 6500046233113717828
    USE_WAYPOINT_RECORDING_AS_ASSISTED_MOVEMENT_ROUTE = 6500167120046822837
    DISABLE_NEAR_CLIP_SCAN_THIS_UPDATE = 6504261568552221279
    PLAYSTATS_HUB_EXIT = 6505076814625771826
    GET_ENTITY_ALPHA = 6505365780593284294
    TASK_PED_SLIDE_TO_COORD_HDG_RATE = 6506129629110488914
    SET_FOLLOW_PED_CAM_VIEW_MODE = 6507594667565250308
    GET_ENTITY_HEIGHT = 6507777749973288157
    STAT_COMMUNITY_START_SYNCH = 6509226632792151042
    DOES_SCENARIO_EXIST_IN_AREA = 6510277754647032769
    STRING_TO_INT = 6511995047536145796
    NETWORK_IS_TRANSITION_PRIVATE = 6515200474330247654
    NETWORK_START_RESPAWN_SEARCH_FOR_PLAYER = 6516702219224674636
    SUPPRESS_AMBIENT_PED_AGGRESSIVE_CLEANUP_THIS_FRAME = 6521039627000175037
    IS_SCREEN_FADED_IN = 6522783478398879352
    ARE_PROFILE_SETTINGS_VALID = 6531273866272062164
    GET_BOAT_VEHICLE_MODEL_AGILITY = 6531337081606161660
    RELEASE_PED_PRELOAD_VARIATION_DATA = 6533412922469711254
    TASK_PERFORM_SEQUENCE = 6537601060411640379
    SET_DRIFT_TYRES = 6541369163745689349
    TASK_TURN_PED_TO_FACE_ENTITY = 6544360553900626860
    SET_SCRIPTS_HAVE_CLEANED_UP_FOR_REPLAY_SYSTEM = 6544736507913168339
    SETTIMERB = 6548545859220659790
    NETWORK_DID_GET_GAMER_STATUS_SUCCEED = 6548652132196988913
    TRIGGER_SCRIPT_EVENT = 6550939030955736669
    SET_VEHICLE_PROVIDES_COVER = 6556939626901707223
    GET_STATUS_OF_CREATE_MISSION_CREATOR_PHOTO_PREVIEW = 6558110179164768868
    DATADICT_CREATE_ARRAY = 6562152048279318111
    CANCEL_MUSIC_EVENT = 6563900810404773285
    GET_REPLAY_STAT_MISSION_ID = 6566017576083353569
    SET_GPS_FLAGS = 6576389480415547739
    GET_PLAYER_SWITCH_INTERP_OUT_CURRENT_TIME = 6577683649291326117
    NETWORK_EARN_AWARD_SHORT_TRIP = 6579123458491720736
    GET_FINAL_RENDERED_CAM_ROT = 6579280224713453051
    NETWORK_GET_PRIMARY_CLAN_DATA_SUCCESS = 6579483016219238586
    HAS_LOADED_SP_DATA_SET = 6579947836550891252
    SET_PED_SHOULD_IGNORE_SCENARIO_NAV_CHECKS = 6584281019619381397
    NETWORK_EARN_TARGET_REFUND = 6586124068969916191
    WASH_DECALS_FROM_VEHICLE = 6589091028502690836
    SET_USE_ADJUSTED_MOUSE_COORDS = 6589830022120762916
    IS_SWITCH_SKIPPING_DESCENT = 6590150046017011326
    DELETE_MISSION_TRAIN = 6590650039989028757
    GET_CONTROL_UNBOUND_NORMAL = 6594625126775523781
    NETWORK_SESSION_VOICE_SET_TIMEOUT = 6597443441721419697
    SET_INVERT_VEHICLE_CONTROLS = 6598250818845233576
    PLAY_SOUND_FROM_ENTITY_HASH = 6600116691201550477
    NETWORK_CLAN_DOWNLOAD_MEMBERSHIP_PENDING = 6601716568125337024
    ADD_ARMOUR_TO_PED = 6604056754174353199
    HAS_VEHICLE_PETROLTANK_SET_ON_FIRE_BY_ENTITY = 6604117671637501612
    SET_PED_DIES_WHEN_INJURED = 6604407477447426083
    NETWORK_SPENT_EMPLOY_ASSASSINS = 6610115616116437445
    SET_USE_DOUBLE_CLICK_FOR_CAR_JUMP = 6610425929382778615
    TASK_GO_TO_COORD_ANY_MEANS = 6612490191631957640
    NETWORK_HAS_CONTROL_OF_PICKUP = 6613898200329449382
    DRAW_SHADOWED_SPOT_LIGHT = 6614196010357986523
    NETWORK_SPENT_JUKEBOX = 6615190775930516434
    STAT_MIGRATE_CHECK_GET_IS_PLATFORM_AVAILABLE = 6617461675217668783
    PLAYSTATS_QUIT_MODE = 6625525431557848148
    GET_PAUSE_MENU_POSITION = 6629077473248403630
    CLEAR_POPSCHEDULE_OVERRIDE_VEHICLE_MODEL = 6633207860560761116
    SET_STATE_OF_RAYFIRE_MAP_OBJECT = 6641110261787051489
    SET_ENTITY_SORT_BIAS = 6646038842053626818
    GET_LAST_MATERIAL_HIT_BY_ENTITY = 6646480253144489036
    SET_FIRST_PERSON_FLASH_EFFECT_TYPE = 6647848214678348050
    WAS_FLY_CAM_CONSTRAINED_ON_PREVIOUS_UDPATE = 6649742794127782265
    ATTACH_ENTITY_BONE_TO_ENTITY_BONE = 6649766434954560876
    NETWORK_SHOW_PSN_UGC_RESTRICTION = 6649975130724452459
    SC_LICENSEPLATE_GET_ISVALID_STATUS = 6651464782698099740
    IS_SCREEN_FADING_IN = 6653025866621830517
    NETWORK_SET_ANTAGONISTIC_TO_PLAYER = 6660958429499668986
    SET_PLAYER_LOCKON = 6668475646901236366
    GET_NEW_SELECTED_MISSION_CREATOR_BLIP = 6669998785878170356
    SET_FOLLOW_VEHICLE_CAM_SEAT_THIS_UPDATE = 6670053907971023151
    NETWORK_EARN_COLLECTABLE_COMPLETED_COLLECTION = 6672955357496954790
    SET_DRIVE_TASK_CRUISE_SPEED = 6673073222263625992
    UGC_LOAD_OFFLINE_QUERY = 6678419587112944896
    NETWORK_GET_VC_BALANCE = 6681892132440906644
    END_TEXT_COMMAND_THEFEED_POST_MESSAGETEXT_WITH_CREW_TAG = 6683196358793214270
    GET_SCREENBLUR_FADE_CURRENT_TIME = 6686367688574230067
    GET_PED_AS_GROUP_LEADER = 6687397790089122796
    IS_PED_HEADTRACKING_PED = 6688913659369391373
    PLAYSTATS_NJVS_VOTE = 6690921144453369552
    ADD_BLIP_FOR_ENTITY = 6691947479759912167
    FORCE_PORTABLE_PICKUP_LAST_ACCESSIBLE_POSITION_SETTING = 6693163072982541402
    LEADERBOARDS2_READ_BY_RADIUS = 6693905934776977604
    TERRAINGRID_SET_COLOURS = 6694083083363615687
    VEHICLE_WAYPOINT_PLAYBACK_USE_DEFAULT_SPEED = 6695486673738041699
    SET_DISABLE_BREAKING = 6695755901876206939
    DOES_WEAPON_TAKE_WEAPON_COMPONENT = 6696357820197948080
    ADD_VEHICLE_SUBTASK_ATTACK_COORD = 6697091213006265717
    NETWORK_HAS_RECEIVED_HOST_BROADCAST_DATA = 6706057179025098886
    SET_VEHICLE_ALLOW_NO_PASSENGERS_LOCKON = 6707218932995881772
    NETWORK_CAN_RECEIVE_PLAYER_CASH = 6708039462977417860
    NETWORK_GET_EVC_BALANCE = 6709930207606202085
    REFRESH_CLOSEST_OCEAN_SHORELINE = 6713735284247588366
    GET_TIME_SINCE_PLAYER_HIT_VEHICLE = 6716534950534450912
    IS_SYSTEM_UI_BEING_DISPLAYED = 6724188946249052473
    RELEASE_PEDHEADSHOT_IMG_UPLOAD = 6724291129554947332
    IS_TENNIS_MODE = 6725134082481130559
    GET_CUTSCENE_PLAY_DURATION = 6726195801414038179
    GET_SHOP_PED_PROP = 6727445416123430652
    GET_HASH_NAME_FOR_PROP = 6728765040443181277
    REMOVE_DECALS_IN_RANGE = 6731523856112450658
    SET_GAMEPLAY_HINT_CAMERA_RELATIVE_SIDE_OFFSET = 6736085478560457016
    TRIGGER_VEHICLE_PART_BROKEN_CAMERA_SHAKE = 6743805870974465696
    NETWORK_SPENT_BALLISTIC_EQUIPMENT = 6743967863927664931
    PLAYSTATS_IDLE_KICK = 6747422340528087663
    SET_WEAPON_OBJECT_COMPONENT_TINT_INDEX = 6748685446660663014
    SET_PLAYER_HEALTH_RECHARGE_MULTIPLIER = 6752691015583894065
    IS_VEHICLE_AUDIBLY_DAMAGED = 6753148804760854258
    SET_SKIDMARK_RANGE_SCALE = 6755124405730726025
    SET_PLAYER_BLUETOOTH_STATE = 6756536921968746817
    NETWORK_IS_TRANSITION_SOLO = 6756937795650164234
    GET_WEAPON_TINT_COUNT = 6759740710971153399
    GET_VEHICLE_ACCELERATION = 6760849226395965358
    GET_PLAYER_HAS_RESERVE_PARACHUTE = 6764374752099253411
    ENABLE_PROCOBJ_CREATION = 6767742304592156306
    UGC_REQUEST_CACHED_DESCRIPTION = 6773806535125711342
    SET_USE_ISLAND_MAP = 6779149314416003640
    GET_AMBIENT_VOICE_NAME_HASH = 6782488807935956022
    UGC_HAS_CREATE_FINISHED = 6783604227140921163
    CLEAR_RELATIONSHIP_BETWEEN_GROUPS = 6784994169655903956
    IS_FIRST_PERSON_AIM_CAM_ACTIVE = 6788171017574572351
    NETWORK_ENABLE_VOICE_BANDWIDTH_RESTRICTION = 6789920576433533166
    CREATE_CAMERA = 6790575688875026045
    SET_VEHICLE_NO_EXPLOSION_DAMAGE_FROM_DRIVER = 6797795254071336110
    RESET_DEEP_OCEAN_SCALER = 6800040885978927835
    CLEAR_PED_IN_PAUSE_MENU = 6801207697238564358
    DOES_LATEST_BRIEF_STRING_EXIST = 6801982385926626661
    DISABLE_PLAYER_FIRING = 6804024751275371192
    NETWORK_EARN_ARENA_WAR_ASSASSINATE_TARGET = 6808009606762822669
    IS_PLAYER_PLAYING = 6815464490581856410
    CASCADE_SHADOWS_SET_ENTITY_TRACKER_SCALE = 6817798212543404296
    NETWORK_HAVE_PLATFORM_SUBSCRIPTION = 6820566196397892871
    CONVERT_OLD_PICKUP_TYPE_TO_NEW = 6821502353065854325
    GET_PLAYER_HAS_DRIVEN_ALL_VEHICLES = 6822157347310818020
    GET_VEHICLE_LIVERY2_COUNT = 6830623794211832020
    NETWORK_SPEND_GANGOPS_TRIP_SKIP = 6831520657011674474
    NETWORK_GET_TIMEOUT_TIME = 6832019364320093007
    CAN_USE_MOBILE_PHONE_DURING_CUTSCENE = 6836166058594642748
    TASK_USE_MOBILE_PHONE_TIMED = 6836509677808544219
    SET_CAM_DOF_STRENGTH = 6837197941419931799
    CAN_CREATE_RANDOM_COPS = 6837250382999549709
    OVERRIDE_PLANE_DAMAGE_THREHSOLD = 6837980663949203093
    GET_PED_HEAD_BLEND_NUM_HEADS = 6841935488603102365
    GET_IS_LEFT_VEHICLE_HEADLIGHT_DAMAGED = 6843075163391201699
    SET_PROP_LIGHT_COLOR = 6846741595902240628
    SET_PARTICLE_FX_LOOPED_EVOLUTION = 6848931988011301858
    HAS_SCRIPT_WITH_NAME_HASH_LOADED = 6849707268841237508
    CASCADE_SHADOWS_SET_CASCADE_BOUNDS_SCALE = 6849763198520265199
    SET_TEXT_RENDER_ID = 6851435361686548753
    SET_PLAYER_SHORT_SWITCH_STYLE = 6854500591887249001
    SET_MISSION_NAME = 6856990973919262511
    GET_FINAL_RENDERED_REMOTE_PLAYER_CAM_FOV = 6860660581892864928
    SUPPRESS_AGITATION_EVENTS_NEXT_FRAME = 6862209615884637522
    IS_PLAYER_VEH_RADIO_ENABLE = 6864568025735202625
    NETWORK_SPENT_CHANGE_APPEARANCE = 6865007043768463020
    DISABLE_ALL_CONTROL_ACTIONS = 6866697718202259867
    ADD_PED_DECORATION_FROM_HASHES = 6871673233298597945
    REMOVE_NAMED_PTFX_ASSET = 6873033708056672621
    ADD_TEXT_COMPONENT_SUBSTRING_KEYBOARD_DISPLAY = 6874835027791089684
    DISABLE_DOWNWASH_PTFX = 6876420319975958689
    GET_ZONE_SCUMMINESS = 6880135243135321913
    OVERRIDE_POPSCHEDULE_VEHICLE_MODEL = 6880754124677085047
    NETWORK_HAVE_ROS_MULTIPLAYER_PRIV = 6886520397566223120
    GET_NUMBER_OF_EVENTS = 6886749890234687658
    IS_ENTITY_DEAD = 6887467227441538385
    GET_NUMBER_OF_PED_PROP_DRAWABLE_VARIATIONS = 6894895945445145415
    HIDE_MINIMAP_EXTERIOR_MAP_THIS_FRAME = 6898077731183497417
    SHOW_HEADING_INDICATOR_ON_BLIP = 6898569612438869215
    GET_MENU_PED_FLOAT_STAT = 6898793993723372927
    GET_IS_PLAYER_DRIVING_ON_HIGHWAY = 6900766719502757299
    NETWORK_TEXT_CHAT_IS_TYPING = 6903821898987114534
    SET_PED_AMMO_BY_TYPE = 6904548124944461182
    NETWORK_PAY_EMPLOYEE_WAGE = 6905686749662321033
    APP_CLEAR_BLOCK = 6909048714621058490
    PLAYSTATS_BW_HEAD_HUNTER = 6913803036466883089
    CLEAR_VEHICLE_CUSTOM_SECONDARY_COLOUR = 6916366759000678409
    SET_LOCAL_PLAYER_AS_GHOST = 6917136782320038191
    IS_PED_IN_ANY_PLANE = 6917332199840217984
    DISABLE_PED_HEATSCALE_OVERRIDE = 6917609043105950801
    PRELOAD_SCRIPT_PHONE_CONVERSATION = 6918862395442375402
    REQUEST_ADDITIONAL_TEXT_FOR_DLC = 6920337118842640550
    NETWORK_SESSION_SET_GAMEMODE = 6921905853196577646
    TASK_SKY_DIVE = 6924063218637123744
    GET_VEHICLE_LIVERY2 = 6924566214525471270
    ADD_NEXT_MESSAGE_TO_PREVIOUS_BRIEFS = 6929187101012700101
    ROLL_UP_WINDOW = 6930569850916064601
    IS_PED_BLUSH_TINT_FOR_BARBER = 6939625919433554521
    PLAYSTATS_CHEAT_APPLIED = 6942411377125371199
    HAS_ENTITY_BEEN_DAMAGED_BY_ANY_PED = 6944368192628204689
    NETWORK_HAVE_ROS_SOCIAL_CLUB_PRIV = 6948576204782629867
    IS_EXPLOSION_ACTIVE_IN_AREA = 6949072141113044724
    ALLOW_SONAR_BLIPS = 6949983046200820540
    APP_SET_INT = 6953151268396176913
    SET_ALL_LOW_PRIORITY_VEHICLE_GENERATORS_ACTIVE = 6954129466167359612
    SET_VEHICLE_EXTRA_COLOUR_6 = 6956317558672667244
    ADD_CAM_SPLINE_NODE_USING_GAMEPLAY_FRAME = 6958756472036117044
    GET_VEHICLE_PED_IS_USING = 6959377544440096893
    SET_VEHICLE_LIVERY = 6971396915951620534
    IS_PED_IN_COVER = 6980527097275419528
    SHOW_ACCOUNT_PICKER = 6982992551130946724
    NETWORK_CHECK_ROS_LINK_WENTDOWN_NOT_NET = 6984468664354086899
    PLAYSTATS_HIT_CONTRABAND_DESTROY_LIMIT = 6984762044908496966
    ASSISTED_MOVEMENT_IS_ROUTE_LOADED = 6987796862537430849
    START_SAVE_ARRAY_WITH_SIZE = 6989118770651443101
    CLEAR_DEFAULT_PRIMARY_TASK = 6989784323272688942
    NETWORK_EARN_FROM_BEND_JOB = 7003782308378816714
    SET_MP_GAMER_TAG_COLOUR = 7007273660281398958
    NET_GAMESERVER_TRANSACTION_IN_PROGRESS = 7007339730010189497
    SET_PED_SHOOT_RATE = 7011436265342456540
    SET_CHECKPOINT_DECAL_ROT_ALIGNED_TO_CAMERA_ROT = 7015826629489998630
    NETWORK_SPENT_UPGRADE_HANGAR = 7016244301234998703
    SET_PLAYER_PERMITTED_TO_COLLECT_PICKUPS_OF_TYPE = 7016770863061245401
    SET_CONVERSATION_AUDIO_PLACEHOLDER = 7017487132777061428
    DISABLE_INTERIOR = 7021274633124436204
    WAS_PED_KNOCKED_OUT = 7022940804768263457
    CLEAR_ALL_HELP_MESSAGES = 7023634693725934496
    NETWORK_GET_NUM_TRANSITION_NON_ASYNC_GAMERS = 7025415043014353237
    NETWORK_SPEND_ARENA_PREMIUM = 7031410773627754784
    IS_SNIPER_INVERTED = 7035250983925701156
    NETWORK_SPEND_SUV_FST_TRVL = 7035431192475023726
    ATTACH_CAM_TO_PED_BONE = 7035708528672633873
    UGC_CLEAR_OFFLINE_QUERY = 7037021563208593050
    REMOVE_FORCED_OBJECT = 7040946315261434735
    SET_SCRIPT_GFX_DRAW_ORDER = 7042254994863937538
    GET_PACKED_INT_STAT_KEY = 7052938158685658631
    IS_ANY_VEHICLE_NEAR_POINT = 7053161900751974118
    TASK_GO_STRAIGHT_TO_COORD_RELATIVE_TO_ENTITY = 7053587784249954606
    REMOVE_GRASS_CULL_SPHERE = 7059777638832842950
    WATER_OVERRIDE_SET_RIPPLEMINBUMPINESS = 7068031373390019764
    SET_ENTITY_COORDS_WITHOUT_PLANTS_RESET = 7068527076383885671
    IS_PED_PLAYING_BASE_CLIP_IN_SCENARIO = 7069646766978141761
    CAMERA_PREVENT_COLLISION_SETTINGS_FOR_TRIPLEHEAD_IN_INTERIORS_THIS_UPDATE = 7077205095449206642
    SET_OBJECT_GLOW_IN_SAME_TEAM = 7081147782924465093
    IS_SYNCHRONIZED_SCENE_LOOPED = 7084760360540148154
    IS_PED_RESPONDING_TO_EVENT = 7087389613169864808
    SET_NETWORK_VEHICLE_AS_GHOST = 7094511303302087710
    NETWORK_EARN_FIXER_PREP = 7098770180591083718
    STAT_DISABLE_STATS_TRACKING = 7103626505871408298
    SET_VEHICLE_AS_NO_LONGER_NEEDED = 7105548214330024505
    NETWORK_REQUEST_INVITE_CONFIRMED_EVENT = 7106725756288487091
    PLAY_VEHICLE_DOOR_CLOSE_SOUND = 7107901401240039220
    HIDE_PED_BLOOD_DAMAGE_BY_ZONE = 7109909689250248156
    FACEBOOK_HAS_POST_COMPLETED = 7113997228353458415
    IS_ANY_ENTITY_ATTACHED_TO_HANDLER_FRAME = 7118528237038425681
    TASK_RELOAD_WEAPON = 7120913868208590125
    SET_MINIMAP_FOW_DO_NOT_UPDATE = 7127027464586979184
    CREATE_SYNCHRONIZED_SCENE_AT_MAP_OBJECT = 7128115453168745930
    DISABLE_CINEMATIC_VEHICLE_IDLE_MODE_THIS_UPDATE = 7128350477778453974
    SET_TEXT_WRAP = 7139434236170869360
    NETWORK_IS_PLAYER_FADING = 7142082149753098467
    NETWORK_EARN_ARENA_WAR = 7142459114847809706
    TAN = 7142997959761211025
    GET_VEHICLE_MOD_KIT = 7144346870170407181
    PAUSE_PLAYBACK_RECORDED_VEHICLE = 7145638777801867697
    GET_MOUSE_EVENT = 7145850591938301609
    GET_NAVMESH_ROUTE_RESULT = 7146793828793061288
    IS_THIS_MODEL_AN_AMPHIBIOUS_CAR = 7151557073908001718
    IS_HELI_LANDING_AREA_BLOCKED = 7152077347623556470
    STOP_BINK_MOVIE = 7160840376094853514
    SET_PED_CAN_PLAY_AMBIENT_ANIMS = 7166301455914477326
    CLEAR_COVER_POINT_FOR_PED = 7167517135969643512
    NETWORK_GET_INSTANCE_ID_OF_THIS_SCRIPT = 7172609684198688475
    SET_PED_CAN_BE_TARGETED_WHEN_INJURED = 7173112365129895767
    IS_ENTRY_POINT_FOR_SEAT_CLEAR = 7175414981322189399
    SET_TASK_VEHICLE_CHASE_IDEAL_PURSUIT_DISTANCE = 7177440587069411037
    UGC_HAS_QUERY_CREATORS_FINISHED = 7184374828337199765
    SET_MP_GAMER_TAG_VISIBILITY = 7186467011688527520
    CREATE_MISSION_TRAIN = 7189658880938010824
    RESET_GROUP_FORMATION_DEFAULT_SPACING = 7195262145949807109
    IPL_GROUP_SWAP_CANCEL = 7199896357528767660
    SET_PROJECTILES_SHOULD_EXPLODE_ON_CONTACT = 7200399841819681635
    SET_PED_CAN_BE_TARGETTED = 7202820943940500141
    NETWORK_IS_PLAYER_IN_MP_CUTSCENE = 7204050901172361714
    ALLOW_PORTABLE_PICKUP_TO_MIGRATE_TO_NON_PARTICIPANTS = 7214528195098505464
    SET_RAIN = 7223253640658701714
    SHUTDOWN_PC_SCRIPTED_CONTROLS = 7223446342698516157
    SAVE_REPLAY_RECORDING = 7225259157996652315
    TRACK_VEHICLE_VISIBILITY = 7225808929017855434
    GET_NTH_CLOSEST_VEHICLE_NODE_ID_WITH_HEADING = 7226031162423669255
    CAN_SET_ENTER_STATE_FOR_REGISTERED_ENTITY = 7231948969982433205
    GET_IS_DOOR_VALID = 7232582464623474226
    PRESENCE_EVENT_UPDATESTAT_INT_WITH_STRING = 7242846310179740751
    UGC_UPDATE_CONTENT = 7245863352565463401
    IS_CONTROL_RELEASED = 7245979435848464349
    USE_VEHICLE_CAM_STUNT_SETTINGS_THIS_UPDATE = 7247364277489308010
    PROCGRASS_DISABLE_CULLSPHERE = 7249836441833976858
    NETWORK_GET_LAST_ENTITY_POS_RECEIVED_OVER_NETWORK = 7266410001097521945
    NETWORK_IS_PRIVILEGE_CHECK_IN_PROGRESS = 7270433556101626739
    NETWORK_FINISH_BROADCASTING_DATA = 7275049505724966413
    SET_VEHICLE_FORWARD_SPEED_XY = 7278118936683477509
    GET_GAMEPLAY_CAM_FOV = 7278264845348258099
    NETWORK_GET_TRANSITION_HOST = 7278990827236639582
    NETWORK_BUY_PROPERTY = 7280641241631886070
    NETWORK_IS_TRANSITION_CLOSED_FRIENDS = 7283013694515547216
    LINK_STATIC_EMITTER_TO_ENTITY = 7286034922052847791
    DECOR_GET_FLOAT = 7288129253306036035
    GET_SHAPE_TEST_RESULT_INCLUDING_MATERIAL = 7289204802319414974
    VMAG = 7290534975576991276
    RELEASE_AMBIENT_AUDIO_BANK = 7297900821373167933
    NETWORK_SPEND_NIGHTCLUB_AND_WAREHOUSE = 7298131561933949089
    DOOR_SYSTEM_GET_OPEN_RATIO = 7298532234928514540
    HAS_PED_HEAD_BLEND_FINISHED = 7299438516656017713
    STAT_GET_MASKED_INT = 7300763395024677547
    PLAYSTATS_FM_EVENT_COMPETITIVEURBANWARFARE = 7300812149499971306
    GET_WEAPON_COMPONENT_VARIANT_EXTRA_COUNT = 7302776444755636056
    NETWORK_PLAYER_IS_CHEATER = 7303591686215209104
    GET_PED_DIES_IN_WATER = 7306837850125863216
    PLAYSTATS_CASINO_ROULETTE_LIGHT = 7310093865469450236
    SET_GHOST_ALPHA = 7315253918893750910
    CLEAR_PED_ENV_DIRT = 7315492131622376101
    TASK_VEHICLE_MISSION = 7319519141423398110
    WAYPOINT_PLAYBACK_USE_DEFAULT_SPEED = 7321120390089869312
    NETWORK_SKIP_RADIO_WARNING = 7321994204644969551
    DISABLE_TIDYING_UP_IN_GARAGE = 7322744631897637880
    SET_SLOW_DOWN_EFFECT_DISABLED = 7327497697880211785
    SET_SCRIPT_HIGH_PRIO = 7337185903382424609
    REQUEST_SCALEFORM_MOVIE_WITH_IGNORE_SUPER_WIDESCREEN = 7343092289874906331
    IS_PED_CURRENT_WEAPON_SILENCED = 7345588343449861831
    IS_PLAYER_BLUETOOTH_ENABLE = 7348447710819006384
    SET_CAM_CONTROLS_MINI_MAP_HEADING = 7357576148255889445
    GET_COMMERCE_ITEM_ID = 7360629487829500945
    GET_BOAT_BOOM_POSITION_RATIO = 7365291076175537957
    NETWORK_EARN_AGENCY_SAFE = 7366564753469352466
    SET_AI_MELEE_WEAPON_DAMAGE_MODIFIER = 7369593155508859476
    SET_PED_CAN_TORSO_VEHICLE_IK = 7370076979686089878
    HAS_PED_PRELOAD_VARIATION_DATA_FINISHED = 7379159613508109279
    TASK_AIM_GUN_AT_COORD = 7381949471095111073
    SET_PLAYBACK_SPEED = 7386936414660884344
    CLONE_PED_ALT = 7390358660664647240
    RECORD_GREATEST_MOMENT = 7392416448564788858
    SET_CARGOBOB_PICKUP_MAGNET_REDUCED_STRENGTH = 7392547528560016687
    CLOSE_SAFEHOUSE_GARAGES = 7396209120374750856
    SET_PED_CAN_BE_TARGETTED_BY_PLAYER = 7400957295976475254
    NETWORK_HAVE_SCS_PRIVATE_MSG_PRIV = 7400994185299650479
    TRIGGER_SIREN_AUDIO = 7405038211763814842
    PLAYSTATS_DRONE_USAGE = 7406093875911933902
    ARE_CUTSCENE_ENTITIES_NETWORKED = 7410292660336927050
    SET_TEXT_FONT = 7412968334783068634
    SET_OVERRIDE_VEHICLE_DOOR_TORQUE = 7413957405759577784
    IS_MISSION_NEWS_STORY_UNLOCKED = 7414222364659619956
    CODE_WANTS_SCRIPT_TO_TAKE_CONTROL = 7415118940931325216
    NETWORK_SET_INVITE_ON_CALL_FOR_INVITE_MENU = 7417446885795930929
    IS_INTERIOR_READY = 7432836922140208910
    PLAYSTATS_SPIN_WHEEL = 7435969121026308816
    CREATE_AMBIENT_PICKUP = 7438089100197720433
    IS_ANY_ENTITY_ENTIRELY_INSIDE_GARAGE = 7439621222773760951
    UNCUFF_PED = 7440068821593357391
    SC_TRANSITION_NEWS_END = 7446457660184252769
    NETWORK_SPENT_UPGRADE_BUSINESS_PROPERTY = 7448137697043721736
    NETWORK_EARN_SPIN_THE_WHEEL_CASH = 7452411161152895834
    IS_PED_ON_VEHICLE = 7454067524096647083
    GET_VEHICLE_TYRES_CAN_BURST = 7461228425533296619
    UGC_GET_GET_BY_CATEGORY = 7461250979854013726
    PLAYSTATS_BW_ASSAULT = 7462331374075382747
    NETWORK_SESSION_VOICE_LEAVE = 7463559884578707293
    IS_VEHICLE_STUCK_TIMER_UP = 7465809137861765236
    NETWORK_HAS_SOCIAL_CLUB_ACCOUNT = 7468472959017996278
    ENABLE_SCRIPT_BRAIN_SET = 7469868092304107627
    SET_VEHICLE_IS_STOLEN = 7472254198818494264
    PLAY_SOUND_FRONTEND = 7477453855356397301
    CLEAR_GPS_MULTI_ROUTE = 7489168016550854036
    GET_PED_DRAWABLE_VARIATION = 7490462606036423932
    ADD_POP_MULTIPLIER_AREA = 7491246761267224973
    GET_IS_LIVE_AREA_LAUNCH_WITH_CONTENT = 7492874584527107557
    NETWORK_IS_IN_TRANSITION = 7495286035303993098
    SET_BINK_SHOULD_SKIP = 7495631954956680050
    HIDE_HUD_COMPONENT_THIS_FRAME = 7495895348773880760
    UGC_RELEASE_ALL_CACHED_DESCRIPTIONS = 7498561696521810498
    NETWORK_EARN_FROM_JOB_BONUS = 7500458499285321589
    SET_VEHICLE_HANDBRAKE = 7514121110102895138
    PLM_IS_IN_CONSTRAINED_MODE = 7514891046611284578
    GET_TOTAL_SUCCESSFUL_STUNT_JUMPS = 7518456375581089444
    SET_CARGOBOB_PICKUP_MAGNET_PULL_ROPE_LENGTH = 7520260829624469643
    FIND_SPAWN_POINT_IN_DIRECTION = 7526889474430343538
    IS_ANY_HOSTILE_PED_NEAR_POINT = 7527535547692248991
    CLEAR_PED_STORED_HAT_PROP = 7528905155161871080
    DATAARRAY_ADD_DICT = 7532632714145023895
    NETWORK_SET_CAN_RECEIVE_RS_INVITES = 7536778462104616861
    POINT_CAM_AT_PED_BONE = 7544292382081432641
    SET_ENTITY_CANT_CAUSE_COLLISION_DAMAGED_ENTITY = 7545045469853649647
    GET_PED_HEAD_BLEND_FIRST_INDEX = 7553472996228824588
    IS_AIM_CAM_ACTIVE = 7560939217536642311
    STAT_SET_PROFILE_SETTING_VALUE = 7561565913806111631
    GIVE_LOADOUT_TO_PED = 7564004940768475302
    IS_REMOTE_PLAYER_IN_NON_CLONED_VEHICLE = 7568969492851950582
    SAVEMIGRATION_MP_GET_STATUS = 7569274153508003944
    TASK_WANDER_SPECIFIC = 7573263405281337496
    IS_AUTO_SAVE_IN_PROGRESS = 7576188390707304864
    UGC_QUERY_BY_CATEGORY = 7578811463815757452
    UGC_SET_PLAYER_DATA = 7578855087601623363
    USE_ACTIVE_CAMERA_FOR_TIMESLICING_CENTRE = 7580816756080318695
    SET_MOBILE_PHONE_POSITION = 7582474547584305243
    SET_ENTITY_REQUIRES_MORE_EXPENSIVE_RIVER_CHECK = 7588002504561402861
    APPLY_DAMAGE_TO_PED = 7597950592220076244
    CAN_REGISTER_MISSION_ENTITIES = 7599699531063287405
    NETWORK_ACCESS_TUNABLE_BOOL_MODIFICATION_DETECTION_REGISTRATION_HASH = 7601883242706721602
    SC_COMMUNITY_EVENT_GET_EXTRA_DATA_STRING_BY_ID = 7610602181657967128
    PLAYSTATS_CARCLUB_PRIZE = 7622662011383583784
    SC_INBOX_MESSAGE_GET_UGCDATA = 7626887770285646420
    PLAYSTATS_ODDJOB_DONE = 7628715043616619340
    NETWORK_SPENT_PURCHASE_OFFICE_PROPERTY = 7633450920405505217
    TASK_LOOK_AT_ENTITY = 7634936779166218604
    TASK_VEHICLE_PLAY_ANIM = 7635223960048549257
    ADD_REPLAY_STAT_VALUE = 7637662725905229289
    STAT_SET_LICENSE_PLATE = 7637844548809561818
    IS_PED_IN_HIGH_COVER = 7639160036357733523
    TASK_GO_TO_ENTITY = 7640095384362883202
    SPECIAL_ABILITY_LOCK = 7640867858484067603
    FREE_MEMORY_FOR_LOW_QUALITY_PHOTO = 7643409598396980682
    OVERRIDE_MP_TEXT_CHAT_TEAM_STRING = 7644641239073022681
    SHAKE_CAM = 7648559245709621282
    GET_PLAYER_PED_IS_FOLLOWING = 7654278640865090071
    NETWORK_SPENT_FROM_ROCKSTAR = 7657345755475787445
    SET_FORCE_MOTIONBLUR = 7661176602240703057
    NETWORK_SET_IGNORE_SPECTATOR_CHAT_LIMITS_SAME_TEAM = 7664433699355246808
    PLAYSTATS_FM_EVENT_CHALLENGES = 7665377501801251369
    STAT_GET_BLOCK_SAVES = 7673880282228494358
    GET_VEHICLE_COLOUR_COMBINATION = 7675309252482981206
    SET_VEHICLE_IMPATIENCE_TIMER = 7680666417712678480
    ATTACH_CONTAINER_TO_HANDLER_FRAME_WHEN_LINED_UP = 7681103487467234772
    CREATE_CAMERA_WITH_PARAMS = 7692046877019140653
    IS_ENTITY_A_VEHICLE = 7694118761768769374
    SET_SYNCHRONIZED_SCENE_ORIGIN = 7696488426199063767
    DATAFILE_DELETE_FOR_ADDITIONAL_DATA_FILE = 7696859974742861515
    HAS_VEHICLE_PHONE_EXPLOSIVE_DEVICE = 7699655435779592757
    SET_VEHICLE_MOD = 7705768285972510429
    SC_INBOX_SEND_BOUNTY_TO_RECIP_LIST = 7709367440466964355
    TOGGLE_STEALTH_RADAR = 7709594747874660551
    NETWORK_ALLOW_INVITE_PROCESS_IN_PLAYER_SWITCH = 7712337182605247349
    SET_AMBIENT_PEDS_DROP_MONEY = 7714210357369428226
    START_SCRIPT_CONVERSATION = 7716854381323604700
    FLASH_MINIMAP_DISPLAY_WITH_COLOR = 7718574371061525017
    DECOR_SET_BOOL = 7718763143089052529
    IS_CAM_SHAKING = 7720506665349145723
    NETWORK_SPENT_CINEMA = 7726185402928965253
    SET_TEXT_RIGHT_JUSTIFY = 7727128373235543623
    HAVE_VEHICLE_REAR_DOORS_BEEN_BLOWN_OPEN_BY_STICKYBOMB = 7728316758094329412
    SET_MINIMAP_SONAR_SWEEP = 7732958218177162945
    NETWORK_IS_TRANSITION_HOST_FROM_HANDLE = 7736203095859685904
    DRAW_LINE = 7742345298724472448
    SET_PED_DROPS_WEAPON = 7743116959586172608
    SET_ENTITY_HEALTH = 7743618636000454307
    SET_PED_CAN_EVASIVE_DIVE = 7744612924842995801
    NETWORK_EARN_FROM_SMUGGLER_WORK = 7745716048155852133
    START_SCRIPT_FIRE = 7747142977873524872
    ATTACH_ENTITY_TO_ENTITY = 7753999234533660383
    SET_PED_MAX_TIME_UNDERWATER = 7756369285497873698
    DOOR_SYSTEM_SET_DOOR_STATE = 7758457796463198035
    GET_BOSS_GOON_UUID = 7764395768671817406
    SET_PLAYER_INVINCIBLE_BUT_HAS_REACTIONS = 7766879010926346315
    END_BEING_GOON = 7767857873581964677
    EXECUTE_CONTENT_CHANGESET_GROUP_FOR_ALL = 7777142021290122247
    SC_TRANSITION_NEWS_SHOW = 7780833457546870228
    NETWORK_SHOW_CHAT_RESTRICTION_MSC = 7782043701931276298
    NETWORK_GET_PLAYER_INDEX_FROM_PED = 7786211388227125880
    ADD_TEXT_COMPONENT_SUBSTRING_PLAYER_NAME = 7789129354908300458
    NETWORK_GET_RESPAWN_RESULT_FLAGS = 7797121976967439357
    USE_PARTICLE_FX_ASSET = 7798175403732277905
    SET_PED_CAN_ARM_IK = 7798912310599534657
    GET_PED_LAST_WEAPON_IMPACT_COORD = 7803898169126431682
    STOP_PED_RINGTONE = 7807801664119263378
    SET_PED_ALTERNATE_WALK_ANIM = 7809304755476848282
    SET_GLOBAL_MIN_BIRD_FLIGHT_HEIGHT = 7812360542331942135
    SET_AMBIENT_VOICE_NAME = 7818360706947881051
    NETWORK_SPEND_SUBMARINE = 7821557695074773675
    GET_FORCED_COMPONENT = 7823858164020053403
    NETWORK_IS_IN_MP_CUTSCENE = 7836963326637900320
    DATAFILE_CLEAR_WATCH_LIST = 7838636614011932953
    NETWORK_SPEND_UPGRADE_AGENCY = 7839188619583136694
    CAN_PED_SEE_HATED_PED = 7842354866013687035
    HAVE_CONTROLS_CHANGED = 7842900453202695622
    SET_USE_SET_DESTINATION_IN_PAUSE_MAP = 7844522970654662787
    ENABLE_ENTITY_BULLET_COLLISION = 7845683761433816714
    ROPE_UNLOAD_TEXTURES = 7846233953947910499
    NETWORK_CLEAR_QUEUED_JOIN_REQUEST = 7846693627984362764
    GET_SHOP_PED_QUERY_PROP_INDEX = 7848613078669061783
    GET_DLC_WEAPON_COMPONENT_DATA = 7851349349450394616
    NETWORK_GET_GLOBAL_MULTIPLAYER_CLOCK = 7855332995215600130
    SET_GAMEPLAY_CAM_RELATIVE_PITCH = 7856627101237848957
    GET_PLAYER_NAME = 7858190532816302584
    DONT_TILT_MINIMAP_THIS_FRAME = 7860118202149457749
    NETWORK_CLEAR_FOUND_GAMERS = 7860132572699834394
    IS_GAME_IN_CONTROL_OF_MUSIC = 7865778738160678141
    DISABLE_FRONTEND_THIS_FRAME = 7869026217671979238
    DETACH_SYNCHRONIZED_SCENE = 7870306363211724778
    NETWORK_SPENT_BUY_PASSIVE_MODE = 7870677022341632377
    UGC_QUERY_MOST_RECENTLY_CREATED_CONTENT = 7875868318715360744
    POP_OUT_VEHICLE_WINDSCREEN = 7882527888856013523
    REACTIVATE_NAMED_WORLD_BRAINS_WAITING_TILL_OUT_OF_RANGE = 7883622405120481329
    CLEAR_VEHICLE_ROUTE_HISTORY = 7884388295745415342
    GET_SHOP_PED_QUERY_OUTFIT = 7888405507221880406
    SET_CARGOBOB_PICKUP_MAGNET_REDUCED_FALLOFF = 7894436344240443899
    SET_SCALEFORM_MOVIE_TO_USE_SYSTEM_TIME = 7894442985399373320
    GRASSBATCH_ENABLE_FLATTENING_IN_SPHERE = 7896322433186174385
    IS_PED_MALE = 7899137457135336006
    SET_RUN_SPRINT_MULTIPLIER_FOR_PLAYER = 7905078105765137929
    CREATE_MP_GAMER_TAG_WITH_CREW_COLOR = 7912928575906358473
    GET_SCRIPT_GFX_ALIGN_POSITION = 7915346457264043186
    SKIP_RADIO_FORWARD = 7916129512124750885
    CASCADE_SHADOWS_SET_AIRCRAFT_MODE = 7916195510439559296
    PLAYSTATS_CREATE_MATCH_HISTORY_ID_2 = 7921400392267733969
    SET_VEHICLE_REDUCE_GRIP_LEVEL = 7921431857838230779
    TASK_WARP_PED_DIRECTLY_INTO_COVER = 7926874005424800374
    GET_IS_AUTO_SAVE_OFF = 7927725541682606151
    SET_HELI_CONTROL_LAGGING_RATE_SCALAR = 7928685778725725644
    DOES_CARGOBOB_HAVE_PICKUP_MAGNET = 7928797542473710281
    STAT_GET_CHALLENGE_FLYING_DIST = 7929240611303736708
    SET_STREAMING = 7929828657818798216
    IS_MP_GAMER_TAG_MOVIE_ACTIVE = 7930473816949053354
    GET_VARIANT_COMPONENT = 7931387062980731830
    SET_VEHICLE_TYRE_FIXED = 7931960884476783901
    GET_SAFE_PICKUP_COORDS = 7932734660826570736
    NETWORK_SPENT_BUY_REVEAL_PLAYERS = 7932931430806193719
    IS_DAMAGE_TRACKER_ACTIVE_ON_NETWORK_ID = 7933423018074923878
    GET_MINIMAP_FOW_COORDINATE_IS_REVEALED = 7940331101862967586
    GET_TYRE_WEAR_RATE = 7942230526716235633
    IS_PLAYER_VEHICLE_WEAPON_TOGGLED_TO_NON_HOMING = 7945301916505659338
    IS_PED_IN_ANY_TAXI = 7950926379301386322
    SET_PLAYBACK_TO_USE_AI_TRY_TO_REVERT_BACK_LATER = 7954348751808169776
    SET_PLAYER_CAN_DO_DRIVE_BY = 7964673893782916215
    REACTIVATE_NAMED_OBJECT_BRAINS_WAITING_TILL_OUT_OF_RANGE = 7967343064991084592
    GET_PLAYER_PARACHUTE_PACK_TINT_INDEX = 7970373186624480674
    NETWORK_IS_ADDING_FRIEND = 7971654329120476545
    NETWORK_EARN_FROM_DAILY_OBJECTIVES = 7972243017414903686
    REQUEST_ANIM_SET = 7972635428772450029
    GET_VEHICLE_HOMING_LOCKEDONTO_STATE = 7974449729982181663
    REQUEST_SCRIPT = 7977554008792313486
    SET_VEHICLE_STOP_INSTANTLY_WHEN_PLAYER_INACTIVE = 7980292972752141336
    IS_SCRIPTED_SCENARIO_PED_USING_CONDITIONAL_ANIM = 7981638804591337965
    REMOVE_WARNING_MESSAGE_OPTION_ITEMS = 7995378863873745474
    SET_CAM_MOTION_BLUR_STRENGTH = 8002746985627579110
    THEFEED_ONLY_SHOW_TOOLTIPS = 8004397031036586490
    SET_THIS_IS_A_TRIGGER_SCRIPT = 8007740668553601217
    IS_MISSION_COMPLETE_READY_FOR_UI = 8008982896674322616
    FORCE_CLOUD_MP_STATS_DOWNLOAD_AND_OVERWRITE_LOCAL_SAVE = 8013622860191339171
    NETWORK_SESSION_HOST = 8015649608906892829
    GET_COMMERCE_ITEM_CAT = 8017757491590462144
    GET_SEAT_PED_IS_TRYING_TO_ENTER = 8019932013815512274
    PLAYSTATS_ARENA_WARS_SPECTATOR = 8020727967853846538
    START_NETWORKED_PARTICLE_FX_LOOPED_ON_ENTITY = 8025670286167043613
    NETWORK_OVERRIDE_TEAM_RESTRICTIONS = 8028082392733869902
    HIDE_PED_WEAPON_FOR_SCRIPTED_CUTSCENE = 8028090550332432527
    SET_BLIP_AS_FRIENDLY = 8029681744942738100
    IS_ONLINE_POLICIES_MENU_ACTIVE = 8030707125249750668
    REGISTER_TEXT_LABEL_15_TO_SAVE = 8032052229897397557
    NETWORK_IS_HANDLE_VALID = 8032655073623294259
    ADD_DOOR_TO_SYSTEM = 8036736002072363558
    IS_PED_IN_ANY_TRAIN = 8040944152950218448
    TASK_LOOK_AT_COORD = 8044667063384373619
    NETWORK_IS_TITLE_UPDATE_REQUIRED = 8050108699681914786
    WAS_VC_WITHDRAWAL_SUCCESSFUL = 8056814245717132379
    KNOCK_OFF_PED_PROP = 8059052351381659464
    NETWORK_SPENT_PURCHASE_BUSINESS_PROPERTY = 8059597639487624986
    NETWORK_GET_NET_STATISTICS_INFO = 8059634381381286278
    SET_PLAYER_VEHICLE_ALARM_AUDIO_ACTIVE = 8060789696654383242
    HAS_GAME_INSTALLED_THIS_SESSION = 8060867548616808172
    SET_DISPATCH_IDEAL_SPAWN_DISTANCE = 8063133996428612643
    NETWORK_IS_PARTICIPANT_ACTIVE = 8068479385834192197
    SET_ANIM_LOOPED = 8071361188838645748
    SC_LICENSEPLATE_GET_COUNT = 8071974299159078780
    NETWORK_GET_STRING_BANK_WALLET_BALANCE = 8073536976916440797
    WAYPOINT_PLAYBACK_GET_IS_PAUSED = 8075927920486318539
    SET_WARNING_MESSAGE_WITH_HEADER_AND_SUBSTRING_FLAGS = 8077515204439881131
    CLOSE_ALL_BARRIERS_FOR_RACE = 8079416081091357604
    SET_ENTITY_ONLY_DAMAGED_BY_RELATIONSHIP_GROUP = 8080229049909162114
    NETWORK_SESSION_SET_CREW_LIMIT_MAX_MEMBERS_TRANSITION = 8082770379737802041
    GET_VEHICLE_NODE_POSITION = 8084282276450675138
    SEND_METRIC_GHOSTING_TO_PLAYER = 8085068529057400974
    ACTIVITY_FEED_ACTION_START_WITH_COMMAND_LINE_ADD = 8087558890440043351
    UGC_GET_CONTENT_USER_NAME = 8088203532048174069
    SET_WEATHER_TYPE_PERSIST = 8091143200275372431
    NETWORK_SPEND_ARENA_SPECTATOR_BOX = 8091208785747631119
    IS_INTERPOLATING_TO_SCRIPT_CAMS = 8095826636772152125
    IS_NAVMESH_REQUIRED_REGION_IN_USE = 8095928690609987008
    SET_RESTART_COORD_OVERRIDE = 8100672656602277475
    TRIGGER_MUSIC_EVENT = 8101227722246563600
    SET_PED_VISUAL_FIELD_MAX_ANGLE = 8104574823225119956
    IS_PEDHEADSHOT_READY = 8107924672780253799
    SET_FIRST_PERSON_AIM_CAM_ZOOM_FACTOR = 8109095963221318602
    HAS_CUTSCENE_CUT_THIS_FRAME = 8109819150992781379
    SET_HOVER_MODE_WING_RATIO = 8116140695162323819
    SET_PED_FLEE_ATTRIBUTES = 8116279360099375049
    SET_SCRIPT_FIRE_POSITION = 8116474636952575443
    SEETHROUGH_RESET = 8117258950743642668
    SCRIPT_OVERRIDES_WIND_ELEVATION = 8122502030125737524
    PLAY_BINK_MOVIE = 8129785171846797116
    NETWORK_SET_OVERRIDE_SPECTATOR_MODE = 8131878017179660816
    SET_VEHICLE_PETROL_TANK_HEALTH = 8132189641834549464
    UGC_GET_CONTENT_HAS_PLAYER_RECORD = 8136471418624866750
    PLAYSTATS_AWARD_NAV = 8139451973173308334
    IS_GAMEPLAY_CAM_LOOKING_BEHIND = 8141848874360864425
    ACTIVATE_PHYSICS = 8143371989984347952
    SC_COMMUNITY_EVENT_GET_EXTRA_DATA_INT = 8145830472587337425
    GET_NEXT_WEATHER_TYPE_HASH_NAME = 8147899912429302114
    SET_DISABLE_HIGH_FALL_DEATH = 8149145075847096619
    DRAW_BINK_MOVIE = 8149518882665624120
    NETWORK_IS_ENTITY_CONCEALED = 8156070357510980906
    SET_VEHICLE_CUSTOM_PRIMARY_COLOUR = 8160934221331913706
    REMOVE_SCRIPT_FIRE_POSITION = 8163021664210251993
    REMOVE_ALL_STICKY_BOMBS_FROM_ENTITY = 8165366924577523981
    SET_CHECKPOINT_RGBA = 8171560653204965367
    FILLOUT_PM_PLAYER_LIST_WITH_NAMES = 8172746593645650182
    HAS_VEHICLE_GOT_PROJECTILE_ATTACHED = 8177556713575955336
    SET_GAME_PAUSES_FOR_STREAMING = 8177647310938554076
    GET_TASK_MOVE_NETWORK_STATE = 8178058769432328045
    PLAYSTATS_RANDOM_MISSION_DONE = 8180273178956739297
    NETWORK_EARN_FROM_CASHING_OUT = 8182965715139361334
    GET_NEAREST_PLAYER_TO_ENTITY = 8184874700316724659
    HIDE_HUD_AND_RADAR_THIS_FRAME = 8187532053442985248
    SET_PED_MICRO_MORPH = 8189164646475760798
    REQUEST_ADDITIONAL_TEXT = 8189655201140380708
    GET_DOES_VEHICLE_HAVE_TOMBSTONE = 8191962341675186727
    LEADERBOARDS2_READ_GET_ROW_DATA_END = 8192056541605958358
    SET_VEHICLE_EXPLODES_ON_HIGH_EXPLOSION_DAMAGE = 8192198556078167562
    IS_CUTSCENE_PLAYBACK_FLAG_SET = 8194102893592393936
    RESURRECT_PED = 8195582117541601333
    SET_MINIMAP_GOLF_COURSE = 8195907273130302041
    NETWORK_EARN_BIKER = 8196202981249966341
    NETWORK_IS_GAMER_TALKING = 8197460765577107594
    SQRT = 8203653444578285572
    NETWORK_HAS_MADE_INVITE_DECISION = 8204508897043661489
    IS_SAFE_TO_START_PLAYER_SWITCH = 8207725548282354349
    GET_PED_DECORATIONS_STATE = 8208571530157315233
    APP_HAS_LINKED_SOCIAL_CLUB_ACCOUNT = 8209752708115631520
    NETWORK_DO_TRANSITION_QUICKMATCH = 8213174549623168342
    NETWORK_SET_CURRENTLY_SELECTED_GAMER_HANDLE_FROM_INVITE_MENU = 8216525552331502011
    GET_COMMERCE_ITEM_TEXTURENAME = 8227897473664573096
    UPDATE_PED_HEAD_BLEND_DATA = 8229546523778907226
    DOES_ENTITY_EXIST = 8230805619690780346
    SET_JOB_ACTIVITY_ID_STARTED = 8231485972689181543
    SET_IS_EXTERIOR_ONLY = 8233086683652873065
    NETWORK_IS_NETWORK_ID_REMOTELY_CONTROLLED = 8233416534753415302
    NETWORK_RESET_BODY_TRACKER = 8233484577556323684
    CLEAR_FACIAL_IDLE_ANIM_OVERRIDE = 8242245702733469743
    SET_PARTICLE_FX_LOOPED_ALPHA = 8243915066403984430
    NETWORK_REMOVE_ALL_TRANSITION_INVITE = 8245531772157322088
    SET_IGNORE_NO_GPS_FLAG = 8247517357546113075
    CAN_REGISTER_MISSION_VEHICLES = 8248327268003606132
    NETWORK_HAS_INVITED_GAMER_TO_TRANSITION = 8251901266330969807
    TASK_THROW_PROJECTILE = 8252165847224375889
    NETWORK_GET_PRESENCE_INVITE_PLAYLIST_CURRENT = 8254056637095792898
    IS_ANY_SPEECH_PLAYING = 8255223690533510857
    RESET_GAMEPLAY_CAM_FULL_ATTACH_PARENT_TRANSFORM_TIMER = 8256718813708787198
    GET_BLIP_HUD_COLOUR = 8258298928391301870
    NETWORK_CLAN_CREWINFO_GET_STRING_VALUE = 8259095949574604422
    SET_CARGOBOB_EXTA_PICKUP_RANGE = 8268271317332611630
    HUD_SET_WEAPON_WHEEL_TOP_SLOT = 8268896358275725272
    TASK_REACT_AND_FLEE_PED = 8271025944283959729
    RELEASE_ALL_COMMERCE_ITEM_IMAGES = 8273236128242129752
    NETWORK_HAVE_USER_CONTENT_PRIVILEGES = 8275673044451249236
    TRIGGER_SONAR_BLIP = 8276845560340660462
    QUEUE_MISSION_REPEAT_LOAD = 8277143426242780341
    NETWORK_EARN_CASINO_HEIST = 8279806038960481219
    NET_GAMESERVER_START_SESSION_PENDING = 8280848308694152875
    PLAYSTATS_BC_POINT_TO_POINT = 8286656527214917624
    NETWORK_CAN_SPEND_MONEY2 = 8287716764823003264
    ROPE_GET_DISTANCE_BETWEEN_ENDS = 8287753169396147366
    SET_ENTITY_RENDER_SCORCHED = 8290950499265355856
    DISPLAY_SNIPER_SCOPE_THIS_FRAME = 8291498716230143586
    SET_USE_HI_DOF_ON_SYNCED_SCENE_THIS_UPDATE = 8294091220252767815
    IS_AN_ENTITY = 8295288192219550113
    SET_VARIABLE_ON_UNDER_WATER_STREAM = 8303194209078339010
    DISABLE_PED_INJURED_ON_GROUND_BEHAVIOUR = 8303661161025552034
    SET_SYNCHRONIZED_SCENE_PHASE = 8305362243532093136
    REQUEST_MISSION_AUDIO_BANK = 8306253829043839218
    SET_OBJECT_IS_A_PRESSURE_PLATE = 8308603740709444250
    HAVE_ALL_STREAMING_REQUESTS_COMPLETED = 8309284474277936130
    SET_PED_CAN_LEG_IK = 8309579803502395691
    SET_BIKE_EASY_TO_LAND = 8310862340885062050
    NETWORK_UNREGISTER_NETWORKED_ENTITY = 8316150165401516246
    DELETE_ALL_TRAINS = 8316584479950085245
    DRAW_TEXTURED_POLY_WITH_THREE_COLOURS = 8317438921807005035
    SET_VEHICLE_TANK_STATIONARY = 8322152388585918463
    NETWORK_EARN_AWARD_PHONE = 8329303147462728675
    NETWORK_GET_TRANSITION_MEMBERS = 8336163975343724585
    DRAW_DEBUG_CROSS = 8336471418351163449
    ABSF = 8346714922768581461
    NETWORK_GET_ACTIVITY_PLAYER_NUM = 8350435671794361762
    SET_GRAVITY_LEVEL = 8362644625630176081
    NETWORK_REQUEST_TO_BE_HOST_OF_THIS_SCRIPT = 8366066892794862209
    CREATE_CINEMATIC_SHOT = 8366282011938524977
    NETWORK_ADD_PED_TO_SYNCHRONISED_SCENE = 8370612209197051097
    NETWORK_GET_PRESENCE_INVITE_INDEX_BY_ID = 8370882150867877593
    PULSE_BLIP = 8371470239498874739
    GET_GAMEPLAY_CAM_RELATIVE_HEADING = 8373888685549897095
    SHOW_TICK_ON_BLIP = 8381549255156111390
    IS_PLAYER_LOGGING_IN_NP = 8382727314144132810
    SET_FRONTEND_ACTIVE = 8383188641852199543
    NETWORK_IS_OFFLINE_INVITE_PENDING = 8388380318487740882
    POPULATE_NOW = 8390974832148959038
    NETWORK_SESSION_IS_CLOSED_CREW = 8391099375925699252
    PLAY_ANIM_ON_RUNNING_SCENARIO = 8394780375071454684
    NETWORK_GET_CURRENTLY_SELECTED_GAMER_HANDLE_FROM_INVITE_MENU = 8396994953546445436
    IS_MOBILE_PHONE_CALL_ONGOING = 8401415412829442636
    APP_GET_STRING = 8402311974982136092
    SET_PLAYER_CLOTH_PIN_FRAMES = 8403626605533980976
    NET_GAMESERVER_CLEAR_SESSION = 8403995109182533189
    DOES_PARTICLE_FX_LOOPED_EXIST = 8408201869211353243
    IS_AIM_CAM_ACTIVE_IN_ACCURATE_MODE = 8412024722259143625
    GET_SHOP_PED_COMPONENT = 8412973304352499552
    ENABLE_MOVIE_KEYFRAME_WAIT = 8413146329544280937
    SET_TYRE_HEALTH = 8414570155870644125
    SET_VEHICLE_SHOOT_AT_TARGET = 8416553235441156842
    REMOVE_PED_DEFENSIVE_AREA = 8418600066141671593
    ALLOW_PLAYER_SWITCH_OUTRO = 8421219511541720896
    STOP_SAVE_DATA = 8422308071220143869
    IS_PED_CUFFED = 8423237306564019845
    NETWORK_GET_NP_UNAVAILABLE_REASON = 8429399477241057193
    IS_TAXI_LIGHT_ON = 8432076543994056956
    NETWORK_SET_ACTIVITY_SPECTATOR = 8436235582563523188
    IS_ENTITY_AT_ENTITY = 8438462313122816391
    NETWORK_REMOVE_TRANSITION_INVITE = 8441069727147030510
    GET_SOUND_ID_FROM_NETWORK_ID = 8441487127002881156
    NETWORK_CLAN_IS_ROCKSTAR_CLAN = 8449803224988481835
    GET_USER_PREMIUM_ACCESS = 8450465154252051720
    ARE_PLANE_PROPELLERS_INTACT = 8457035875967810942
    SET_DISABLE_MAP_COLLISION = 8458446486553399469
    SC_PROFANITY_CHECK_STRING = 8458653310818113603
    VEHICLE_SET_ENABLE_NORMALISE_RAMP_CAR_VERTICAL_VELOCTIY = 8460828740016310788
    SC_INBOX_MESSAGE_GET_DATA_STRING = 8463089720764308333
    OVERRIDE_MICROPHONE_SETTINGS = 8464302270526627472
    IS_MODEL_A_PED = 8467160340481104597
    STAT_GET_NUMBER_OF_MINUTES = 8467810453804433845
    FORCE_PICKUP_REGENERATE = 8469683321249339792
    PRELOAD_VEHICLE_MOD = 8471070522906859146
    UGC_GET_CONTENT_RATING_COUNT = 8472002923565535913
    BEGIN_CREATE_LOW_QUALITY_COPY_OF_PHOTO = 8473048136402056884
    SET_FIRST_PERSON_SHOOTER_CAMERA_PITCH = 8475233452046769242
    SHOW_HEIGHT_ON_BLIP = 8476174985676657221
    SET_MINIMAP_COMPONENT = 8478484834750160550
    TASK_SEEK_COVER_FROM_POS = 8479199890695358962
    NETWORK_BUY_SMOKES = 8480138348999536317
    BG_START_CONTEXT_HASH = 8480716019117618375
    REQUEST_PED_USE_SMALL_BBOX_VISIBILITY_TRACKING = 8483124406314601647
    SET_CURRENT_PED_VEHICLE_WEAPON = 8486287495292755370
    OPEN_SOCIAL_CLUB_MENU = 8490245270360272986
    GET_PLAYER_PARACHUTE_TINT_INDEX = 8490401996352368965
    SET_BOAT_ANCHOR = 8492641107122760976
    SET_PLAYER_FORCED_ZOOM = 8495993443580991746
    BG_SET_EXITFLAG_RESPONSE = 8505347739182930154
    SET_LOCAL_PLAYER_VISIBLE_LOCALLY = 8509892673133592340
    GET_VEHICLE_NEON_COLOUR = 8510095654457341311
    HAS_CLOSEST_OBJECT_OF_TYPE_BEEN_BROKEN = 8510411767871766654
    ADD_TEXT_COMPONENT_SUBSTRING_PHONE_NUMBER = 8510527060190799389
    CLEAR_PICKUP_REWARD_TYPE_SUPPRESSION = 8515659091894635780
    NETWORK_BUY_AIRSTRIKE = 8519486489798872857
    DOES_ENTITY_HAVE_SKELETON = 8524955002948550081
    SET_PLAYER_FORCE_SKIP_AIM_INTRO = 8525802710196937000
    STOP_CINEMATIC_SHOT = 8530036391243548558
    DISPLAY_HUD_WHEN_NOT_IN_STATE_OF_PLAY_THIS_FRAME = 8532625725029707875
    SET_FLOATING_HELP_TEXT_SCREEN_POSITION = 8537078988462243148
    STAT_GET_INT = 8538750310448033597
    IS_SCALEFORM_MOVIE_METHOD_RETURN_VALUE_READY = 8543320341737964758
    UGC_GET_CONTENT_TOTAL = 8545951800180485813
    HAS_WEAPON_GOT_WEAPON_COMPONENT = 8548263397245042577
    RESERVE_NETWORK_MISSION_VEHICLES = 8552386415624168553
    SET_NETWORK_ID_VISIBLE_IN_CUTSCENE_REMAIN_HACK = 8553446874497316498
    GET_HEAD_BLEND_EYE_COLOR = 8555610926633273321
    NETWORK_HAS_SOCIAL_NETWORKING_SHARING_PRIV = 8556562192993965301
    SET_VEHICLE_DONT_TERMINATE_TASK_WHEN_ACHIEVED = 8562022537810052254
    SET_HORN_ENABLED = 8563176606583573774
    NETWORK_HAS_FOLLOW_INVITE = 8564080086179946462
    NETWORK_GET_VC_BANK_BALANCE = 8570113532776560986
    SET_PARTICLE_FX_NON_LOOPED_ALPHA = 8581201661510857468
    NETWORK_PLAYER_GET_NAME = 8581840958160123858
    NETWORK_SPEND_GANGOPS_CANNON = 8582412895067158463
    FIX_VEHICLE_WINDOW = 8584567789502981762
    GET_VEHICLE_MOD = 8586499896144719835
    SET_RADIO_STATION_MUSIC_ONLY = 8596201885425639714
    DELETE_PATROL_ROUTE = 8604089281203999513
    USE_PLAYER_COLOUR_INSTEAD_OF_TEAM_COLOUR = 8607928348571297479
    NETWORK_IS_SHOWING_SYSTEM_UI_OR_RECENTLY_REQUESTED_UPSELL = 8613380446150369666
    CLEAR_DYNAMIC_PAUSE_MENU_ERROR_MESSAGE = 8616021925407933230
    DOES_CURRENT_PED_COMPONENT_HAVE_RESTRICTION_TAG = 8617270768035830725
    SAVEMIGRATION_MP_NUM_ACCOUNTS = 8620278917687544917
    PLAY_ENTITY_SCRIPTED_ANIM = 8620433692846193905
    SET_PED_PATH_CAN_USE_LADDERS = 8621491691477485422
    RESET_DISPATCH_IDEAL_SPAWN_DISTANCE = 8622216433203350037
    SET_ENTITY_QUATERNION = 8624986918210506503
    SET_REDUCE_PED_MODEL_BUDGET = 8626075141584545552
    IS_LOOK_INVERTED = 8626102284276728077
    GET_DEBUG_CAM = 8629968653990921974
    SET_PLAYER_MAX_ARMOUR = 8637847965451127921
    SET_FAKE_PAUSEMAP_PLAYER_POSITION_THIS_FRAME = 8638710128135168463
    RELEASE_NAMED_SCRIPT_AUDIO_BANK = 8641588576275202416
    PAUSE_MENUCEPTION_GO_DEEPER = 8642807101718321772
    GET_SCRIPT_TASK_STATUS = 8642898859635411157
    SET_OBJECT_FORCE_VEHICLES_TO_AVOID = 8643321571544708010
    SCALEFORM_MOVIE_METHOD_ADD_PARAM_LITERAL_STRING = 8646405517797544368
    SET_PICKUP_REGENERATION_TIME = 8647294581580156061
    NETWORK_IS_CONNETED_TO_NP_PRESENCE = 8649270420731536091
    SET_PICKUP_OBJECT_COLLECTABLE_IN_VEHICLE = 8652515189380237209
    SET_VEHICLE_DOORS_SHUT = 8654578603176050421
    SET_MOVEMENT_MODE_OVERRIDE = 8655330219874224082
    NETWORK_CHECK_ONLINE_PRIVILEGES = 8661015725816666317
    HAS_PED_PRELOAD_PROP_DATA_FINISHED = 8664928595896049817
    SET_FLOATING_HELP_TEXT_WORLD_POSITION = 8668206492294005112
    EXPLODE_VEHICLE_IN_CUTSCENE = 8676834177737408267
    SET_LOCAL_PLAYER_CAN_COLLECT_PORTABLE_PICKUPS = 8684487946389010697
    IS_SCENARIO_OCCUPIED = 8685005888811098236
    SET_FLOATING_HELP_TEXT_STYLE = 8687021280588556273
    GET_PLAYER_SWITCH_JUMP_CUT_INDEX = 8701193290245248053
    SET_PED_CLOTH_PIN_FRAMES = 8702337210939337563
    SET_SHOULD_RESET_TURRET_IN_SCRIPTED_CAMERAS = 8705157096798110239
    IS_PLAYER_TARGETTING_ANYTHING = 8705428498500991140
    SET_PED_VISUAL_FIELD_MAX_ELEVATION_ANGLE = 8705658698331543638
    IS_NAMED_RENDERTARGET_REGISTERED = 8709077765568140980
    SET_ENTITY_IS_IN_VEHICLE = 8712463782327583317
    ADD_AMMO_TO_PED = 8714538174022443552
    DATADICT_GET_INT = 8714587784846092300
    IS_PLAYER_TARGETTING_ENTITY = 8724308091205739702
    NETWORK_REMOVE_INVALID_OBJECT_MODEL = 8727654298956264552
    HIRED_LIMO = 8728664007952783012
    UGC_DID_MODIFY_SUCCEED = 8736968377147549172
    SET_POSITION_OFFSET_FOR_RECORDED_VEHICLE_PLAYBACK = 8748954202524064234
    NETWORK_SET_CURRENT_DATA_MANAGER_HANDLE = 8748954432052207421
    IS_PED_IN_MODEL = 8749809010202026802
    IS_SCREEN_FADING_OUT = 8753528501838783119
    RESERVE_LOCAL_NETWORK_MISSION_OBJECTS = 8754888129885606414
    IS_MESSAGE_BEING_DISPLAYED = 8756334933637345089
    SET_PLAYERPAD_SHAKES_WHEN_CONTROLLER_DISABLED = 8759464672204640392
    DRAW_MARKER_SPHERE = 8759527637269938450
    GET_DLC_WEAPON_DATA = 8760131098298343758
    PLAYSTATS_ACQUIRED_HIDDEN_PACKAGE = 8767158209719485452
    TASK_EXIT_COVER = 8769169158966693161
    SET_TABLE_GAMES_CAMERA_THIS_UPDATE = 8773263032172758242
    GET_PED_PARACHUTE_STATE = 8777473353230940598
    SET_FREEMODE_STRAND_PROGRESSION_STATUS = 8778378414050081993
    SET_VEHICLE_DIRT_LEVEL = 8778559758790880907
    SET_VEHICLE_EXTENDED_REMOVAL_RANGE = 8781876888261021185
    SET_ENTITY_ONLY_DAMAGED_BY_PLAYER = 8786559155253806920
    TASK_AIM_GUN_SCRIPTED = 8798111594244947200
    GET_INDEXED_ITEM_IN_ITEMSET = 8798202044993121195
    NETWORK_GET_DESTROYER_OF_NETWORK_ID = 8798589940124617252
    SET_PED_VISUAL_FIELD_MIN_ELEVATION_ANGLE = 8802125710759352079
    RELEASE_SCRIPT_AUDIO_BANK = 8803845475387808831
    IS_STUNT_JUMP_IN_PROGRESS = 8808787365159830821
    UI3DSCENE_CLEAR_PATCHED_DATA = 8809800505743578133
    NETWORK_EARN_RDR_BONUS = 8814469947957200501
    GET_NETWORK_TIME = 8814819898341092168
    SET_SCENARIO_PED_DENSITY_MULTIPLIER_THIS_FRAME = 8815058788752046232
    SET_PED_CAN_BE_KNOCKED_OFF_VEHICLE = 8819514170820492360
    STOP_CURRENT_PLAYING_SPEECH = 8823625181532992711
    REQUEST_CUTSCENE = 8828871934635515401
    DATADICT_GET_ARRAY = 8833875170271058413
    CLEAR_GPS_RACE_TRACK = 8837668642037204363
    TASK_SHUFFLE_TO_NEXT_VEHICLE_SEAT = 8838316509574349803
    PHONEPHOTOEDITOR_TOGGLE = 8845719116291772813
    NETWORK_SET_SCRIPT_READY_FOR_EVENTS = 8847130222610807584
    ROLL_DOWN_WINDOW = 8852360316713789923
    END_TEXT_COMMAND_THEFEED_POST_UNLOCK_TU_WITH_COLOR = 8854174245385855112
    SET_PED_ACCURACY = 8858501697828937398
    TASK_SWEEP_AIM_POSITION = 8862679292048050130
    SET_WARNING_MESSAGE = 8869688505341545844
    PLAYSTATS_BC_CAR_JACKING = 8870079580392319445
    SET_PLAYER_ICON_COLOUR = 8872619834692084298
    IS_SCREENBLUR_FADE_RUNNING = 8872773480040538281
    IS_THIS_A_MINIGAME_SCRIPT = 8876865746910642328
    GET_ENTITY_QUATERNION = 8878569394405243416
    GET_FILENAME_FOR_AUDIO_CONVERSATION = 8886306764405083250
    NETWORK_BUY_BOUNTY = 8895046979010425561
    SET_MP_GAMER_TAG_BIG_TEXT = 8896618572110583222
    IGNORE_MENU_PREFERENCE_FOR_BONNET_CAMERA_THIS_UPDATE = 8901987107742153711
    SET_PLAYER_PREVIOUS_VARIATION_DATA = 8912175574354996747
    STAT_SET_MASKED_INT = 8915749936381744144
    SET_SPEED_BOOST_EFFECT_DISABLED = 8916705007427228158
    CREATE_PICK_UP_ROPE_FOR_CARGOBOB = 8929244404911140667
    SET_CAM_SPLINE_NODE_EXTRA_FLAGS = 8931101277165371504
    NETWORK_SPENT_HELI_PICKUP = 8931156196047234194
    TASK_COMBAT_HATED_TARGETS_AROUND_PED = 8932948940817864904
    DETACH_CONTAINER_FROM_HANDLER_FRAME = 8935216418893608636
    STOP_BRINGING_VEHICLE_TO_HALT = 8936886637159913518
    HAS_CUTSCENE_FINISHED = 8938107252012227927
    MP_TEXT_CHAT_IS_TEAM_JOB = 8944832014349291786
    GET_PED_STEALTH_MOVEMENT = 8947185480862490559
    PLAYSTATS_MISSION_OVER = 8956449348010210084
    NETWORK_ECONOMY_HAS_FIXED_CRAZY_NUMBERS = 8957603390018204564
    SET_VEHICLE_DOOR_OPEN = 8963811182594345058
    DOES_GROUP_EXIST = 8965272827573046206
    GET_ARE_CAMERA_CONTROLS_DISABLED = 8971536799987876032
    NETWORK_SPENT_PLAYER_HEALTHCARE = 8978225059614043877
    WATER_OVERRIDE_SET_RIPPLEBUMPINESS = 8979063984491565170
    GET_HUD_COLOUR = 8979211922652018191
    REGISTER_FLOAT_TO_SAVE = 8984332293923274427
    LEADERBOARDS_READ_CLEAR = 8993227156949980929
    NETWORK_CREATE_SYNCHRONISED_SCENE = 8995584341056541990
    GET_AI_PED_PED_BLIP_INDEX = 8996278909784906796
    SET_PED_VOICE_GROUP = 8997220342924992947
    GET_VEHICLE_NUMBER_PLATE_TEXT = 8998698628399956494
    UGC_GET_CONTENT_DESCRIPTION_HASH = 9002771004001498968
    SET_CAM_DOF_SHOULD_KEEP_LOOK_AT_TARGET_IN_FOCUS = 9003732846178615560
    SET_ENTITY_LIGHTS = 9005975120541333620
    GET_VEHICLE_EXTRA_COLOUR_5 = 9012939617897488694
    NET_GAMESERVER_USE_SERVER_TRANSACTIONS = 9018186096283333131
    GET_CAM_ROT = 9020793739271880210
    PLAYSTATS_BC_SALVAGE = 9022444058110694281
    NETWORK_SET_LOOK_AT_TALKERS = 9023347395842466070
    STAT_SAVE_PENDING = 9023621802390373804
    STREAMVOL_HAS_LOADED = 9025752219894176557
    GET_VEHICLE_PETROL_TANK_HEALTH = 9033565442791362676
    SET_VEHICLE_ALLOW_HOMING_MISSLE_LOCKON = 9038612572300981920
    REQUEST_PED_VISIBILITY_TRACKING = 9041590071078039224
    WAYPOINT_PLAYBACK_OVERRIDE_SPEED = 9042431214974701189
    START_PLAYBACK_RECORDED_VEHICLE_WITH_FLAGS = 9043506659263882054
    PLAYSTATS_IMPEXP_MISSION_ENDED = 9046500570024469703
    SC_EMAIL_GET_NUM_RETRIEVED_EMAILS = 9057174982204174488
    NETWORK_GET_BONE_ID_OF_FATAL_HIT = 9058211335668634016
    GET_PED_RELATIONSHIP_GROUP_HASH = 9060627034653941508
    IS_PED_IN_PARACHUTE_FREE_FALL = 9065336868616016384
    OVERRIDE_CAM_SPLINE_MOTION_BLUR = 9065601397766565205
    SET_CAM_DOF_FNUMBER_OF_LENS = 9066367097664261211
    CREATE_PED_INSIDE_VEHICLE = 9068377762319815988
    SET_PLAYER_HAS_RESERVE_PARACHUTE = 9068757119162565475
    IS_WANTED_AND_HAS_BEEN_SEEN_BY_COPS = 9081446565475122582
    SET_SEETHROUGH = 9081669462265990368
    GET_MENU_LAYOUT_CHANGED_EVENT_DETAILS = 9085940040720886703
    REGISTER_EFFECT_FOR_REPLAY_EDITOR = 9091593298042183433
    NETWORK_SPEND_SET_DISCOUNT = 9092572549925762272
    LOAD_GLOBAL_WATER_FILE = 9097084249329858259
    NETWORK_IS_INACTIVE_PROFILE = 9104154555220834862
    STAT_CLOUD_SLOT_SAVE_FAILED = 9108889746028410703
    NETWORK_CAN_ENTER_MULTIPLAYER = 9113080648447700005
    IS_PED_SHOOTING_IN_AREA = 9123727853582440687
    IS_FRONTEND_FADING = 9125056660290447085
    UPDATE_SOUND_COORD = 9134362695735698539
    GET_FIRST_PERSON_AIM_CAM_ZOOM_FACTOR = 9134756639609966960
    CLEAR_SCENARIO_SPAWN_HISTORY = 9135263378961769746
    SET_INSIDE_VERY_LARGE_INTERIOR = 9135740573159472506
    ENABLE_STADIUM_PROBES_THIS_FRAME = 9137233570910776812
    SET_VEHICLE_EXTRA = 9143331738832080073
    GET_PED_CONFIG_FLAG = 9143768600959694099
    GET_HASH_OF_MAP_AREA_AT_COORDS = 9144081107607193384
    START_SHAPE_TEST_LOS_PROBE = 9145110827451611406
    LEADERBOARDS2_READ_BY_SCORE_INT = 9145823822820450666
    IS_COP_VEHICLE_IN_AREA_3D = 9146641337764012650
    IS_ENTITY_IN_GHOST_COLLISION = 9148891786601037584
    SET_SNOW = 9153165449383164954
    WAS_PED_KILLED_BY_TAKEDOWN = 9153815145544627324
    STOP_ENTITY_FIRE = 9155205527417199359
    STAT_CLOUD_SLOT_LOAD_FAILED = 9163783863233863500
    IS_SYNCHRONIZED_SCENE_HOLD_LAST_FRAME = 9164630712636299247
    ALLOW_ALTERNATIVE_SCRIPT_CONTROLS_LAYOUT = 9171338763075101149
    NETWORK_ADD_INVALID_OBJECT_MODEL = 9175571576847761913
    IS_THIS_MODEL_A_CAR = 9182194428474387960
    NETWORK_SESSION_VOICE_RESPOND_TO_REQUEST = 9188490820673251001
    GET_RATIO_OF_CLOSEST_POINT_ON_LINE = 9191675341225556726
    SET_PARTICLE_FX_LOOPED_COLOUR = 9191676997121112123
    TASK_EVERYONE_LEAVE_VEHICLE = 9192806827815412338
    SET_VEHICLE_MODEL_PLAYER_WILL_EXIT_SCENE = 9193802044567663399
    BEGIN_CREATE_MISSION_CREATOR_PHOTO_PREVIEW = 9197995495574268934
    SET_PED_GENERATES_DEAD_BODY_EVENTS = 9201271453299690075
    PLAY_ENTITY_ANIM = 9201443540889044737
    UGC_GET_CONTENT_HAS_HI_RES_PHOTO = 9208798853858067389
    UGC_REQUEST_CONTENT_DATA_FROM_PARAMS = 9210592460182813022
    ADD_SHOCKING_EVENT_FOR_ENTITY = 9212381037151687714
    DRAW_DEBUG_LINE = 9214274567968275632
    NETWORK_SPENT_TELESCOPE = 9216079537485696009
    GET_PED_AMMO_TYPE_FROM_WEAPON = 9217412182166970228
    PLAY_SOUND = 9220157394528049453
    REMOVE_SCRIPT_FIRE = 9220355218917582655
    SC_GAMERDATA_GET_STRING = 9222457167027436223
    CLEAR_PED_FALL_UPPER_BODY_CLIPSET_OVERRIDE = 9224864623024467654
    CAN_REGISTER_MISSION_OBJECTS = 9227264798088691851
    IS_IME_IN_PROGRESS = 9230261206088200955
    GET_LENGTH_OF_STRING_WITH_THIS_TEXT_LABEL = 9231203256139661172
    NETWORK_HAVE_ROS_BANNED_PRIV = 9232563096275438205
    SET_PLAYER_MAY_ONLY_ENTER_THIS_VEHICLE = 9234348980891588490
    BEGIN_TEXT_COMMAND_SCALEFORM_STRING = 9237872426053230165
    OPEN_ONLINE_POLICIES_MENU = 9249686353212173388
    STOP_CUTSCENE_AUDIO = 9250491198493388294
    SET_HELI_RESIST_TO_EXPLOSION = 9256247539861039378
    IS_PROSPERO_VERSION = 9257921005951395026
    SET_PLAYER_IS_IN_DIRECTOR_MODE = 9260835933841995427
    SET_CUTSCENE_FADE_VALUES = 9265015192487249876
    GET_SPAWN_COORDS_FOR_VEHICLE_NODE = 9265392827702887831
    GET_REPLAY_STAT_AT_INDEX = 9266377056264564248
    GET_CONTROL_GROUP_INSTRUCTIONAL_BUTTONS_STRING = 9278256740344842241
    SET_REDUCE_VEHICLE_MODEL_BUDGET = 9278866077444525299
    SET_CAM_DEATH_FAIL_EFFECT_STATE = 9279862214405765913
    GET_NTH_CLOSEST_VEHICLE_NODE_WITH_HEADING = 9280347129195875524
    SET_RANDOM_TRAINS = 9284723967894636505
    SET_ALLOW_RAMMING_SOOP_OR_RAMP = 9287325679885769761
    ADD_TEXT_COMPONENT_SUBSTRING_BLIP_NAME = 9289475650368165166
    GET_FINAL_RENDERED_CAM_FOV = 9289819125479829492
    HAS_PICKUP_BEEN_COLLECTED = 9289880285775860729
    CASCADE_SHADOWS_ENABLE_ENTITY_TRACKER = 9290006893322648331
    THEFEED_CLEAR_FROZEN_POST = 9294953794500671018
    PLAYSTATS_MASTER_CONTROL = 9298631186805719024
    NET_GAMESERVER_IS_SESSION_REFRESH_PENDING = 9299515629782518777
    GET_UTC_TIME = 9302150507821724883
    IS_DLC_PRESENT = 9306008721141064158
    NETWORK_SPENT_ARREST_BAIL = 9308751900871664281
    NETWORK_IS_CLOUD_BACKGROUND_SCRIPT_REQUEST_PENDING = 9309715497612948115
    IS_PED_HEADTRACKING_ENTITY = 9311766709871215391
    NETWORK_MONEY_CAN_BET = 9313531156054212187
    SC_LICENSEPLATE_GET_ADD_STATUS = 9315695789069623725
    FORCE_EXPOSURE_READBACK = 9316531306299677051
    GET_MAX_RANGE_OF_CURRENT_PED_WEAPON = 9316994463577839225
    GET_VEHICLE_PED_IS_TRYING_TO_ENTER = 9317851689464185949
    GET_VEHICLE_MOD_COLOR_2 = 9320529165889799976
    UGC_GET_GET_BY_CONTENT_ID = 9321991840898620775
    NETWORK_ENTITY_GET_OBJECT_ID = 9322196887242999167
    SET_VEHICLE_MOD_COLOR_2 = 9323967158299838526
    APPLY_PED_BLOOD_DAMAGE_BY_ZONE = 9326789359401956667
    ASSISTED_MOVEMENT_REQUEST_ROUTE = 9327632773940614266
    SET_DESCRIPTION_FOR_UGC_MISSION_EIGHT_STRINGS = 9330198458700222033
    GET_VEHICLE_WEAPON_RESTRICTED_AMMO = 9331966604781263799
    UNLOCK_MINIMAP_ANGLE = 9332379123252997690
    REQUEST_VEHICLE_ASSET = 9340843933356239674
    NETWORK_BUY_HELI_STRIKE = 9343357415291959913
    IS_PED_SHADER_READY = 9343369985984060729
    REPLAY_STOP_EVENT = 9352761002800684937
    GET_WARNING_SCREEN_MESSAGE_HASH = 9358368676174356473
    SET_ROCKET_BOOST_ACTIVE = 9358855157613082681
    REFRESH_WAYPOINT = 9365823934806974673
    NETWORK_SPENT_REQUEST_JOB = 9368853338950414677
    SET_PED_CAN_PLAY_IN_CAR_IDLES = 9371595630247319501
    NETWORK_MANUAL_DELETE_CHARACTER = 9373143968113274071
    GET_CGOFFSET = 9373297824573371922
    HAS_SCALEFORM_CONTAINER_MOVIE_LOADED_INTO_PARENT = 9373984299572259837
    SET_PLAYER_PARACHUTE_SMOKE_TRAIL_COLOR = 9374239562500810191
    SPECIAL_ABILITY_ACTIVATE = 9376455402216964240
    THEFEED_GET_LAST_SHOWN_PHONE_ACTIVATABLE_FEED_ID = 9382448590019246282
    SET_DISABLE_PED_STAND_ON_TOP = 9382671199950435881
    NETWORK_GET_PLAYER_OWNS_WAYPOINT = 9383104026285176621
    RESET_WANTED_LEVEL_HIDDEN_ESCAPE_TIME = 9385159572976851334
    NETWORK_GET_HOST_PLAYER_INDEX = 9390563314814148552
    REGISTER_TEXT_LABEL_31_TO_SAVE = 9397184413055140088
    IS_PED_SITTING_IN_ANY_VEHICLE = 9397505571394551544
    SET_CUSTOM_PICKUP_WEAPON_HASH = 9398201965513211000
    NETWORK_EARN_FROM_BETTING = 9401927921893558893
    SET_CONTROL_LIGHT_EFFECT_COLOR = 9408060509652430005
    BG_GET_SCRIPT_ID_FROM_NAME_HASH = 9411628416378742135
    NETWORK_SHOULD_SHOW_STRICT_NAT_WARNING = 9413283561167259889
    SET_PED_CLOTH_PACKAGE_INDEX = 9413603877056198883
    ABORT_VEHICLE_CREW_EMBLEM_REQUEST = 9416116996428509279
    DISPLAY_PLAYER_NAME_TAGS_ON_BLIPS = 9425713183487565648
    SET_VEHICLE_DETONATION_MODE = 9430727015394289076
    SC_PROFANITY_GET_CHECK_IS_PENDING = 9431845538921274087
    SET_TIMECYCLE_MODIFIER_STRENGTH = 9432789202013202099
    RETAIN_ENTITY_IN_INTERIOR = 9433835734320521911
    GET_PROJECTILE_OF_PROJECTILE_TYPE_WITHIN_DISTANCE = 9438953992511352388
    PLAYSTATS_NIGHTCLUB_MISSION_ENDED = 9442986586368060665
    GET_ENTITY_ROLL = 9447991552259743967
    SET_ENTITY_ANGULAR_VELOCITY = 9455699069722763822
    ALLOW_PICKUP_ARROW_MARKER_WHEN_UNCOLLECTABLE = 9458479113922136157
    GET_ONSCREEN_KEYBOARD_RESULT = 9467323548894312007
    NETWORK_GET_ASSISTED_KILL_OF_ENTITY = 9468267856376631885
    TIMERA = 9468377998387232075
    BG_IS_EXITFLAG_SET = 9469770879987954890
    SET_BLIP_ROUTE_COLOUR = 9471445831088593417
    GET_GAMEPLAY_CAM_ROT = 9473152089056669883
    SET_PED_CHANCE_OF_FIRING_BLANKS = 9473430057970387325
    REMOVE_VEHICLE_STUCK_CHECK = 9477473254601942857
    GET_VEHICLE_CUSTOM_SECONDARY_COLOUR = 9478332663426216668
    SET_NETWORK_ENABLE_HIGH_SPEED_EDGE_FALL_DETECTION = 9479409345686203725
    SET_PED_PHONE_PALETTE_IDX = 9484978747130712226
    NETWORK_EARN_CASINO_COLLECTABLE_COMPLETED_COLLECTION = 9488350994431382659
    SET_CAM_SPLINE_NODE_EASE = 9491371531531098669
    DATAFILE_START_SAVE_TO_CLOUD = 9492688829345390341
    NETWORK_IS_HOST_OF_THIS_SCRIPT = 9497416109822188213
    TASK_PLAY_ANIM_ADVANCED = 9497441865609983755
    SET_GAMEPLAY_OBJECT_HINT = 9504975693516778182
    NETWORK_CHECK_COMMUNICATION_PRIVILEGES = 9507816676892868538
    APPLY_PED_BLOOD = 9509315551151168038
    SUPPRESS_NEONS_ON_VEHICLE = 9509371877843605982
    GET_LAST_PED_IN_VEHICLE_SEAT = 9509748267553039972
    NETWORK_SHOW_ACCOUNT_UPGRADE_UI = 9511194984512565271
    GET_LOCKON_DISTANCE_OF_CURRENT_PED_WEAPON = 9515828836988497052
    CLEAR_FAKE_CONE_ARRAY = 9516323581945215901
    TASK_FLUSH_ROUTE = 9516460747797729286
    ARE_ALL_NAVMESH_REGIONS_LOADED = 9517752372806957802
    SC_GAMERDATA_GET_BOOL = 9518074474632173527
    SET_PED_PREFERRED_COVER_SET = 9521149805999657401
    SET_TASK_MOVE_NETWORK_ANIM_SET = 9521546527352952201
    SET_RANDOM_BOATS = 9530583018426679647
    IS_PED_IN_COVER_FACING_LEFT = 9535021680318317483
    ATTACH_TV_AUDIO_TO_ENTITY = 9537407365930223155
    AUDIO_IS_MUSIC_PLAYING = 9538619863173364286
    PAUSE_MENU_IS_CONTEXT_ACTIVE = 9541309789331285558
    APP_DATA_VALID = 9541624474208495030
    GET_ENTITY_HEADING_FROM_EULERS = 9541990891763836702
    GET_BEST_PED_WEAPON = 9548732433391192802
    PLAYSTATS_DUPE_DETECTED = 9550839653924551429
    NETWORK_EARN_FROM_PROPERTY = 9553903050330469829
    IS_PED_INJURED = 9557445016008013249
    STAT_GET_CURRENT_FRONT_WHEEL_DISTANCE = 9558908572057115662
    IS_TOGGLE_MOD_ON = 9561761758880500455
    SAVEMIGRATION_IS_MP_ENABLED = 9562295298770119708
    NETWORK_EARN_FROM_DESTROYING_CONTRABAND = 9565664768403869634
    MOVE_VEHICLE_DECALS = 9568134640113103488
    TASK_SEEK_COVER_FROM_PED = 9571041169460368164
    IS_ROPE_ATTACHED_AT_BOTH_ENDS = 9574155140062406384
    PLAYSTATS_FM_EVENT_HOTPROPERTY = 9574588459565982028
    SET_HYDRAULIC_SUSPENSION_RAISE_FACTOR = 9577636633989345036
    GET_IS_HIDEF = 9578365966413583049
    NETWORK_GET_TALKER_PROXIMITY = 9579421600721461400
    SET_CAR_HIGH_SPEED_BUMP_SEVERITY_MULTIPLIER = 9582887004743788566
    NETWORK_EARN_COLLECTABLE_ITEM = 9583488196699157309
    HAS_PED_RECEIVED_EVENT = 9585837826331274688
    BEGIN_TEXT_COMMAND_DISPLAY_HELP = 9586393620515641873
    GET_PED_DESIRED_MOVE_BLEND_RATIO = 9590367744336139245
    GRAB_PAUSEMENU_OWNERSHIP = 9591780051132529276
    SET_ENTITY_ROTATION = 9593978580461510151
    PAUSE_SCRIPTED_CONVERSATION = 9597361534365281042
    GET_VEHICLE_IS_DUMMY = 9598238422622860086
    BEGIN_TEXT_COMMAND_IS_MESSAGE_DISPLAYED = 9598939907525681683
    NETWORK_HAS_VALID_ROS_CREDENTIALS = 9602870625939551547
    SC_PROFANITY_GET_STRING_PASSED = 9607122277766007145
    NETWORK_SESSION_IS_IN_VOICE_SESSION = 9609489219226891908
    ROLL_DOWN_WINDOWS = 9617836149684691286
    NETWORK_EARN_FROM_BUSINESS_PRODUCT = 9621510244675947695
    SET_PICKUP_TRANSPARENT_WHEN_UNCOLLECTABLE = 9623851542836544682
    SET_CAM_ROT = 9626222390276852487
    NETWORK_SHOW_PROFILE_UI = 9628363738797309096
    NETWORK_QUEUE_GAMER_FOR_STATUS = 9628959150142687276
    ARE_ENTITIES_ENTIRELY_INSIDE_GARAGE = 9635108700145311202
    CLEAR_INTERIOR_STATE_OF_ENTITY = 9643686930075461389
    NETWORK_DOES_TUNABLE_EXIST = 9648391253260808714
    HAS_SCALEFORM_MOVIE_LOADED = 9651244295395497742
    END_TEXT_COMMAND_GET_SCREEN_WIDTH_OF_DISPLAY_TEXT = 9651321592079003495
    SAVEMIGRATION_MP_REQUEST_ACCOUNTS = 9652374613921926258
    ADD_VEHICLE_SUBTASK_ATTACK_PED = 9652448456064476287
    NET_GAMESERVER_GET_CATALOG_CLOUD_CRC = 9653124590307519439
    TASK_AIM_GUN_SCRIPTED_WITH_TARGET = 9657317450239419820
    ADD_CAM_SPLINE_NODE = 9658470085705661243
    ASSISTED_MOVEMENT_FLUSH_ROUTE = 9665069012116897311
    IS_SCALEFORM_MOVIE_DELETING = 9666232367297717054
    SET_TASK_MOVE_NETWORK_SIGNAL_FLOAT_LERP_RATE = 9670581840027424891
    IS_PED_BEING_STEALTH_KILLED = 9672364137847217650
    DESTROY_CAM = 9680778529535173353
    SET_IGNORE_PLANES_SMALL_PITCH_CHANGE = 9683890451700368550
    GET_ENTITY_FORWARD_Y = 9685635723418703120
    HAS_ACHIEVEMENT_BEEN_PASSED = 9688199240742057707
    HIDE_PORTABLE_PICKUP_WHEN_DETACHED = 9688465614809058482
    SHOOT_SINGLE_BULLET_BETWEEN_COORDS = 9689024882534281004
    GET_GPS_BLIP_ROUTE_FOUND = 9700096964479131654
    REMOVE_BLIP = 9702532981073061341
    SET_VEHICLE_WEAPON_CAN_TARGET_OBJECTS = 9706583350490740263
    NETWORK_CLEAR_GET_GAMER_STATUS = 9718880207512573293
    HAS_NAMED_PTFX_ASSET_LOADED = 9728410087137920084
    NETWORK_SPEND_BUY_ARCADE = 9728489488316138360
    SET_PED_COORDS_NO_GANG = 9729235227491988039
    SET_VEHICLE_BOBBLEHEAD_VELOCITY = 9731024777952761288
    NETWORK_REQUEST_CONTROL_OF_DOOR = 9731680478500984548
    GET_VEHICLE_ATTACHED_TO_CARGOBOB = 9744526066508282341
    GET_ACTUAL_SCREEN_RESOLUTION = 9744838726593289683
    ENABLE_MOVIE_SUBTITLES = 9745691034725833072
    CLEAR_PLAYER_PARACHUTE_MODEL_OVERRIDE = 9751306387685043775
    GET_RANDOM_PED_AT_COORD = 9754874484072167196
    NETWORK_SPENT_NIGHTCLUB_ENTRY_FEE = 9754891798676858205
    HAS_PEDHEADSHOT_IMG_UPLOAD_FAILED = 9757375001082513869
    SET_PICKUP_ROPE_LENGTH_FOR_CARGOBOB = 9762711827796660259
    IS_DRIVEBY_TASK_UNDERNEATH_DRIVING_TASK = 9765465234159077400
    SET_TRAILER_LEGS_LOWERED = 9767311162033944898
    PLAYSTATS_ENTER_SESSION_PACK = 9768291472006617430
    GET_VEHICLE_LIVERY_COUNT = 9779071972287304998
    DRAW_SCALEFORM_MOVIE_3D = 9787761741249990264
    SET_AMBIENT_LAW_PED_ACCURACY_MODIFIER = 9790239967273982620
    SC_INBOX_GET_BOUNTY_DATA_AT_INDEX = 9790831289471689958
    UGC_GET_CONTENT_RATING_POSITIVE_COUNT = 9792448933333557422
    OPEN_BOMB_BAY_DOORS = 9793062281908792497
    NETWORK_IS_FRIEND_HANDLE_ONLINE = 9794056229888398555
    NETWORK_AM_I_BLOCKED_BY_PLAYER = 9796338375174927677
    NETWORK_GET_PRESENCE_INVITE_IS_TOURNAMENT = 9801748961635323397
    PLAYSTATS_BW_HUNT_THE_BOSS = 9802224097873110190
    FORCE_CLOSE_TEXT_INPUT_BOX = 9806412662608192000
    SET_VEHICLE_FORCE_INTERIORLIGHT = 9809149421780872677
    GET_MP_LIGHT_ENABLED = 9810893952621839981
    IS_STORE_AVAILABLE_TO_USER = 9817136645577513139
    CLEAR_PED_ALTERNATE_WALK_ANIM = 9819179782389803497
    LEADERBOARDS2_READ_GET_ROW_DATA_INT = 9824478818019789370
    STAT_GET_SAVE_MIGRATION_STATUS = 9829409359531763905
    IS_ENTITY_IN_AIR = 9830856524580389046
    SET_INITIAL_PLAYER_STATION = 9833995800756988045
    UNPAUSE_PLAYBACK_RECORDED_VEHICLE = 9834152984408425941
    PLAYSTATS_INVENTORY = 9835207805439277320
    SET_FORCE_FIX_LINK_MATRICES = 9835759913695874162
    SET_PICKUP_OBJECT_TRANSPARENT_WHEN_UNCOLLECTABLE = 9836364656519772568
    GET_SCREEN_RESOLUTION = 9839617397771089444
    SET_ALLOW_ABILITY_BAR = 9841255549971568188
    IS_IPL_ACTIVE = 9846911559021573269
    GET_IS_LAUNCH_FROM_LIVE_AREA = 9850930067154634382
    CANCEL_REPLAY_RECORDING = 9852526917964636736
    SET_VEHICLE_USE_MORE_RESTRICTIVE_SPAWN_CHECKS = 9852863595025575577
    NETWORK_SPEND_CASINO_GENERIC = 9853765351354192835
    REMOVE_PTFX_ASSET = 9855706948368681587
    SET_PED_STEALTH_MOVEMENT = 9857172108909181906
    NETWORK_EARN_AWARD_FIXER_MISSION = 9860283010048687173
    SET_PED_PATH_CLIMB_COST_MODIFIER = 9863777880417544779
    SET_LOCAL_PLAYER_PERMITTED_TO_COLLECT_PICKUPS_WITH_MODEL = 9865957837158639910
    GET_NETWORK_TIME_ACCURATE = 9872523409720610463
    NETWORK_SPEND_UPGRADE_SUB = 9873186174936082062
    PLAY_STREAM_FROM_PED = 9873189826558735825
    NETWORK_TRIGGER_DAMAGE_EVENT_FOR_ZERO_DAMAGE = 9875879801130525549
    CREATE_PICKUP_ROTATE = 9878650672424589495
    DO_SCREEN_FADE_OUT = 9879590510830748335
    GET_FOCUS_PED_ON_SCREEN = 9881283267424887882
    TASK_PERFORM_SEQUENCE_FROM_PROGRESS = 9881490315637044464
    ATAN2 = 9883092181120606628
    SET_ENTITY_FOR_NULL_CONV_PED = 9884111149781616373
    GET_MOD_TEXT_LABEL = 9886916650758148812
    ACTIVITY_FEED_POST = 9894948913319171016
    WAYPOINT_PLAYBACK_START_AIMING_AT_COORD = 9901234207769680051
    NETWORK_CASINO_CAN_BUY_CHIPS_PVC = 9901397808286796817
    NET_GAMESERVER_GET_SESSION_STATE_AND_STATUS = 9904598459991998768
    TEST_PROBE_AGAINST_ALL_WATER = 9904651976348723807
    PLAYSTATS_MC_CLUBHOUSE_ACTIVITY = 9910676582319007028
    GET_PED_PROP_INDEX = 9911510248128752856
    GET_STATE_OF_RAYFIRE_MAP_OBJECT = 9915705055645413934
    RESET_PARTICLE_FX_OVERRIDE = 9928279102562192046
    IS_HANDLER_FRAME_LINED_UP_WITH_CONTAINER = 9932179695416732963
    TASK_CLIMB = 9933248364425581297
    DONT_ZOOM_MINIMAP_WHEN_RUNNING_THIS_FRAME = 9933399096411707296
    SET_VEHICLE_GRAVITY = 9939806898937026522
    GET_HASH_OF_THIS_SCRIPT_NAME = 9951982208438757502
    DOES_SCENARIO_BLOCKING_AREA_EXISTS = 9954275036337907645
    PATCH_DECAL_DIFFUSE_MAP = 9959085237601067136
    SC_PAUSE_NEWS_GET_PENDING_STORY = 9963113293214513766
    SET_CREATE_RANDOM_COPS_NOT_ON_SCENARIOS = 9964643556797642471
    VEHICLE_WAYPOINT_PLAYBACK_PAUSE = 9966020413104745413
    INTERRUPT_CONVERSATION_AND_PAUSE = 9973588037931162680
    SET_OBJECT_TARGETTABLE = 9976477479970995585
    IS_MEMORY_CARD_IN_USE = 9977107226443598557
    REQUEST_MODELS_IN_ROOM = 9978358362105965656
    NETWORK_BUY_FAIRGROUND_RIDE = 9978632427433939637
    PLAYSTATS_STOP_TRACKING_STUNTS = 9979991810062001501
    NETWORK_IS_LOCAL_PLAYER_INVINCIBLE = 9981829127194652672
    IS_PLAYER_SCRIPT_CONTROL_ON = 9982064081789376471
    CREATE_MODEL_HIDE = 9986658107151672440
    END_TEXT_COMMAND_IS_MESSAGE_DISPLAYED = 9987754355478197779
    LOBBY_AUTO_MULTIPLAYER_EVENT = 9990220738884709581
    SET_VEHICLE_DISABLE_HEIGHT_MAP_AVOIDANCE = 9991543696220151109
    SET_VEHICLE_UNDRIVEABLE = 9996419924669770645
    GET_APPROX_HEIGHT_FOR_AREA = 9997575593193741539
    HAS_OBJECT_BEEN_BROKEN = 9997910961191404514
    DOES_VEHICLE_HAVE_ROOF = 10000351483635981184
    GET_ENTITY_TYPE = 10001710134357738757
    SET_RANDOM_WEATHER_TYPE = 10017686195456081952
    GET_CONTENT_TO_LOAD_TYPE = 10019428783591201121
    STAT_GET_DATE = 10020417841698472523
    PLAY_SYNCHRONIZED_AUDIO_EVENT = 10029468361250168109
    IS_OBJECT_VISIBLE = 10030269424795809094
    GET_ALLOCATED_STACK_SIZE = 10033076774007577442
    NETWORK_TRANSITION_START = 10038519691265257967
    DATAARRAY_GET_DICT = 10042936787056858207
    IS_STREAMING_ADDITIONAL_TEXT = 10045305044058106864
    NETWORK_SESSION_SET_MATCHMAKING_GROUP_MAX = 10045927477498143253
    SET_VEHICLE_FULLBEAM = 10051990933519155742
    STAT_IS_RECORDING_STAT = 10060157383120176012
    GET_PED_PARACHUTE_LANDING_TYPE = 10060795030760679104
    SET_VEHICLE_AUTOMATICALLY_ATTACHES = 10063002459648431251
    HAS_ENTITY_COLLIDED_WITH_ANYTHING = 10064703972973583892
    GET_ENTITY_FORWARD_X = 10066934134177064661
    SET_GAMEPLAY_CAM_FOLLOW_PED_THIS_UPDATE = 10068584170564634536
    GET_PLAYER_HEALTH_RECHARGE_MAX_PERCENT = 10071480034128492799
    NETWORK_EARN_SELL_PRIZE_VEHICLE = 10073188561166760831
    GET_STATUS_OF_TEXTURE_DOWNLOAD = 10076459875791962822
    GET_GROUND_Z_AND_NORMAL_FOR_3D_COORD = 10078066389880938102
    NETWORK_ACCESS_TUNABLE_INT = 10079359903666619496
    SET_PED_INTERIOR_WALLA_DENSITY = 10086101100699743710
    REPLAY_GET_MAX_DISTANCE_ALLOWED_FROM_PLAYER = 10087196057075278262
    GET_VEHICLE_MODEL_ACCELERATION = 10089273025457314666
    REFILL_AMMO_INSTANTLY = 10091819004293262727
    CREATE_SYNCHRONIZED_SCENE = 10095065924937375091
    SET_CAM_AFFECTS_AIMING = 10096445253756247181
    TASK_PERFORM_SEQUENCE_LOCALLY = 10102455826430609933
    TASK_CHAT_TO_PED = 10102574530039184665
    GET_VEHICLE_NEON_ENABLED = 10109334683377952421
    CREATE_PARACHUTE_BAG_OBJECT = 10110365600034469851
    NETWORK_SET_VEHICLE_DRIVEN_IN_TEST_DRIVE = 10119629249784525323
    NETWORK_IS_PLAYER_MUTED_BY_ME = 10119914414716935737
    SET_HIGH_FALL_TASK = 10124755914734031740
    UGC_GET_CONTENT_CREATED_BY_LOCAL_PLAYER = 10127794265917796111
    IS_OBJECT_NEAR_POINT = 10128875160973583882
    SET_PED_POPULATION_BUDGET = 10130059273862070515
    PLAYSTATS_FM_EVENT_URBANWARFARE = 10132273842250963285
    SET_DISABLE_COLLISIONS_BETWEEN_CARS_AND_CAR_PARACHUTE = 10136110437220322260
    SC_COMMUNITY_EVENT_GET_EXTRA_DATA_INT_BY_ID = 10143348445200817020
    STAT_SET_USER_ID = 10150535098105773585
    SET_PARTICLE_FX_FORCE_VEHICLE_INTERIOR = 10150709601296759610
    SET_PICKUP_OBJECT_ALPHA_WHEN_TRANSPARENT = 10159949852892672241
    NETWORK_IS_REFRESHING_ROS_CREDENTIALS = 10165158834549508556
    DATAARRAY_GET_VECTOR = 10169238896371196554
    GET_EVER_HAD_BAD_PACK_ORDER = 10173902347349693109
    SET_PLAYER_CONTROL = 10174252221492641954
    IS_VEHICLE_SPRAYABLE = 10180189662694304990
    GET_FOLLOW_PED_CAM_VIEW_MODE = 10181871448879805754
    FIND_RADIO_STATION_INDEX = 10189192497809277579
    IS_ENTITY_AN_OBJECT = 10189615146141002062
    INFORM_CODE_OF_CONTENT_ID_OF_CURRENT_UGC_MISSION = 10193020824436663747
    SET_PLAYER_MAX_EXPLOSIVE_DAMAGE = 10193482152665883205
    GET_COORDS_OF_PROJECTILE_TYPE_IN_AREA = 10194535389182552645
    PLAY_SOUND_FROM_COORD = 10197986523051753760
    REVIVE_INJURED_PED = 10199190270953494990
    PLAYSTATS_BW_BOSSONBOSSDEATHMATCH = 10199205469336740421
    SET_SCRIPT_CAN_START_CUTSCENE = 10204583826990466435
    NETWORK_IS_HOST = 10210389022571616775
    ATTACH_CAM_TO_VEHICLE_BONE = 10210769942916820850
    SET_MOUSE_CURSOR_STYLE = 10212140842084607314
    ATTACH_PORTABLE_PICKUP_TO_PED = 10215170457877182293
    FIND_SPAWN_COORDINATES_FOR_HELI = 10216810855561049378
    SUPPRESS_PICKUP_SOUND_FOR_PICKUP = 10217067053665840901
    GET_GROUP_SIZE = 10225035802851711557
    NETWORK_IS_CHATTING_IN_PLATFORM_PARTY = 10225867550917061714
    HAS_PED_GOT_WEAPON = 10226742572059207868
    CLEAR_HELP = 10231313563422525442
    NETWORK_ADD_FRIEND = 10232977943488250403
    PLAY_PED_AMBIENT_SPEECH_NATIVE = 10233584479118828642
    SET_PED_PATH_CAN_USE_CLIMBOVERS = 10234050815090880500
    SET_VEHICLE_NEON_COLOUR = 10235090006366889621
    GET_BINK_MOVIE_TIME = 10238896192160644905
    NETWORK_SPENT_UPGRADE_OFFICE_PROPERTY = 10242373263103464835
    SET_ENTITY_HEADING = 10242646436556216334
    ALLOW_PLAYER_SWITCH_ASCENT = 10244007289206761876
    FORCE_CHECK_SCRIPT_VARIABLES = 10256959941064618848
    DESTROY_ALL_CAMS = 10259113460775751968
    SET_HYDRAULIC_VEHICLE_STATE = 10279587041368874109
    REMOVE_GROUP = 10282551999567196243
    LEADERBOARDS_CLEAR_CACHE_DATA_ID = 10288276446022368511
    ADD_PATROL_ROUTE_NODE = 10295111106453597052
    GET_WATER_HEIGHT_NO_WAVES = 10297116871110596500
    SET_EVERYONE_IGNORE_PLAYER = 10299065303624326052
    SET_BITS_IN_RANGE = 10299870978336711149
    NETWORK_SET_SPECTATOR_TO_NON_SPECTATOR_TEXT_CHAT = 10301186773723979164
    SCRIPT_RACE_GET_PLAYER_SPLIT_TIME = 10301235629828086364
    CLEAR_PED_LAST_DAMAGE_BONE = 10301623148778549275
    END_TEXT_COMMAND_THEFEED_POST_CREW_RANKUP_WITH_LITERAL_FLAG = 10303338122199270884
    GET_CHARACTER_MENU_PED_FLOAT_STAT = 10306489394852022205
    SET_DISABLE_RETRACTING_WEAPON_BLADES = 10307995872436982231
    GET_VEHICLE_DIRT_LEVEL = 10310917179768153643
    SET_FLAMMABILITY_MULTIPLIER = 10320291858383673786
    NETWORK_CAN_COMMUNICATE_WITH_GAMER = 10330442636123353196
    DATAFILE_DELETE_REQUESTED_FILE = 10330872441733488896
    GET_VEHICLE_LOCK_ON_TARGET = 10330899868672905166
    RAISE_CONVERTIBLE_ROOF = 10331173284347444336
    GET_NUMBER_OF_PED_TEXTURE_VARIATIONS = 10336137878209981357
    SET_BOAT_SINKS_WHEN_WRECKED = 10336211342771641250
    STOP_PARTICLE_FX_LOOPED = 10337337331096316310
    HINT_AMBIENT_AUDIO_BANK = 10343658073732034396
    SET_THIRD_PERSON_CAM_RELATIVE_HEADING_LIMITS_THIS_UPDATE = 10347368856049835662
    BEGIN_TEXT_COMMAND_OVERRIDE_BUTTON_TEXT = 10348961230723411149
    PLAY_TENNIS_DIVE_ANIM = 10352020927949555275
    TASK_PLAY_PHONE_GESTURE_ANIMATION = 10356985398738282988
    SET_PED_CAN_PLAY_AMBIENT_IDLES = 10365204289172881360
    CLEAR_PED_BLOOD_DAMAGE = 10367891578892343319
    DATADICT_SET_STRING = 10372780042086834956
    SET_GPS_CUSTOM_ROUTE_RENDER = 10376441921594854255
    SET_VEHICLE_STEERING_BIAS_SCALAR = 10378443027063572692
    SET_BLIP_DISPLAY = 10388030775920576808
    CREATE_GROUP = 10391790874654546493
    END_TEXT_COMMAND_GET_NUMBER_OF_LINES_FOR_STRING = 10394553889593972486
    IS_PAUSEMAP_IN_INTERIOR_MODE = 10397120712398565231
    DETACH_VEHICLE_FROM_TRAILER = 10399707500062170502
    DATAFILE_GET_FILE_DICT = 10406542809864368822
    NETWORK_IS_USING_ONLINE_PROMOTION = 10406873271788432548
    IS_AMBIENT_SPEECH_PLAYING = 10408602366793727917
    GET_CAR_HAS_JUMP = 10410282495026928105
    SET_PARTICLE_FX_BLOOD_SCALE = 10413185619881797664
    SET_VEHICLE_NUMBER_PLATE_TEXT_INDEX = 10414832911214686369
    IS_PLAYER_READY_FOR_CUTSCENE = 10415909822333073040
    ADD_PLAYER_TARGETABLE_ENTITY = 10419055117599351082
    PARTICIPANT_ID = 10419199270309464707
    IS_PED_BEING_ARRESTED = 10421504610366576264
    GET_VEHICLE_MOD_MODIFIER_VALUE = 10422330747105880257
    SET_PED_ALTERNATE_MOVEMENT_ANIM = 10422522243744508742
    GET_MENU_PED_MASKED_INT_STAT = 10423109015435743280
    GET_STATUS_OF_TAKE_MISSION_CREATOR_PHOTO = 10423456863573476435
    SET_AMBIENT_VEHICLE_RANGE_MULTIPLIER_THIS_FRAME = 10427762177004414426
    NETWORK_SPEND_BUY_SUB = 10434132699718087092
    PLAYSTATS_QUICKFIX_TOOL = 10434948262282134597
    TASK_SET_BLOCKING_OF_NON_TEMPORARY_EVENTS = 10435426795485601129
    IS_GARAGE_EMPTY = 10440595429217894584
    GET_IS_VEHICLE_SECONDARY_COLOUR_CUSTOM = 10451221855851406700
    SET_DRIVE_ARTICULATED_JOINT = 10452894610396584176
    LEADERBOARDS_GET_CACHE_DATA_ROW = 10457614364798521971
    SET_MINIMAP_IN_PROLOGUE = 10462870595005426007
    IS_PED_IN_FLYING_VEHICLE = 10463136496930668956
    IS_REPORTUGC_MENU_OPEN = 10463366397162636158
    ACTIVITY_FEED_LARGE_IMAGE_URL = 10478933489439546935
    REMOVE_NAVMESH_REQUIRED_REGIONS = 10479606114466088030
    LEADERBOARDS2_READ_FRIENDS_BY_ROW = 10487493845665303427
    ADD_DISPATCH_SPAWN_ANGLED_BLOCKING_AREA = 10487893066247279243
    NETWORK_IS_PLAYER_CONCEALED = 10492046384407155449
    TASK_STAND_STILL = 10492227417279764825
    SET_DISABLE_VEHICLE_ENGINE_FIRES = 10493595366067401029
    IS_DISABLED_CONTROL_JUST_PRESSED = 10497601588777486455
    NETWORK_HAS_ROS_PRIVILEGE_SPECIAL_EDITION_CONTENT = 10500279235883426641
    IS_TRACKED_PED_VISIBLE = 10504899121431808172
    HAS_INSTANT_FILL_VEHICLE_POPULATION_FINISHED = 10508829948822211499
    CREATE_AIR_DEFENCE_SPHERE = 10515681208687443609
    SET_FOLLOW_VEHICLE_CAM_HIGH_ANGLE_MODE_THIS_UPDATE = 10515745590155828119
    FORCE_ROOM_FOR_GAME_VIEWPORT = 10524214410905907674
    REMOVE_STEALTH_MODE_ASSET = 10527592376442087490
    IS_TASK_MOVE_NETWORK_ACTIVE = 10528537609198390337
    REGISTER_HATED_TARGETS_AROUND_PED = 10530246063284245758
    SC_LICENSEPLATE_GET_CHECK_IS_PENDING = 10536139669876519254
    LOWER_FORKLIFT_FORKS = 10536779578848789733
    NETWORK_SPEND_BIKE_SHOP = 10536992175822528267
    REQUEST_COLLISION_FOR_MODEL = 10537494222108839883
    NETWORK_SET_SCRIPT_IS_SAFE_FOR_NETWORK_GAME = 10539472927263604816
    NETWORK_REQUEST_CLOUD_BACKGROUND_SCRIPTS = 10539591633987627285
    DISABLE_PAUSEMENU_SPINNER = 10540085660267596682
    NETWORK_EARN_FROM_SELL_BUNKER = 10543409052280464820
    NETWORK_SPEND_CAR_CLUB_BAR = 10543533109311089179
    GET_POSITION_OF_VEHICLE_RECORDING_ID_AT_TIME = 10543555057322447229
    GET_PLAYER_MAX_ARMOUR = 10549008456688745651
    START_END_USER_BENCHMARK = 10554476422534802138
    PLAYSTATS_START_TRACKING_STUNTS = 10560307500704567027
    GET_NUMBER_OF_VEHICLE_DOORS = 10561550669898559821
    PREVENT_COLLECTION_OF_PORTABLE_PICKUP = 10569661762773794851
    SET_VEHICLE_BRAKE_LIGHTS = 10570881273414561638
    IS_INTERIOR_CAPPED = 10572983720435575846
    TASK_PLANE_TAXI = 10575402684550816514
    CREATE_MODEL_SWAP = 10575709229457912483
    CLEAR_EXTRA_TCMODIFIER = 10578042356565706202
    NETWORK_SPEND_BUSINESS_PROPERTY_FEES = 10579465535184437020
    REMOVE_VEHICLE_MOD = 10580672842142417412
    STOP_SYNCHRONIZED_AUDIO_EVENT = 10580829704081196080
    SC_TRANSITION_NEWS_GET_EXTRA_DATA_INT_TU = 10581891705787947985
    SET_VEHICLE_HAS_STRONG_AXLES = 10588190813215531055
    THEFEED_SET_BACKGROUND_COLOR_FOR_NEXT_POST = 10588202547000612572
    PLAYSTATS_HEIST3_HACK = 10591356838945507860
    SC_INBOX_GET_MESSAGE_IS_READ_AT_INDEX = 10593186631268433160
    REQUEST_SCALEFORM_SCRIPT_HUD_MOVIE = 10593741883486582762
    PLAYSTATS_NPC_INVITE = 10593957849328155716
    SC_PROFANITY_GET_STRING_STATUS = 10596374189893078243
    PLAYSTATS_BC_MOST_WANTED = 10596776692690543049
    IS_AMBIENT_SPEECH_DISABLED = 10604900741009915903
    SET_PED_PROP_INDEX = 10608065531555015519
    IS_SWITCH_TO_MULTI_FIRSTPART_FINISHED = 10609283266083141108
    TASK_SET_SPHERE_DEFENSIVE_AREA = 10609361769477613988
    SET_BIT = 10609753527953370320
    NETWORK_PAY_MATCH_ENTRY_FEE = 10612417302084668742
    GET_EVENT_EXISTS = 10623535673165802933
    IS_WEAPON_VALID = 10627493561550189747
    MODIFY_VEHICLE_TOP_SPEED = 10638515397018075480
    NETWORK_SPEND_INTERACTION_MENU_ABILITY = 10640388975076305189
    SET_VEHICLE_LOD_MULTIPLIER = 10641559937555192817
    SET_PLAYER_PARACHUTE_PACK_TINT_INDEX = 10642282067781501024
    TASK_ACHIEVE_HEADING = 10644603204722958141
    GET_PED_SOURCE_OF_DEATH = 10648961764697600652
    NETWORK_REMOVE_ENTITY_AREA = 10650879646885496948
    SET_VEHICLE_DOOR_SHUT = 10653754407603636709
    NETWORK_IS_PLAYER_CONNECTED = 10654421488304384465
    GET_RANDOM_VEHICLE_NODE = 10655758079426509437
    SET_PED_HEAD_BLEND_DATA = 10670401406750737150
    UGC_DID_GET_SUCCEED = 10673059455317820103
    SKIP_TIME_IN_PLAYBACK_RECORDED_VEHICLE = 10680558840463170080
    REQUEST_PTFX_ASSET = 10685166128146757064
    IS_PED_ON_ANY_BIKE = 10685168940141536377
    TASK_COMBAT_PED_TIMED = 10686814165295262686
    NETWORK_SET_MINIMUM_RANK_FOR_MISSION = 10688027318389372367
    TASK_VEHICLE_MISSION_PED_TARGET = 10688258585250325882
    TASK_SMART_FLEE_COORD = 10689433456246744533
    NETWORK_SKIP_RADIO_RESET_NEXT_CLOSE = 10693206343548747627
    GET_PED_ARMOUR = 10701590112812511704
    NETWORK_SPENT_CARGO_SOURCING = 10702529597779806244
    GET_EXTRACONTENT_CLOUD_RESULT = 10703197673380910469
    SET_PARTICLE_FX_FOOT_LODRANGE_SCALE = 10709341635739330739
    SET_HELI_CAN_PICKUP_ENTITY_THAT_HAS_PICK_UP_DISABLED = 10711404499576291453
    NETWORK_IS_GETTING_GAMER_STATUS = 10711874716929032506
    NETWORK_SESSION_DO_CREW_MATCHMAKING = 10717531275555344767
    ADD_TEXT_COMPONENT_SUBSTRING_WEBSITE = 10722871427172256134
    SET_PED_PLAYS_HEAD_ON_HORN_ANIM_WHEN_DIES_IN_VEHICLE = 10725687488826502461
    DISPLAY_SYSTEM_SIGNIN_UI = 10726862416215971742
    PACKED_STAT_GET_INT_STAT_INDEX = 10732406389452956473
    NET_GAMESERVER_SET_TELEMETRY_NONCE_SEED = 10738785100885451182
    INIT_SYNCH_SCENE_AUDIO_WITH_ENTITY = 10739419675661918597
    PLAYSTATS_CASINO_ROULETTE = 10741116190643775473
    SET_PED_VEHICLE_FORCED_SEAT_USAGE = 10749818252643759564
    REGISTER_PEDHEADSHOT_TRANSPARENT = 10751609423277409199
    IS_THIS_MODEL_A_JETSKI = 10752073029506790910
    SET_VEHICLE_DEFORMATION_FIXED = 10753929475942778001
    CREATE_WEAPON_OBJECT = 10755110271371022134
    DOES_VEHICLE_EXIST_WITH_DECORATOR = 10766770371178634231
    PLAYSTATS_PEGASUS_AS_PERSONAL_AIRCRAFT = 10768877801008734498
    CLEAR_AREA_LEAVE_VEHICLE_HEALTH = 10770420815831486765
    UNLOAD_ALL_CLOUD_HATS = 10772180462461942628
    DRAW_SPRITE_ARX_WITH_UV = 10772944127051384614
    NETWORK_BAIL = 10777470535143963176
    TASK_CLEAR_DEFENSIVE_AREA = 10783522318166626685
    IPL_GROUP_SWAP_START = 10783828341731855079
    SET_VEHICLE_NUMBER_PLATE_TEXT = 10784026586230086215
    REPLAY_SYSTEM_HAS_REQUESTED_A_SCRIPT_CLEANUP = 10784866962491865944
    DECOR_SET_TIME = 10785795346691705508
    NETWORK_ENTITY_USE_HIGH_PRECISION_ROTATION = 10789210170476348969
    STOP_PLAYER_SWITCH = 10790806933449775777
    APP_SAVE_DATA = 10792264451834177631
    CELL_SET_INPUT = 10793412172051246235
    SET_TRAILER_LEGS_RAISED = 10794938863693855226
    REMOVE_MULTIPLAYER_WALLET_CASH = 10794989480695437447
    SET_PED_IS_DRUNK = 10795923819931986826
    ADD_PED_TO_CONVERSATION = 10797930671033112295
    SET_PED_DENSITY_MULTIPLIER_THIS_FRAME = 10800711787831782642
    IS_PLAYER_CLIMBING = 10802155550941313948
    OVERRIDE_PED_CREW_LOGO_TEXTURE = 10802831712772537022
    HAS_ENTITY_BEEN_DAMAGED_BY_ANY_OBJECT = 10802896790238288997
    GET_ENTITY_UPRIGHT_VALUE = 10803807467542486943
    DISPLAY_HELP_TEXT_THIS_FRAME = 10812192697039119388
    DELETE_PED = 10814314362921280843
    NETWORK_GET_AGE_GROUP = 10814469951324919851
    GET_CLOCK_YEAR = 10815244861152360215
    DETACH_ENTITY = 10816174385029791581
    SET_REMOTE_PLAYER_VISIBLE_IN_CUTSCENE = 10822728682718291892
    REQUEST_MODEL = 10825852671273492652
    SET_VEHICLE_DAMAGE_SCALES = 10826903138422316619
    SET_LIGHT_OVERRIDE_MAX_INTENSITY_SCALE = 10827032344667600053
    SET_STORE_ENABLED = 10827121893762309214
    TASK_OPEN_VEHICLE_DOOR = 10833287586458935394
    TASK_PLANT_BOMB = 10835639164684593599
    SKIP_TO_NEXT_SCRIPTED_CONVERSATION_LINE = 10836784865951738624
    GET_RAIN_LEVEL = 10838297566594487795
    CLEAR_SERVICE_EVENT_ARGUMENTS = 10839557715028893719
    ADD_PETROL_TRAIL_DECAL_INFO = 10840859641856300666
    GET_IS_PLAYER_IN_ANIMAL_FORM = 10847221236054964901
    REMOVE_MULTIPLAYER_HUD_CASH = 10848932969399459530
    SET_PED_SHOOTS_AT_COORD = 10853778798363652538
    UNREGISTER_PEDHEADSHOT = 10858519677351805695
    DISPLAY_CASH = 10871347368796752055
    GET_SHOP_PED_QUERY_COMPONENT_INDEX = 10872413608648956791
    START_BEING_GOON = 10873612636734299145
    SET_OBJECT_SPEED_BOOST_AMOUNT = 10875646342196354944
    SET_PARTICLE_FX_SHOOTOUT_BOAT = 10876078591633374965
    GET_BLIP_ALPHA = 10885024991924373637
    SET_RANDOM_EVENT_FLAG = 10887776491286634840
    SET_PED_KEEP_TASK = 10888921553773003503
    GET_CUTSCENE_END_TIME = 10888994807344787353
    SET_OBJECT_TINT_INDEX = 10889035418781929523
    UPDATE_TASK_AIM_GUN_SCRIPTED_TARGET = 10891106161309199056
    NETWORK_ACCESS_TUNABLE_FLOAT_HASH = 10893013445016601813
    SET_VEHICLE_DOORS_LOCKED_FOR_NON_SCRIPT_PLAYERS = 10896357530094567029
    NETWORK_EARN_CASINO_AWARD = 10897188831422811627
    NETWORK_TRANSITION_BLOCK_JOIN_REQUESTS = 10897997147803380918
    TASK_GO_TO_ENTITY_WHILE_AIMING_AT_ENTITY = 10900497284191097065
    NETWORK_IS_MULTIPLAYER_DISABLED = 10900726674967654106
    SET_AMBIENT_ZONE_LIST_STATE = 10901238110512533054
    SET_MAX_HEALTH_HUD_DISPLAY = 10906986713097635404
    REMOVE_PICK_UP_ROPE_FOR_CARGOBOB = 10910198128113403908
    NETWORK_LEAVE_PED_BEHIND_BEFORE_WARP = 10910524327694195459
    CAN_PAY_AMOUNT_TO_BOSS = 10914318999409301807
    SET_WEAPON_OBJECT_CAMO_INDEX = 10915786003686370891
    SET_PLAYER_PARACHUTE_MODEL_OVERRIDE = 10916079413933097947
    GET_FINAL_RENDERED_CAM_FAR_DOF = 10916992866160419889
    SET_DISABLE_AUTOMATIC_CRASH_TASK = 10917875813265043926
    TASK_USE_NEAREST_SCENARIO_CHAIN_TO_COORD_WARP = 10926452205845894705
    UGC_GET_MOST_RECENTLY_PLAYED_CONTENT = 10927826986195910187
    SET_PED_ENABLE_WEAPON_BLOCKING = 10927861562529559037
    RESET_PED_WEAPON_MOVEMENT_CLIPSET = 10930477480769179255
    SET_PED_AI_BLIP_NOTICE_RANGE = 10936526085528190889
    END_TEXT_COMMAND_THEFEED_POST_CREWTAG = 10937524850872979244
    SET_FORCE_HD_VEHICLE = 10938795766069953520
    GET_CURRENT_WEBSITE_ID = 10940503084174461869
    NETWORK_OVERRIDE_SEND_RESTRICTIONS = 10942986615870205546
    ACTIVITY_FEED_ADD_INT_TO_CAPTION = 10945966734720700763
    SHIFT_RIGHT = 10948002598818267253
    STOP_ANIM_TASK = 10952532887463698442
    SET_VEHICLE_FORCE_REVERSE_WARNING = 10952671477917319270
    SET_MOUSE_CURSOR_VISIBLE = 10962134389170235274
    GET_VEHICLE_WAYPOINT_PROGRESS = 10963116061220069721
    SET_VEHICLE_ENGINE_CAN_DEGRADE = 10968347041253909753
    SET_VEHICLE_CAUSES_SWERVING = 10973546217508846796
    HAS_BULLET_IMPACTED_IN_AREA = 10984469687502965141
    SET_FLASH_LIGHT_ACTIVE_HISTORY = 10992643470123515904
    SET_CUTSCENE_TRIGGER_AREA = 10995202345175778490
    HAS_MODEL_LOADED = 10999174976919095634
    GET_FIRST_N_CHARACTERS_OF_LITERAL_STRING = 11007870136933241105
    BEGIN_SCALEFORM_SCRIPT_HUD_MOVIE_METHOD = 11008087205089361877
    UI3DSCENE_ASSIGN_PED_TO_SLOT = 11008203140876031178
    GET_ZONE_FROM_NAME_ID = 11010488726806031553
    GET_IS_TIMECYCLE_TRANSITIONING_OUT = 11011733221677349785
    STAT_ENABLE_STATS_TRACKING = 11016574469671126979
    REQUEST_EARLY_LIGHT_CHECK = 11019735899804132594
    SET_PED_NAME_DEBUG = 11020204052071939041
    DOES_VEHICLE_HAVE_SEARCHLIGHT = 11025197643980230931
    GET_ENTITY_ATTACHED_TO_CARGOBOB = 11027414846095689930
    SET_BLOCKING_OF_NON_TEMPORARY_EVENTS_FOR_AMBIENT_PEDS_THIS_FRAME = 11029865940178564691
    IS_CUTSCENE_ACTIVE = 11029968252726419332
    UGC_GET_CONTENT_HAS_PLAYER_BOOKMARKED = 11041909679412269605
    NETWORK_SPENT_ROBBED_BY_MUGGER = 11050256723068064601
    SET_ABILITY_BAR_VALUE = 11054465290396358750
    GET_NUM_SUCCESSFUL_STUNT_JUMPS = 11055723428323463176
    IS_PED_IN_ANY_VEHICLE = 11059360085529971211
    NETWORK_SPENT_PURCHASE_CLUB_HOUSE = 11064808610562607100
    SET_VEHICLE_SHUNT_ON_STICK = 11069944889208529686
    START_PETROL_TRAIL_DECALS = 11073365279950801213
    ADD_VEHICLE_PHONE_EXPLOSIVE_DEVICE = 11073591500803197897
    NETWORK_APPLY_CACHED_PLAYER_HEAD_BLEND_DATA = 11076370714224609552
    OBJ_TO_NET = 11078816139353253185
    SET_VEHICLE_KERS_ALLOWED = 11081159153226301006
    FORCE_SUB_THROTTLE_FOR_TIME = 11081908322697961722
    NETWORK_START_SYNCHRONISED_SCENE = 11104539458923169431
    CREATE_OBJECT_NO_OFFSET = 11108492561942820996
    SC_INBOX_MESSAGE_DO_APPLY = 11109395550867416090
    PLAY_CAM_ANIM = 11109553116855739282
    GET_NUMBER_OF_ACTIVE_BLIPS = 11114870540554220776
    GET_CAUSE_OF_MOST_RECENT_FORCE_CLEANUP = 11115393256838472306
    IS_PED_BEING_JACKED = 11117557767523109139
    NETWORK_IS_CLOUD_AVAILABLE = 11118530911209485058
    SET_AMBIENT_VOICE_NAME_HASH = 11120476930948589968
    NETWORK_SPEND_SPIN_THE_WHEEL_PAYMENT = 11122714396005708700
    STAT_MIGRATE_SAVEGAME_GET_STATUS = 11124714157173170193
    SET_CARGOBOB_PICKUP_MAGNET_ACTIVE = 11125673735726183579
    GET_CLOUD_TIME_AS_INT = 11129278735060327542
    SET_VEHICLE_GENERATOR_AREA_OF_INTEREST = 11129899222162558893
    TOGGLE_SCENARIO_PED_COWER_IN_PLACE = 11130611099620252425
    TASK_WARP_PED_INTO_VEHICLE = 11132063835731916420
    HAVE_VEHICLE_MODS_STREAMED_IN = 11134013156105876975
    GET_ENTITY_SPEED_VECTOR = 11136680643181378317
    GET_VEHICLE_PED_IS_IN = 11137703836139538195
    SUPPRESS_CRIME_THIS_FRAME = 11139779675151915064
    SET_ISLAND_ENABLED = 11141091453926071537
    NETWORK_GET_PRIMARY_CLAN_DATA_CLEAR = 11143149771698350061
    SET_VEHICLE_FLIGHT_NOZZLE_POSITION_IMMEDIATE = 11143172112926947634
    DATAFILE_DELETE = 11149155450699001339
    SET_PED_FIRING_PATTERN = 11152451949107533993
    UNHINT_SCRIPT_AUDIO_BANK = 11153497549183620011
    NETWORK_HAS_PLAYER_STARTED_TRANSITION = 11153671075701888917
    RESTART_SCRIPTED_CONVERSATION = 11163060481669253548
    SET_PED_COORDS_KEEP_VEHICLE = 11168644811073104686
    FORCE_POSTFX_BULLET_IMPACTS_AFTER_HUD = 11171071476308214995
    SET_WANTED_LEVEL_DIFFICULTY = 11172220366678417018
    GET_LANDING_GEAR_STATE = 11173217139357185229
    GET_PEDS_JACKER = 11174149495931667663
    SET_LOCKED_UNSTREAMED_IN_DOOR_OF_TYPE = 11174268100976307632
    RESET_ENTITY_ALPHA = 11177514605217251962
    BLOCK_DISPATCH_SERVICE_RESOURCE_CREATION = 11181263008756394543
    STAT_CLEAR_DIRTY_READ_DETECTED = 11190268722901280265
    NETWORK_SPEND_EARNED_FROM_BANK_AND_WALLETS = 11191469977363966149
    TASK_AIM_GUN_AT_ENTITY = 11192495582369525587
    STAT_INCREMENT = 11194375024613955849
    CREATE_RANDOM_PED_AS_DRIVER = 11196574481639228576
    GET_BLIP_INFO_ID_PICKUP_INDEX = 11198067315515970434
    QUERY_MOVIE_MESH_SET_STATE = 11200013318199660267
    GET_ALL_VEHICLES = 11208927241441506024
    ROPE_LOAD_TEXTURES = 11209523089359657153
    DOOR_SYSTEM_SET_AUTOMATIC_DISTANCE = 11213965044713518631
    BEGIN_SRL = 11217864779081431075
    SET_INSTANCE_PRIORITY_MODE = 11218003581167595640
    IS_PED_GROUP_MEMBER = 11218499898526077329
    SET_VEHICLE_CONVERSATIONS_PERSIST_NEW = 11229652372472148355
    SET_VEHICLE_COUNTERMEASURE_AMMO = 11230327925766031445
    SET_CARGOBOB_PICKUP_MAGNET_SET_AMBIENT_MODE = 11231352109576295892
    SETUP_SHOP_PED_APPAREL_QUERY_TU = 11231794408604973249
    NETWORK_SPEND_AUTOSHOP_MODIFY = 11234850552465065499
    SET_VEHICLE_ACT_AS_IF_HAS_SIREN_ON = 11235589065693984934
    UGC_QUERY_MY_CONTENT = 11237669098498135786
    TASK_GET_OFF_BOAT = 11241239185137020415
    SET_HORN_PERMANENTLY_ON = 11245928624285173525
    GET_PED_ENVEFF_SCALE = 11246846181799959100
    NETWORK_SESSION_VOICE_HOST = 11246990685066641968
    SET_MP_GAMER_TAG_NUM_PACKAGES = 11247253652016247503
    WASH_DECALS_IN_RANGE = 11254602384772869615
    PLAYSTATS_RACE_CHECKPOINT = 11256567160511258084
    NETWORK_DO_TRANSITION_QUICKMATCH_WITH_GROUP = 11262013399182985610
    LEADERBOARDS_GET_CACHE_EXISTS = 11263841987227156012
    CAN_PED_SHUFFLE_TO_OR_FROM_TURRET_SEAT = 11270939875144156310
    CLEAR_PED_WETNESS = 11273081024317505150
    SET_PED_VISUAL_FIELD_PERIPHERAL_RANGE = 11273830090915149114
    START_VEHICLE_HORN = 11280502237559143724
    CREATE_NON_NETWORKED_AMBIENT_PICKUP = 11282491517935197264
    NETWORK_SET_IN_MP_CUTSCENE = 11287672567829757636
    DATAFILE_SELECT_UGC_STATS = 11290734992637045821
    SPECIAL_ABILITY_DEACTIVATE_FAST = 11292158172906032474
    GET_VEHICLE_PLATE_TYPE = 11298569554518870240
    GET_GAME_TIMER = 11300229656120296547
    ADD_ENTITY_ICON = 11300726557217082832
    SET_BIKE_ON_STAND = 11311433226459102395
    GOLF_TRAIL_SET_SHADER_PARAMS = 11312436481022512119
    NETWORK_JOIN_TRANSITION = 11314743246248423962
    GET_NUM_VEHICLE_WINDOW_TINTS = 11318148397216196359
    GET_TASK_RAPPEL_DOWN_WALL_STATE = 11323498930777448671
    NETWORK_SPENT_REQUEST_HEIST = 11323826461795417698
    NETWORK_SET_ACTIVITY_SPECTATOR_MAX = 11324155538302902818
    CLEAR_BRIEF = 11324634911882449683
    VEHICLE_SET_JET_WASH_FORCE_ENABLED = 11326667946093879483
    SET_PED_SPHERE_DEFENSIVE_AREA = 11326924300274321412
    SET_HORN_PERMANENTLY_ON_TIME = 11329637667895357080
    NETWORK_IS_SCRIPT_ACTIVE = 11331302476240543896
    SET_VEHICLE_IN_CAR_MOD_SHOP = 11332460526619134019
    NETWORK_EARN_HEIST_AWARD = 11335520336967013993
    BG_START_CONTEXT = 11338416496334613197
    STOP_PED_SPEAKING = 11341426432931849171
    NETWORK_AM_I_MUTED_BY_PLAYER = 11342739934660953604
    IS_HORN_ACTIVE = 11343437243661181217
    SET_NETWORK_ID_CAN_BE_REASSIGNED = 11345213149725757436
    GET_PED_HELMET_STORED_HAT_TEX_INDEX = 11345284472091137304
    PREPARE_ALARM = 11345884900650014003
    SEETHROUGH_SET_FADE_ENDDISTANCE = 11346108270625876927
    NETWORK_IS_TRANSITION_TO_GAME = 11346422169773698231
    END_TEXT_COMMAND_PRINT = 11346543740400845814
    NETWORK_SET_PROXIMITY_AFFECTS_TEAM = 11347660108948903698
    NETWORK_INVITE_GAMERS = 11349296585652774878
    SET_PLAYER_IS_REPEATING_A_MISSION = 11352805748639145714
    CREATE_AIR_DEFENCE_ANGLED_AREA = 11359640511477300232
    SET_PED_MOTION_IN_COVER_CLIPSET_OVERRIDE = 11365414731318294537
    TERMINATE_ALL_SCRIPTS_WITH_THIS_NAME = 11369075285246167263
    ENABLE_ALIEN_BLOOD_VFX = 11371060260457810037
    NETWORK_GET_FOUND_GAMER = 11371574420629566582
    NETWORK_DISABLE_INVINCIBLE_FLASHING = 11372548653699314209
    IS_PED_SWIMMING = 11376980390135051458
    SC_COMMUNITY_EVENT_GET_EXTRA_DATA_STRING = 11377731992513109712
    NETWORK_IS_SESSION_STARTED = 11377821997192667199
    NETWORK_ARE_PLAYERS_IN_SAME_TUTORIAL_SESSION = 11378774353010738292
    CREATE_SCRIPT_VEHICLE_GENERATOR = 11380464527765569814
    SET_FOLLOW_VEHICLE_CAM_HIGH_ANGLE_MODE_EVERY_UPDATE = 11384558816065405334
    GET_TIME_AS_STRING = 11395146608893132205
    GET_MP_OUTFIT_DATA_FROM_METADATA = 11398866979184585903
    GET_OFFSET_FROM_INTERIOR_IN_WORLD_COORDS = 11401775521218355759
    INVALIDATE_CINEMATIC_VEHICLE_IDLE_MODE = 11406773403435500658
    SMASH_VEHICLE_WINDOW = 11410817766430417497
    DISABLE_METRO_SYSTEM = 11413602432665415843
    GET_RELATIONSHIP_BETWEEN_GROUPS = 11415340851948334684
    SET_SOCIAL_CLUB_TOUR = 11418738629567602656
    NETWORK_DO_TRANSITION_TO_NEW_FREEMODE = 11421310875458992500
    GET_GROUND_Z_EXCLUDING_OBJECTS_FOR_3D_COORD = 11421956533085805353
    SET_PED_MOVE_ANIMS_BLEND_OUT = 11424665299683135181
    IS_RADAR_PREFERENCE_SWITCHED_ON = 11436418664070324990
    SET_ENTITY_COMPLETELY_DISABLE_COLLISION = 11438164406836389148
    SET_IN_STUNT_MODE = 11438427401768909554
    INT_TO_PARTICIPANTINDEX = 11440937697330480912
    STAT_GET_CURRENT_JUMP_DISTANCE = 11441541644660057402
    SHUTDOWN_AND_LOAD_MOST_RECENT_SAVE = 11441981640324420657
    INCREASE_PLAYER_JUMP_SUPPRESSION_RANGE = 11447436568753426874
    REQUEST_WAYPOINT_RECORDING = 11452572689105639314
    NETWORK_GAMERTAG_FROM_HANDLE_START = 11460546800196516438
    IS_AUSSIE_VERSION = 11464253468675555336
    IS_BIG_VEHICLE = 11467357866649993982
    REMOVE_PLAYER_TARGETABLE_ENTITY = 11467866675314801827
    SET_AUTO_GIVE_PARACHUTE_WHEN_ENTER_PLANE = 11471849700316629942
    SET_PED_AS_GROUP_MEMBER = 11471935980938408373
    SET_VEHICLE_BLIP_THROTTLE_RANDOMLY = 11475005392661980569
    GET_ENTITY_MODEL = 11477336068289496245
    WATER_OVERRIDE_SET_RIPPLEMAXBUMPINESS = 11483734532277223642
    IS_PED_GOING_INTO_COVER = 11485828064771152597
    UGC_GET_CREW_CONTENT = 11488163823955521250
    SET_PED_COMBAT_ATTRIBUTES = 11490816196028522521
    SET_PLAYER_CLOTH_PACKAGE_INDEX = 11491983583685846272
    SET_BLOCKING_OF_NON_TEMPORARY_EVENTS = 11496187148832857076
    BLOCK_FIRST_PERSON_ORIENTATION_RESET_THIS_UPDATE = 11499900500155795434
    RESET_PED_RAGDOLL_TIMER = 11503431828944865256
    NETWORK_CLAN_JOIN = 11505189570185656447
    SET_CAM_ACTIVE_WITH_INTERP = 11510535963658572452
    SET_COP_BLIP_SPRITE = 11514363666357737114
    GET_PED_DECORATION_ZONE_FROM_HASHES = 11516921130581129867
    DECOR_REGISTER = 11518245437423485902
    TASK_USE_NEAREST_SCENARIO_CHAIN_TO_COORD = 11518548947881699507
    SET_PED_WEAPON_COMPONENT_TINT_INDEX = 11521724316029606125
    UGC_IS_CREATING = 11524140149637185769
    NETWORK_SPENT_PAY_VEHICLE_INSURANCE_PREMIUM = 11525430014994998248
    SET_PED_GRAVITY = 11525916196422391306
    SC_INBOX_MESSAGE_GET_DATA_INT = 11533435248767665518
    INTERRUPT_CONVERSATION = 11536147665999638438
    SET_PLAYER_SPRINT = 11536956114075201012
    GET_IN_VEHICLE_CLIPSET_HASH_FOR_SEAT = 11537032908023774124
    REQUEST_MENU_PED_MODEL = 11539940711043417374
    NETWORK_SESSION_END = 11542261121661603846
    GET_FINAL_RENDERED_CAM_NEAR_DOF = 11544136502667607451
    NETWORK_EARN_FROM_GANGATTACK_PICKUP = 11546467268442621134
    IS_COMMANDLINE_END_USER_BENCHMARK = 11549944955082699512
    NETWORK_JOIN_GROUP_ACTIVITY = 11557654629731871716
    NETWORK_SUPPRESS_INVITE = 11558538368063093309
    SPECIAL_ABILITY_CHARGE_NORMALIZED = 11558886904674512408
    DECOR_GET_INT = 11559779936061977240
    PLAYSTATS_ACTIVITY_DONE = 11561269029515104902
    IS_EXPLOSION_IN_ANGLED_AREA = 11563456883644030027
    SET_PICKUP_OBJECT_GLOW_OFFSET = 11569718737768298973
    NETWORK_DO_TRANSITION_QUICKMATCH_ASYNC = 11570211317688070885
    IS_THIS_MODEL_A_PLANE = 11571025849083470046
    IS_MUSIC_ONESHOT_PLAYING = 11571905952892451617
    GET_SIZE_OF_SAVE_DATA = 11574120668225226783
    IS_PEDHEADSHOT_VALID = 11576897081859713442
    GET_POINT_AREA_OVERLAP = 11577934948723186082
    NETWORK_HAVE_ROS_CREATE_TICKET_PRIV = 11578048940007006049
    NETWORK_SET_VEHICLE_DRIVEN_LOCATION = 11587359301675635643
    CLEAR_CONTROL_SHAKE_SUPPRESSED_ID = 11587476974180412315
    IS_ANY_PED_SHOOTING_IN_AREA = 11588842792705092693
    SET_PLAYER_UNDERWATER_BREATH_PERCENT_REMAINING = 11588858018531081848
    DISPLAY_RADAR = 11595565366281037459
    GET_ROAD_BOUNDARY_USING_HEADING = 11599204808676293637
    LEADERBOARDS2_READ_GET_ROW_DATA_START = 11599369747962202445
    NETWORK_IS_LOGGED_IN_TO_PSN = 11599670405247116366
    NETWORK_HANDLE_FROM_MEMBER_ID = 11600465318696082508
    IS_MULTIHEAD_FADE_UP = 11600839529331203547
    GET_CAM_ANIM_CURRENT_PHASE = 11604419118627989168
    NETWORK_GET_NETWORK_ID_FROM_ENTITY = 11607747012039726172
    SET_FORCED_JUMP_THIS_FRAME = 11608093803785720785
    GET_VEHICLE_MAX_TRACTION = 11615622724727426480
    NETWORK_CLAN_IS_EMBLEM_READY = 11616040730399814449
    NET_GAMESERVER_START_SESSION = 11616380518993034247
    SET_USE_HI_DOF = 11617882012875573908
    THEFEED_FORCE_RENDER_ON = 11618180799823637500
    HUD_GET_WEAPON_WHEEL_TOP_SLOT = 11618885992809154578
    NETWORK_CAN_TEXT_CHAT_WITH_GAMER = 11623971990645271327
    IS_RADIO_RETUNING = 11624255977718632037
    IS_NETWORK_ID_OWNED_BY_PARTICIPANT = 11628427924148007647
    STAT_LOAD_PENDING = 11634222782993667681
    SET_FAKE_GPS_PLAYER_POSITION_THIS_FRAME = 11634914383042481429
    SET_HELI_BLADES_FULL_SPEED = 11635127903352186381
    SET_CARGOBOB_PICKUP_MAGNET_FALLOFF = 11636084368942912638
    FLASH_WANTED_DISPLAY = 11640392409260190239
    GET_VEHICLE_COLOURS = 11642990248343929260
    NETWORK_SPEND_GANGOPS_START_STRAND = 11645957309904088582
    IS_THIS_MODEL_AN_AMPHIBIOUS_QUADBIKE = 11649119110350402317
    ROPE_DRAW_ENABLED = 11650376164785061027
    NETWORK_GET_NUM_FOUND_GAMERS = 11650886927529875195
    HAS_CUT_FILE_LOADED = 11658014873199322670
    STOP_ALARM = 11658374460494404161
    SET_VEHICLE_DAMAGE = 11663533030030266153
    ATTACH_ENTITY_TO_CARGOBOB = 11663622593587027998
    UGC_CLEAR_MODIFY_RESULT = 11665976839065554032
    GET_PLAYER_UNDERWATER_TIME_REMAINING = 11672478003903903537
    GET_FINAL_RENDERED_CAM_COORD = 11673588752110908488
    DLC_CHECK_COMPAT_PACK_CONFIGURATION = 11678873001097585408
    DISABLE_HEAD_BLEND_PALETTE_COLOR = 11681230797825367810
    TASK_SWAP_WEAPON = 11681300754376708677
    SET_GAMEPLAY_VEHICLE_HINT = 11685009353825786926
    GET_PM_PLAYER_CREW_COLOR = 11689120523351033365
    END_REPLAY_STATS = 11690924755543172594
    GET_IS_VEHICLE_SHUNTING = 11692927322755575437
    SET_FLEEING_VEHICLES_USE_SWITCHED_OFF_NODES = 11693589762414217262
    CLEAR_RESTART_COORD_OVERRIDE = 11705257030375616377
    ANIMATED_SHAKE_CAM = 11706103286567630797
    SET_CAM_IS_INSIDE_VEHICLE = 11706670002120752258
    HAS_DIRECTOR_MODE_BEEN_LAUNCHED_BY_CODE = 11706966539473138702
    NETWORK_SESSION_FORCE_CANCEL_INVITE = 11714276010390935108
    SET_NETWORK_VEHICLE_MAX_POSITION_DELTA_MULTIPLIER = 11720344903059199196
    GET_VEHICLE_NODE_IS_GPS_ALLOWED = 11722408342446334902
    CLEAR_ALL_PICKUP_REWARD_TYPE_SUPPRESSION = 11727925286446975469
    GET_TIME_DIFFERENCE = 11729339369839329264
    GET_PED_WEAPON_CAMO_INDEX = 11730095978102264453
    CELL_CAM_ACTIVATE_SHALLOW_DOF_MODE = 11730960460953719204
    NETWORK_SET_DO_NOT_LAUNCH_FROM_JOIN_AS_MIGRATED_HOST = 11739126846226360525
    SET_VEHICLE_DOORS_LOCKED_FOR_ALL_PLAYERS = 11743148728654440396
    REQUEST_COMMERCE_ITEM_IMAGE = 11743507733356666187
    DETACH_CAM = 11743905585564462466
    LEADERBOARDS_READ_ANY_PENDING = 11754343700827837117
    NETWORK_GET_CAN_SPEND_FROM_BANK = 11754349537397533972
    IS_MOUNTED_WEAPON_TASK_UNDERNEATH_DRIVING_TASK = 11754657829532138043
    TRIGGER_SCREENBLUR_FADE_IN = 11756825268821131228
    GET_MISSION_FLAG = 11762519102602810782
    LEADERBOARDS_READ_CLEAR_ALL = 11766981029412162059
    RESTORE_PLAYER_STAMINA = 11768681773981695283
    TERRAINGRID_ACTIVATE = 11769762961958936165
    DATADICT_CREATE_DICT = 11770427483498950369
    OPEN_PATROL_ROUTE = 11775782035738541442
    SET_VEHICLE_WHEELS_CAN_BREAK_OFF_WHEN_BLOW_UP = 11780178925065548617
    GET_MAX_AMMO_IN_CLIP = 11785304485072036602
    SET_PED_SHOULD_PLAY_NORMAL_SCENARIO_EXIT = 11793002850566200216
    STOP_SOUND = 11795143047108103093
    DRAW_DEBUG_TEXT_2D = 11798074867750820495
    SHOW_NUMBER_ON_BLIP = 11799628222247225526
    END_BEING_BOSS = 11800899991608135378
    SET_PLAYER_PARACHUTE_TINT_INDEX = 11804186708958356965
    NETWORK_BUY_BACKUP_GANG = 11812337796177318841
    IS_PED_IN_VEHICLE = 11812460267229133275
    IS_MOBILE_PHONE_TO_PED_EAR = 11813881124880795328
    SEND_TU_SCRIPT_EVENT = 11821039991900145719
    NETWORK_GET_VC_WALLET_BALANCE = 11821839234496899253
    IS_NEW_LOAD_SCENE_ACTIVE = 11824770054270229381
    START_NETWORKED_PARTICLE_FX_NON_LOOPED_ON_PED_BONE = 11825162084267246287
    FORCE_CINEMATIC_RENDERING_THIS_UPDATE = 11825271136428513964
    SET_OVERRIDE_WEATHER = 11834717031454399471
    REGISTER_NOIR_LENS_EFFECT = 11839954009542385070
    SET_VEHICLE_CEILING_HEIGHT = 11845613838102143784
    GOLF_TRAIL_GET_VISUAL_CONTROL_POINT = 11846236626667239610
    SC_COMMUNITY_EVENT_IS_ACTIVE_BY_ID = 11846965926760098928
    SET_WEATHER_PTFX_USE_OVERRIDE_SETTINGS = 11847690765046516449
    STOP_STREAM = 11849403913525625169
    GOLF_TRAIL_GET_MAX_HEIGHT = 11853930920893677485
    GENERATE_VEHICLE_CREATION_POS_FROM_PATHS = 11854088970562390032
    HUD_GET_WEAPON_WHEEL_CURRENTLY_HIGHLIGHTED = 11856061474772694782
    SET_SPECIAL_ABILITY_MULTIPLIER = 11861428562303797943
    GET_SAVE_HOUSE_DETAILS_AFTER_SUCCESSFUL_LOAD = 11862488420260115036
    NETWORK_GET_NUM_CONNECTED_PLAYERS = 11864625272246502996
    NETWORK_CAP_EMPTY_CROWDING_VEHICLES_REMOVAL = 11865195855246088325
    HIDE_STREET_AND_CAR_NAMES_THIS_FRAME = 11880177133408043657
    CREATE_MOBILE_PHONE = 11883001152044989383
    SET_PED_AMMO_TO_DROP = 11884981361672827119
    GET_FOLLOW_VEHICLE_CAM_VIEW_MODE = 11889317863454124718
    SET_TEXT_LEADING = 11892524688486562559
    SET_PLAYER_VEHICLE_DAMAGE_MODIFIER = 11893462893929705228
    NETWORK_EARN_BEACH_PARTY_LOST_FOUND = 11894913579243880549
    SET_THIRD_PERSON_CAM_RELATIVE_PITCH_LIMITS_THIS_UPDATE = 11895908327409623521
    NETWORK_SPENT_TRADE_BUSINESS_PROPERTY = 11897112096471256954
    GOLF_TRAIL_SET_ENABLED = 11897467357575402158
    DISABLE_STUNT_JUMP_SET = 11900531937640925174
    SET_PED_NO_TIME_DELAY_BEFORE_SHOT = 11902259857859968532
    SET_PED_GENDER = 11904189438099079638
    SET_ENTITY_NO_COLLISION_ENTITY = 11907189013180015946
    SET_PED_COWER_HASH = 11910071655013453523
    SET_PLAYBACK_TO_USE_AI = 11910265865249128753
    GET_NUM_MOD_COLORS = 11912511502899890029
    TASK_GO_TO_COORD_AND_AIM_AT_HATED_ENTITIES_NEAR_COORD = 11913507004874961404
    CLEAR_AREA = 11920748883847386016
    GET_PLAYER_RADIO_STATION_GENRE = 11921478027720445163
    IS_USING_KEYBOARD_AND_MOUSE = 11921543228142303000
    SPAWNPOINTS_IS_SEARCH_COMPLETE = 11927497650722913723
    SET_VEHICLE_DOOR_LATCHED = 11937183589473234760
    GET_WAYPOINT_DISTANCE_ALONG_ROUTE = 11941128409463383191
    STAT_MIGRATE_SAVEGAME_START = 11945812917125553766
    IS_BLIP_FLASHING = 11953714324508692208
    DISPLAY_AMMO_THIS_FRAME = 11954677266752150613
    NETWORK_ADD_PED_TO_SYNCHRONISED_SCENE_WITH_IK = 11955647742749295682
    GET_PLAYER_INDEX = 11956428154230912141
    UGC_CREATE_MISSION = 11956990938096993543
    SET_AUDIO_SCRIPT_CLEANUP_TIME = 11958033039665568197
    ENABLE_ALL_CONTROL_ACTIONS = 11961536079038356967
    NETWORK_HOST_TRANSITION = 11964856732014588500
    GET_PED_HEAD_OVERLAY = 11965769224155712835
    SET_RADIO_TO_STATION_INDEX = 11968792548046558991
    IS_AREA_OCCUPIED = 11969246150199653742
    NETWORK_SPENT_BUY_OFFTHERADAR = 11973003527953275997
    DISPLAY_HUD = 11973181459913502762
    SPAWNPOINTS_GET_NUM_SEARCH_RESULTS = 11976691108123291586
    SET_CAM_SPLINE_NODE_VELOCITY_SCALE = 11977426473294180767
    STAT_LOAD = 11984435121915370726
    NET_GAMESERVER_BASKET_IS_ACTIVE = 11985600410337602086
    GET_ROOM_KEY_FOR_GAME_VIEWPORT = 11986146879237829712
    SET_PED_CLOTH_PRONE = 11988858139591784421
    SET_EXPLOSIVE_AMMO_THIS_FRAME = 11992085018254978299
    NETWORK_REQUEST_CONTROL_OF_NETWORK_ID = 11993283059155729360
    BEGIN_TAKE_HIGH_QUALITY_PHOTO = 11996522629490130333
    SET_MP_GAMER_TAGS_SHOULD_USE_VEHICLE_HEALTH = 11997479760391485169
    SC_INBOX_SEND_UGCSTATUPDATE_TO_RECIP_LIST = 12001315800923192070
    SET_NETWORK_ID_VISIBLE_IN_CUTSCENE = 12002801652188848820
    NETWORK_HAS_ROS_PRIVILEGE = 12004790651755954708
    DATAFILE_SELECT_UGC_DATA = 12005124007913019300
    ACTION_MANAGER_ENABLE_ACTION = 12006923410386814398
    NETWORK_GET_MAX_NUM_PARTICIPANTS = 12018154381697586670
    SET_VEHICLE_LIVERY2 = 12021137051077784176
    DOES_BLIP_EXIST = 12023247411461470170
    NETWORK_SPENT_BULL_SHARK = 12023912097099546924
    GET_NUMBER_OF_PED_PROP_TEXTURE_VARIATIONS = 12026847200020783473
    GET_ENTITY_SCRIPT = 12027359293266032456
    REQUEST_VEHICLE_HIGH_DETAIL_MODEL = 12027423328935770206
    DATAFILE_LOAD_OFFLINE_UGC_FOR_ADDITIONAL_DATA_FILE = 12028815608529821405
    RESET_PLAYER_STAMINA = 12029979906644123134
    PLAYSTATS_BW_BELLY_OF_THE_BEAST = 12030605211757852138
    REMOVE_DECALS_FROM_OBJECT_FACING = 12031075102061565004
    NETWORK_GET_STRING_BANK_BALANCE = 12031992549528836993
    NETWORK_SET_CUSTOM_ARENA_BALL_PARAMS = 12032752679422908025
    BYPASS_CAMERA_COLLISION_BUOYANCY_TEST_THIS_UPDATE = 12036198751708399698
    REMOVE_VEHICLE_WINDOW = 12038498450811400297
    GET_WANTED_LEVEL_TIME_TO_ESCAPE = 12043189406219501220
    GET_MAX_NUM_NETWORK_PICKUPS = 12044935504594353740
    IS_ORBIS_VERSION = 12045933518223659422
    CLEAR_ENTITY_LAST_DAMAGE_ENTITY = 12046242566872886458
    SET_DRIVER_AGGRESSIVENESS = 12047680995803024956
    REGISTER_INT64_TO_SAVE = 12048594911913791136
    NETWORK_SESSION_BLOCK_JOIN_REQUESTS = 12048931413310846915
    PLAYSTATS_JOB_LTS_END = 12049046000527327220
    UNLOAD_CLOUD_HAT = 12053887682083518484
    SET_SRL_TIME = 12054539833599911864
    VEHICLE_SET_PARACHUTE_MODEL_TINT_INDEX = 12054678540305090691
    NETWORK_SPENT_VEHICLE_EXPORT_MODS = 12059741881841115089
    FACEBOOK_DID_POST_SUCCEED = 12060124574396338498
    NETWORK_EARN_FROM_CLUB_MANAGEMENT_PARTICIPATION = 12060266423237121767
    STAT_STOP_RECORD_STAT = 12061155113903153725
    OVERRIDE_LODSCALE_THIS_FRAME = 12061583168054117262
    SC_GAMERDATA_GET_FLOAT = 12065364329591679685
    IS_VEHICLE_IN_SUBMARINE_MODE = 12069021430080709093
    UGC_GET_MOST_RECENTLY_CREATED_CONTENT = 12071383980299910526
    STAT_LOCAL_RESET_ALL_ONLINE_CHARACTER_STATS = 12072901167110216278
    SEETHROUGH_SET_FADE_STARTDISTANCE = 12073555032749902753
    WATER_OVERRIDE_SET_SHOREWAVEMAXAMPLITUDE = 12078955967429028918
    GET_NUM_DLC_VEHICLES = 12081019053034058395
    DOES_CAM_EXIST = 12081242549857203470
    REMOVE_PED_HELMET = 12083797222263021272
    UGC_GET_CONTENT_CATEGORY = 12086167294499908698
    GET_VEHICLE_MAX_NUMBER_OF_PASSENGERS = 12089054235866735952
    SET_REMOTE_PLAYER_AS_GHOST = 12089088540661242424
    SET_CAN_ADJUST_GROUND_CLEARANCE = 12095788224996223220
    NETWORK_OVERRIDE_COORDS_AND_HEADING = 12097528319082982729
    SET_WAYPOINT_OFF = 12098043896530100863
    GET_IS_RIGHT_VEHICLE_HEADLIGHT_DAMAGED = 12100247729950371616
    GET_TASK_MOVE_NETWORK_SIGNAL_BOOL = 12105599148477820775
    IS_PED_SITTING_IN_VEHICLE = 12108114641748692930
    SET_CAN_CLIMB_ON_ENTITY = 12108740162522121295
    GET_VEHICLE_ENVEFF_SCALE = 12116963156199523331
    NETWORK_EARN_ARENA_WAR_EVENT_CARGO = 12117314155315311193
    WATER_OVERRIDE_FADE_IN = 12124621612066658023
    DOOR_SYSTEM_SET_DOOR_OPEN_FOR_RACES = 12131045208726038865
    UNREGISTER_SCRIPT_WITH_AUDIO = 12133695624530130202
    IS_HUD_HIDDEN = 12133956090350482885
    END_TEXT_COMMAND_OVERRIDE_BUTTON_TEXT = 12135250013684502639
    STAT_CLEAR_PENDING_SAVES = 12138105244504849233
    STAT_SET_STRING = 12140335934556418519
    SET_GAMEPLAY_CAM_SHAKE_AMPLITUDE = 12141142277564455005
    SET_NETWORK_ID_ALWAYS_EXISTS_FOR_PLAYER = 12150751756953449322
    BLOCK_SPEECH_CONTEXT_GROUP = 12152915442233817467
    NETWORK_IS_PLATFORM_SUBSCRIPTION_CHECK_PENDING = 12154289904339298504
    LOCALIZATION_GET_SYSTEM_DATE_TYPE = 12154726862171804436
    SET_BLIP_ROTATION_WITH_FLOAT = 12157097598244662407
    VMAG2 = 12163849536751198296
    GET_WIND_SPEED = 12163972732459761426
    THEFEED_FLUSH_QUEUE = 12177085331921854394
    ADD_POINT_TO_GPS_MULTI_ROUTE = 12179168437209252891
    NETWORK_EARN_GANGOPS_SETUP = 12183934186288721144
    GET_VEHICLE_CAN_DEPLOY_PARACHUTE = 12183988986306711267
    SET_SWIM_MULTIPLIER_FOR_PLAYER = 12185736806130608659
    NETWORK_CLEAR_CHARACTER_WALLET = 12187267057479264501
    UGC_GET_CONTENT_IS_VERIFIED = 12187878134276475411
    STAT_GET_CURRENT_REAR_WHEEL_DISTANCE = 12196870491660689149
    START_SAVE_DATA = 12202326723784243607
    NETWORK_EARN_COLLECTABLES = 12203905402730514498
    NETWORK_SPENT_UPGRADE_WAREHOUSE_PROPERTY = 12204586191338022362
    ENABLE_EXTERIOR_CULL_MODEL_THIS_FRAME = 12213521933275342507
    NETWORK_CLAN_DOWNLOAD_MEMBERSHIP = 12216300199152257726
    DOES_SCRIPTED_COVER_POINT_EXIST_AT_COORDS = 12217014802665331249
    UPDATE_TASK_HANDS_UP_DURATION = 12218207504077932596
    NETWORK_EARN_GANGOPS_AWARD = 12223636310471008218
    DISABLE_PED_PAIN_AUDIO = 12223926206249021672
    SET_PED_IS_AVOIDED_BY_OTHERS = 12228990642838948842
    SET_PED_MONEY = 12234193376882508213
    THEFEED_IS_PAUSED = 12235151267021336592
    LEADERBOARDS2_READ_BY_ROW = 12235631355188516995
    DECOR_REGISTER_LOCK = 12236648430102876744
    ATAN = 12236695102160123491
    TASK_GOTO_ENTITY_AIMING = 12239175179009747986
    GET_SHOP_PED_OUTFIT_PROP_VARIANT = 12248034933198625979
    SET_DRAW_ORIGIN = 12249800829367284758
    ALLOW_PICKUP_BY_NONE_PARTICIPANT = 12251370303332670723
    REMOVE_WEAPON_ASSET = 12252305655226026236
    IS_VEHICLE_VISIBLE = 12252696799449023123
    SET_TRAIN_SPEED = 12253108332762994403
    IS_PED_ACTIVE_IN_SCENARIO = 12255244102459206851
    GET_VARIATION_CHOSEN_FOR_SCRIPTED_LINE = 12257097615618389348
    END_TEXT_COMMAND_THEFEED_POST_AWARD = 12261431993475881085
    SET_THIS_SCRIPT_CAN_BE_PAUSED = 12265866338236823471
    CLEAR_VEHICLE_PHONE_EXPLOSIVE_DEVICE = 12267651018428051999
    SET_BLIP_FLASH_INTERVAL = 12272831464067893886
    SEND_METRIC_VIP_POACH = 12272975286059631349
    SET_PED_DESIRED_HEADING = 12275263158295789168
    DELETE_CHILD_ROPE = 12276085912401926944
    TASK_STEALTH_KILL = 12276179632630664153
    SET_MAX_WANTED_LEVEL = 12276534250078405817
    NETWORK_GET_PREDICTED_VELOCITY = 12276724404982865479
    SET_DIP_STRAIGHT_DOWN_WHEN_CRASHING_PLANE = 12278284719034249376
    NETWORK_ACCESS_TUNABLE_BOOL = 12279706109914888026
    SET_IN_ARENA_MODE = 12279733542163593583
    NETWORK_SET_CURRENT_SPAWN_LOCATION_OPTION = 12280564469472708790
    RESET_PED_MOVEMENT_CLIPSET = 12282701622993938988
    ADJUST_AMBIENT_PED_SPAWN_DENSITIES_THIS_FRAME = 12283010728198929470
    GET_NUM_RESERVED_MISSION_OBJECTS = 12286301305332579010
    CLEAR_PED_TASKS_IMMEDIATELY = 12295758863867781272
    SET_NETWORK_CUTSCENE_ENTITIES = 12296326612917986391
    GET_DEFAULT_SECONDARY_TINT_FOR_BARBER = 12296695506270806088
    NETWORK_CLAN_GET_MEMBERSHIP_COUNT = 12299646607298380481
    SWITCH_TO_MULTI_FIRSTPART = 12300210255363577532
    SET_HUD_COMPONENT_POSITION = 12302461265122524397
    FORCE_CAM_FAR_CLIP = 12303098090079590963
    DRAW_DEBUG_SPHERE = 12310182876797576754
    SET_PED_PINNED_DOWN = 12310257172164331026
    SET_MOUSE_CURSOR_THIS_FRAME = 12315038331679700003
    GRASSBATCH_ENABLE_FLATTENING_EXT_IN_SPHERE = 12315584048234523051
    SET_VEHICLE_NOT_STEALABLE_AMBIENTLY = 12323029800733276846
    IS_EXPLOSION_IN_SPHERE = 12326212991055881347
    SET_EXPECTED_CLONE_NEXT_TASK_MOVE_NETWORK_STATE = 12327378395246671577
    SET_GOON_BOSS_VEHICLE = 12335903972203171049
    NETWORK_CAN_SPEND_MONEY = 12338924456736023770
    SET_VEHICLE_FORWARD_SPEED = 12345673040874251733
    BEGIN_SCALEFORM_MOVIE_METHOD_ON_FRONTEND = 12346832217046066118
    STOP_PED_SPEAKING_SYNCED = 12350983052834378864
    SKIP_TO_END_AND_STOP_PLAYBACK_RECORDED_VEHICLE = 12361869541218343043
    IS_THIS_MODEL_A_TRAIN = 12363314968004559403
    BEGIN_TEXT_COMMAND_BUSYSPINNER_ON = 12367304027125689791
    PLM_GET_CONSTRAINED_DURATION_MS = 12372226492937673586
    NETWORK_SESSION_VOICE_CONNECT_TO_PLAYER = 12382058436541365682
    ALLOW_DAMAGE_EVENTS_FOR_NON_NETWORKED_OBJECTS = 12383420467654872058
    DOES_TEXT_LABEL_EXIST = 12396662200215159378
    SET_PED_WETNESS = 12397201241077697250
    GIVE_PED_TO_PAUSE_MENU = 12397279322583338516
    SET_FOLLOW_VEHICLE_CAM_VIEW_MODE = 12404388335382335304
    DRAW_POLY = 12404726881981786193
    NETWORK_SPENT_BUY_TRUCK = 12404932123836500952
    CELL_CAM_SET_SELFIE_MODE_DISTANCE_SCALING = 12405323808628639260
    IS_PED_STILL = 12405487600806068608
    LEADERBOARDS_READ_PENDING = 12409999195844651714
    SET_WIND = 12410360263898470681
    GET_HELI_TAIL_BOOM_HEALTH = 12416865476924450295
    CLEAR_ENTITY_LAST_WEAPON_DAMAGE = 12423054505849681106
    REMOVE_PED_ELEGANTLY = 12424662107189803358
    RESET_DISPATCH_SPAWN_BLOCKING_AREAS = 12428806168733018741
    TASK_HELI_CHASE = 12430974951581855136
    NETWORK_HAS_PENDING_INVITE = 12433448579207833192
    NETWORK_EARN_CASINO_STORY_MISSION_REWARD = 12436106895940903058
    TASK_TOGGLE_DUCK = 12436233642443140600
    CONVERT_POSIX_TIME = 12436601963283015125
    SET_ENTITY_ALWAYS_PRERENDER = 12442619067061659273
    GET_VEHICLE_DEFAULT_HORN_IGNORE_MODS = 12445095905966123072
    NEW_LOAD_SCENE_START_SPHERE = 12452370149643997616
    NETWORK_SPENT_CALL_PLAYER = 12456518438408689532
    REMOVE_VEHICLE_ASSET = 12458814499592986293
    SET_PARTICLE_FX_CAM_INSIDE_NONPLAYER_VEHICLE = 12461019496964028086
    SET_EMITTER_RADIO_STATION = 12462994012102129927
    SET_LAST_DRIVEN_VEHICLE = 12464596404723171026
    START_PLAYER_TELEPORT = 12472139131140050910
    TELL_GROUP_PEDS_IN_AREA_TO_ATTACK = 12477180261841127913
    GET_NUM_DLC_WEAPON_COMPONENTS_SP = 12477920330437198875
    SET_PLANE_TURBULENCE_MULTIPLIER = 12478674817419047217
    NETWORK_IS_PLAYER_ON_BLOCKLIST = 12484865458510324472
    IS_MISSION_TRAIN = 12485754076329634812
    ALLOW_PLAYER_SWITCH_DESCENT = 12492949308869181049
    DATAFILE_WATCH_REQUEST_ID = 12495366615396551068
    SET_VARIABLE_ON_SOUND = 12496135779187878326
    IS_SUBTITLE_PREFERENCE_SWITCHED_ON = 12496834364523667620
    SET_ENTITY_AS_MISSION_ENTITY = 12498487530917625361
    FORCE_START_HIDDEN_EVASION = 12498560276991585554
    GET_VEHICLE_MAX_BRAKING = 12501576933583198148
    NETWORK_IS_IN_TUTORIAL_SESSION = 12511636424984419023
    SET_PED_RELATIONSHIP_GROUP_DEFAULT_HASH = 12516613898344307176
    NETWORK_GET_MUTE_COUNT_FOR_PLAYER = 12517049670368545419
    ONLY_CLEAN_UP_OBJECT_WHEN_OUT_OF_RANGE = 12519523221682229882
    HAS_THIS_ADDITIONAL_TEXT_LOADED = 12519732147037193660
    IS_POSITION_OCCUPIED = 12523920530176275245
    SET_ON_ISLAND_X_FOR_TAKEN_PHOTO = 12526307699588224088
    CALCULATE_TRAVEL_DISTANCE_BETWEEN_POINTS = 12527145474710610327
    PLAYSTATS_RACE_TO_POINT_MISSION_DONE = 12528201028562987284
    THEFEED_AUTO_POST_GAMETIPS_OFF = 12532813350900117478
    IS_PROP_LIGHT_OVERRIDEN = 12533663978943372550
    SET_CURRENT_PED_WEAPON = 12535367907453402124
    DETACH_VEHICLE_FROM_ANY_CARGOBOB = 12535697291456201007
    DISABLE_CINEMATIC_BONNET_CAMERA_THIS_UPDATE = 12537769756257640378
    TASK_STAND_GUARD = 12538918064706920080
    LEADERBOARDS2_WRITE_DATA = 12547598471139995209
    REMOVE_COVER_POINT = 12549417329207351061
    SET_BLIP_COORDS = 12550114335291799133
    SET_CAM_FAR_CLIP = 12551654390081779822
    GET_IS_VEHICLE_ENGINE_RUNNING = 12552068584028443438
    DELETE_ENTITY = 12555119163340016073
    END_TEXT_COMMAND_UNPARSED_SCALEFORM_STRING = 12560118625101213831
    PROCGRASS_ENABLE_CULLSPHERE = 12561028117532162662
    SET_PLAYER_MELEE_WEAPON_DEFENSE_MODIFIER = 12561668789842461922
    HIDE_TOMBSTONE = 12570104447996265863
    GET_HELI_TAIL_ROTOR_HEALTH = 12577683127534201996
    SET_PED_TO_RAGDOLL = 12581363652839441482
    SET_BLIP_PRIORITY = 12582997914019671161
    IS_PLAYBACK_USING_AI_GOING_ON_FOR_VEHICLE = 12585587717912215814
    UGC_GET_CONTENT_IS_USING_SC_NICKNAME = 12586321221152778404
    ASSISTED_MOVEMENT_CLOSE_ROUTE = 12591792016616722014
    NETWORK_DUMP_NET_IF_CONFIG = 12600820801389975267
    USE_SNOW_FOOT_VFX_WHEN_UNSHELTERED = 12604921234040708288
    NETWORK_HAVE_COMMUNICATION_PRIVILEGES = 12605373931461201532
    ARE_FOLDING_WINGS_DEPLOYED = 12605902328484345746
    DETACH_ENTITY_FROM_CARGOBOB = 12610924579888632134
    SET_PLAYER_RESERVE_PARACHUTE_TINT_INDEX = 12611425305903619896
    SET_MAPDATACULLBOX_ENABLED = 12615252212068267465
    SET_ROOM_FOR_GAME_VIEWPORT_BY_NAME = 12624868473407120449
    CREATE_VEHICLE = 12625226732244324784
    IS_WARNING_MESSAGE_READY_FOR_CONTROL = 12628684180558330810
    NETWORK_CAN_ACCESS_MULTIPLAYER = 12632836761044327332
    REQUEST_VEHICLE_RECORDING = 12632962730954637077
    SET_VEHICLE_DISABLE_COLLISION_UPON_CREATION = 12637354140334266410
    NETWORK_OVERRIDE_TRANSITION_CHAT = 12638795563565490793
    REPLAY_DISABLE_CAMERA_MOVEMENT_THIS_FRAME = 12639032320734114120
    IS_MINIMAP_RENDERING = 12643098531718812954
    CREATE_PATROL_ROUTE = 12648997531343132892
    SET_PED_MOVEMENT_CLIPSET = 12649086252934573039
    GET_PED_RESET_FLAG = 12654650622687834784
    ARE_PLAYER_FLASHING_STARS_ABOUT_TO_DROP = 12659484430345729257
    GET_ENTITY_ROTATION = 12663385257975586489
    DOES_PICKUP_EXIST = 12664626233909212369
    PLAYSTATS_CRATE_CREATED = 12666345229212282694
    SET_PED_UPPER_BODY_DAMAGE_ONLY = 12666786256047359923
    ROTATE_OBJECT = 12673778394683711050
    NETWORK_GET_MAX_FRIENDS = 12676420008678950866
    SET_BINK_MOVIE_VOLUME = 12678542322193343011
    DROP_AMBIENT_PROP = 12678883156603595794
    STAT_GET_CURRENT_SKYDIVING_DISTANCE = 12678889735550524622
    IS_PAUSE_MENU_ACTIVE = 12683062486377168843
    CLOSE_PATROL_ROUTE = 12701255580442479553
    SET_VEHICLE_FORCE_AFTERBURNER = 12706241441111445463
    NETWORK_GAMERTAG_FROM_HANDLE_PENDING = 12714192233854618864
    GET_IS_TASK_ACTIVE = 12715354110265278805
    NETWORK_HAS_ENTITY_BEEN_REGISTERED_WITH_THIS_THREAD = 12717375373840897957
    SET_DISABLE_SUPERDUMMY = 12720674040153828821
    SET_INCIDENT_REQUESTED_UNITS = 12721408736823327292
    SET_FLOATING_HELP_TEXT_TO_ENTITY = 12724001682988565056
    SET_CLOCK_DATE = 12724429943787777255
    IS_PED_EXCLUSIVE_DRIVER_OF_VEHICLE = 12726369798170340159
    SET_TASK_MOVE_NETWORK_SIGNAL_BOOL = 12729089900991484040
    IS_BOAT_ANCHORED = 12730851756176159138
    LOBBY_SET_AUTO_MULTIPLAYER = 12737705678694045795
    GET_INTERIOR_AT_COORDS = 12751933987834943939
    IS_VEHICLE_ON_ALL_WHEELS = 12755545563352728290
    IS_MP_TEXT_CHAT_TYPING = 12761142339698897569
    CASCADE_SHADOWS_SET_SHADOW_SAMPLE_TYPE = 12762520455654676786
    NETWORK_CLAN_PLAYER_IS_ACTIVE = 12764526802401857304
    REMOVE_EXTRA_CALMING_QUAD = 12764659564178582191
    SET_PED_CAN_RAGDOLL = 12765514099411209770
    REMOVE_POP_MULTIPLIER_AREA = 12765985615085675711
    DISABLE_FIRST_PERSON_CAMERA_WATER_CLIPPING_TEST_THIS_UPDATE = 12769987082907843376
    PLAY_MISSION_COMPLETE_AUDIO = 12770144453462408297
    SET_CAM_FOV = 12771105691888832583
    SET_PED_HAS_AI_BLIP_WITH_COLOUR = 12771587647444013624
    NETWORK_RETAIN_ACTIVITY_GROUP = 12771796116134273980
    SET_BLIP_FLASHES = 12773706319605124670
    IS_CINEMATIC_CAM_RENDERING = 12777102243323636200
    COMMIT_TO_LOADINGSCREEN_SELCTION = 12778812655719714715
    GIVE_PED_NM_MESSAGE = 12779210013242448987
    NETWORK_SPENT_AMMO_DROP = 12782021228171047291
    IS_ENTITY_ATTACHED_TO_ANY_PED = 12782111407971274001
    UNLOCK_MISSION_NEWS_STORY = 12782811667038416321
    IS_SCREEN_FADED_OUT = 12785665044532404610
    SET_ENTITY_CAN_ONLY_BE_DAMAGED_BY_ENTITY = 12789033567567803820
    NETWORK_SPENT_HANGAR_UTILITY_CHARGES = 12793252013506153322
    SET_PLAYER_TARGETING_MODE = 12794841531097256947
    SET_DRIVER_ABILITY = 12796415013332960707
    IS_ITEMSET_VALID = 12804272885229477803
    ROPE_CHANGE_SCRIPT_OWNER = 12805459340947862878
    GOLF_TRAIL_SET_FIXED_CONTROL_POINT = 12806833762798642646
    NETWORK_EARN_FROM_CRATE_DROP = 12811645408652589610
    IS_SPECIAL_ABILITY_ENABLED = 12813304981393175499
    STAT_COMMUNITY_SYNCH_IS_PENDING = 12813509627718268337
    NETWORK_SPENT_HANGAR_STAFF_CHARGES = 12822087269027841495
    GIVE_WEAPON_OBJECT_TO_PED = 12824669778194449591
    SET_BLIP_BRIGHT = 12827255829962061956
    SET_DRIVE_ARTICULATED_JOINT_WITH_INFLICTOR = 12828561434140838038
    IS_DAMAGE_TRACKER_ACTIVE_ON_PLAYER = 12828831324739458143
    SET_SPECIAL_ABILITY_MP = 12832115919238461466
    GET_DISPLAY_NAME_FROM_VEHICLE_MODEL = 12832350468514893849
    NETWORK_SPENT_PROSTITUTES = 12834002540298946462
    GET_CAM_SPLINE_NODE_INDEX = 12838381411535099558
    NET_GAMESERVER_IS_SESSION_VALID = 12848498453233286558
    SET_DEPLOY_FOLDING_WINGS = 12849298272314504228
    TRACK_OBJECT_VISIBILITY = 12849539409712928291
    DESTROY_TRACKED_POINT = 12852649963575233090
    ALLOW_AMBIENT_VEHICLES_TO_AVOID_ADVERSE_CONDITIONS = 12854615646716077963
    PLAYSTATS_DJ_USAGE = 12857608738871383847
    GET_CHARACTER_FROM_AUDIO_CONVERSATION_FILENAME_WITH_BYTE_LIMIT = 12860457834078406085
    SET_PED_CAN_BE_KNOCKED_OFF_BIKE = 12862971704959467875
    GIVE_DELAYED_WEAPON_TO_PED = 12863085853907369077
    SET_FORCE_LOW_LOD_ANCHOR_MODE = 12865411832137766901
    GET_RADIO_STATION_NAME = 12866443377061439673
    TASK_GO_TO_COORD_WHILE_AIMING_AT_ENTITY = 12871679457162276423
    BUSYSPINNER_IS_DISPLAYING = 12872856395699497419
    SPAWNPOINTS_START_SEARCH_IN_ANGLED_AREA = 12875774850951477807
    IS_PED_DOING_DRIVEBY = 12880443145480368831
    SET_PLAYER_SNEAKING_NOISE_MULTIPLIER = 12880755172382995580
    CAN_SET_EXIT_STATE_FOR_CAMERA = 12883616598381802528
    NETWORK_EARN_FROM_JOB = 12883752032968542872
    GET_LAST_DRIVEN_VEHICLE = 12884921330753189239
    SET_ENTITY_FLAG_RENDER_SMALL_SHADOW = 12885007326478503514
    SET_CLEAR_FREEZE_WAITING_ON_COLLISION_ONCE_PLAYER_ENTERS = 12889514161342329330
    GET_SCREEN_ASPECT_RATIO = 12892654320168440041
    ADD_DECAL = 12898912183395138989
    CLEAR_PLAYER_WANTED_LEVEL = 12898964665736385689
    NETWORK_SET_SCRIPT_AUTOMUTED = 12901101999872671775
    CLEAR_ALL_BROKEN_GLASS = 12907890408356333843
    STAT_SET_INT = 12909319269763101761
    GET_ENTITY_BONE_COUNT = 12909811064680103963
    SET_PED_HEALTH_PENDING_LAST_DAMAGE_EVENT_OVERRIDE_FLAG = 12913278090757507551
    GET_BASE_ELEMENT_LOCATION_FROM_METADATA_BLOCK = 12913499504156456060
    TASK_PARACHUTE_TO_TARGET = 12915805977192419386
    IS_ENTITY_ATTACHED = 12918091122985027735
    IS_MOBILE_PHONE_RADIO_ACTIVE = 12924461877893738878
    CLEAR_ROOM_FOR_ENTITY = 12927015435217928103
    NETWORK_WAITING_POP_CLEAR_TUTORIAL_SESSION = 12933861397624310395
    SET_VEHICLE_LIGHT_MULTIPLIER = 12935821712570840444
    TASK_HELI_ESCORT_HELI = 12935835884309672464
    GET_VEHICLE_MOD_VARIATION = 12939491323657885148
    SET_RADIO_TRACK = 12940960428246098699
    SET_CAN_ATTACK_FRIENDLY = 12948353830549571421
    SET_RANDOM_VEHICLE_DENSITY_MULTIPLIER_THIS_FRAME = 12948752261143492563
    SET_MOTIONBLUR_MAX_VEL_SCALER = 12954113891772397274
    GET_PLAYER_SWITCH_TYPE = 12954967789100899938
    GET_WEAPON_COMPONENT_HUD_STATS = 12955435042151262712
    GET_OWNER_OF_EXPLOSION_IN_SPHERE = 12956101742097265014
    CLEAR_TACTICAL_NAV_MESH_POINTS = 12956109339009853522
    STAT_ROLLBACK_SAVE_MIGRATION = 12959712686925057581
    WATER_OVERRIDE_SET_OCEANWAVEMAXAMPLITUDE = 12963108010627120770
    GET_WEAPON_OBJECT_COMPONENT_TINT_INDEX = 12964262346989061707
    GET_PICKUP_GENERATION_RANGE_MULTIPLIER = 12964920343290966388
    GET_VEHICLE_WHEEL_TYPE = 12965049668393645788
    NETWORK_CLAN_ANY_DOWNLOAD_MEMBERSHIP_PENDING = 12967633998624007287
    GET_COMMERCE_ITEM_NAME = 12981362673567326024
    SET_PARTICLE_FX_LOOPED_SCALE = 12989032969121712429
    GET_VEHICLE_MOD_COLOR_1_NAME = 12993031946558755724
    SET_LAW_RESPONSE_DELAY_OVERRIDE = 12997106438076901286
    SET_PROFILE_SETTING_PROLOGUE_COMPLETE = 13003566115280473445
    SET_CAN_PED_SELECT_INVENTORY_WEAPON = 13003892800235661540
    PLAYSTATS_ARENA_WARS_ENDED = 13004665027390217157
    STOP_ANY_PED_MODEL_BEING_SUPPRESSED = 13005217458194956495
    GET_RAYFIRE_MAP_OBJECT = 13010845278157745746
    IS_VEHICLE_STUCK_ON_ROOF = 13013133991342886879
    NETWORK_SPENT_PA_SERVICE_DANCER = 13015062152416317535
    GET_MOBILE_PHONE_RENDER_ID = 13016878493316378529
    NETWORK_SESSION_CHANGE_SLOTS = 13018571294932118702
    CREATE_RANDOM_PED = 13018918117347950223
    REMOVE_PORTAL_SETTINGS_OVERRIDE = 13023281597564293675
    NETWORK_SPENT_PURCHASE_OFFICE_GARAGE = 13025232858614220622
    GET_LIVERY_NAME = 13026566506111638047
    SET_PED_SHOOT_ORDNANCE_WEAPON = 13026898851905159710
    VEH_TO_NET = 13027019417800884636
    NETWORK_EARN_NIGHTCLUB_DANCING = 13033046133144693453
    SET_GAMEPLAY_CAM_RELATIVE_HEADING = 13036833585655820785
    ANIMPOSTFX_STOP_ALL = 13037318497635138437
    GET_TASK_MOVE_NETWORK_EVENT = 13039172250820257356
    CANCEL_ALL_POLICE_REPORTS = 13040471442308772207
    NETWORK_GET_PRIMARY_CLAN_DATA_PENDING = 13044480298453208295
    GET_RANDOM_VEHICLE_BACK_BUMPER_IN_SPHERE = 13044685025472194780
    IS_THIS_MODEL_A_BIKE = 13045814370742226564
    CLEAR_PED_SCUBA_GEAR_VARIATION = 13046563961801475244
    CREATE_CAM_WITH_PARAMS = 13047372873132765537
    SET_CREDITS_FADE_OUT_WITH_SCREEN = 13050194468614014604
    GET_CAM_SPLINE_PHASE = 13057235177729052826
    NETWORK_EARN_FROM_VEHICLE = 13058676996217695480
    SET_NO_DUCKING_FOR_CONVERSATION = 13061246563229938192
    SET_PED_WETNESS_ENABLED_THIS_FRAME = 13062794386943062041
    SET_BLIP_MARKER_LONG_DISTANCE = 13065666665620711404
    SET_LOCK_ADAPTIVE_DOF_DISTANCE = 13072247808449217444
    CAN_REQUEST_ASSETS_FOR_CUTSCENE_ENTITY = 13072748828914211275
    NETWORK_CAN_VIEW_GAMER_USER_CONTENT = 13076845094687292647
    CLEAR_REMINDER_MESSAGE = 13077764844387541711
    SET_VEHICLE_CHEAT_POWER_INCREASE = 13086980938857091803
    INIT_CREATOR_BUDGET = 13088827437700724874
    NETWORK_SPEND_ARCADE_MGMT = 13093527779176919198
    SET_IS_OBJECT_BALL = 13094062140187034693
    SET_VEHICLE_TYRE_SMOKE_COLOR = 13094920670137621519
    SET_VEHICLE_EXCLUSIVE_DRIVER = 13097905143211908739
    IS_VEHICLE_SIREN_AUDIO_ON = 13099916866306466688
    NETWORK_SESSION_IS_VOICE_SESSION_ACTIVE = 13101891867505943848
    SET_VEHICLE_INDICATOR_LIGHTS = 13102187807342558704
    GET_IDEAL_PLAYER_SWITCH_TYPE = 13103137814654094853
    SET_DECISION_MAKER = 13115786772067832046
    TRIGGER_COMMERCE_DATA_FETCH = 13116424730110740850
    GET_CAM_FAR_CLIP = 13117469482393839274
    RESERVE_NETWORK_MISSION_PEDS = 13118963330556613487
    GET_SAFE_COORD_FOR_PED = 13122520127042066890
    WAYPOINT_RECORDING_GET_CLOSEST_WAYPOINT = 13126201362803033967
    GET_VEHICLE_TYRE_SMOKE_COLOR = 13129463142448411587
    IS_ENTITY_IN_ZONE = 13134252393473667185
    GET_VEHICLE_CUSTOM_PRIMARY_COLOUR = 13136141173969739602
    IS_AUDIO_SCENE_ACTIVE = 13140202257820324389
    LOAD_MOVIE_MESH_SET = 13141613960760453361
    SET_VEHICLE_DOORS_LOCKED = 13142674893052018598
    END_TEXT_COMMAND_THEFEED_POST_VERSUS_TU = 13152510946485217686
    SET_USE_DESIRED_Z_CRUISE_SPEED_FOR_LANDING = 13154164555674449549
    NETWORK_REQUEST_CONTROL_OF_ENTITY = 13155885047170474823
    THEFEED_REPORT_LOGO_OFF = 13156671256699709934
    GET_PLAYERS_LAST_VEHICLE = 13157682470943312064
    SET_MICROPHONE_POSITION = 13163618112166545250
    DATADICT_GET_DICT = 13166798819796250338
    REMOVE_RELATIONSHIP_GROUP = 13166876337920097698
    SET_SYNCHRONIZED_SCENE_RATE = 13169826626972244573
    TASK_CLIMB_LADDER = 13171208089415333908
    DOOR_SYSTEM_SET_OPEN_RATIO = 13179498064365429932
    GET_OBJECT_FRAGMENT_DAMAGE_HEALTH = 13185410543173567894
    PLAY_STREAM_FROM_VEHICLE = 13187512395955731962
    GET_PLAYER_INVINCIBLE = 13195995625634897415
    PLAYSTATS_COPY_RANK_INTO_NEW_SLOT = 13197090220221047050
    ADD_VEHICLE_UPSIDEDOWN_CHECK = 13199530267293122651
    SET_ENTITY_AS_NO_LONGER_NEEDED = 13201920304224023247
    ROPE_SET_REFFRAMEVELOCITY_COLLIDERORDER = 13205670342611007504
    UGC_GET_CREATORS_BY_USER_ID = 13206473902398808617
    GET_VEHICLE_EXTRA_COLOUR_6 = 13214509638265019391
    SET_VEHICLE_BODY_HEALTH = 13221730319678876379
    SPAWNPOINTS_GET_SEARCH_RESULT_FLAGS = 13223404287353338581
    GET_SHOP_PED_OUTFIT = 13228515175478630301
    VDIST2 = 13233308750539886151
    SPECIAL_ABILITY_CHARGE_ABSOLUTE = 13236227802081120397
    SET_COP_BLIP_SPRITE_AS_STANDARD = 13238457900890112280
    CLEAR_EXTENDED_PICKUP_PROBE_AREAS = 13242509316276184474
    NETWORK_FORCE_LOCAL_PLAYER_SCAR_SYNC = 13242824453876101195
    UNPATCH_DECAL_DIFFUSE_MAP = 13253373268039149085
    SET_PARTICLE_FX_NON_LOOPED_SCALE = 13253909332277308362
    IS_PED_WEAPON_READY_TO_SHOOT = 13262153763314100041
    REQUEST_NAMED_PTFX_ASSET = 13262405284139535030
    SET_CUTSCENE_ORIGIN = 13263861752237510439
    SHOW_OUTLINE_INDICATOR_ON_BLIP = 13264885120101131473
    ENABLE_STUNT_JUMP_AUDIO = 13266743810898358267
    SET_VEHICLE_DOORS_LOCKED_FOR_TEAM = 13267443194257140648
    UGC_GET_GET_BY_CONTENT_IDS = 13272722639618472998
    NETWORK_EARN_TUNER_AWARD = 13278570240187903478
    SET_HD_AREA = 13285379626243450741
    ADD_TACTICAL_NAV_MESH_POINT = 13290707474624298998
    BEGIN_TEXT_COMMAND_PRINT = 13292998748565841533
    DISABLE_PLAYER_THROW_GRENADE_WHILE_USING_GUN = 13296179899875993181
    SET_TASK_VEHICLE_GOTO_PLANE_MIN_HEIGHT_ABOVE_TERRAIN = 13300010810241450331
    SET_SCRIPT_GFX_ALIGN = 13305974099546635958
    IS_PED_SHELTERED = 13309595166979716528
    START_NEW_SCRIPT_WITH_ARGS = 13311091582424151521
    STOP_CURRENT_PLAYING_AMBIENT_SPEECH = 13312289524232936207
    IS_JAPANESE_VERSION = 13312846613327609267
    NETWORK_IS_PLAYER_ACTIVE = 13321598277342454069
    IS_VEHICLE_DOOR_DAMAGED = 13322071994783909159
    CAN_CREATE_RANDOM_DRIVER = 13324908736320727416
    IS_PLAYING_PHONE_GESTURE_ANIM = 13324939540337036304
    TASK_GO_TO_COORD_ANY_MEANS_EXTRA_PARAMS_WITH_CRUISE_SPEED = 13325260827509029634
    GET_VEHICLE_HEALTH_PERCENTAGE = 13325976614562141097
    WATER_OVERRIDE_SET_SHOREWAVEAMPLITUDE = 13328542380663746934
    SET_VEHICLE_KEEP_ENGINE_ON_WHEN_ABANDONED = 13329468185524349364
    REMOVE_PARTICLE_FX_FROM_ENTITY = 13330284274827555877
    START_VEHICLE_ALARM = 13330508336945546053
    GET_VEHICLE_LIGHTS_STATE = 13338338421850755375
    NETWORK_SESSION_LEAVE = 13345601690847697073
    SET_CREDITS_ACTIVE = 13346619697735426572
    SET_VEHICLE_NEON_INDEX_COLOUR = 13347306347645139409
    BEGIN_SCALEFORM_MOVIE_METHOD_ON_FRONTEND_HEADER = 13349962621701283484
    IS_PED_HELMET_VISOR_UP = 13351322298792467244
    SET_CARJACK_MISSION_REMOVAL_PARAMETERS = 13354897360535157211
    SET_DEEP_OCEAN_SCALER = 13360773722244290431
    IS_PED_HUMAN = 13366690418504398749
    SET_THIS_SCRIPT_CAN_REMOVE_BLIPS_CREATED_BY_ANY_SCRIPT = 13367306888133146775
    WATER_OVERRIDE_SET_RIPPLEDISTURB = 13368176821713515478
    RESET_GLOBAL_ACTIONSCRIPT_FLAG = 13374651088496090921
    LEADERBOARDS_CACHE_DATA_ROW = 13383318079891653357
    SET_HELP_MESSAGE_STYLE = 13385651071679847546
    PLAY_SYNCHRONIZED_MAP_ENTITY_ANIM = 13386181702782614468
    GET_IS_USING_FPS_THIRD_PERSON_COVER = 13388954822730783729
    NETWORK_SESSION_HOST_FRIENDS_ONLY = 13389151640189635971
    RESET_WANTED_LEVEL_DIFFICULTY = 13389445341602988509
    SET_CHECKPOINT_RGBA2 = 13396591030873621888
    SET_AUDIO_FLAG = 13398162446994666074
    NETWORK_SPEND_SET_COMMON_FIELDS = 13400359988318075466
    FORCE_PARTICLE_FX_IN_VEHICLE_INTERIOR = 13403037783925019849
    SET_CUTSCENE_PED_COMPONENT_VARIATION = 13403248738641624009
    NETWORK_EARN_FIXER_FINALE = 13408697630087598568
    IS_VEHICLE_TYRE_BURST = 13414279665309277353
    LEADERBOARDS2_READ_BY_RANK = 13415235588138288282
    SET_PARTICLE_FX_FOOT_OVERRIDE_NAME = 13419910228775246459
    SET_HIDOF_OVERRIDE = 13419994135530749653
    NETWORK_SESSION_IS_VISIBLE = 13421128661309933930
    ACTIVITY_FEED_ONLINE_PLAYED_WITH_POST = 13423978711272084817
    SET_ZONE_ENABLED = 13429398643585996305
    IS_PED_DEFENSIVE_AREA_ACTIVE = 13430818199855768135
    GET_POS_FROM_FIRED_EVENT = 13431258268292603555
    EXPLODE_VEHICLE = 13434538314134409548
    SCALEFORM_MOVIE_METHOD_ADD_PARAM_TEXTURE_NAME_STRING = 13434598638770258789
    PLAYSTATS_PROP_CHANGE = 13435255206363649767
    SUPPRESS_FRONTEND_RENDERING_THIS_FRAME = 13435670785628967510
    NETWORK_SET_OBJECT_SCOPE_DISTANCE = 13438472422450417335
    REGISTER_PEDHEADSHOT_HIRES = 13440999277212607765
    FORCE_OFF_WANTED_STAR_FLASH = 13442512345701483237
    GET_IS_BOAT_CAPSIZED = 13443755358914255277
    UGC_CLEAR_QUERY_RESULTS = 13444996727801969253
    STAT_GET_CURRENT_DRIVE_NOCRASH_DISTANCE = 13445296355555802501
    NETWORK_ARE_SOCIAL_CLUB_POLICIES_CURRENT = 13445344229290641615
    SET_VEHICLE_MAX_SPEED = 13447825130553031686
    PLAYSTATS_FM_EVENT_ATOB = 13448575633841220584
    SET_TV_CHANNEL = 13451050475020240974
    NETWORK_SET_VOICE_ACTIVE = 13456414728902526331
    GET_CAM_COORD = 13456818321258898862
    STOP_AUDIO_SCENES = 13459003645209002401
    NETWORK_IS_FRIEND_INDEX_ONLINE = 13463777872942745633
    THEFEED_SET_SNAP_FEED_ITEM_POSITIONS = 13467163360803175216
    GET_SAFE_ZONE_SIZE = 13470556441847568368
    SET_PED_CAN_PLAY_GESTURE_ANIMS = 13470842991174582308
    UGC_GET_CONTENT_PATH = 13472160667485916179
    SET_PED_AS_COP = 13475829523936935933
    GET_EXTRA_TCMODIFIER = 13476221356207065453
    IS_PED_GETTING_INTO_A_VEHICLE = 13476506400098240398
    UPDATE_TASK_SWEEP_AIM_POSITION = 13479388600682422212
    SET_VEHICLE_USES_MP_PLAYER_DAMAGE_MULTIPLIER = 13484678589808760959
    GET_PED_IN_VEHICLE_SEAT = 13493027623591629670
    GET_LOCAL_PLAYER_AIM_STATE = 13493259179427234439
    NETWORK_CLAN_REMOTE_MEMBERSHIPS_ARE_IN_CACHE = 13505855403104691890
    SET_VEHICLE_RADIO_LOUD = 13506045344488295374
    SET_FOCUS_POS_AND_VEL = 13507514344510389797
    SET_MOBILE_PHONE_ROTATION = 13508437185511549029
    RESET_PED_LAST_VEHICLE = 13514714034352281787
    SC_INBOX_GET_MESSAGE_TYPE_AT_INDEX = 13514917029022889668
    SET_PARTICLE_FX_BULLET_IMPACT_LODRANGE_SCALE = 13515550063721294629
    TASK_WANDER_STANDARD = 13518926983824632347
    PLAYSTATS_ROBBERY_FINALE = 13521314515398606660
    GET_GPS_BLIP_ROUTE_LENGTH = 13525536997791804037
    STAT_SAVE_PENDING_OR_REQUESTED = 13526188748229557923
    IS_CINEMATIC_CAM_SHAKING = 13528970971632434954
    GET_CLOCK_MONTH = 13530826567613306785
    IS_PED_FLEEING = 13532437319132349570
    TO_FLOAT = 13536264826763565705
    NETWORK_CONCEAL_PLAYER = 13537546024259851782
    ADD_STUNT_JUMP_ANGLED = 13539465364927548607
    SET_MISSION_TRAIN_AS_NO_LONGER_NEEDED = 13539901319752752104
    SET_CURRENT_PLAYER_TCMODIFIER = 13543212342515224043
    GET_PLAYER_RECEIVED_BATTLE_EVENT_RECENTLY = 13548890130111313158
    ROPE_ATTACH_VIRTUAL_BOUND_GEOM = 13550458828441540176
    SET_PED_GET_OUT_UPSIDE_DOWN_VEHICLE = 13551007203705785282
    SC_HAS_NEW_ROCKSTAR_MSG = 13554930057724333422
    NETWORK_HASH_FROM_PLAYER_HANDLE = 13555120810802113541
    SET_VEHICLE_INTERIORLIGHT = 13555908479372192467
    END_TEXT_COMMAND_SET_BLIP_NAME = 13562788859053587611
    SET_LIGHTS_CUTOFF_DISTANCE_TWEAK = 13563938658184407814
    IS_HUD_COMPONENT_ACTIVE = 13568394209825573901
    IS_INTERIOR_DISABLED = 13569650953496943893
    NETWORK_EARN_CARCLUB_MEMBERSHIP = 13574455628198874670
    IS_INTERIOR_SCENE = 13579115764212553037
    IS_HELI_PART_BROKEN = 13579677505201859722
    CAN_USE_WEAPON_ON_PARACHUTE = 13581701627098144628
    PLAYSTATS_MATCH_STARTED = 13583105163036663357
    FORCE_CLEANUP = 13585534833047170385
    GET_BLIP_FROM_ENTITY = 13586724326735280104
    UPDATE_WANTED_POSITION_THIS_FRAME = 13588645173305190651
    IS_STREAMVOL_ACTIVE = 13589651095095073964
    PLAY_PAIN = 13590422653806206188
    GET_VEHICLE_HAS_PARACHUTE = 13591018391803054927
    DISABLE_PLAYER_HEALTH_RECHARGE = 13596477513821136486
    NETWORK_EARN_TUNER_ROBBERY = 13597042531695307873
    CAN_REGISTER_MISSION_PEDS = 13600677290276411265
    SET_CARGOBOB_PICKUP_MAGNET_STRENGTH = 13600815474373564898
    SET_VARIABLE_ON_SYNCH_SCENE_AUDIO = 13601609279912048264
    GET_DOES_VEHICLE_HAVE_DAMAGE_DECALS = 13608840237274767006
    SET_PLAYERS_LAST_VEHICLE = 13609750184128445290
    SET_CUTSCENES_WEAPON_FLASHLIGHT_ON_THIS_FRAME = 13611449512695413423
    PHONEPHOTOEDITOR_IS_ACTIVE = 13613730802488418646
    DETACH_ROPE_FROM_ENTITY = 13615228748778988669
    SET_FIRST_PERSON_AIM_CAM_RELATIVE_PITCH_LIMITS_THIS_UPDATE = 13617868421263211504
    SET_PLAYER_WEAPON_MINIGUN_DEFENSE_MODIFIER = 13618298056193550300
    REQUEST_SCALEFORM_MOVIE_SKIP_RENDER_WHILE_PAUSED = 13620791902492182722
    NETWORK_CACHE_LOCAL_PLAYER_HEAD_BLEND_DATA = 13622228612230408897
    NETWORK_SPENT_PURCHASE_WAREHOUSE_PROPERTY = 13623102062608316794
    SET_RADAR_ZOOM_PRECISE = 13624169452525634359
    END_TEXT_COMMAND_BUSYSPINNER_ON = 13624224649877445044
    TASK_USE_MOBILE_PHONE = 13630864193301112795
    SET_BOAT_WRECKED = 13633210168762965458
    NET_GAMESERVER_CATALOG_ITEM_IS_VALID = 13640698138777941559
    NETWORK_IS_NP_AVAILABLE = 13642631721288926615
    DISABLE_SWITCH_OUTRO_FX = 13646007536612586427
    LOAD_ALL_OBJECTS_NOW = 13649993082112101183
    GET_ENTITY_BONE_OBJECT_ROTATION = 13658628585779162110
    SET_AMBIENT_ZONE_STATE = 13664060191501999686
    TASK_PATROL = 13665574152449359438
    NETWORK_SESSION_IS_DISPLAYING_INVITE_CONFIRMATION = 13670387069751194504
    NET_TO_PED = 13676752553518992190
    SET_PLAYER_TCMODIFIER_TRANSITION = 13685180278807499268
    STOP_CAM_SHAKING = 13685584137032321731
    SET_GRASS_CULL_SPHERE = 13698119011954473204
    GET_ANIM_INITIAL_OFFSET_POSITION = 13700709201249353792
    SET_STREAMED_TEXTURE_DICT_AS_NO_LONGER_NEEDED = 13703517772758820869
    CLEAR_AREA_OF_PEDS = 13705013785195228249
    ADD_BLIP_FOR_PICKUP = 13705460156381510966
    STAT_IS_STATS_TRACKING_ENABLED = 13708308589074815044
    NETWORK_SESSION_DO_ACTIVITY_QUICKMATCH = 13708452016629279618
    THEFEED_REMOVE_ITEM = 13709960893284214311
    TRANSFORM_TO_SUBMARINE = 13712481544041852606
    PLAYSTATS_SPENT_PI_CUSTOM_LOADOUT = 13713631333510798987
    SET_CG_AT_BOUNDCENTER = 13714038759131939103
    SET_VEHICLE_WILL_FORCE_OTHER_VEHICLES_TO_STOP = 13716858724054929397
    SET_TEXT_COLOUR = 13721100270610396226
    SET_VEHICLE_INDIVIDUAL_DOORS_LOCKED = 13722593684471962573
    SET_BLIP_AS_SHORT_RANGE = 13730319670167370610
    GET_ENTITY_PROOFS = 13730588776204058303
    GET_BLIP_INFO_ID_TYPE = 13734581770745051035
    SET_SRL_READAHEAD_TIMES = 13741284702225495386
    CLEAR_TV_CHANNEL_PLAYLIST = 13741560447150080960
    ACTIVATE_DAMAGE_TRACKER_ON_PLAYER = 13745128380597845210
    GIVE_ACHIEVEMENT_TO_PLAYER = 13746964553983525269
    REMAP_LODSCALE_RANGE_THIS_FRAME = 13751963975671628051
    STAT_COMMUNITY_GET_HISTORY = 13752292769533324567
    DATAFILE_IS_SAVE_PENDING = 13752751532590934223
    SET_SKIP_MINIGUN_SPIN_UP_AUDIO = 13759423876992128477
    UGC_GET_CONTENT_NAME = 13765666134840489346
    GIVE_WEAPON_TO_PED = 13767458866752540619
    TASK_PLANE_LAND = 13770162815871300288
    SET_ROADS_IN_AREA = 13770424549976125422
    SET_PED_CAN_BE_TARGETTED_BY_TEAM = 13771065895300730668
    NETWORK_LEAVE_PED_BEHIND_BEFORE_CUTSCENE = 13772817945428814183
    SET_RELATIONSHIP_BETWEEN_GROUPS = 13773674009954236333
    SET_MOBILE_PHONE_RADIO_STATE = 13774378573840577503
    SET_PED_ENVEFF_SCALE = 13774630443272451425
    PLAYSTATS_MISSION_ENDED = 13778513276289815293
    USE_FOOTSTEP_SCRIPT_SWEETENERS = 13784886756864773626
    DRAW_HUD_OVER_FADE_THIS_FRAME = 13785294882117687052
    LEADERBOARDS_GET_COLUMN_TYPE = 13785500072013239507
    SET_NEXT_PLAYER_TCMODIFIER = 13788175408801174833
    IS_CODE_GAMEPLAY_HINT_ACTIVE = 13795248093864063013
    START_SAVE_STRUCT_WITH_SIZE = 13795499829391780573
    NETWORK_SPEND_HIDDEN = 13801162006392247463
    IS_THIS_MODEL_A_BICYCLE = 13804902037466111698
    START_FIRING_AMNESTY = 13806865574565084744
    SC_CACHE_NEW_ROCKSTAR_MSGS = 13808218334375472253
    DOES_OBJECT_OF_TYPE_EXIST_AT_COORDS = 13809318694034547007
    PLAYSTATS_FM_EVENT_VEHICLETARGET = 13812499786099967403
    GET_VEHICLE_MODEL_MAX_BRAKING_MAX_MODS = 13815420397991984831
    SET_CAM_PARAMS = 13823924928455167674
    SET_VEHICLE_NAME_DEBUG = 13825936842566056271
    SHOOT_SINGLE_BULLET_BETWEEN_COORDS_IGNORE_ENTITY_NEW = 13827587348164445770
    CREATE_FAKE_MP_GAMER_TAG = 13830522785006309397
    SET_PICKUP_TRACK_DAMAGE_EVENTS = 13834587114238901468
    NET_TO_ENT = 13834683421016262986
    UGC_GET_ROOT_CONTENT_ID = 13841599513800606536
    STATS_COMPLETED_CHARACTER_CREATION = 13843260897124736602
    NETWORK_IS_DOOR_NETWORKED = 13843665009790169926
    IS_PED_SWIMMING_UNDER_WATER = 13845339151829380916
    IS_MODEL_VALID = 13846715278875188882
    SET_TEXT_CENTRE = 13848372864960272523
    PLAYSTATS_MISSION_VOTE = 13852979185079953563
    GOLF_TRAIL_SET_FIXED_CONTROL_POINT_ENABLE = 13853471602805276254
    GET_ENTRY_POINT_POSITION = 13859591633263918499
    REGISTER_SAVE_HOUSE = 13866949435125058132
    GET_ENTITY_INDEX_OF_REGISTERED_ENTITY = 13867737904326268109
    NETWORK_GET_PRIMARY_CLAN_DATA_NEW = 13871367663892971994
    GET_DLC_VEHICLE_MOD_LOCK_HASH = 13877984106848006143
    FORCE_GAME_STATE_PLAYING = 13883001127662981965
    DATAARRAY_GET_FLOAT = 13890552284671627189
    NETWORK_IS_PUSH_TO_TALK_ACTIVE = 13894360218093106378
    STAT_GET_LOAD_SAFE_TO_PROGRESS_TO_MP_FROM_SP = 13898344324803620526
    SET_PED_HELMET_FLAG = 13900234201931967269
    SET_PICKUP_ROPE_LENGTH_WITHOUT_CREATING_ROPE_FOR_CARGOBOB = 13901877820316162984
    IS_VEHICLE_SEARCHLIGHT_ON = 13905285848649779591
    NETWORK_EARN_UPGRADE_AUTOSHOP = 13907998182754771438
    NETWORK_SEND_TRANSITION_INVITE_VIA_PRESENCE = 13913589141289337489
    SET_PED_CAN_HEAD_IK = 13915023376345542876
    SET_ALL_VEHICLE_GENERATORS_ACTIVE_IN_AREA = 13917004117723053645
    NET_GAMESERVER_RETRIEVE_SESSION_ERROR_CODE = 13924066701951229745
    SET_HAS_POSTED_ALL_VEHICLES_DRIVEN = 13925614457829988332
    DISABLE_PLAYER_VEHICLE_REWARDS = 13925902161512632927
    NETWORK_UGC_NAV = 13926383842697220848
    PLAYSTATS_MINIGAME_USAGE = 13928465919726721458
    IS_DOOR_REGISTERED_WITH_SYSTEM = 13930693845672184001
    STOP_PED_WEAPON_FIRING_WHEN_DROPPED = 13932116899881240072
    ENABLE_STALL_WARNING_SOUNDS = 13932175539696029618
    SET_PED_CAN_BE_DRAGGED_OUT = 13936123607432176869
    ROPE_RESET_LENGTH = 13938052941319115936
    GET_SHOP_PED_APPAREL_VARIANT_COMPONENT_COUNT = 13941685280410692826
    SET_VEH_FORCED_RADIO_THIS_FRAME = 13943246726267993616
    NETWORK_SPENT_IMPORT_EXPORT_REPAIR = 13949107336061262078
    NEW_LOAD_SCENE_STOP = 13949725492155249828
    PLAYSTATS_MISSION_STARTED = 13950508037900673585
    NETWORK_SESSION_VALIDATE_JOIN = 13951989529778169599
    SET_RADIO_AUTO_UNFREEZE = 13955141577658083728
    SETTIMERA = 13957193594485226082
    SET_PED_RESET_FLAG = 13972597501312313842
    PLAYSTATS_HEIST4_FINALE = 13972809018908128598
    SET_INTERIOR_ENTITY_SET_TINT_INDEX = 13975111697588294423
    SET_PED_HEATSCALE_OVERRIDE = 13976617951018964280
    SWING_BOAT_BOOM_FREELY = 13977345472634752035
    SET_PLAYER_SWITCH_OUTRO = 13981625651669789537
    TASK_ENTER_VEHICLE = 13983202585294707880
    GET_PLAYER_PARACHUTE_MODEL_OVERRIDE = 13986360186682891329
    NETWORK_HAS_ROS_PRIVILEGE_END_DATE = 13990734272451782321
    TASK_SUBMARINE_GOTO_AND_STOP = 13991347412351421604
    REQUEST_CUTSCENE_WITH_PLAYBACK_LIST = 13996590508742325644
    SET_HYDRAULIC_WHEEL_STATE = 13997316495358270673
    NETWORK_STOP_SYNCHRONISED_SCENE = 14002896419073346351
    GET_CAM_NEAR_DOF = 14006525941184027164
    IS_ANIMAL_VOCALIZATION_PLAYING = 14007848093023379389
    NET_GAMESERVER_GET_PRICE = 14010708620624046221
    DATADICT_SET_FLOAT = 14014670713589665886
    LOAD_ALL_PATH_NODES = 14027424203929104267
    SET_ACHIEVEMENT_PROGRESS = 14028712679202106460
    NETWORK_CLEAR_PROPERTY_ID = 14031005491903530302
    SC_COMMUNITY_EVENT_GET_DISPLAY_NAME = 14035888979989090734
    SET_MULTIPLAYER_WALLET_CASH = 14038102595923224508
    GET_FAKE_SPECTATOR_MODE = 14038473885450659256
    DETACH_VEHICLE_FROM_TOW_TRUCK = 14040934353521151704
    ANIMATED_SHAKE_SCRIPT_GLOBAL = 14045289057447832881
    TRIGGER_IDLE_ANIMATION_ON_PED = 14046166552868608851
    NET_GAMESERVER_TRANSFER_WALLET_TO_BANK = 14048977195193867389
    STAT_SET_CURRENT_POSIX_TIME = 14049062049037487201
    GET_ID_OF_THIS_THREAD = 14052137831553183265
    LEADERBOARDS2_READ_BY_HANDLE = 14053222755243900686
    IS_PED_GESTURING = 14054567779070471187
    SET_PARACHUTE_TASK_TARGET = 14056640000561048999
    SET_IK_TARGET = 14062342233199144153
    GET_WEAPONTYPE_GROUP = 14062629349971965772
    NETWORK_CLAN_HAS_CREWINFO_METADATA_BEEN_RECEIVED = 14064363004691641687
    GET_CAM_FOV = 14065597356113244778
    SET_ALL_NEUTRAL_RANDOM_PEDS_FLEE_THIS_FRAME = 14066834293359561926
    GET_CLOSEST_PED = 14067759205800968548
    SET_ENTITY_WATER_REFLECTION_FLAG = 14072557277826119145
    DISABLE_HDTEX_THIS_FRAME = 14076683465507996338
    CLEAR_DRIVEBY_TASK_UNDERNEATH_DRIVING_TASK = 14076947156617711465
    SET_VEHICLE_BROKEN_PARTS_DONT_AFFECT_AI_HANDLING = 14078720844518274984
    SET_CAM_DOF_MAX_NEAR_IN_FOCUS_DISTANCE = 14079741466297652781
    ATTACH_ENTITY_TO_ENTITY_PHYSICALLY = 14080318970639913209
    SET_PLAYER_HEALTH_RECHARGE_MAX_PERCENT = 14089688388591795252
    LEADERBOARDS2_READ_RANK_PREDICTION = 14091132015804044412
    SET_PED_LEG_IK_MODE = 14093722256403988157
    CREATE_CAM = 14094047806098104639
    START_REPLAY_RECORDING = 14099697308171152513
    SET_WIDESCREEN_FORMAT = 14100906360598409457
    NETWORK_TRANSITION_ADD_STAGE = 14105253769309203117
    WATER_OVERRIDE_FADE_OUT = 14105874013513521681
    NETWORK_SEND_INVITE_VIA_PRESENCE = 14107427631987443236
    SCALEFORM_MOVIE_METHOD_ADD_PARAM_INT = 14109922879970035366
    WATER_OVERRIDE_SET_SHOREWAVEMINAMPLITUDE = 14117327543806979304
    REMOVE_PARTICLE_FX = 14123658133604488143
    IS_SOCIAL_CLUB_ACTIVE = 14125186412911573423
    SET_BLIP_EXTENDED_HEIGHT_THRESHOLD = 14134423667045280365
    TASK_VEHICLE_TEMP_ACTION = 14135071823246254377
    NETWORK_HAS_CONFIRMED_INVITE = 14136191625950344289
    SET_MISSION_FLAG = 14136832564121365875
    NETWORK_GET_DESTROYER_OF_ENTITY = 14137946285548054391
    MODIFY_WATER = 14142425935910774327
    STOP_PLAYER_TELEPORT = 14144097709538345116
    SET_PED_RANDOM_PROPS = 14144293859224031942
    NETWORK_UPDATE_LOAD_SCENE = 14148093505384029254
    SET_VEHICLE_USE_PLAYER_LIGHT_SETTINGS = 14149228038100052700
    IS_TRACKED_POINT_VISIBLE = 14149410262693846184
    GET_VEHICLE_ENGINE_HEALTH = 14149504890089024184
    GET_IS_INITIAL_LOADING_SCREEN_ACTIVE = 14151289062761319619
    DOOR_SYSTEM_SET_SPRING_REMOVED = 14160971436433045848
    GET_PROFILE_SETTING = 14161849555513669521
    SET_VEHICLE_REMOVE_AGGRESSIVE_CARJACK_MISSION = 14173730158750193161
    LEADERBOARDS_GET_COLUMN_ID = 14174312892429953662
    START_NEW_SCRIPT_WITH_NAME_HASH_AND_ARGS = 14175969932617039480
    SC_PRESENCE_ATTR_SET_FLOAT = 14178553594052299300
    CAN_PHONE_BE_SEEN_ON_SCREEN = 14187043856251976267
    HAS_ANIM_SET_LOADED = 14189161536823175600
    IS_WORLD_POINT_WITHIN_BRAIN_ACTIVATION_RANGE = 14196521158419141712
    NETWORK_DISABLE_LEAVE_REMOTE_PED_BEHIND = 14196757155057487899
    END_SCALEFORM_MOVIE_METHOD_RETURN_VALUE = 14198340658526877830
    SET_VEHICLE_LIMIT_SPEED_WHEN_PLAYER_INACTIVE = 14198979231544683403
    REQUEST_SCALEFORM_MOVIE_INSTANCE = 14201055364078303238
    SET_PED_CAN_PEEK_IN_COVER = 14201118858005067574
    NETWORK_EARN_FROM_FMBB_PHONECALL_MISSION = 14201366272313008658
    GET_CAM_NEAR_CLIP = 14204532778782893233
    DATAFILE_LOAD_OFFLINE_UGC = 14205351586031732196
    IS_PED_RUNNING = 14206728153055832226
    SET_ENABLE_BOUND_ANKLES = 14208310939854896174
    IS_DOOR_CLOSED = 14209400576093299017
    REMOVE_VEHICLE_UPSIDEDOWN_CHECK = 14212995567744351888
    IS_SCARLETT_VERSION = 14214955939797842740
    WATER_OVERRIDE_SET_STRENGTH = 14216184830359819280
    SET_PLAYER_SIMULATE_AIMING = 14216902889763161525
    GET_RANDOM_VEHICLE_FRONT_BUMPER_IN_SPHERE = 14219920157253745256
    DATAFILE_FLUSH_MISSION_HEADER = 14220209040707242114
    UGC_GET_CREATE_CONTENT_ID = 14220691147171425571
    GET_TINT_INDEX_FOR_LAST_GEN_HAIR_TEXTURE = 14226799957050793388
    NETWORK_IS_TRANSITION_LEAVE_POSTPONED = 14227382390502439977
    SCALEFORM_MOVIE_METHOD_ADD_PARAM_BOOL = 14232541106153632856
    GET_SNOW_LEVEL = 14233216051052274606
    HAS_PED_GOT_WEAPON_COMPONENT = 14236759287530185536
    REMOVE_COP_BLIP_FROM_PED = 14237201228792779951
    SET_SUBMARINE_CRUSH_DEPTHS = 14238256275250510279
    HAS_CUTSCENE_LOADED = 14240191319203509049
    SC_COMMUNITY_EVENT_GET_EXTRA_DATA_FLOAT_BY_ID = 14241328098729475145
    SET_SCRIPT_WITH_NAME_HASH_AS_NO_LONGER_NEEDED = 14248267209664748327
    PLAYSTATS_LEAVE_JOB_CHAIN = 14248847500126099104
    SET_DEPTHWRITING = 14251915283817955185
    ADD_LINE_TO_CONVERSATION = 14262783695077848646
    SET_INSTANCE_PRIORITY_HINT = 14263085750709084622
    APPLY_FORCE_TO_ENTITY = 14264742704217730328
    SET_TURRET_HIDDEN = 14267510182170511281
    IS_SPECIAL_ABILITY_UNLOCKED = 14267825189556299412
    SET_OBJECT_IS_SPECIAL_GOLFBALL = 14268315330003562421
    SET_PAD_CAN_SHAKE_DURING_CUTSCENE = 14275151645856674820
    SET_SCRIPT_GFX_DRAW_BEHIND_PAUSEMENU = 14282936202403724237
    ADD_TEXT_COMPONENT_SUBSTRING_TEXT_LABEL = 14284527218482400231
    GET_NEXT_AUDIBLE_BEAT = 14288240297836553973
    CLOUD_DELETE_MEMBER_FILE = 14289338322178473527
    PRELOAD_BUSYSPINNER = 14292933746084667288
    SET_CAM_DOF_FOCUS_DISTANCE_BIAS = 14297220887994283998
    NETWORK_EARN_AUTOSHOP_INCOME = 14298116250408582693
    SET_PTFX_FORCE_VEHICLE_INTERIOR_FLAG = 14299788691179374339
    END_SCALEFORM_MOVIE_METHOD = 14301579258302520915
    FORCE_SUBMARINE_NEURTAL_BUOYANCY = 14302782642363163582
    SET_PROFILE_SETTING_SP_CHOP_MISSION_COMPLETE = 14302919639509195234
    PLAY_PED_AMBIENT_SPEECH_AND_CLONE_NATIVE = 14309091921686936505
    IS_DECAL_ALIVE = 14309298625833532684
    IS_VEHICLE_BEING_BROUGHT_TO_HALT = 14311227783020744943
    SET_RADIO_TO_STATION_NAME = 14312116532935479559
    GET_FLYING_VEHICLE_MODEL_AGILITY = 14316116923238077644
    GET_SHOP_PED_APPAREL_FORCED_COMPONENT_COUNT = 14319717569941854403
    IS_FOLLOW_PED_CAM_ACTIVE = 14327026183995711737
    LOBBY_AUTO_MULTIPLAYER_RANDOM_JOB = 14329471267055055718
    STAT_MIGRATE_CHECK_START = 14330702922318706363
    NETWORK_EARN_NIGHTCLUB_AND_WAREHOUSE = 14332508970529638528
    START_PARTICLE_FX_LOOPED_ON_ENTITY_BONE = 14333625685297823499
    REGISTER_SCRIPT_WITH_AUDIO = 14334286158367002001
    END_TEXT_COMMAND_THEFEED_POST_MESSAGETEXT_SUBTITLE_LABEL = 14336506708921755308
    GET_NAVMESH_ROUTE_DISTANCE_REMAINING = 14336576906188871213
    NETWORK_SESSION_JOIN_INVITE = 14337398024027361082
    NETWORK_SET_TASK_CUTSCENE_INSCOPE_MULTIPLER = 14338597142480612897
    GET_TIME_SINCE_LAST_DEATH = 14340384834815123402
    IS_PED_PLANTING_BOMB = 14342662639574418136
    SET_CINEMATIC_CAM_SHAKE_AMPLITUDE = 14349813123090427879
    STOP_CUTSCENE = 14350482124138379374
    PLAYSTATS_SELL_CONTRABAND_MISSION = 14351170026963548014
    UGC_QUERY_BY_CONTENT_IDS = 14355639994434102370
    NETWORK_TRY_ACCESS_TUNABLE_BOOL_HASH = 14358039221613945478
    NETWORK_SESSION_HOST_SINGLE_PLAYER = 14360910471973328597
    SET_PED_COMBAT_ABILITY = 14367094196529200552
    SHOW_CONTACT_INSTRUCTIONAL_BUTTON = 14371735198991718511
    PLAY_SYNCHRONIZED_ENTITY_ANIM = 14372992612441344646
    NETWORK_GET_ENTITY_IS_NETWORKED = 14376186384880618616
    SET_CAM_NEAR_CLIP = 14376773126884446594
    PAUSE_MENU_SET_BUSY_SPINNER = 14379469807889341881
    CLEAR_PED_MOTION_IN_COVER_CLIPSET_OVERRIDE = 14380440959818096929
    CLEANUP_ASYNC_INSTALL = 14383056958920859570
    CLOUD_IS_CHECKING_AVAILABILITY = 14387782953863605819
    PREPARE_SYNCHRONIZED_AUDIO_EVENT = 14387816404730881894
    NETWORK_GET_HOST_OF_THIS_SCRIPT = 14390363770108672604
    GET_MAX_NUM_NETWORK_OBJECTS = 14392997886784040060
    REMOVE_MULTIPLAYER_BANK_CASH = 14395325864471424464
    STOP_END_USER_BENCHMARK = 14401164441476724011
    LOBBY_SET_AUTO_MP_RANDOM_JOB = 14404508441872907113
    SET_PED_CAN_BE_SHOT_IN_VEHICLE = 14406764142192015879
    OPEN_ALL_BARRIERS_FOR_RACE = 14407750369176597774
    PLAYSTATS_RANK_UP = 14407822532172496820
    SET_PED_ANGLED_DEFENSIVE_AREA = 14409106420996785569
    SET_PED_RELATIONSHIP_GROUP_HASH = 14414461841627274642
    STOP_RENDERING_SCRIPT_CAMS_USING_CATCH_UP = 14418823738263598738
    NETWORK_MEMBER_ID_FROM_GAMER_HANDLE = 14422267715408477039
    SET_FOLLOW_PED_CAM_LADDER_ALIGN_THIS_UPDATE = 14427593876267358554
    NETWORK_EARN_FROM_PREMIUM_JOB = 14429663106557949259
    ASIN = 14430384276805901543
    UGC_CREATE_CONTENT = 14430984433500463641
    STAT_MIGRATE_CLEAR_FOR_RESTART = 14431701714524094645
    DISABLE_HOSPITAL_RESTART = 14434978098343635880
    SC_GAMERDATA_GET_INT = 14436975971694084778
    HAS_ENTITY_BEEN_DAMAGED_BY_ENTITY = 14442313745284758776
    UGC_WAS_QUERY_FORCE_CANCELLED = 14447112256505803468
    NETWORK_ACTION_FOLLOW_INVITE = 14447924649977641173
    SET_PED_RANDOM_COMPONENT_VARIATION = 14459167355187903528
    TERMINATE_THREAD = 14461491531900042452
    IS_MOBILE_INTERFERENCE_ACTIVE = 14461535876444114384
    ENABLE_LASER_SIGHT_RENDERING = 14462304661930534058
    SET_FLY_CAM_VERTICAL_CONTROLS_THIS_UPDATE = 14462682002538728340
    NETWORK_CLAN_GET_MEMBERSHIP = 14464471364728992785
    IS_INCIDENT_VALID = 14464546474843291306
    ADVANCE_CLOCK_TIME_TO = 14468542163779599163
    SAVEMIGRATION_MP_GET_ACCOUNTS_STATUS = 14468756743965811402
    ROPE_SET_UPDATE_PINVERTS = 14471868725878409914
    PAUSE_MENU_GET_MOUSE_CLICK_EVENT = 14474858448948444133
    SET_OVERRIDE_NITROUS_LEVEL = 14477303374716757517
    INIT_SYNCH_SCENE_AUDIO_WITH_POSITION = 14478485378191566548
    END_TEXT_COMMAND_THEFEED_POST_UNLOCK_TU = 14480105214373658815
    REGISTER_BOOL_TO_SAVE = 14480219678871926177
    PLAYSTATS_CASINO_THREE_CARD_POKER_LIGHT = 14483597724864778018
    PLAYSTATS_MISSION_CHECKPOINT = 14483674715095796765
    IS_CAM_PLAYING_ANIM = 14485302465778347250
    GET_GROUND_Z_FOR_3D_COORD = 14485449809187343659
    SET_SCRIPT_AS_NO_LONGER_NEEDED = 14487285925372368972
    IS_SCRIPT_GLOBAL_SHAKING = 14488835398135026194
    REQUEST_ADDITIONAL_COLLISION_AT_COORD = 14489608052167256554
    SET_FLY_CAM_COORD_AND_CONSTRAIN = 14491576813728499914
    SET_GAMEPLAY_HINT_CAMERA_RELATIVE_VERTICAL_OFFSET = 14494580242613233412
    NETWORK_CAN_SET_WAYPOINT = 14494813559058640736
    TASK_GUARD_SPHERE_DEFENSIVE_AREA = 14503559015034697186
    START_NETWORKED_PARTICLE_FX_NON_LOOPED_ON_ENTITY = 14510230605445337405
    HAS_FORCE_CLEANUP_OCCURRED = 14512963100351546073
    SET_TYRE_MAXIMUM_GRIP_DIFFERENCE_DUE_TO_WEAR_RATE = 14515331263737485160
    LEADERBOARDS2_WRITE_DATA_FOR_EVENT_TYPE = 14519858284755623260
    APP_GET_DELETED_FILE_STATUS = 14521076533707067814
    NETWORK_SPEND_CASINO_CLUB = 14524603946433876146
    SPECIAL_ABILITY_CHARGE_ON_MISSION_FAILED = 14530692506368557930
    FADE_UP_PED_LIGHT = 14533550605700730747
    NETWORK_FORCE_LOCAL_USE_OF_SYNCED_SCENE_CAMERA = 14534305891649105319
    SET_SAVE_MENU_ACTIVE = 14537467669149777783
    IS_PED_MODEL = 14543630739788422135
    TIMERB = 14544731519793341300
    DISABLE_VEHICLE_DISTANTLIGHTS = 14553816234644632482
    IS_STRING_NULL_OR_EMPTY = 14556807627007080597
    NETWORK_SPENT_BANK_INTEREST = 14565499460417580273
    NETWORK_SET_GAMER_INVITED_TO_TRANSITION = 14568160127138844086
    WATER_REFLECTION_SET_SCRIPT_OBJECT_VISIBILITY = 14575440171862471098
    GET_VEHICLE_INDIVIDUAL_DOOR_LOCK_STATUS = 14576678556651678843
    SET_PARTICLE_FX_BULLET_TRACE_NO_ANGLE_REJECT = 14576713032136906099
    PRELOAD_VEHICLE_AUDIO_BANK = 14577283838636984958
    APP_HAS_SYNCED_DATA = 14578758488050192767
    NETWORK_DISABLE_VOICE_BANDWIDTH_RESTRICTION = 14580223719053600204
    NETWORK_SKIP_RADIO_RESET_NEXT_OPEN = 14580910317845472462
    GET_CHARACTER_MENU_PED_INT_STAT = 14585804031603160659
    DISPLAY_ONSCREEN_KEYBOARD_WITH_LONGER_INITIAL_STRING = 14589639279881065214
    HAS_PTFX_ASSET_LOADED = 14590989371548583963
    SET_AIR_DRAG_MULTIPLIER_FOR_PLAYERS_VEHICLE = 14591038487492435614
    GET_COMMERCE_PRODUCT_PRICE = 14597385868021109548
    NETWORK_IS_IN_SESSION = 14598176716237453591
    IS_CINEMATIC_IDLE_CAM_RENDERING = 14599872450384025376
    SET_NUMBER_OF_PARKED_VEHICLES = 14601056006077421567
    DATAARRAY_ADD_INT = 14609034328411203899
    SHOW_GOLD_TICK_ON_BLIP = 14610243571739636136
    SET_PLAYER_CAN_COLLECT_DROPPED_MONEY = 14611211652835644255
    SET_VEHICLE_USES_LARGE_REAR_RAMP = 14611477472789977703
    NETWORK_EARN_DAR_CHALLENGE = 14611491421803914411
    PLAY_DEFERRED_SOUND_FRONTEND = 14617094552583026718
    GET_WEAPON_OBJECT_FROM_PED = 14619208419641565549
    NETWORK_SESSION_ADD_ACTIVE_MATCHMAKING_GROUP = 14620196531724584796
    PLAYSTATS_HOLD_UP_MISSION_DONE = 14627719537886469809
    CLEAR_CONTROL_LIGHT_EFFECT = 14628642598264395789
    GET_NUM_CREATED_MISSION_PEDS = 14637081742576974567
    IS_TIME_LESS_THAN = 14640345957071505616
    STOP_ROPE_WINDING = 14640440119028984444
    NETWORK_HAS_CONTROL_OF_DOOR = 14644695183499826655
    GET_IS_WAYPOINT_RECORDING_LOADED = 14649800469116238941
    GET_IS_USING_HOOD_CAMERA = 14655943016611488907
    SET_NOISINESSOVERIDE = 14657664533053181031
    SET_PED_CAN_COWER_IN_COVER = 14660716305380058933
    SET_RADAR_ZOOM_TO_DISTANCE = 14662806510087023937
    GET_STATUS_OF_CREATE_LOW_QUALITY_COPY_OF_PHOTO = 14664460079109911141
    SET_FORCE_STEP_TYPE = 14670066029040734573
    SET_VEHICLE_POPULATION_BUDGET = 14672198393358120169
    GET_INDEX_OF_CURRENT_LEVEL = 14676500190617269500
    LOAD_ROPE_DATA = 14677798260016069927
    FILLOUT_PM_PLAYER_LIST = 14681027015716784137
    IS_FOLLOW_VEHICLE_CAM_ACTIVE = 14681144155113444502
    GET_ATTACHED_PICK_UP_HOOK_POSITION = 14689505661984491821
    SET_MOBILE_PHONE_SCALE = 14689952717465901362
    NETWORK_SET_TALKER_PROXIMITY = 14695576975085065862
    PLAYSTATS_MC_REQUEST_BIKE = 14710344443894692330
    CLEAR_PRINTS = 14714379805468572121
    ALLOW_PAUSE_WHEN_NOT_IN_STATE_OF_PLAY_THIS_FRAME = 14717726118987496547
    SET_TASK_VEHICLE_CHASE_BEHAVIOR_FLAG = 14728559327049495015
    DOES_RELATIONSHIP_GROUP_EXIST = 14730776764986229233
    RESET_DISABLE_BREAKING = 14730876592034363522
    SET_HEAD_BLEND_PALETTE_COLOR = 14742114159531151913
    SET_ANIMAL_MOOD = 14742448247598603323
    IS_SCRIPTED_SPEECH_PLAYING = 14743273960543126772
    IS_CINEMATIC_SHOT_ACTIVE = 14744560268273159113
    IS_PS3_VERSION = 14745074541249205954
    NETWORK_HAS_VIEW_GAMER_USER_CONTENT_RESULT = 14745965566320721695
    NETWORK_SPENT_PURCHASE_HANGAR = 14750196755438260954
    IS_OBJECT_WITHIN_BRAIN_ACTIVATION_RANGE = 14752126902777032791
    CLEAR_WEATHER_TYPE_PERSIST = 14754798680422182133
    STOP_GAMEPLAY_HINT_BEING_CANCELLED_THIS_UPDATE = 14758428755229485427
    SET_MOUNTED_WEAPON_TARGET = 14760708415523990457
    SHUTDOWN_CREATOR_BUDGET = 14763468085510208215
    GET_ENTITY_COLLISION_DISABLED = 14767841371638916224
    REMOVE_DECALS_FROM_OBJECT = 14769305104806538425
    END_TEXT_COMMAND_DISPLAY_TEXT = 14772192000654010967
    REQUEST_PED_RESTRICTED_VEHICLE_VISIBILITY_TRACKING = 14772242567161760579
    PLAYSTATS_COLLECTIBLE_PICKED_UP = 14774773892453506290
    NETWORK_DEFER_CASH_TRANSACTIONS_UNTIL_SHOP_SAVE = 14776129359885034611
    SET_PED_PRIMARY_LOOKAT = 14778480077195349406
    GET_WEAPON_OBJECT_TINT_INDEX = 14778618342366064215
    NETWORK_SPENT_MOVE_SUBMARINE = 14793593275253904013
    GET_DEAD_PED_PICKUP_COORDS = 14794328832896667446
    PLAY_END_CREDITS_MUSIC = 14795288279680600320
    SET_BLIP_SCALE_2D = 14800275623171967353
    UGC_GET_CONTENT_USER_ID = 14800988933507861660
    NETWORK_USE_LOGARITHMIC_BLENDING_THIS_FRAME = 14803794786533929118
    SET_FAKE_SPECTATOR_MODE = 14804496589921774187
    DOES_AIR_DEFENCE_SPHERE_EXIST = 14806047015550418255
    CLEAR_ALL_PED_PROPS = 14810779206492172038
    GET_NAME_OF_ZONE = 14812450763245150666
    TAKE_OWNERSHIP_OF_SYNCHRONIZED_SCENE = 14815936647629449839
    NETWORK_EARN_GOON = 14817342140811016194
    PAUSE_MENUCEPTION_THE_KICK = 14828707501208161167
    TASK_WRITHE = 14833779066214329454
    SET_VEHICLE_ALARM = 14836518586668520780
    SET_PLAYER_WEAPON_DAMAGE_MODIFIER = 14846039169330490787
    SET_DISABLE_VERTICAL_FLIGHT_MODE_TRANSITION = 14856041974383075215
    SET_GROUP_FORMATION = 14857198989786123294
    RELEASE_WEAPON_AUDIO = 14864904916758982725
    NETWORK_GET_ENTITY_FROM_NETWORK_ID = 14865922340470912352
    CLEAR_HD_AREA = 14868829675486513171
    STAT_GET_SAVE_MIGRATION_CONSUME_CONTENT_STATUS = 14869377738856783584
    ADD_BLIP_FOR_AREA = 14870057342365184568
    NETWORK_GET_PLAYER_FROM_GAMER_HANDLE = 14870719517945799837
    NETWORK_IS_GAMER_MUTED_BY_ME = 14871130065913805176
    GET_ENTITY_BONE_ROTATION = 14871612343888918406
    NETWORK_GET_PRIMARY_CLAN_DATA_START = 14881819621038891271
    GET_CHARACTER_FROM_AUDIO_CONVERSATION_FILENAME_BYTES = 14885714783822319754
    SET_PED_ARMOUR = 14888985593447081164
    ORDER_BOSS_VEHICLE = 14890399978938844897
    SET_FLASH_LIGHT_FADE_DISTANCE = 14890709808944305051
    SET_PICKUP_COLLIDES_WITH_PROJECTILES = 14891091564646364812
    SET_FIRST_PERSON_AIM_CAM_ZOOM_FACTOR_LIMITS_THIS_UPDATE = 14902565917035304903
    SET_PED_SHOULD_PROBE_FOR_SCENARIO_EXITS_IN_ONE_FRAME = 14905332188220870756
    IS_PED_JUMPING = 14905433007184723863
    IS_VEHICLE_IN_GARAGE_AREA = 14908120985973273538
    FLAG_PLAYER_CONTEXT_IN_TOURNAMENT = 14912003518425952209
    NETWORK_SESSION_IS_PRIVATE = 14913400397865982881
    NETWORK_GET_NUM_PRESENCE_INVITES = 14914398631461189517
    SET_CARGOBOB_PICKUP_ROPE_DAMPING_MULTIPLIER = 14920851035725910791
    GET_ENTITY_BONE_OBJECT_POSTION = 14921067459188760534
    GET_PED_HEAD_OVERLAY_NUM = 14924057702203344910
    SET_MP_GAMER_TAG_WANTED_LEVEL = 14925648428786555331
    NET_GAMESERVER_RETRIEVE_CATALOG_REFRESH_STATUS = 14931925339148836446
    GET_NUM_RESERVED_MISSION_VEHICLES = 14932412823601750065
    DETACH_PORTABLE_PICKUP_FROM_PED = 14935692415863549105
    IS_ENTITY_ATTACHED_TO_ANY_OBJECT = 14938748105593315532
    DRAW_SCALEFORM_MOVIE_FULLSCREEN_MASKED = 14939424981715340517
    NETWORK_GET_TOTAL_NUM_PLAYERS = 14943458910033340907
    CLEAR_THIS_PRINT = 14947587908815894237
    NETWORK_ADD_SYNCHRONISED_SCENE_CAMERA = 14955279743659623127
    SET_VEHICLE_READY_FOR_CLEANUP = 14956833703762151564
    IS_ENTITY_IN_WATER = 14965638415315453347
    CONTROL_LANDING_GEAR = 14972426531406603637
    APP_SET_APP = 14974539588691365163
    UGC_GET_CONTENT_UPDATED_DATE = 14974774096468959075
    DISABLE_IN_WATER_PTFX = 14974872340656247644
    LOCK_DOORS_WHEN_NO_LONGER_NEEDED = 14976572021797561694
    END_TEXT_COMMAND_ADD_DIRECTLY_TO_PREVIOUS_BRIEFS = 14977810567242948852
    NETWORK_REMAIN_IN_GAME_CHAT = 14982146499706148331
    NETWORK_BLOCK_JOIN_QUEUE_INVITES = 14982221358702907579
    GET_PED_NEARBY_VEHICLES = 14985844084871073154
    GET_FINAL_RENDERED_CAM_NEAR_CLIP = 14990273171478638995
    ROPE_FORCE_LENGTH = 14990784799107701531
    REMOVE_CUT_FILE = 14991769197972412498
    ACTIVATE_AUDIO_SLOWMO_MODE = 14992489562141276024
    REQUEST_TASK_MOVE_NETWORK_STATE_TRANSITION = 14992507104788144502
    IS_SRL_LOADED = 14998737188714557627
    HAS_ANIM_DICT_LOADED = 15001957746457249932
    TASK_PED_SLIDE_TO_COORD = 15010469479099992582
    SET_ENTITY_FLAG_SUPPRESS_SHADOW = 15013367565662056217
    IS_ENTITY_WAITING_FOR_WORLD_COLLISION = 15013874209943373455
    UGC_SET_DELETED = 15014185785842349208
    NETWORK_EARN_UPGRADE_AGENCY = 15023019067455115404
    CALL_SCALEFORM_MOVIE_METHOD_WITH_NUMBER = 15024976308019809262
    GET_ARE_BOMB_BAY_DOORS_OPEN = 15028927856255482792
    NETWORK_IS_TRANSITION_VISIBILITY_LOCKED = 15034287464279875518
    NETWORK_END_TUTORIAL_SESSION = 15037431150385394423
    SET_GPS_DISABLED_ZONE_AT_INDEX = 15040928121556492628
    SET_PED_GADGET = 15048692283445430810
    DETACH_VEHICLE_FROM_ANY_TOW_TRUCK = 15053789753048992984
    SC_LICENSEPLATE_SET_PLATE_DATA = 15054977193248966378
    GET_STREET_NAME_FROM_HASH_KEY = 15055404454487149753
    DRAW_SPOT_LIGHT = 15057305032293387059
    COS = 15059950717509440412
    GET_CITY_DENSITY = 15060743825892121504
    PLAYSTATS_SET_JOIN_TYPE = 15060932466269815966
    SET_LOCAL_PLAYER_VISIBLE_IN_CUTSCENE = 15061828707536501614
    SET_DISPATCH_SPAWN_LOCATION = 15064334183716367696
    NETWORK_TRY_TO_SET_THIS_SCRIPT_IS_NETWORK_SCRIPT = 15064830173929911698
    IS_STREAM_PLAYING = 15068944498283895160
    IS_PED_DUCKING = 15070643543572072124
    CLEAR_ALL_BLIP_ROUTES = 15071440000031833873
    SET_SPECIAL_FLIGHT_MODE_RATIO = 15076074724104038455
    GET_PACKED_TU_INT_STAT_KEY = 15090483553124952148
    IS_PED_RUNNING_MELEE_TASK = 15098056418973297879
    SET_BLOCK_WANTED_FLASH = 15101734431743575145
    ARE_CREDITS_RUNNING = 15103956213288718108
    PLAYSTATS_BW_YATCHATTACK = 15105616563684304736
    SET_CAM_SPLINE_SMOOTHING_STYLE = 15109845112018561629
    SET_TV_PLAYER_WATCHING_THIS_FRAME = 15115587853151499572
    PASS_KEYBOARD_INPUT_TO_SCALEFORM = 15116273975514179940
    CHANGE_UNIFORM = 15116817222292411677
    NETWORK_SPEND_CAR_CLUB_TAKEOVER = 15124327956320326325
    GET_NUM_PED_MAKEUP_TINTS = 15129783665620559896
    SET_GAMEPLAY_HINT_BASE_ORBIT_PITCH_OFFSET = 15129902587980036168
    SET_FAKE_MINIMAP_MAX_ALTIMETER_HEIGHT = 15132644501924499565
    END_TEXT_COMMAND_THEFEED_POST_REPLAY = 15132861299754369391
    UPDATE_RADAR_ZOOM_TO_BLIP = 15133385805985858421
    NETWORK_EARN_ISLAND_HEIST = 15140276335432867605
    ANIMPOSTFX_STOP_AND_FLUSH_REQUESTS = 15141273338572521868
    STOP_CUTSCENE_IMMEDIATELY = 15141310657442105886
    REMOVE_VEHICLE_CREW_EMBLEM = 15145605771007711204
    NETWORK_LEAVE_TRANSITION = 15148449439529687833
    GET_POSITION_OF_VEHICLE_RECORDING_AT_TIME = 15150798036259634082
    GET_HASH_KEY = 15153829671144605900
    SET_IDEAL_SPAWN_DISTANCE_FOR_INCIDENT = 15159602598280527986
    DATAFILE_CREATE = 15163717397261259758
    NETWORK_EARN_ARCADE = 15173529762491887039
    CASCADE_SHADOWS_SET_CASCADE_BOUNDS = 15173591053574405309
    SET_MP_GAMER_TAGS_SHOULD_USE_POINTS_HEALTH = 15176785000166805524
    TASK_GUARD_ASSIGNED_DEFENSIVE_AREA = 15177702416162850971
    REQUEST_CLIP_SET = 15179134168094313033
    SET_AUTO_GIVE_SCUBA_GEAR_WHEN_EXIT_VEHICLE = 15182502641979446141
    CLOSE_SOCIAL_CLUB_MENU = 15182527026982954694
    SET_ENABLE_PED_ENVEFF_SCALE = 15187732287137320734
    CREATE_NEW_SCRIPTED_CONVERSATION = 15188699854293085782
    OVERRIDE_PLAYER_GROUND_MATERIAL = 15189648466101620985
    GET_RANDOM_EVENT_FLAG = 15192188682518992817
    RESET_VEHICLE_STARTUP_REV_SOUND = 15194245252994173335
    IS_VEHICLE_EXTRA_TURNED_ON = 15196977125611980989
    TASK_PARACHUTE = 15200147081389834667
    SC_LICENSEPLATE_GET_ISVALID_IS_PENDING = 15204972160511920591
    SET_PED_HAS_AI_BLIP = 15207618962722216117
    NETWORK_SPEND_CASINO_HEIST = 15208237658859356968
    NETWORK_SESSION_IS_AWAITING_INVITE_RESPONSE = 15209745021743591732
    SET_VEHICLE_AVOID_PLAYER_VEHICLE_RIOT_VAN_MISSION = 15217687745233982066
    FORCE_ZERO_MASS_IN_COLLISIONS = 15221509465143605188
    REMOVE_SCENARIO_BLOCKING_AREAS = 15236805464555690569
    SET_BLIP_SCALE = 15242226327205421655
    NETWORK_GET_NUMBER_BODY_TRACKER_HITS = 15243640670829412765
    SET_ENTITY_CAN_BE_TARGETED_WITHOUT_LOS = 15247350545182087321
    NETWORK_GET_PRESENCE_INVITE_PLAYLIST_LENGTH = 15247851330257933759
    CASCADE_SHADOWS_SET_DYNAMIC_DEPTH_MODE = 15248365671629653265
    UI3DSCENE_IS_AVAILABLE = 15249487164880033997
    APP_GET_INT = 15250747526420995403
    GET_NEXT_GPS_DISABLED_ZONE_INDEX = 15251054137710885516
    DRAW_BOX = 15251887762495533650
    REQUEST_ANIM_DICT = 15257422121632202486
    IS_CUTSCENE_PLAYING = 15259006430109172510
    SET_BLIP_FLASH_TIMER = 15261977662507091916
    SHOULD_USE_METRIC_MEASUREMENTS = 15263074436821727123
    TASK_LEAVE_VEHICLE = 15266022280670526978
    VEHICLE_SET_OVERRIDE_SIDE_RATIO = 15268640944044535534
    DATAARRAY_GET_STRING = 15272550673523371858
    IS_VEHICLE_ATTACHED_TO_CARGOBOB = 15276571616016966105
    GET_SHOP_PED_APPAREL_VARIANT_PROP_COUNT = 15279214153607464547
    NETWORK_GET_AVERAGE_LATENCY = 15282048422706158386
    SET_DISABLE_DAMAGE_WITH_PICKED_UP_ENTITY = 15283353564814752116
    BUSYSPINNER_IS_ON = 15286058012351506709
    PLAYSTATS_SUB_WEAP = 15291547234442124720
    TASK_SEEK_COVER_TO_COVER_POINT = 15293544594376574079
    THEFEED_REPORT_LOGO_ON = 15295222714265570915
    ACTIVATE_DAMAGE_TRACKER_ON_NETWORK_ID = 15301859329558380313
    NETWORK_HANDLE_FROM_FRIEND = 15302308046443739090
    GET_ENTITY_PITCH = 15302601003449311742
    SET_PLAYER_CAN_USE_COVER = 15304824011544815636
    HIDE_HELP_TEXT_THIS_FRAME = 15305804375043908229
    ENABLE_SWITCH_PAUSE_BEFORE_DESCENT = 15310336574637648845
    NET_GAMESERVER_TRANSFER_BANK_TO_WALLET = 15310598380377818909
    GET_CLOSEST_BLIP_INFO_ID = 15313575125103452654
    SET_MP_GAMER_TAG_ALPHA = 15316712945669830743
    CREATE_PED = 15321134921733597150
    ADD_EXTENDED_PICKUP_PROBE_AREA = 15323396807702154501
    LEADERBOARDS_CLEAR_CACHE_DATA = 15325796172190064604
    SET_DISABLE_RANDOM_TRAINS_THIS_FRAME = 15328251820983961707
    GET_VEHICLE_IS_MERCENARY = 15331489174703639389
    SET_VEHICLE_DOOR_BROKEN = 15336153818213079603
    IS_CONTENT_ITEM_LOCKED = 15336920792406041660
    IS_MOVE_BLEND_RATIO_RUNNING = 15337117846544689465
    DO_SCREEN_FADE_IN = 15341760935224295475
    ASSISTED_MOVEMENT_SET_ROUTE_PROPERTIES = 15348317526569659931
    GET_ENTITY_SPEED = 15349247917266452847
    SET_GAMEPLAY_COORD_HINT = 15355828677610573747
    GET_RANDOM_INT_IN_RANGE = 15362697152651844904
    UGC_IS_GETTING = 15364819298720302824
    GET_VEHICLE_HORN_SOUND_INDEX = 15366064404548442126
    PLAYSTATS_CASINO_BLACKJACK_LIGHT = 15367720622126918511
    PLAYSTATS_ABANDONED_MC = 15373247063020529874
    GET_TIME_SINCE_PLAYER_DROVE_ON_PAVEMENT = 15373550519145956667
    HAS_PLAYER_LEFT_THE_WORLD = 15374690669139436180
    SET_VEHICLE_EXPLODES_ON_EXPLOSION_DAMAGE_AT_ZERO_BODY_HEALTH = 15376965024408866320
    FREEZE_MICROPHONE = 15382795360080579857
    GET_PLAYER_RESERVE_PARACHUTE_TINT_INDEX = 15393328524069293888
    UGC_GET_BOOKMARKED_CONTENT = 15394629097145505160
    TASK_MOVE_NETWORK_ADVANCED_BY_NAME = 15398752612590394059
    NETWORK_SET_TEAM_ONLY_CHAT = 15399082811850695875
    SET_TASK_MOVE_NETWORK_SIGNAL_FLOAT = 15400973881305242190
    NETWORK_SPENT_NO_COPS = 15400974197517975967
    ADD_COVER_POINT = 15402638885934156159
    SET_PLAYER_CAN_BE_HASSLED_BY_GANGS = 15412550122795475526
    REQUEST_SCRIPT_WITH_NAME_HASH = 15432261226617787366
    HAVE_REPLAY_STATS_BEEN_STORED = 15438957020084625078
    GET_PICKUP_TYPE_FROM_WEAPON_HASH = 15439071803284451749
    NETWORK_DISPLAYNAMES_FROM_HANDLES_START = 15450898637081299330
    PLAYSTATS_BUY_CONTRABAND_MISSION = 15454135392107049463
    SET_SCRIPT_VARIABLE_HUD_COLOUR = 15459274192404912244
    SET_PED_ENVEFF_COLOR_MODULATOR = 15462002842728659433
    SCALEFORM_MOVIE_METHOD_ADD_PARAM_FLOAT = 15462887953135416602
    IS_PED_PRONE = 15467721985080403897
    SPECIAL_ABILITY_DEACTIVATE = 15467986508560539735
    CELL_CAM_SET_SELFIE_MODE_HEAD_YAW_OFFSET = 15469277037362924041
    PLAYSTATS_DJ_MISSION_ENDED = 15477280598275002146
    NETWORK_SESSION_GET_KICK_VOTE = 15479041721659334385
    NETWORK_REGISTER_HIGH_FREQUENCY_PLAYER_BROADCAST_VARIABLES = 15480920913518234945
    PRESET_INTERIOR_AMBIENT_CACHE = 15492965952886818078
    HAS_PLAYER_BEEN_SPOTTED_IN_STOLEN_VEHICLE = 15493917686594916172
    IS_PED_FACING_PED = 15498656372762106531
    ADD_TO_CLOCK_TIME = 15498842407160086754
    SET_PED_DIES_IN_SINKING_VEHICLE = 15499316417087583420
    DOES_CURRENT_PED_PROP_HAVE_RESTRICTION_TAG = 15503284050957542784
    IS_BONNET_CINEMATIC_CAM_RENDERING = 15507582718153417355
    RESET_VEHICLE_STUCK_TIMER = 15517463679601715834
    GET_PED_LAST_DAMAGE_BONE = 15517540603941266588
    SET_PED_USING_ACTION_MODE = 15517940822472086375
    SET_PED_TO_RAGDOLL_WITH_FALL = 15521149076023895752
    TASK_GO_STRAIGHT_TO_COORD = 15522596972595670923
    PLACE_OBJECT_ON_GROUND_OR_OBJECT_PROPERLY = 15523607711391776726
    FADE_DECALS_IN_RANGE = 15528089199422007008
    SET_STUNT_JUMPS_CAN_TRIGGER = 15533343274177648095
    IS_ENTITY_VISIBLE_TO_SCRIPT = 15534827559198002738
    STOP_SCRIPTED_CONVERSATION = 15536837052699336378
    STAT_GET_FLOAT = 15541478783997101388
    SET_INVERT_GHOSTING = 15543830227334568911
    SET_PICK_UP_BY_CARGOBOB_DISABLED = 15544190040613569430
    ON_ENTER_SP = 15546720902295687881
    NETWORK_IS_CLOCK_TIME_OVERRIDDEN = 15549061658607711522
    NETWORK_SPENT_MC_ABILITY = 15550027512402594544
    UNBLOCK_DECISION_MAKER_EVENT = 15550257657199499752
    SEETHROUGH_SET_HEATSCALE = 15551123033653007377
    GET_CONTROL_HOW_LONG_AGO = 15551544507843401914
    GET_OBJECT_INDEX_FROM_ENTITY_INDEX = 15556481442984724950
    FREE_MEMORY_FOR_HIGH_QUALITY_PHOTO = 15564946096525386737
    SET_VEHICLE_HAS_MUTED_SIRENS = 15565863143422620276
    GET_SYNCHRONIZED_SCENE_RATE = 15567029479391317312
    PLAYER_PED_ID = 15567071428299294886
    GET_SCALEFORM_MOVIE_METHOD_RETURN_VALUE_BOOL = 15567396024569157473
    SC_TRANSITION_NEWS_SHOW_NEXT_ITEM = 15569555517149002133
    GET_VARIANT_PROP = 15572179945206005350
    SET_PLAYER_EXPLOSIVE_DAMAGE_MODIFIER = 15573734946140815442
    ENABLE_CLOWN_BLOOD_VFX = 15573809274285527667
    SWITCH_TO_MULTI_SECONDPART = 15576080799818947768
    IS_SPHERE_VISIBLE_TO_ANOTHER_MACHINE = 15577098879177796056
    NETWORK_SET_ENTITY_CAN_BLEND = 15578046208237758579
    IS_PED_FATALLY_INJURED = 15580560283690424960
    NETWORK_IS_SESSION_ACTIVE = 15581376729331042688
    NET_TO_OBJ = 15587344650859760447
    NETWORK_SPEND_COMP_SUV = 15593012195176063875
    CLEAR_RAGDOLL_BLOCKING_FLAGS = 15595138813470444107
    PLAYSTATS_FM_HEIST_PREP_ENDED = 15613895544899226811
    DRAW_DEBUG_LINE_WITH_TWO_COLOURS = 15616698641015177108
    SET_POP_CONTROL_SPHERE_THIS_FRAME = 15619537110062378797
    CLEAR_PED_ALTERNATE_MOVEMENT_ANIM = 15623434015562776014
    DELETE_WAYPOINTS_FROM_THIS_PLAYER = 15629342789145110761
    GET_EVENT_AT_INDEX = 15633799955427500371
    SET_CGOFFSET = 15634871766511806724
    GET_ITEMSET_SIZE = 15641703559802111537
    CAP_INTERIOR = 15643076920324709204
    SET_PLAYER_PARACHUTE_VARIATION_OVERRIDE = 15647838870677501228
    GET_WEAPON_HUD_STATS = 15649009931461107386
    SET_CAM_SHAKE_AMPLITUDE = 15653866047499144448
    SET_DISABLE_PETROL_DECALS_IGNITING_THIS_FRAME = 15656002518046496732
    GET_ENTITY_CAN_BE_DAMAGED = 15662611112691867807
    GET_CONTROL_VALUE = 15663090593132522535
    GIVE_WEAPON_COMPONENT_TO_PED = 15665442664280656825
    NETWORK_CLEAR_CLOCK_TIME_OVERRIDE = 15668831687896176238
    GET_CLOCK_DAY_OF_WEEK = 15668837556037559135
    NETWORK_SPENT_WAGER = 15680885259507210238
    SET_SYNCHRONIZED_SCENE_LOOPED = 15683952436282824527
    NETWORK_BUY_HEALTHCARE = 15686151736757838813
    DOOR_SYSTEM_SET_HOLD_OPEN = 15688035671099450944
    NETWORK_SPENT_HOLDUPS = 15688407604437161827
    GET_CAM_SPLINE_NODE_PHASE = 15695298228073802902
    IS_PLAYER_SWITCH_IN_PROGRESS = 15695836346704376671
    SET_SCRIPT_VEHICLE_GENERATOR = 15696769700584080560
    NETWORK_SPEND_SOURCE_BIKE = 15699344327618828488
    REMOVE_MODEL_HIDE = 15700393205701531493
    DOES_PICKUP_OBJECT_EXIST = 15703971481536605859
    RESET_WANTED_RESPONSE_NUM_PEDS_TO_SPAWN = 15705902186664072488
    ADD_SHOCKING_EVENT_AT_POSITION = 15706379927697040873
    SC_INBOX_MESSAGE_PUSH_GAMER_T0_RECIP_LIST = 15709201857782019146
    CLEAR_GARAGE = 15709990648034479609
    SET_POSITIONED_PLAYER_VEHICLE_RADIO_EMITTER_ENABLED = 15710668341870853775
    RESET_WORLD_BOUNDARY_FOR_PLAYER = 15716982420889755470
    SET_PED_ALLOWED_TO_DUCK = 15717311443427161711
    GET_POSIX_TIME = 15728979107437549134
    SET_RANDOM_BOATS_MP = 15735035000830767306
    IS_BLIP_SHORT_RANGE = 15735444228579637542
    GET_VEHICLE_FLIGHT_NOZZLE_POSITION = 15736142781931532910
    SET_FADE_IN_AFTER_DEATH_ARREST = 15737497366831513362
    NETWORK_IS_SCRIPT_ACTIVE_BY_HASH = 15743993307101261331
    GET_PACKED_STAT_BOOL_CODE = 15744232198466957744
    NETWORK_SPEND_GANGOPS_SKIP_MISSION = 15750348935955045400
    DOES_ENTITY_HAVE_PHYSICS = 15750752776961675364
    IS_AIR_DEFENCE_SPHERE_IN_AREA = 15760737785750737908
    SET_HAS_SPECIALEDITION_CONTENT = 15762725996750413333
    SET_DRIVE_TASK_DRIVING_STYLE = 15766570009348321127
    DECOR_GET_BOOL = 15766652691334493659
    TASK_HELI_MISSION = 15767148344044076724
    IS_HELP_MESSAGE_ON_SCREEN = 15768086655799919022
    SCRIPT_THREAD_ITERATOR_RESET = 15771515346973967272
    PLAYSTATS_GUNRUNNING_RND = 15778369643847306220
    SET_WARNING_MESSAGE_OPTION_HIGHLIGHT = 15778486040717972735
    SET_DISPATCH_COPS_FOR_PLAYER = 15787126758079550452
    SET_CHECKPOINT_FORCE_DIRECTION = 15789243440724251116
    STAT_SET_POS = 15791942317835806510
    START_GPS_CUSTOM_ROUTE = 15795505796495784712
    GET_DEFAULT_AMMO_FOR_WEAPON_PICKUP = 15799138191365559479
    GET_PEDHEADSHOT_TXD_STRING = 15802758171925831019
    BYPASS_CUTSCENE_CAM_RENDERING_THIS_UPDATE = 15808373553457658374
    NETWORK_GET_PLAYER_ACCOUNT_ID = 15809390380198397865
    REMOVE_ALL_COVER_BLOCKING_AREAS = 15809614640661354200
    GET_RENDERED_CHARACTER_HEIGHT = 15819073411951650688
    GET_TIME_SINCE_PLAYER_DROVE_AGAINST_TRAFFIC = 15819273152188223874
    SET_PLAYER_NOISE_MULTIPLIER = 15819438297272679657
    SET_PACKED_STAT_BOOL_CODE = 15819554148298771719
    SET_GAMEPLAY_CAM_ALTITUDE_FOV_SCALING_STATE = 15821364073188638961
    REQUEST_VEHICLE_DIAL = 15826705244040414864
    SET_PED_ALERTNESS = 15827638201295126950
    GOLF_TRAIL_SET_TESSELLATION = 15828568054653660486
    CLEAR_PRIMARY_VEHICLE_TASK = 15833664685809484071
    SET_DONT_ALLOW_PLAYER_TO_ENTER_VEHICLE_IF_LOCKED_FOR_PLAYER = 15836400051006278540
    GET_VEHICLE_CLASS_MAX_TRACTION = 15837028510951904353
    NETWORK_SPEND_BOSS = 15837302402475801767
    NETWORK_APPLY_VOICE_PROXIMITY_OVERRIDE = 15839728776442845463
    DATAFILE_GET_FILE_DICT_FOR_ADDITIONAL_DATA_FILE = 15850525331203614105
    VEHICLE_WAYPOINT_PLAYBACK_RESUME = 15854074397342684306
    ENABLE_DISPATCH_SERVICE = 15857035167618947158
    GET_MAX_AMMO = 15858883120068610355
    NETWORK_GET_CAN_SPEND_FROM_BANK_AND_WALLET = 15859517473685087541
    SET_GPS_DISABLED_ZONE = 15861757313688621569
    BG_END_CONTEXT = 15864964160901128413
    SET_PED_LOD_MULTIPLIER = 15865156897723921451
    SET_WARNING_MESSAGE_WITH_HEADER = 15868657717162190295
    IS_SPHERE_VISIBLE_TO_PLAYER = 15869050122087553634
    FORCE_RENDER_IN_GAME_UI = 15872265059507774555
    FACEBOOK_POST_CREATE_CHARACTER = 15873015163559105585
    DELETE_STUNT_JUMP = 15875610902764826143
    GET_VEHICLE_MODEL_MAX_BRAKING = 15876311570061300812
    GET_MAXIMUM_NUMBER_OF_CLOUD_PHOTOS = 15876498958784795887
    ROPE_SET_UPDATE_ORDER = 15877341769189295853
    REPORT_POLICE_SPOTTED_PLAYER = 15881049930447711506
    SET_WAIT_FOR_COLLISIONS_BEFORE_PROBE = 15884061753822341267
    SET_PLAYER_PARACHUTE_PACK_MODEL_OVERRIDE = 15888880642546084708
    HAS_BULLET_IMPACTED_IN_BOX = 15892179976513618836
    GET_REPLAY_STAT_COUNT = 15893894299569039463
    SET_CINEMATIC_NEWS_CHANNEL_ACTIVE_THIS_UPDATE = 15897049075608932934
    GET_HAS_RETRACTABLE_WHEELS = 15898116407875072140
    SET_PARTICLE_FX_LOOPED_FAR_CLIP_DIST = 15902655278810117441
    GET_PLAYER_DEBUG_INVINCIBLE = 15906842693044290991
    IS_PED_PERFORMING_MELEE_ACTION = 15909556250171936727
    IS_PLAYER_FREE_FOR_AMBIENT_TASK = 15911169040677300916
    SET_AMMO_IN_CLIP = 15911966477853176983
    SET_WIDESCREEN_BORDERS = 15912601297522708506
    GET_MAIN_PLAYER_BLIP_ID = 15912603139834708730
    NETWORK_HANDLE_FROM_USER_ID = 15912657676102462556
    SHAKE_CINEMATIC_CAM = 15916306959303242703
    IS_THIS_MODEL_A_HELI = 15916903365363078378
    SET_VEHICLE_STEER_FOR_BUILDINGS = 15918390557941869512
    SET_CINEMATIC_MODE_ACTIVE = 15920353646728379726
    SHOW_CREW_INDICATOR_ON_BLIP = 15923423495891924606
    CONTROL_MOUNTED_WEAPON = 15924237928379716442
    IS_SCRIPTED_HUD_COMPONENT_ACTIVE = 15929248037438029669
    REMOVE_PARTICLE_FX_IN_RANGE = 15932040156801233669
    NETWORK_SPEND_NIGHTCLUB_BAR_DRINK = 15934210568977159269
    SET_MULTIPLAYER_BANK_CASH = 15934216371787123978
    DOES_BLIP_HAVE_GPS_ROUTE = 15934361058581903185
    GET_IS_MOPPING_AREA_FREE_IN_FRONT_OF_PLAYER = 15935460304965693425
    PAUSE_MENU_ACTIVATE_CONTEXT = 15949018543013677366
    SET_RADIO_RETUNE_DOWN = 15955074384889273849
    END_TEXT_COMMAND_THEFEED_POST_REPLAY_INPUT = 15955324172998177628
    SET_FOLLOW_CAM_IGNORE_ATTACH_PARENT_MOVEMENT_THIS_UPDATE = 15959032629851251145
    IS_NETWORK_VEHICLE_RUNNING_RESPOT_TIMER = 15959894354593425574
    NETWORK_SPEND_UPGRADE_AUTOSHOP = 15961490048201639020
    RESET_SCENARIO_GROUPS_ENABLED = 15965310171172810042
    CLEAR_AREA_OF_OBJECTS = 15968527570113953627
    DEACTIVATE_AUDIO_SLOWMO_MODE = 15980519519720713302
    NETWORK_IS_FINDING_GAMERS = 15987608017109315754
    START_NETWORKED_PARTICLE_FX_LOOPED_ON_ENTITY_BONE = 15988411105938116355
    DOES_ENTITY_BELONG_TO_THIS_SCRIPT = 15989713108567949778
    PLAYSTATS_WEBSITE_VISITED = 15992930246972209169
    SET_ANIM_PHASE = 15993350289303014217
    NETWORK_OVERRIDE_RECEIVE_RESTRICTIONS = 15994320956569705140
    SET_PED_GESTURE_GROUP = 15994537613504850600
    PAUSE_MENU_GET_HAIR_COLOUR_INDEX = 15997738120179329503
    IS_BULLET_IN_BOX = 16001128347410330449
    DESTROY_ITEMSET = 16003578706972393178
    DISABLE_ON_FOOT_FIRST_PERSON_VIEW_THIS_UPDATE = 16010004042676488415
    IS_TIME_MORE_THAN = 16011721119759610988
    GET_SHOP_PED_QUERY_PROP = 16016102137930089341
    SET_ALL_NEUTRAL_RANDOM_PEDS_FLEE = 16016438143247314529
    IS_PED_WALKING = 16018204685783205658
    NETWORK_FADE_OUT_ENTITY = 16021073340841986541
    NETWORK_EARN_YATCH_MISSION = 16026308921286816050
    CAN_PLAYER_START_MISSION = 16029548722278906886
    DISABLE_SCREENBLUR_FADE = 16033135267915810216
    NETWORK_RESOLVE_PRIVILEGE_USER_CONTENT = 16037922477509689202
    SET_MP_GAMER_TAG_NAME = 16042587305586342212
    ALLOW_MISSION_CREATOR_WARP = 16042774062584529631
    GET_PED_COMBAT_MOVEMENT = 16044394811451421685
    STAT_MIGRATE_CHECK_GET_PLATFORM_STATUS = 16044908746008723095
    UPDATE_LIGHTS_ON_ENTITY = 16045693110842147038
    NETWORK_START_USER_CONTENT_PERMISSIONS_CHECK = 16047092493802644134
    IS_PED_IN_WRITHE = 16048248660544706112
    NETWORK_EARN_FROM_JOBX2 = 16049691646066168272
    LOWER_CONVERTIBLE_ROOF = 16056774613380606013
    SET_DRIVER_RACING_MODIFIER = 16056932847786963607
    GET_VEHICLE_CLASS_FROM_NAME = 16059586183117414912
    NETWORK_EARN_SMUGGLER_AGENCY = 16061545955263709960
    NETWORK_AM_I_MUTED_BY_GAMER = 16069585405642483418
    IS_SCRIPTED_CONVERSATION_LOADED = 16072595822230333239
    SET_ENABLE_HANDCUFFS = 16076435279705359098
    SET_THIRD_PERSON_CAM_ORBIT_DISTANCE_LIMITS_THIS_UPDATE = 16081825916459691649
    SET_PAUSE_MENU_ACTIVE = 16089105643441842639
    IS_REPLAY_INITIALIZED = 16090118124908059541
    SC_GET_NEW_ROCKSTAR_MSG = 16097162829550704520
    SET_OBJECT_SPEED_BOOST_DURATION = 16099418909101159291
    HAS_SCALEFORM_SCRIPT_HUD_MOVIE_LOADED = 16099904157786624320
    GET_BLIP_COLOUR = 16101105946780988199
    SET_BLIP_SPRITE = 16101307653538016687
    GET_VEHICLE_SIZE = 16104378497256139832
    DOOR_SYSTEM_GET_IS_PHYSICS_LOADED = 16111572506586447156
    SET_PED_CAN_RAGDOLL_FROM_PLAYER_IMPACT = 16111978299072887333
    REQUEST_STREAMED_TEXTURE_DICT = 16114705809917771221
    IS_SWITCH_READY_FOR_DESCENT = 16116145226749974963
    IS_CAM_ACTIVE = 16119145122951410996
    GET_COORDS_OF_PROJECTILE_TYPE_WITHIN_DISTANCE = 16119530470897449857
    PLAYSTATS_HEIST3_DRONE = 16122204690296595099
    TOGGLE_PAUSED_RENDERPHASES = 16123540706355665591
    GET_FINAL_RENDERED_CAM_FAR_CLIP = 16125362517181313276
    PLAYSTATS_HEIST4_PREP = 16126740742401536865
    HAS_ENTITY_BEEN_DAMAGED_BY_ANY_VEHICLE = 16128801213299861960
    SET_DISABLE_PED_MAP_COLLISION = 16133736970873347067
    STOP_AUDIO_SCENE = 16134218418505442952
    PLAY_POLICE_REPORT = 16135224756727311126
    NETWORK_GET_PRESENCE_INVITE_ID = 16136562696038302598
    NETWORK_EARN_RC_TIME_TRIAL = 16137698090569673448
    NETWORK_SESSION_GET_HOST_AIM_PREFERENCE = 16139313267567506196
    SET_VEHICLE_ACTIVE_DURING_PLAYBACK = 16140038260948851528
    SET_ENTITY_VISIBLE_IN_CUTSCENE = 16141777635363957634
    SET_SCRIPT_ROCKET_BOOST_RECHARGE_TIME = 16145170128856116873
    GET_MINIMAP_FOW_DISCOVERY_RATIO = 16146261466407716212
    CLEAR_LAST_DRIVEN_VEHICLE = 16147942081350518942
    SET_VEHICLE_USE_CUTSCENE_WHEEL_COMPRESSION = 16151008515437609239
    NETWORK_CLEAR_VOICE_CHANNEL = 16156284357341470793
    IS_WAYPOINT_PLAYBACK_GOING_ON_FOR_PED = 16157577551664225124
    SET_PED_PATHS_BACK_TO_ORIGINAL = 16162091895400587859
    TASK_WANDER_IN_AREA = 16164602603745899285
    SET_REPLAY_SYSTEM_PAUSED_FOR_SAVE = 16165696561629620122
    SET_VEHICLE_USED_FOR_PILOT_SCHOOL = 16167307938362295203
    SET_NETWORK_ID_EXISTS_ON_ALL_MACHINES = 16167502273159259080
    DAMAGE_OBJECT_FRAGMENT_CHILD = 16167758761991125762
    STAT_SAVE = 16175744795673809661
    NETWORK_EARN_ARENA_SKILL_LEVEL_PROGRESSION = 16177588440840780588
    IS_CONVERSATION_PED_DEAD = 16186129209363659450
    UGC_GET_CONTENT_NUM = 16187647368315582519
    SET_PLAYER_WANTED_LEVEL_NOW = 16188138165339409775
    GET_PED_EXTRACTED_DISPLACEMENT = 16190230929004791779
    IS_PED_HAIR_TINT_FOR_BARBER = 16200413632953699361
    BEGIN_REPLAY_STATS = 16205358990659894630
    STAT_GET_NUMBER_OF_DAYS = 16206296671008569193
    SET_ENTITY_ICON_VISIBILITY = 16206413183313164849
    NETWORK_EARN_NIGHTCLUB = 16210756786758848856
    SET_CAM_DOF_OVERRIDDEN_FOCUS_DISTANCE_BLEND_LEVEL = 16217928179736693701
    NETWORK_GET_FRIEND_NAME = 16221609283824123531
    BEGIN_TEXT_COMMAND_CLEAR_PRINT = 16223367188165755292
    SET_CAN_AUTO_VAULT_ON_ENTITY = 16224989919468624492
    GET_PED_PROP_TEXTURE_INDEX = 16226929629455719090
    SET_ENTITY_LOCALLY_INVISIBLE = 16228063746044265944
    GET_CLOSEST_OBJECT_OF_TYPE = 16232092507137524585
    HAS_VC_WITHDRAWAL_COMPLETED = 16236801067431457468
    SET_PLANE_RESIST_TO_EXPLOSION = 16240335094792118013
    IS_MOUSE_LOOK_INVERTED = 16240365910995219709
    SET_PED_MODEL_IS_SUPPRESSED = 16241005812428730129
    CAN_REGISTER_MISSION_DOORS = 16242978679968165315
    START_PARTICLE_FX_LOOPED_AT_COORD = 16250382670785745127
    IS_WARNING_MESSAGE_ACTIVE = 16252105188079644931
    NET_GAMESERVER_BASKET_APPLY_SERVER_DATA = 16258070584803096594
    NETWORK_SPENT_BUY_WANTEDLEVEL = 16262840690705417462
    RESET_PAUSED_RENDERPHASES = 16269377434949960732
    GET_FORCED_PROP = 16269962752828533021
    THEFEED_RESUME = 16270694327106528865
    GET_SCALEFORM_MOVIE_METHOD_RETURN_VALUE_STRING = 16276669321232011845
    PLAY_FACIAL_ANIM = 16277799782697402605
    CLEAR_PED_TASKS = 16280297226355339981
    SET_ENTITY_CAN_BE_DAMAGED_BY_RELATIONSHIP_GROUP = 16297840812409717017
    NETWORK_SPENT_PA_SERVICE_IMPOUND = 16301584173928229294
    UPDATE_PLAYER_TELEPORT = 16302283480354081889
    IS_DISABLED_CONTROL_PRESSED = 16309926292945926941
    SET_BLIP_HIGH_DETAIL = 16310080455802146491
    DEPOSIT_VC = 16312284946730948012
    PLAY_TENNIS_SWING_ANIM = 16313987435599963348
    REFRESH_PLAYER_LIST_STATS = 16315644214271380596
    NETWORK_SPENT_RDR_HATCHET_BONUS = 16322404526960684598
    SET_DISTANCE_BLUR_STRENGTH_OVERRIDE = 16323629444521985850
    GET_PLAYER_WANTED_LEVEL = 16325078576001511725
    NETWORK_EARN_AGENCY_PHONE = 16329838254888786818
    TASK_VEHICLE_DRIVE_TO_COORD = 16330802319343843239
    NET_GAMESERVER_END_SERVICE = 16332755515527131135
    SET_ARTIFICIAL_VEHICLE_LIGHTS_STATE = 16334986584629394738
    NETWORK_EARN_FROM_ISLAND_HEIST_DJ_MISSION = 16337715422114881681
    CREATE_TRACKED_POINT = 16341667072337373792
    NETWORK_EARN_DISPATCH_CALL = 16348705100723340419
    RESET_FORMATION_LEADER = 16354046990608625121
    SET_CARGOBOB_PICKUP_MAGNET_SET_TARGETED_MODE = 16357563558409616624
    REMOVE_VEHICLE_COMBAT_AVOIDANCE_AREA = 16358521772546410525
    NETWORK_GET_RANDOM_INT_RANGED = 16360721403940069187
    IS_ENTITY_OCCLUDED = 16365004017189333860
    PLAYSTATS_BC_FINDERS_KEEPERS = 16367802301768026827
    PLAY_SYNCHRONIZED_CAM_ANIM = 16370301635947768332
    IS_SPHERE_VISIBLE = 16374342614917681119
    IS_TURRET_SEAT = 16375082268351744128
    SET_GAMEPLAY_HINT_CAMERA_BLEND_TO_FOLLOW_PED_MEDIUM_VIEW_MODE = 16376001585667894848
    ANIMPOSTFX_GET_CURRENT_TIME = 16382750340049432953
    SET_PED_PATH_CAN_DROP_FROM_HEIGHT = 16384594378313898575
    POW = 16384690022721388078
    ENABLE_STUNT_JUMP_SET = 16386810654977581078
    GET_TIME_SINCE_PLAYER_HIT_PED = 16386951091587342146
    SET_CAR_GENERATORS_CAN_UPDATE_DURING_CUTSCENE = 16387078250494245990
    HIDE_SCRIPTED_HUD_COMPONENT_THIS_FRAME = 16389941104658275348
    SET_INTERIOR_ACTIVE = 16391825850913138925
    APPLY_IMPULSE_TO_CLOTH = 16392946616666363780
    POP_OFF_VEHICLE_ROOF_WITH_IMPULSE = 16396684679968709580
    GET_NUM_VEHICLE_MODS = 16397203146118530630
    ADD_TO_ITEMSET = 16398822311459174365
    TASK_GOTO_ENTITY_OFFSET = 16400790381650501159
    RESET_SCRIPT_GFX_ALIGN = 16403195341277969835
    SHOOT_SINGLE_BULLET_BETWEEN_COORDS_IGNORE_ENTITY = 16404207908830195595
    ADD_EXPLOSION = 16405817240112490924
    GET_GLOBAL_ACTIONSCRIPT_FLAG = 16406708090115837972
    CLEAR_PED_DECORATIONS_LEAVE_SCARS = 16407315415432929036
    IS_PED_RUNNING_RAGDOLL_TASK = 16408312723812296350
    PREVENT_ARREST_STATE_THIS_FRAME = 16418270269239458654
    GET_PED_PALETTE_VARIATION = 16419384452682359425
    RESET_ADAPTATION = 16420900173499972727
    NET_GAMESERVER_INIT_SESSION = 16421716086407481069
    SET_BOAT_REMAINS_ANCHORED_WHILE_PLAYER_IS_DRIVER = 16423408364588467504
    NETWORK_SPENT_HIRE_MUGGER = 16430468144015236080
    REGISTER_ENTITY_FOR_CUTSCENE = 16432540299811996392
    SET_VEHICLE_XENON_LIGHT_COLOR_INDEX = 16433691881432431111
    TASK_VEHICLE_AIM_AT_PED = 16436033458109198487
    APP_CLOSE_APP = 16437124754795595260
    IS_BLIP_ON_MINIMAP = 16437194366933105191
    GET_RESERVED_MISSION_ENTITIES_IN_AREA = 16441906043154654681
    BLOCK_DECISION_MAKER_EVENT = 16442587251302569719
    GET_VEHICLE_HAS_LANDING_GEAR = 16444614503220375972
    BLOCK_PED_FROM_GENERATING_DEAD_BODY_EVENTS_WHEN_DEAD = 16445478747144768463
    COPY_VEHICLE_DAMAGES = 16450127866771058467
    SET_MISSION_NAME_FOR_UGC_MISSION = 16451798802165566402
    IS_PED_STRAFING = 16454885448303803913
    GET_COLLISION_NORMAL_OF_LAST_HIT_FOR_ENTITY = 16457794246291140210
    SET_PED_DEFENSIVE_SPHERE_ATTACHED_TO_VEHICLE = 16461287443765054719
    GET_VEHICLE_CAUSE_OF_DESTRUCTION = 16471302037889482016
    STAT_CLOUD_SLOT_LOAD_FAILED_CODE = 16471534362760120918
    UPDATE_TASK_SWEEP_AIM_ENTITY = 16471702047283889331
    GET_SYNCHRONIZED_SCENE_PHASE = 16475030217870177228
    GET_INTERIOR_GROUP_ID = 16476501421259159834
    HAS_ACTION_MODE_ASSET_LOADED = 16480347513358012005
    HAS_PLAYER_DAMAGED_AT_LEAST_ONE_NON_ANIMAL_PED = 16481221038019450706
    ADD_VALID_VEHICLE_HIT_HASH = 16484214127907910615
    GET_HELI_MAIN_ROTOR_HEALTH = 16486399787048096453
    SET_EQIPPED_WEAPON_START_SPINNING_AT_FULL_SPEED = 16491315969314470309
    SET_VEHICLE_BRAKE = 16493023177471202908
    NETWORK_DOES_TUNABLE_EXIST_HASH = 16493657466368168231
    STOP_SMOKE_GRENADE_EXPLOSION_SOUNDS = 16494114044158053506
    SC_PAUSE_NEWS_INIT_STARTER_PACK = 16498630267019136849
    STAT_GET_STRING = 16502179337152486260
    GET_NTH_CLOSEST_VEHICLE_NODE = 16505220125311341707
    IS_GAMEPLAY_HINT_ACTIVE = 16510476724605573952
    SET_PED_AI_BLIP_GANG_ID = 16513449137041283592
    NETWORK_FIND_GAMERS_IN_CREW = 16515498633516961066
    SET_WANTED_RESPONSE_NUM_PEDS_TO_SPAWN = 16515522381597580111
    SET_MODEL_AS_NO_LONGER_NEEDED = 16515533089562745515
    IS_POINT_OBSCURED_BY_A_MISSION_ENTITY = 16523179938161861005
    SET_AUDIO_VEHICLE_PRIORITY = 16525471215939746068
    NETWORK_ACCESS_TUNABLE_FLOAT = 16528365284492720735
    NETWORK_SESSION_GET_INVITER = 16533725459096182224
    RESTART_GAME = 16534023074718088113
    SET_AIRCRAFT_PILOT_SKILL_NOISE_SCALAR = 16537511156596798197
    GET_MOTIONBLUR_MAX_VEL_SCALER = 16542640528184125927
    GET_SYSTEM_TIME_STEP = 16544436141437451803
    SET_DRIVEBY_TASK_TARGET = 16551575328854729454
    GET_NUM_PED_HAIR_TINTS = 16555460409682481488
    TASK_STAY_IN_COVER = 16562698007147448201
    SAVEMIGRATION_MP_REQUEST_STATUS = 16566900704589225885
    NETWORK_SPEND_MAKE_IT_RAIN = 16570326739291221853
    SET_LOCAL_PLAYER_INVISIBLE_LOCALLY = 16570840629414318440
    PLAYSTATS_CASINO_SLOT_MACHINE_LIGHT = 16573339679104443007
    SET_DISABLE_TURRET_MOVEMENT = 16579363737896666986
    SET_PICKUP_AMMO_AMOUNT_SCALER = 16582532232365756184
    GET_CUTSCENE_TIME = 16583870847647734457
    TOGGLE_PLAYER_DAMAGE_OVERLAY = 16590553418165958251
    NETWORK_ENTITY_AREA_DOES_EXIST = 16594142437274433449
    IS_ENTITY_ON_SCREEN = 16598549118451140683
    PLAY_SOUND_FROM_ENTITY = 16600059863515181549
    LEADERBOARDS2_READ_BY_SCORE_FLOAT = 16601051866252480316
    SET_ENTITY_MIRROR_REFLECTION_FLAG = 16601244377441519632
    NETWORK_APPLY_PED_SCAR_DATA = 16603761384742785360
    NETWORK_ENABLE_EXTRA_VEHICLE_ORIENTATION_BLEND_CHECKS = 16605192274079157642
    NETWORK_OVERRIDE_CLOCK_TIME = 16607555653966641298
    ALLOW_DISPLAY_OF_MULTIPLAYER_CASH_TEXT = 16608270460176475623
    REMOVE_POP_MULTIPLIER_SPHERE = 16611135717234385923
    GET_PED_WAYPOINT_DISTANCE = 16620666118384589765
    SET_SCALEFORM_MOVIE_TO_USE_SUPER_LARGE_RT = 16621079839524304153
    START_SHAPE_TEST_SWEPT_SPHERE = 16621779372552499204
    GET_VEHICLE_HOMING_LOCKON_STATE = 16623042203658435568
    CANCEL_STUNT_JUMP = 16624950805814097758
    SET_ENABLE_VEHICLE_SLIPSTREAMING = 16627509776179688759
    CLEAR_ALL_PED_VEHICLE_FORCED_SEAT_USAGE = 16630251801833955691
    HAS_SCRIPT_LOADED = 16630842602425130737
    SET_WEAPON_EFFECT_DURATION_MODIFIER = 16632583823339551118
    CLEAR_GPS_CUSTOM_ROUTE = 16635739991366117988
    SET_HELI_TURBULENCE_SCALAR = 16641144020667700442
    WAYPOINT_PLAYBACK_START_SHOOTING_AT_PED = 16648584860776239324
    IS_PLAYER_IN_CUTSCENE = 16658976598673641766
    GET_IS_PRELOADED_CONVERSATION_READY = 16659770340757966842
    TASK_PAUSE = 16661672023969927234
    SC_COMMUNITY_EVENT_GET_EXTRA_DATA_INT_FOR_TYPE = 16670718533674560902
    RESET_TREVOR_RAGE = 16682744453613688032
    SET_NOISEOVERIDE = 16683513473157047241
    DOES_THIS_PHOTO_SLOT_CONTAIN_A_VALID_PHOTO = 16686363420566301835
    GET_MUSIC_PLAYTIME = 16690571381759561851
    NETWORK_SPENT_HIRE_MERCENARY = 16697111200514182102
    IS_VEHICLE_ATTACHED_TO_TRAILER = 16703635855612878604
    GET_INTERIOR_FROM_PRIMARY_VIEW = 16704528233003574979
    ADD_TEXT_COMPONENT_FLOAT = 16707428521474840942
    NETWORK_SPENT_MOVE_YACHT = 16708158927121921390
    DATADICT_SET_INT = 16708413188189276373
    GET_MOUNT = 16708666388346900568
    BREAK_OBJECT_FRAGMENT_CHILD = 16709693378984958208
    DRAW_SPRITE = 16717272063779526800
    CLEAR_BIT = 16718648974139562643
    START_NEW_SCRIPT = 16723644071793487432
    LOG10 = 16723807522761735712
    GET_ENTITY_SUBMERGED_LEVEL = 16724957362389795278
    SET_RADAR_AS_EXTERIOR_THIS_FRAME = 16725099261547195777
    IS_PED_COMPONENT_VARIATION_VALID = 16728047655949133597
    DRAW_MARKER_EX = 16728384355880522042
    SET_FLY_CAM_VERTICAL_RESPONSE = 16728542991814967738
    ADD_ROPE = 16731672373918347808
    SCALEFORM_MOVIE_METHOD_ADD_PARAM_PLAYER_NAME_STRING = 16733755764273145408
    GET_ENTITY_HEADING = 16734619320245782804
    SET_BOAT_LOW_LOD_ANCHOR_DISTANCE = 16736125229695876482
    GET_OBJECT_TINT_INDEX = 16739520511557890922
    DOOR_SYSTEM_GET_AUTOMATIC_DISTANCE = 16740239470930114383
    SET_VEHICLE_MAY_BE_USED_BY_GOTO_POINT_ANY_MEANS = 16740412531408164026
    NETWORK_GET_LOCAL_HANDLE = 16744472992203328910
    SET_PED_CAN_LOSE_PROPS_ON_DAMAGE = 16744894345424298680
    NETWORK_SPEND_ISLAND_HEIST = 16746223885228041257
    NETWORK_HAS_HEADSET = 16749161831829139962
    GET_HAS_VEHICLE_BEEN_HIT_BY_SHUNT = 16749326472444891684
    NETWORK_EARN_HACKER_TRUCK = 16753777545602230995
    STAT_GET_CURRENT_NEAR_MISS_NOCRASH_PRECISE = 16754868069277946070
    OPEN_SEQUENCE_TASK = 16754879640974778667
    SET_PED_RESERVE_PARACHUTE_TINT_INDEX = 16757226213359133357
    HAS_PEDHEADSHOT_IMG_UPLOAD_SUCCEEDED = 16762795726337721665
    SET_CONTROL_VALUE_NEXT_FRAME = 16763057966653091934
    GET_PLAYER_RADIO_STATION_INDEX = 16766751624649170067
    NETWORK_SPENT_ORDER_BODYGUARD_VEHICLE = 16767097609875081070
    HAS_RESUMED_FROM_SUSPEND = 16769646809987956533
    GET_VEHICLE_MOD_COLOR_1 = 16777699334157870739
    APP_CLOSE_BLOCK = 16781534775082749688
    GET_PLAYER_RGB_COLOUR = 16790245784519841679
    SET_PED_ENABLE_CREW_EMBLEM = 16791368377059764168
    REMOVE_DECALS_FROM_VEHICLE = 16798175259792805207
    NETWORK_IS_GAMER_BLOCKED_BY_ME = 16808776268737370243
    CLONE_PED_TO_TARGET = 16812735942556757402
    GET_TENNIS_SWING_ANIM_SWUNG = 16815047366265780587
    PLAYSTATS_WEAPON_MODE_CHANGE = 16815466946351869092
    HAS_COLLISION_LOADED_AROUND_ENTITY = 16818533798995768097
    HAS_STEALTH_MODE_ASSET_LOADED = 16823192400983700545
    REPORT_CRIME = 16839123424570066407
    UGC_CANCEL_QUERY = 16841663153901671433
    SET_IN_VEHICLE_CAM_STATE_THIS_UPDATE = 16855309667613334692
    RELEASE_NAMED_RENDERTARGET = 16858943627931766228
    SET_ENTITY_IS_TARGET_PRIORITY = 16862287563816601378
    GET_VEHICLE_BOMB_AMMO = 16866751443983755681
    IS_COMMERCE_DATA_VALID = 16867369243527425072
    RESET_AI_WEAPON_DAMAGE_MODIFIER = 16867782766264349756
    NETWORK_ACCESS_TUNABLE_BOOL_HASH = 16867870242269239877
    SET_ENTITY_VISIBLE = 16869464999882091451
    SET_PARTICLE_FX_OVERRIDE = 16869971367703305945
    NETWORK_RESURRECT_LOCAL_PLAYER = 16871544814804643067
    SET_PLAYER_ANGRY = 16871640547856543889
    UI_STARTED_END_USER_BENCHMARK = 16874741932035599760
    DELETE_VEHICLE = 16877355631701828943
    TASK_PLAY_ANIM = 16881741240819145620
    NETWORK_GET_REMAINING_TRANSFER_BALANCE = 16885695715281592731
    GET_ROPE_VERTEX_COORD = 16889002791013490253
    DISABLE_GAMEPLAY_CAM_ALTITUDE_FOV_SCALING_THIS_UPDATE = 16897236249372944239
    NETWORK_REGISTER_HIGH_FREQUENCY_HOST_BROADCAST_VARIABLES = 16900898736146907690
    NETWORK_SPEND_BUY_AGENCY = 16901116364872439940
    SC_PAUSE_NEWS_SHUTDOWN = 16903628454843877518
    GET_DEFAULT_SECONDARY_TINT_FOR_CREATOR = 16904649124889874192
    SET_BLIP_NAME_FROM_TEXT_FILE = 16906794343532668804
    NETWORK_BAIL_TRANSITION = 16908045735013960987
    REMOVE_ALL_SHOCKING_EVENTS = 16909865403413505868
    CAN_CREATE_RANDOM_BIKE_RIDER = 16919722156279042396
    NETWORK_SPEND_PLAY_ARCADE = 16921105853358675032
    CAN_PED_IN_COMBAT_SEE_TARGET = 16921200154546865953
    SET_PARKED_VEHICLE_DENSITY_MULTIPLIER_THIS_FRAME = 16926459000783100701
    IS_ALLOWED_INDEPENDENT_CAMERA_MODES = 16929306397907469714
    HAS_ANIM_EVENT_FIRED = 16930382980430948642
    GET_PED_PARACHUTE_TINT_INDEX = 16930710940016209053
    TASK_RAPPEL_DOWN_WALL_USING_CLIPSET_OVERRIDE = 16930837281545734035
    ACTIVITY_FEED_ACTION_START_WITH_COMMAND_LINE = 16935659554214521565
    INIT_SHOP_PED_PROP = 16936397132598576399
    STAT_CLEAR_SLOT_FOR_RELOAD = 16936474796576384173
    SET_WIND_DIRECTION = 16937831938213496104
    RELEASE_MOVIE_MESH_SET = 16938489685853376899
    STOP_SAVE_STRUCT = 16940137024818224914
    START_NEW_SCRIPT_WITH_NAME_HASH = 16941529988248844946
    QUEUE_MISSION_REPEAT_SAVE_FOR_BENCHMARK_TEST = 16942828672015332073
    SC_PROFANITY_CHECK_STRING_UGC = 16945910801758026280
    REPLAY_PREVENT_RECORDING_THIS_FRAME = 16946291525136165696
    RESET_DISPATCH_TIME_BETWEEN_SPAWN_ATTEMPTS = 16946395358004597939
    HUD_FORCE_WEAPON_WHEEL = 16948538893060047271
    GET_TOGGLE_PAUSED_RENDERPHASES_STATUS = 16950893879719108190
    SET_SCENARIO_TYPE_ENABLED = 16953779142900023009
    GET_NUMBER_RESOURCES_ALLOCATED_TO_WANTED_LEVEL = 16954377136050018071
    QUIT_GAME = 16962968457331276562
    SET_OBJECT_TAKES_DAMAGE_FROM_COLLIDING_WITH_BUILDINGS = 16964807575777355218
    SET_PED_STEERS_AROUND_VEHICLES = 16964982643892298732
    IS_UPDATING_MP_GAMER_TAG_NAME_AND_CREW_DETAILS = 16965229355532467725
    CLEAR_VALID_VEHICLE_HIT_HASHES = 16970025031319957895
    TASK_SET_DECISION_MAKER = 16970997011576201434
    SET_VEHICLE_TYRES_CAN_BURST = 16977941433352285254
    GET_RELATIONSHIP_BETWEEN_PEDS = 16980168434936410401
    PLAY_STREAM_FROM_OBJECT = 16981556202366523133
    IS_PEDHEADSHOT_IMG_UPLOAD_AVAILABLE = 16984048875808885416
    NETWORK_IS_NP_PENDING = 16990596937483039988
    IS_PED_PERFORMING_A_COUNTER_ATTACK = 16992342778730600399
    ACTIVITY_FEED_ADD_LITERAL_SUBSTRING_TO_CAPTION = 16992961390462974445
    NETWORK_SPEND_SUPPLY = 16993351021479300013
    SET_PED_SUFFERS_CRITICAL_HITS = 16994173916529397932
    NETWORK_APPLY_TRANSITION_PARAMETER_STRING = 17001021417627907481
    NETWORK_REMOVE_AND_CANCEL_ALL_INVITES = 17003384706675108691
    UGC_HAS_DESCRIPTION_REQUEST_FINISHED = 17004058720744527044
    NETWORK_SPENT_CARWASH = 17006655531746542342
    NETWORK_USE_HIGH_PRECISION_TRAIN_BLENDING = 17009002092623271764
    GET_CONTROL_NORMAL = 17022651722841437539
    SET_PED_CAN_USE_AUTO_CONVERSATION_LOOKAT = 17025443789596214904
    SET_PED_INJURED_ON_GROUND_BEHAVIOUR = 17026785535546885418
    GET_INTERIOR_FROM_COLLISION = 17027259154904532004
    SET_NETWORK_VEHICLE_RESPOT_TIMER = 17028516163055531752
    SCALEFORM_MOVIE_METHOD_ADD_PARAM_LATEST_BRIEF_STRING = 17028891057506688003
    BAD_SPORT_PLAYER_LEFT_DETECTED = 17032115665384622721
    IS_PED_ON_SPECIFIC_VEHICLE = 17032445446681738162
    SET_PED_SHOULD_PLAY_DIRECTED_NORMAL_SCENARIO_EXIT = 17035206352705977232
    GET_BOTH_VEHICLE_HEADLIGHTS_DAMAGED = 17035338351297355971
    SET_VEHICLE_TYRE_BURST = 17035463926257943429
    LOAD_HIGH_QUALITY_PHOTO = 17037894025228314090
    TAKE_CONTROL_OF_FRONTEND = 17046797982469197608
    NETWORK_EARN_FROM_CONTRABAND = 17052414681581247090
    GET_ENTITY_MATRIX = 17055972306262151479
    STAT_LOAD_DIRTY_READ_DETECTED = 17056287129341346817
    GET_DLC_VEHICLE_MODEL = 17059665609335452476
    SET_PLAYER_TARGETTABLE_FOR_AIR_DEFENCE_SPHERE = 17067552057518837576
    GET_CONTENT_ID_INDEX = 17073217760514446556
    SET_PAUSE_MENU_PED_SLEEP_STATE = 17073471867460778481
    NETWORK_EARN_FROM_PICKUP = 17083586959442953880
    NETWORK_EARN_GANGOPS_PREP_PARTICIPATION = 17088442934239214589
    SET_PED_DRIVE_BY_CLIPSET_OVERRIDE = 17092474967677953312
    NETWORK_SESSION_HOST_CLOSED = 17092498417382951863
    FORCE_INSTANT_LEG_IK_SETUP = 17094668775194429380
    REMOVE_DECAL = 17095440315324356185
    NETWORK_CASINO_SELL_CHIPS = 17096941254080918656
    SPECIAL_ABILITY_CHARGE_CONTINUOUS = 17097941492585458071
    PLAYER_ATTACH_VIRTUAL_BOUND = 17100575969275211089
    NETWORK_GET_CAN_SPEND_FROM_WALLET = 17103185420626541242
    SET_BOAT_IGNORE_LAND_PROBES = 17104353206720676809
    NETWORK_SPENT_PA_SERVICE_VEHICLE = 17104627056680231522
    PLAY_AMBIENT_SPEECH_FROM_POSITION_NATIVE = 17105797387423809093
    IS_PED_HAIR_TINT_FOR_CREATOR = 17108486860360617182
    SET_WEATHER_TYPE_NOW_PERSIST = 17109505538612268170
    REMOVE_PED_FROM_GROUP = 17110301433960623042
    NETWORK_SPENT_PURCHASE_NIGHTCLUB_AND_WAREHOUSE = 17111094275994795903
    SET_PED_CAN_SWITCH_WEAPON = 17113536741096813376
    SET_CARGOBOB_PICKUP_MAGNET_PULL_STRENGTH = 17114389929821051818
    SET_PED_WAYPOINT_ROUTE_OFFSET = 17120681420994176180
    REGISTER_TEXT_LABEL_TO_SAVE = 17127509531294361135
    SET_DISABLE_HELI_EXPLODE_FROM_BODY_DAMAGE = 17130712242632350921
    PLAYSTATS_FM_EVENT_CRIMINALDAMAGE = 17131530920737400264
    GET_STATE_OF_CLOSEST_DOOR_OF_TYPE = 17132156668443833343
    SET_CAM_FAR_DOF = 17138750295828967136
    SHIFT_LEFT = 17138829061642276328
    SET_INPUT_EXCLUSIVE = 17141956811594263985
    NETWORK_EARN_FROM_VEHICLE_EXPORT = 17143754251928299699
    SET_PED_STAY_IN_VEHICLE_WHEN_JACKED = 17146338063427094945
    UGC_GET_QUERY_RESULT = 17147448052461347403
    SET_PED_NON_CREATION_AREA = 17149993380040246250
    PLAY_ANIMAL_VOCALIZATION = 17151515459292797962
    STOP_ANIM_PLAYBACK = 17152180813269878225
    SET_WIND_SPEED = 17152501161601681404
    ENABLE_MP_LIGHT = 17159971021127289167
    GET_NUM_DLC_WEAPONS = 17169801364938531687
    FORCE_CLOSE_REPORTUGC_MENU = 17171115343732485231
    SET_PLAYER_HOMING_DISABLED_FOR_ALL_VEHICLE_WEAPONS = 17171871140348143684
    GET_CUTSCENE_TOTAL_DURATION = 17173264735913935060
    WOULD_ENTITY_BE_OCCLUDED = 17175930811431119938
    NETWORK_PLAYER_ID_TO_INT = 17178991153621971998
    REMOVE_IPL = 17180206544770345005
    SET_ALL_MP_GAMER_TAGS_VISIBILITY = 17183202346688145072
    GET_CAM_VIEW_MODE_FOR_CONTEXT = 17183360736828670690
    GET_FOLLOW_VEHICLE_CAM_ZOOM_LEVEL = 17186343154491045520
    NETWORK_SPENT_IN_STRIPCLUB = 17192905330013989020
    SET_DAMPING = 17195783518102140507
    IS_COLLISION_MARKED_OUTSIDE = 17196340069418152936
    TASK_SYNCHRONIZED_SCENE = 17197321818494048340
    SET_PED_DIES_INSTANTLY_IN_WATER = 17201007542980421583
    NETWORK_SPEND_BUY_AUTOSHOP = 17201469991848904809
    GET_VEHICLE_COLOURS_WHICH_CAN_BE_SET = 17203688625676236212
    SET_PARTICLE_FX_CAM_INSIDE_VEHICLE = 17204881356220425488
    NETWORK_CLAN_PLAYER_GET_DESC = 17214704787170742202
    SET_PED_SHOULD_PLAY_FLEE_SCENARIO_EXIT = 17216574936252095088
    NETWORK_CHANGE_TRANSITION_SLOTS = 17216599361375963527
    GET_ENTITY_HEALTH = 17217360309205258761
    ACTIVATE_FRONTEND_MENU = 17222278909183986811
    NETWORK_SESSION_IS_VOICE_SESSION_BUSY = 17224318994409114443
    APPLY_PED_BLOOD_SPECIFIC = 17225521098971257615
    SET_AUDIO_SCENE_VARIABLE = 17231240493402826344
    NETWORK_SET_TRANSITION_CREATOR_HANDLE = 17232588137186265045
    CLONE_PED = 17233482896622930651
    GET_PED_VISUAL_FIELD_CENTER_ANGLE = 17234274819683213245
    SET_EXPOSURETWEAK = 17237962906896647673
    SET_SRL_POST_CUTSCENE_CAMERA = 17238070873252424076
    DETONATE_VEHICLE_PHONE_EXPLOSIVE_DEVICE = 17242540257743764670
    GET_MENU_PED_INT_STAT = 17243418215069965421
    GET_PLAYER_PARACHUTE_SMOKE_TRAIL_COLOR = 17246213354101229703
    PLAYSTATS_CASINO_SLOT_MACHINE = 17248441864007942922
    NETWORK_SET_VOICE_CHANNEL = 17249370151240800803
    CALL_SCALEFORM_MOVIE_METHOD_WITH_NUMBER_AND_STRING = 17250525507777368241
    LOBBY_AUTO_MULTIPLAYER_FREEMODE = 17256975445195564620
    SET_CHECK_FOR_ENOUGH_ROOM_FOR_PED = 17266018735609052996
    ADJUST_NEXT_POS_SIZE_AS_NORMALIZED_16_9 = 17270116489102613116
    TRIGGER_SCREENBLUR_FADE_OUT = 17270399324890869973
    OVERRIDE_INTERIOR_SMOKE_END = 17272815833152992190
    IS_ENTITY_ATTACHED_TO_ENTITY = 17275370056189556520
    SET_SCRIPT_RAMP_IMPULSE_SCALE = 17276154640824366429
    SET_PLAYER_FALL_DISTANCE_TO_TRIGGER_RAGDOLL_OVERRIDE = 17282457639463922123
    DISABLE_REGION_VFX = 17282985733030960013
    GET_ENTITY_ATTACHED_TO_TOW_TRUCK = 17287657456831270773
    SET_CAN_PED_SELECT_ALL_WEAPONS = 17290046886974186761
    NETWORK_IS_CABLE_CONNECTED = 17292456173534314745
    GET_PED_WEAPONTYPE_IN_SLOT = 17293496626451649357
    NETWORK_BUY_ITEM = 17295929755209999189
    END_TEXT_COMMAND_THEFEED_POST_MPTICKER = 17303051221525879610
    NETWORK_REMOVE_PRESENCE_INVITE = 17303113892708840625
    GET_LENGTH_OF_LITERAL_STRING = 17307492233653037565
    GET_FM_FEMALE_SHOP_PED_APPAREL_ITEM_INDEX = 17308249935942122216
    NETWORK_CLEAR_VOICE_PROXIMITY_OVERRIDE = 17309397603964700428
    LEADERBOARDS_GET_CACHE_TIME = 17315245624822986440
    SET_VEHICLE_SLIPSTREAMING_SHOULD_TIME_OUT = 17316861459643906496
    SET_USE_HIGHER_CAR_JUMP = 17323683974913013976
    PLAYSTATS_BW_AIR_FREIGHT = 17323781245007844419
    PAUSE_MENU_SET_WARN_ON_TAB_CHANGE = 17324991050806069731
    NETWORK_REMOVE_AND_CANCEL_ALL_TRANSITION_INVITES = 17330840219808340990
    REMOVE_MODEL_FROM_CREATOR_BUDGET = 17331731064279450531
    GET_IS_VEHICLE_PRIMARY_COLOUR_CUSTOM = 17335973723136045595
    SET_PED_RAGDOLL_ON_COLLISION = 17340250254854485143
    GET_PED_WEAPON_COMPONENT_TINT_INDEX = 17340547693307858733
    TASK_VEHICLE_MISSION_COORS_TARGET = 17343116606543362243
    CLEAR_PLAYER_HAS_DAMAGED_AT_LEAST_ONE_PED = 17345185489865105304
    IS_PROJECTILE_TYPE_IN_ANGLED_AREA = 17346759931086364320
    NETWORK_PATCH_POST_CUTSCENE_HS4F_TUN_ENT = 17346911170109706709
    ABSI = 17353243276582801287
    REQUEST_PEDHEADSHOT_IMG_UPLOAD = 17355447100583439909
    DISABLE_VEHCILE_DYNAMIC_AMBIENT_SCALES = 17358203470965593196
    IS_OBJECT_PARTIALLY_INSIDE_GARAGE = 17361048525663314810
    GET_ROTATION_OF_VEHICLE_RECORDING_ID_AT_TIME = 17361957376151309223
    GET_INTERIOR_AT_COORDS_WITH_TYPEHASH = 17363481972041050013
    SET_PED_ID_RANGE = 17368105809406184965
    GET_IS_PLAYER_DRIVING_WRECKLESS = 17369052242503363059
    SPECIAL_ABILITY_CHARGE_MEDIUM = 17371478509595477523
    REMOVE_VEHICLE_RECORDING = 17372084488104460232
    GET_VEHICLE_NUMBER_PLATE_TEXT_INDEX = 17373694244543164821
    STAT_GET_RECORDED_VALUE = 17374607921103721322
    SET_SPECIAL_FLIGHT_MODE_ALLOWED = 17375195817804408675
    SET_TINT_INDEX_CLOSEST_BUILDING_OF_TYPE = 17378884101348032358
    GET_CLOUD_TIME_AS_STRING = 17378947654497851038
    GET_ASPECT_RATIO = 17379530557664791943
    IS_MOVE_BLEND_RATIO_WALKING = 17380441814118525215
    ARE_ONLINE_POLICIES_UP_TO_DATE = 17383862298057491809
    SPECIAL_ABILITY_UNLOCK = 17385569934691179067
    USING_MISSION_CREATOR = 17386279386545571566
    BLOCK_DEATH_JINGLE = 17389727270974467564
    SET_PED_HELMET_TEXTURE_INDEX = 17389819055948792546
    ROPE_DRAW_SHADOW_ENABLED = 17391114195629202344
    GET_NUM_UNLOCKED_RADIO_STATIONS = 17393480977256291815
    GET_PED_GROUP_INDEX = 17393712323052938869
    TASK_COMBAT_PED = 17394841866481616004
    SET_VEHICLE_OUT_OF_CONTROL = 17410082034936983756
    SET_PROFILE_SETTING_CREATOR_RACES_DONE = 17411338634752619029
    SHOW_START_MISSION_INSTRUCTIONAL_BUTTON = 17412817812920774118
    LEADERBOARDS2_READ_BY_PLAFORM = 17414959947355662113
    GET_DISTANCE_BETWEEN_COORDS = 17417496221515303250
    NETWORK_SEED_RANDOM_NUMBER_GENERATOR = 17417743546674790805
    SET_NEXT_DESIRED_MOVE_STATE = 17418218490894141754
    SET_PED_SHOULD_PLAY_IMMEDIATE_SCENARIO_EXIT = 17419987488203881008
    NETWORK_SET_ENTITY_ONLY_EXISTS_FOR_PARTICIPANTS = 17422758662185636504
    UI3DSCENE_PUSH_PRESET = 17424049431099838106
    CELL_CAM_SET_SELFIE_MODE_HEAD_ROLL_OFFSET = 17429543815892364205
    NETWORK_SESSION_SET_MATCHMAKING_MENTAL_STATE = 17433050280521344669
    SET_VEHICLE_STARTUP_REV_SOUND = 17435709577742980892
    IS_STRING_NULL = 17450160236712865894
    SC_LICENSEPLATE_GET_CHECK_IS_VALID = 17450499666599218810
    IS_CURRENT_HEAD_PROP_A_HELMET = 17453798443263544722
    SET_CONTROL_SHAKE_SUPPRESSED_ID = 17454052260106616328
    NETWORK_ADD_ENTITY_TO_SYNCHRONISED_SCENE = 17456037268178884090
    IS_PLAYER_ONLINE = 17464171132920953788
    REMOVE_ALL_PED_WEAPONS = 17464388802800305651
    DISABLE_VEHICLE_EXPLOSION_BREAK_OFF_PARTS = 17464399478513998072
    GET_VEHICLE_BODY_HEALTH = 17469766964027330322
    HAS_MENU_TRIGGER_EVENT_OCCURRED = 17475282014969817106
    FORCE_PED_MOTION_STATE = 17476611774346628554
    START_PARTICLE_FX_LOOPED_ON_PED_BONE = 17477812592399448188
    CAN_PED_HEAR_PLAYER = 17480502303258429993
    SET_PED_SEEING_RANGE = 17482117859965365486
    DRAW_LIGHT_WITH_RANGE = 17483451453036157908
    OVERRIDE_UNDERWATER_STREAM = 17485733166032374742
    SET_PED_CAN_TORSO_IK = 17489465739186568416
    SET_PED_ALLOW_HURT_COMBAT_FOR_ALL_MISSION_PEDS = 17491625671667655070
    SET_VEHICLE_DOOR_CONTROL = 17491875687605866443
    LOBBY_AUTO_MULTIPLAYER_MENU = 17494795973434417618
    ROPE_ARE_TEXTURES_LOADED = 17496738158824412567
    GET_RANDOM_MWC_INT_IN_RANGE = 17497777675316810036
    STAT_GET_NUMBER_OF_HOURS = 17497807257329119171
    ROUND = 17499705547816067449
    FLASH_MINIMAP_DISPLAY = 17500275170792791002
    DLC_CHECK_CLOUD_DATA_CORRECT = 17501120204742742665
    ENABLE_SAVING_IN_GARAGE = 17501453328021935782
    TASK_HANDS_UP = 17503999823725459728
    GET_NUM_COMMERCE_ITEMS = 17504016292177905187
    SLERP_NEAR_QUATERNION = 17507359797302232613
    NETWORK_GAMER_HAS_HEADSET = 17509245258117663829
    NET_GAMESERVER_BASKET_ADD_ITEM = 17512669851184715894
    REPLACE_HUD_COLOUR_WITH_RGBA = 17515852788994771278
    GET_POS_ALONG_GPS_TYPE_ROUTE = 17516232016361659813
    SET_VEHICLE_MISSILE_WARNING_ENABLED = 17525287951118717177
    STOP_CAM_POINTING = 17526522486315440094
    IS_PED_WEARING_HELMET = 17526848534906706713
    FLOOR = 17532204621987346500
    SET_PED_PATH_MAY_ENTER_WATER = 17533680636106336236
    SET_CLOUDS_ALPHA = 17537466796832820358
    SET_AMBIENT_ZONE_LIST_STATE_PERSISTENT = 17538017154727691745
    ADD_RELATIONSHIP_GROUP = 17542290357016364550
    NETWORK_SESSION_IS_SOLO = 17551262373996006606
    SET_CONVERTIBLE_ROOF = 17553992667821581506
    IS_CONTROL_PRESSED = 17555624867233159754
    REMOVE_PLAYER_HELMET = 17558451738318955816
    VEHICLE_SET_EXTENABLE_SIDE_TARGET_RATIO = 17559781988546094069
    TASK_ARREST_PED = 17562252433449906865
    GET_CURR_WEATHER_STATE = 17562886828200801299
    GET_VEHICLE_COLOR = 17567543846557062472
    SET_FADE_IN_AFTER_LOAD = 17570670087380241785
    SC_INBOX_MESSAGE_GET_RAW_TYPE_AT_INDEX = 17573922154676531972
    SET_ARENA_THEME_AND_VARIATION_FOR_TAKEN_PHOTO = 17579650158572987517
    SETUP_SHOP_PED_OUTFIT_QUERY = 17580894975001529384
    SET_PLAYER_CAN_LEAVE_PARACHUTE_SMOKE_TRAIL = 17582529595820257107
    PROCESS_ENTITY_ATTACHMENTS = 17584309764505279599
    SET_VEHICLE_EXTRA_COLOUR_5 = 17585947422526242585
    GET_VEHICLE_MODEL_ESTIMATED_MAX_SPEED = 17588740519377235267
    IS_PED_BLUSH_TINT_FOR_CREATOR = 17589755200512041942
    STAT_SET_BLOCK_SAVES = 17596866715346286544
    NETWORK_IS_SESSION_BUSY = 17601014464195498078
    SPAWNPOINTS_IS_SEARCH_FAILED = 17601719418638440338
    REMOVE_SCALEFORM_SCRIPT_HUD_MOVIE = 17602974824764755863
    NETWORK_CLAN_GET_UI_FORMATTED_TAG = 17605505813620958448
    NETWORK_SET_NO_SPECTATOR_CHAT = 17611922294919485824
    STOP_GAMEPLAY_HINT = 17612549121656326422
    GET_WEAPONTYPE_MODEL = 17612694354744302228
    OVERRIDE_MP_TEXT_CHAT_COLOR = 17617613879510097170
    SWING_BOAT_BOOM_TO_RATIO = 17620550585058804274
    GET_PED_ORIGINAL_AMMO_TYPE_FROM_WEAPON = 17620813263454292953
    SET_VEHICLE_SIREN = 17623225488012915581
    NETWORK_SESSION_SET_UNIQUE_CREW_LIMIT = 17625606940922290775
    GET_INTERIOR_HEADING = 17625778749366477529
    DRAW_LIGHT_WITH_RANGEEX = 17626695965285041557
    IPL_GROUP_SWAP_FINISH = 17627329577555951526
    NETWORK_EARN_FIXER_AGENCY_SHORT_TRIP = 17629593029343911991
    SET_VEHICLE_BOMB_AMMO = 17632416461353244532
    SHAKE_SCRIPT_GLOBAL = 17638576219001388746
    INVALIDATE_IDLE_CAM = 17650381910379109920
    DISABLE_VEHICLE_WEAPON = 17653101666101680214
    PLAYSTATS_HEIST_SAVE_CHEAT = 17653831306435135587
    SCRIPT_IS_MOVING_MOBILE_PHONE_OFFSCREEN = 17659167576116842786
    IS_WAYPOINT_PLAYBACK_GOING_ON_FOR_VEHICLE = 17659539119890073228
    NETWORK_EARN_FROM_ROB_ARMORED_CARS = 17659847922208236496
    SET_CHECKPOINT_CLIPPLANE_WITH_POS_NORM = 17662332791826895197
    PLAYSTATS_MC_KILLED_RIVAL_MC_MEMBER = 17668986167014370598
    SET_FORCE_OBJECT_THIS_FRAME = 17669882043718475421
    UGC_IS_LANGUAGE_SUPPORTED = 17671641453793767115
    RESET_PED_AUDIO_FLAGS = 17675423155129611061
    SET_CAM_DOF_OVERRIDDEN_FOCUS_DISTANCE = 17680639860638495196
    START_NETWORKED_PARTICLE_FX_NON_LOOPED_AT_COORD = 17684370438765941597
    GET_LINE_PLANE_INTERSECTION = 17685067819093226102
    SET_PED_CAN_TORSO_REACT_IK = 17691387123743689252
    SET_SIREN_BYPASS_MP_DRIVER_CHECK = 17691493407055483956
    SET_SCRIPT_GFX_ALIGN_PARAMS = 17699927744894097309
    PLAYSTATS_JOB_BEND = 17706902130925392576
    IS_TIME_EQUAL_TO = 17707192235454813458
    GET_STATUS_OF_SORTED_LIST_OPERATION = 17707822952791368369
    DELETE_CHECKPOINT = 17720881635468301614
    IS_CINEMATIC_CAM_INPUT_ACTIVE = 17722201759336331158
    SET_PED_MAX_HEALTH = 17723414459326929363
    GET_PED_CURRENT_MOVE_BLEND_RATIO = 17726561628885169931
    FORCE_LIGHTNING_FLASH = 17727907597539985560
    DOES_SCRIPT_VEHICLE_GENERATOR_EXIST = 17728538440791754870
    IS_XBOX360_VERSION = 17735205353054153373
    NETWORK_CASINO_CAN_BET_AMOUNT = 17739517944627826660
    SET_WHEELS_EXTENDED_INSTANTLY = 17753295444312751016
    REMOVE_ANIM_DICT = 17756110238032734726
    SET_SAVE_MIGRATION_TRANSACTION_ID_WARNING = 17760270588872832269
    GET_WATER_HEIGHT = 17762927292766151972
    START_ENTITY_FIRE = 17773976481860363231
    GET_PED_ALERTNESS = 17774038143109185490
    GET_VEHICLE_DOORS_LOCKED_FOR_PLAYER = 17775545771403546645
    NETWORK_EARN_BOUNTY_HUNTER_REWARD = 17776113421644635783
    SC_LICENSEPLATE_CHECK_STRING = 17778710458491060032
    LINK_NAMED_RENDERTARGET = 17780385220993433389
    NETWORK_SPENT_REHIRE_DJ = 17782644843987539196
    GET_PLAYER_RADIO_STATION_NAME = 17786742166479351043
    SET_OBJECT_PHYSICS_PARAMS = 17789058621623892239
    BEGIN_SCALEFORM_MOVIE_METHOD = 17790495150362356046
    NETWORK_TRANSITION_SET_ACTIVITY_ISLAND = 17794909855791903002
    GET_ENTITY_POPULATION_TYPE = 17795153826185276927
    WITHDRAW_VC = 17802441345110447145
    GET_IS_PED_GADGET_EQUIPPED = 17812074215687656812
    SPECIAL_ABILITY_CHARGE_LARGE = 17812849642795793811
    GET_CLOSEST_VEHICLE = 17815877436373559451
    PLAYSTATS_CASINO_THREE_CARD_POKER = 17816516324978269237
    GET_GLOBAL_WATER_FILE = 17816729980689799469
    FORCE_CLEANUP_FOR_THREAD_WITH_THIS_ID = 17817844820968675179
    SET_ALLOW_STREAM_HEIST_ISLAND_NODES = 17819371510466739178
    WATER_OVERRIDE_SET_OCEANWAVEMINAMPLITUDE = 17821220293787171869
    POINT_CAM_AT_COORD = 17822036457080948739
    SET_PED_INTO_VEHICLE = 17823854667459462717
    SET_WEATHER_PTFX_OVERRIDE_CURR_LEVEL = 17837491694972713071
    ARE_PLANE_CONTROL_PANELS_INTACT = 17838640295920060215
    SET_DISTANT_CARS_ENABLED = 17840505911926191709
    RELEASE_PED_PRELOAD_PROP_DATA = 17843153898667107866
    GET_MAKE_NAME_FROM_VEHICLE_MODEL = 17847570802589409175
    NETWORK_FIND_MATCHED_GAMERS = 17848556827166339085
    SET_TV_CHANNEL_PLAYLIST = 17848763143056129675
    ARE_NODES_LOADED_FOR_AREA = 17849905319598465805
    REMOVE_WEAPON_COMPONENT_FROM_WEAPON_OBJECT = 17859071658891376145
    SET_PARTICLE_FX_LOOPED_OFFSETS = 17860691097194871875
    SET_VEHICLE_IS_WANTED = 17864695207840106278
    IS_SEAT_WARP_ONLY = 17866346945754625697
    SET_FRONTEND_RADIO_ACTIVE = 17866461894064860088
    TASK_PLANE_GOTO_PRECISE_VTOL = 17868555759024296027
    NETWORK_SET_FRIENDLY_FIRE_OPTION = 17872613597342980131
    IS_NAVMESH_LOADED_IN_AREA = 17875851137686463141
    NETWORK_STORE_INVITE_THROUGH_RESTART = 17876192950008927968
    SET_SRL_FORCE_PRESTREAM = 17876293797489278094
    SET_BINK_MOVIE_AUDIO_FRONTEND = 17876742484996010541
    SET_WEAPON_OBJECT_TINT_INDEX = 17881358221396206761
    SET_STATE_OF_CLOSEST_DOOR_OF_TYPE = 17883107033543093309
    SET_PED_CAN_PLAY_VISEME_ANIMS = 17884882337142951235
    SETUP_FAKE_CONE_DATA = 17887470800858931913
    GET_VEHICLE_COUNTERMEASURE_AMMO = 17890173915701360644
    REPLAY_RESET_EVENT_INFO = 17894001569556575619
    DOES_SCRIPT_WITH_NAME_HASH_EXIST = 17900299737247191937
    SET_BLIP_ROTATION = 17903642289297440622
    ENABLE_VEHICLE_DYNAMIC_AMBIENT_SCALES = 17905642666200650246
    BLOCK_ALL_SPEECH_FROM_PED = 17919030089904285950
    DATAARRAY_ADD_BOOL = 17920093003080436854
    SET_AIRCRAFT_IGNORE_HIGHTMAP_OPTIMISATION = 17921124033222955239
    SET_GAMEPLAY_HINT_FOLLOW_DISTANCE_SCALAR = 17923692362181134753
    GET_CONVERTIBLE_ROOF_STATE = 17925337595986853697
    PLAYSTATS_JOB_ACTIVITY_END = 17925815556800123356
    DATAFILE_HAS_VALID_FILE_DATA = 17927738018238751391
    SET_MINIMAP_HIDE_FOW = 17933017767121566611
    SET_VEHICLE_BULLDOZER_ARM_POSITION = 17936655106386403255
    GENERATE_DIRECTIONS_TO_COORD = 17942664111592492536
    DOES_SCENARIO_GROUP_EXIST = 17943268986684571859
    PLAYSTATS_ARCADE_CABINET = 17944981477965928916
    BEGIN_TEXT_COMMAND_SET_BLIP_NAME = 17947189971611575920
    IS_SCE_PLATFORM = 17947379520926090520
    SUPPRESS_PICKUP_REWARD_TYPE = 17951516694274433703
    GET_VEHICLE_PED_IS_ENTERING = 17953197144696923644
    NETWORK_EARN_FROM_IMPORT_EXPORT = 17954164283470529238
    WAS_PED_KILLED_BY_STEALTH = 17978381401878278144
    UGC_SET_QUERY_DATA_FROM_OFFLINE = 17982273024087331619
    SET_RADAR_ZOOM_TO_BLIP = 17982393093251385265
    GET_HUD_SCREEN_POSITION_FROM_WORLD_POSITION = 17982958051554803395
    SET_ENABLE_SCUBA = 17987203189956728070
    SPECIAL_FUNCTION_DO_NOT_USE = 17991023581627738661
    NETWORK_GET_STRING_WALLET_BALANCE = 17992174435784700731
    NETWORK_DID_FIND_GAMERS_SUCCEED = 17994197695905761379
    SET_PED_DEFENSIVE_SPHERE_ATTACHED_TO_PED = 17994406204129645886
    FIX_OBJECT_FRAGMENT = 17996780017967217941
    DOES_PICKUP_OF_TYPE_EXIST_IN_AREA = 17997336640076680755
    NETWORK_REFUND_CASH = 17998656584548804631
    SET_FLY_CAM_MAX_HEIGHT = 18000924204615933303
    GET_PED_COMBAT_RANGE = 18003693607827943328
    UGC_GET_FRIEND_CONTENT = 18005897835243160193
    PLAY_PED_RINGTONE = 18006911401335853477
    STAT_IS_PLAYER_VEHICLE_ABOVE_OCEAN = 18010618556407355884
    NETWORK_EARN_FROM_CRIMINAL_MASTERMIND = 18014568257746792916
    SET_PED_MIN_GROUND_TIME_FOR_STUNGUN = 18016216736995505146
    NETWORK_SPENT_UPGRADE_CLUB_HOUSE = 18016498157661050831
    SHUTDOWN_SESSION_CLEARS_AUTO_MULTIPLAYER = 18022858741389546005
    IS_PLAYER_PRESSING_HORN = 18022891105905121529
    NETWORK_SEND_QUEUED_JOIN_REQUEST = 18025808019291147926
    NET_GAMESERVER_BASKET_END = 18028875226120495312
    OVERRIDE_FREEZE_FLAGS = 18032407474518263971
    TASK_START_SCENARIO_AT_POSITION = 18036631158424162055
    PLAYSTATS_EXTRA_EVENT = 18040141077673406361
    NETWORK_EARN_ASSASSINATE_TARGET_KILLED = 18045938595797530506
    GET_BLIP_INFO_ID_COORD = 18049441090438847753
    REMOVE_COVER_BLOCKING_AREAS_AT_POSITION = 18051494277141466980
    NETWORK_SESSION_KICK_PLAYER = 18052965925827658272
    NETWORK_ACCEPT_PRESENCE_INVITE = 18055305899608738594
    USE_SIREN_AS_HORN = 18055825785383972600
    SET_PLAYER_VISIBLE_LOCALLY = 18059732609498422002
    START_PLAYER_SWITCH = 18060066917042199911
    REGISTER_TEXT_LABEL_63_TO_SAVE = 18060657090312963939
    SET_ALLOW_STUNT_JUMP_CAMERA = 18066547061062479051
    NETWORK_HIDE_PROJECTILE_IN_CUTSCENE = 18068879806014763536
    SET_LAW_PEDS_CAN_ATTACK_NON_WANTED_PLAYER_THIS_FRAME = 18070510473313286355
    SET_LAST_VIEWED_SHOP_ITEM = 18079182773598138937
    SET_ENTITY_PROOFS = 18081400121429920696
    SET_GLOBAL_POSITION_OFFSET_FOR_RECORDED_VEHICLE_PLAYBACK = 18082699623687626484
    NETWORK_ACCESS_TUNABLE_MODIFICATION_DETECTION_CLEAR = 18085369437639698651
    SET_TICKER_JOHNMARSTON_IS_DONE = 18086678693861155368
    NETWORK_GIVE_PLAYER_JOBSHARE_CASH = 18093457367178805509
    IPL_GROUP_SWAP_IS_READY = 18093653944824726026
    NETWORK_FIND_LARGEST_BUNCH_OF_PLAYERS = 18095344013951344959
    NETWORK_GET_PLAYER_IS_HIGH_EARNER = 18096684525253454439
    NETWORK_CLEAR_TRANSITION_CREATOR_HANDLE = 18100655345302161241
    HINT_SCRIPT_AUDIO_BANK = 18102229875105383194
    SET_WEATHER_TYPE_OVERTIME_PERSIST = 18109050757229278655
    NETWORK_ALLOW_GANG_TO_JOIN_TUTORIAL_SESSION = 18115744070583835760
    IS_DISABLED_CONTROL_RELEASED = 18116926263294897810
    NETWORK_EARN_FROM_AMBIENT_JOB = 18117331021315582438
    GET_ENTITY_BONE_INDEX_BY_NAME = 18118288114022001850
    TOGGLE_SHOW_OPTIONAL_STUNT_JUMP_CAMERA = 18122673095757980093
    SET_VEHICLE_BURNOUT = 18124618246404268283
    NETWORK_CANCEL_RESPAWN_SEARCH = 18126753682458447038
    IS_PED_FALLING = 18127728484137885603
    CREATE_PICKUP = 18131646376056322648
    SET_VEHICLE_NEEDS_TO_BE_HOTWIRED = 18132988441774804710
    NETWORK_SPEND_CASINO_MEMBERSHIP = 18139942331681578310
    UGC_GET_CREATE_RESULT = 18142161111144168042
    NETWORK_SESSION_IS_CLOSED_FRIENDS = 18144900550378940560
    CALL_SCALEFORM_MOVIE_METHOD = 18147656602949702963
    RECORD_BROKEN_GLASS = 18150072924382293149
    IS_PED_IN_ANY_SUB = 18157389777550563742
    UNFREEZE_RADIO_STATION = 18158589894405624285
    DOES_SCRIPT_EXIST = 18159767552029868442
    GET_VEHICLE_MOD_KIT_TYPE = 18160078651065191474
    NETWORK_SET_IN_FREE_CAM_MODE = 18165510258038530118
    GET_TV_CHANNEL = 18167001216789485973
    LOBBY_SET_AUTO_MULTIPLAYER_EVENT = 18172198856348913077
    SET_CAR_BOOT_OPEN = 18176752360889296764
    IS_OBJECT_A_PICKUP = 18178811112218940029
    LOAD_CLOUD_HAT = 18178853164908265419
    EXPLODE_PROJECTILES = 18179854281387413988
    NETWORK_SPENT_RENAME_ORGANIZATION = 18180715081363094390
    REMOVE_ALL_PROJECTILES_OF_TYPE = 18181841982048199976
    TASK_VEHICLE_FOLLOW = 18182257234651046838
    SET_CURSOR_POSITION = 18188161314911740441
    GET_FRAME_COUNT = 18195108673376937714
    GET_ALLOW_MOVEMENT_WHILE_ZOOMED = 18196123744571782486
    GET_ONLINE_VERSION = 18206143712130542602
    HAS_SOUND_FINISHED = 18211939454132455653
    PLAYSTATS_BW_SIGHTSEER = 18213164787491667116
    END_TEXT_COMMAND_CLEAR_PRINT = 18214619992096412536
    DATAFILE_IS_VALID_REQUEST_ID = 18215624226298333304
    PLAYSTATS_CASINO_STORY_MISSION_ENDED = 18216123897043087744
    ADD_NAVMESH_BLOCKING_OBJECT = 18218688733846187866
    HAS_ENTITY_CLEAR_LOS_TO_ENTITY = 18221554983472701868
    SAVEMIGRATION_MP_GET_ACCOUNT = 18222255130820806140
    IS_PED_HEADING_TOWARDS_POSITION = 18227046555762388416
    SET_CHECKPOINT_FORCE_OLD_ARROW_POINTING = 18227889100701437140
    SET_PED_AI_BLIP_SPRITE = 18229107900571690365
    NETWORK_GAMERTAG_FROM_HANDLE_SUCCEEDED = 18230704941221356509
    ATTACH_ENTITY_BONE_TO_ENTITY_BONE_Y_FORWARD = 18236928417976046649
    SET_MULTIPLAYER_HUD_CASH = 18238771464696018980
    SET_HELI_BLADES_SPEED = 18241842718139137101
    SET_GAMEPLAY_CAM_ENTITY_TO_LIMIT_FOCUS_OVER_BOUNDING_SPHERE_THIS_UPDATE = 18244453507302826565
    SET_USE_CAMERA_HEADING_FOR_DESIRED_DIRECTION_LOCK_ON_TEST = 18244738037095531223
    IS_PED_PERFORMING_STEALTH_KILL = 18252189600478478775
    DOES_ROPE_EXIST = 18254295171343707542
    SHAKE_GAMEPLAY_CAM = 18254747994658183119
    UGC_SET_USING_OFFLINE_CONTENT = 18263744365016366899
    SWITCH_TRAIN_TRACK = 18266947224440635168
    NETWORK_IS_IN_PLATFORM_PARTY_CHAT = 18269840669551906888
    THEFEED_PAUSE = 18281275929582043968
    ADD_EXTRA_CALMING_QUAD = 18284417518858540806
    ALLOW_ALL_PLAYERS_TO_COLLECT_PICKUPS_OF_TYPE = 18284751208426682133
    GET_WANTED_LEVEL_THRESHOLD = 18289533611757229420
    THEFEED_RESET_ALL_PARAMETERS = 18291460208433472862
    NETWORK_EARN_BB_EVENT_BONUS = 18291601076294456720
    REMOVE_PED_PREFERRED_COVER_SET = 18292253124968084441
    DRAW_TV_CHANNEL = 18292543404032564720
    CELL_CAM_ACTIVATE = 18296137823264362790
    THEFEED_FREEZE_NEXT_POST = 18297005273246196520
    GET_TIMECYCLE_MODIFIER_INDEX = 18299208839268596582
    REQUEST_AMBIENT_AUDIO_BANK = 18303473030733143449
    SET_PED_PANIC_EXIT_SCENARIO = 18304880017946258986
    SET_HELI_TAIL_ROTOR_HEALTH = 18311740781874220635
    GET_VEHICLE_CREW_EMBLEM_REQUEST_STATE = 18313344151913083647
    GET_VEHICLE_DOOR_ANGLE_RATIO = 18320533513229773781
    SET_NEW_WAYPOINT = 18321547689007051516
    START_SHAPE_TEST_BOX = 18322439210830667032
    SC_TRANSITION_NEWS_SHOW_TIMED = 18324052926535614846
    SET_VEHICLE_TOW_TRUCK_ARM_POSITION = 18326476374594126794
    NETWORK_EARN_DAILY_VEHICLE_BONUS = 18331251265768403634
    DISABLE_CONTROL_ACTION = 18345895136465843900
    PLAYSTATS_INST_MISSION_END = 18348781883649036538
    NETWORK_BLOCK_PROXY_MIGRATION_BETWEEN_TUTORIAL_SESSIONS = 18349814783046536530
    GET_NUMBER_OF_FREE_STACKS_OF_THIS_SIZE = 18351349330601704463
    SET_ROCKET_BOOST_FILL = 18352975442354984494
    SEETHROUGH_SET_NOISE_MAX = 18356601573743802846
    IS_USING_PED_SCUBA_GEAR_VARIATION = 18359385338739110705
    ATTACH_CAM_TO_ENTITY = 18364409510355558627
    GET_ANIM_DURATION = 18365099070646179728
    SPAWNPOINTS_CANCEL_SEARCH = 18366986898585594360
    IS_SNIPER_BULLET_IN_AREA = 18373825678050619685
    GET_PED_TYPE = 18376267707516577340
    GET_CLOSEST_VEHICLE_NODE_WITH_HEADING = 18376691677910270896
    CLEAR_DRAW_ORIGIN = 18377889423277741999
    PLAYSTATS_CARCLUB_POINTS = 18380552369580571582
    REMOVE_WAYPOINT_RECORDING = 18382439456700521928
    SET_EXPLOSIVE_MELEE_THIS_FRAME = 18382547445568245728
    SET_RADIO_RETUNE_UP = 18385502500354595165
    FORCE_ALL_HEADING_VALUES_TO_ALIGN = 18386072075868751514
    SET_PLAYER_LEAVE_PED_BEHIND = 18388210980731636235
    SET_COMBAT_FLOAT = 18393181026566117404
    SET_HEALTH_SNACKS_CARRIED_BY_ALL_NEW_PEDS = 18394956784010285785
    CLEAR_GPS_PLAYER_WAYPOINT = 18397125075908836775
    GET_TATTOO_SHOP_DLC_ITEM_DATA = 18398955005361528966
    SEETHROUGH_SET_NOISE_MIN = 18399899251051486469
    LOCK_RADIO_STATION_TRACK_LIST = 18401249181066767603
    START_SHAPE_TEST_MOUSE_CURSOR_LOS_PROBE = 18405055629834616628
    SC_COMMUNITY_EVENT_IS_ACTIVE = 18415001803157329530
    NETWORK_GET_NUM_UNACKED_RELIABLES = 18415165687380412956
    TEST_PROBE_AGAINST_WATER = 18421367862894008795
    GET_NEAREST_PARTICIPANT_TO_ENTITY = 18428008751355912447
    NETWORK_SPENT_BOSS_GOON = 18428169805683185341
    SET_FACIAL_IDLE_ANIM_OVERRIDE = 18429375743702305592
    NETWORK_JOIN_PREVIOUSLY_FAILED_TRANSITION = 18438270926037003060
    SC_INBOX_MESSAGE_GET_DATA_BOOL = 18439356932900619549
    UPDATE_SPECIAL_ABILITY_FROM_STAT = 18441835452672090510
    STOP_ROPE_UNWINDING_FRONT = 18443266350541421491
    NETWORK_EARN_FMBB_WAGE_BONUS = 18445514484563883764

    def __int__(self) -> int: ...
    def __hash__(self) -> int: ...


# Pour permettre "from GTA import Native" puis "Native.Function.Call"
class Native:
    Function: ClassVar[type[Function]]
    Hash: ClassVar[type[Hash]]
    InputArgument: ClassVar[type[InputArgument]]
    OutputArgument: ClassVar[type[OutputArgument]]


